/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.mcidas;

import edu.wisc.ssec.mcidas.McIDASException;
import edu.wisc.ssec.mcidas.McIDASUtil;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import ucar.grid.GridIndex;
import ucar.grid.GridRecord;
import ucar.nc2.iosp.mcidas.McGridDefRecord;
import ucar.nc2.iosp.mcidas.McIDASGridRecord;
import ucar.unidata.io.RandomAccessFile;

public class McIDASGridReader {
    protected RandomAccessFile rf;
    private String errorMessage;
    private GridIndex gridIndex;
    protected boolean needToSwap = false;
    private HashMap<String, McGridDefRecord> gdsMap = new HashMap();
    private static final int MAX_GRIDS = 999999;

    public McIDASGridReader() {
    }

    public McIDASGridReader(String filename) throws IOException {
        this(new RandomAccessFile(filename, "r", 2048));
    }

    public McIDASGridReader(RandomAccessFile raf) throws IOException {
        this.init(raf);
    }

    public final void init(RandomAccessFile raf) throws IOException {
        this.init(raf, true);
    }

    public final void init(RandomAccessFile raf, boolean fullCheck) throws IOException {
        this.rf = raf;
        raf.order(0);
        boolean ok = this.init(fullCheck);
        if (!ok) {
            throw new IOException("Unable to open McIDAS Grid file: " + this.errorMessage);
        }
    }

    protected boolean init() throws IOException {
        return this.init(true);
    }

    protected boolean init(boolean fullCheck) throws IOException {
        int i;
        if (this.rf == null) {
            this.logError("File is null");
            return false;
        }
        this.gridIndex = new GridIndex(this.rf.getLocation());
        this.rf.order(0);
        int numEntries = Math.abs(this.readInt(10));
        if (numEntries > 1000000) {
            this.needToSwap = true;
            numEntries = Math.abs(McIDASUtil.swbyt4(numEntries));
        }
        if (numEntries > 999999) {
            return false;
        }
        this.rf.seek(0L);
        String label = this.rf.readString(32);
        if (label.indexOf("GEMPAK DATA MANAGEMENT FILE") >= 0) {
            this.logError("label indicates this is a GEMPAK grid");
            return false;
        }
        for (int i2 = 0; i2 < label.length(); ++i2) {
            String s0 = label.substring(i2, i2 + 1);
            if (0 <= s0.compareTo(" ") && s0.compareTo("~") <= 0) continue;
            this.logError("bad label, not a McIDAS grid");
            return false;
        }
        int project = this.readInt(8);
        int date = this.readInt(9);
        if (date < 10000 || date > 400000) {
            this.logError("date wrong, not a McIDAS grid");
            return false;
        }
        int[] entries = new int[numEntries];
        for (i = 0; i < numEntries; ++i) {
            entries[i] = this.readInt(i + 11);
            if (entries[i] >= -1) continue;
            this.logError("bad grid offset " + i + ": " + entries[i]);
            return false;
        }
        if (!fullCheck) {
            return true;
        }
        this.rf.order(0);
        for (i = 0; i < numEntries; ++i) {
            if (entries[i] == -1) continue;
            int[] header = new int[64];
            this.rf.seek(entries[i] * 4);
            this.rf.readInt(header, 0, 64);
            if (this.needToSwap) {
                this.swapGridHeader(header);
            }
            try {
                McIDASGridRecord gr = new McIDASGridRecord(entries[i], header);
                this.gridIndex.addGridRecord(gr);
                if (this.gdsMap.get(gr.getGridDefRecordId()) != null) continue;
                McGridDefRecord mcdef = gr.getGridDefRecord();
                this.gdsMap.put(mcdef.toString(), mcdef);
                this.gridIndex.addHorizCoordSys(mcdef);
                continue;
            }
            catch (McIDASException me) {
                this.logError("problem creating grid dir");
                return false;
            }
        }
        if (this.gridIndex.getGridRecords().isEmpty()) {
            this.logError("no grids found");
            return false;
        }
        return true;
    }

    private void swapGridHeader(int[] gh) {
        McIDASUtil.flip(gh, 0, 5);
        McIDASUtil.flip(gh, 7, 7);
        McIDASUtil.flip(gh, 9, 10);
        McIDASUtil.flip(gh, 12, 14);
        McIDASUtil.flip(gh, 32, 51);
    }

    public float[] readGrid(McIDASGridRecord gr) {
        float[] data = null;
        try {
            int te = (gr.getOffsetToHeader() + 64) * 4;
            int rows = gr.getRows();
            int cols = gr.getColumns();
            this.rf.seek(te);
            float scale = (float)gr.getParamScale();
            data = new float[rows * cols];
            this.rf.order(this.needToSwap ? 1 : 0);
            boolean n = false;
            for (int nc = 0; nc < cols; ++nc) {
                for (int nr = 0; nr < rows; ++nr) {
                    int temp = this.rf.readInt();
                    data[(rows - nr - 1) * cols + nc] = temp == -2139062144 ? Float.NaN : (float)temp / scale;
                }
            }
            this.rf.order(0);
        }
        catch (Exception esc) {
            System.out.println(esc);
        }
        return data;
    }

    public GridIndex getGridIndex() {
        return this.gridIndex;
    }

    public int readInt(int word) throws IOException {
        if (this.rf == null) {
            throw new IOException("no file to read from");
        }
        this.rf.seek(word * 4);
        if (this.needToSwap) {
            this.rf.order(1);
        } else {
            this.rf.order(0);
        }
        int idata = this.rf.readInt();
        this.rf.order(0);
        return idata;
    }

    private void logError(String errMsg) {
        this.errorMessage = errMsg;
    }

    public static void main(String[] args) throws IOException {
        String file = "GRID2001";
        if (args.length > 0) {
            file = args[0];
        }
        McIDASGridReader mg = new McIDASGridReader(file);
        GridIndex gridIndex = mg.getGridIndex();
        List<GridRecord> grids = gridIndex.getGridRecords();
        System.out.println("found " + grids.size() + " grids");
        int num = Math.min(grids.size(), 10);
        for (int i = 0; i < num; ++i) {
            System.out.println(grids.get(i));
        }
    }
}

