/*
 * Decompiled with CFR 0.152.
 */
package visad.data;

import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.ImageObserver;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import visad.data.ArrayWrapper;

public class CachedBufferedByteImage
extends BufferedImage {
    public static int cnt = 0;
    private ArrayWrapper bytes;
    private String cacheFile;
    private int myWidth;
    private int myHeight;
    private int dbSize;
    private int dbOffset;
    private Object MUTEX = new Object();

    public CachedBufferedByteImage(int width, int height, int type) {
        super(1, 1, type);
        BufferedImage fullImage = new BufferedImage(width, height, type);
        WritableRaster raster = fullImage.getRaster();
        DataBuffer db = raster.getDataBuffer();
        byte[] byteData = ((DataBufferByte)db).getData();
        this.dbSize = db.getSize();
        this.dbOffset = db.getOffset();
        this.myWidth = width;
        this.myHeight = height;
        this.bytes = new ArrayWrapper(byteData);
    }

    public void bytesChanged(byte[] newByteData) {
        this.bytes.updateData(newByteData);
    }

    public void finalize() throws Throwable {
        super.finalize();
        this.bytes = null;
    }

    public boolean inMemory() {
        return this.bytes.inMemory();
    }

    public byte[] getBytesFromCache() {
        return this.bytes.getByteArray1D();
    }

    public int getHeight() {
        return this.myHeight;
    }

    public int getWidth() {
        return this.myWidth;
    }

    public int getHeight(ImageObserver obs) {
        return this.myWidth;
    }

    public int getWidth(ImageObserver obs) {
        return this.myHeight;
    }

    public WritableRaster getRaster() {
        DataBufferByte db = new DataBufferByte(this.getBytesFromCache(), this.dbSize, this.dbOffset);
        WritableRaster newRaster = Raster.createWritableRaster(this.getSampleModel(), db, null);
        return newRaster;
    }
}

