/*
 * Decompiled with CFR 0.152.
 */
package visad.data.hdf5.hdf5objects;

import ncsa.hdf.hdf5lib.H5;
import ncsa.hdf.hdf5lib.exceptions.HDF5Exception;
import ncsa.hdf.hdf5lib.exceptions.HDF5LibraryException;
import visad.data.hdf5.hdf5objects.HDF5Object;

public class HDF5Dataspace
extends HDF5Object {
    private int rank;
    private long[] dims;
    private long[] maxdims;
    private long[] start;
    private long[] stride;
    private long[] count;

    public HDF5Dataspace() {
        this.type = 4;
    }

    public HDF5Dataspace(int space_type) {
        this.type = 4;
        try {
            this.id = H5.H5Screate(space_type);
        }
        catch (HDF5Exception e) {
            System.err.println("HDF5Dataspace: " + e);
            this.id = -1;
        }
        try {
            this.init();
        }
        catch (HDF5Exception e) {
            System.err.println("HDF5Dataspace.init(): " + e);
        }
    }

    public HDF5Dataspace(int rank, long[] dims, long[] maxdims) {
        this.type = 4;
        try {
            this.id = H5.H5Screate_simple(rank, dims, maxdims);
        }
        catch (HDF5Exception e) {
            System.err.println("HDF5Dataspace: " + e);
            this.id = -1;
        }
        try {
            this.init();
        }
        catch (HDF5Exception e) {
            System.err.println("HDF5Dataspace.init(): " + e);
        }
    }

    public void init() throws HDF5Exception {
        if (this.id < 0) {
            return;
        }
        this.rank = H5.H5Sget_simple_extent_ndims(this.id);
        this.dims = new long[this.rank];
        this.maxdims = new long[this.rank];
        this.start = new long[this.rank];
        this.stride = new long[this.rank];
        this.count = new long[this.rank];
        for (int i = 0; i < this.rank; ++i) {
            this.start[i] = 0L;
            this.stride[i] = 1L;
        }
        int status = H5.H5Sget_simple_extent_dims(this.id, this.dims, this.maxdims);
        if (status < 0) {
            return;
        }
        for (int i = 0; i < this.rank; ++i) {
            this.count[i] = this.dims[i];
        }
    }

    public void select(long[] start, long[] stride, long[] count) throws HDF5LibraryException, NullPointerException, IllegalArgumentException {
        this.start = start;
        this.stride = stride;
        this.count = count;
        long[] block = new long[this.rank];
        for (int i = 0; i < this.rank; ++i) {
            block[i] = 1L;
        }
        H5.H5Sselect_hyperslab(this.id, 0, start, stride, count, block);
    }

    public int getRank() {
        return this.rank;
    }

    public long[] getDims() {
        return this.dims;
    }

    public long[] getMaxdims() {
        return this.maxdims;
    }

    public long[] getCount() {
        return this.count;
    }

    public synchronized String toString() {
        String d_str = "";
        for (int i = 0; i < this.rank; ++i) {
            d_str = d_str + this.dims[i] + "x";
        }
        int l = d_str.length();
        if (l > 1) {
            d_str = d_str.substring(0, l - 1);
        }
        return this.getClass().getName() + "[rank=" + this.rank + ",dimensions=" + d_str + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            super.finalize();
        }
        finally {
            H5.H5Sclose(this.id);
        }
    }
}

