/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.expressionevaluator.impl.function.dataaccess;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Objects;
import org.apache.commons.lang3.Range;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.gvsig.expressionevaluator.Code;
import org.gvsig.expressionevaluator.CodeBuilder;
import org.gvsig.expressionevaluator.Codes;
import org.gvsig.expressionevaluator.ExpressionRuntimeException;
import org.gvsig.expressionevaluator.ExpressionUtils;
import org.gvsig.expressionevaluator.Interpreter;
import org.gvsig.expressionevaluator.SymbolTable;
import org.gvsig.expressionevaluator.spi.AbstractFunction;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.DataStore;
import org.gvsig.fmap.dal.expressionevaluator.TableAttributeHandler;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureType;

public abstract class AbstractSelectFunction
extends AbstractFunction {
    protected AbstractSelectFunction(String group, String name, Range argc, String description, String template, String[] descriptionArgs, String returnType, boolean sqlCompatible) {
        super(group, name, argc, description, template, descriptionArgs, returnType, sqlCompatible);
    }

    protected AbstractSelectFunction(String group, String name, Range argc, String description, String template, String[] descriptionArgs, String returnType) {
        super(group, name, argc, description, template, descriptionArgs, returnType);
    }

    protected String getIdentifier(Codes args, int argn) {
        Code.Constant storeName_const;
        Code id_code = (Code)args.get(argn);
        if (id_code == null) {
            return null;
        }
        if (id_code instanceof Code.Identifier) {
            return ((Code.Identifier)id_code).name();
        }
        if (id_code instanceof Code.Constant && (storeName_const = (Code.Constant)id_code).value() instanceof CharSequence) {
            return storeName_const.value().toString();
        }
        throw new ExpressionRuntimeException("Invalid identifier (" + Objects.toString(id_code) + ") in function '" + this.name() + "'.");
    }

    protected Code getWhereCode(Codes args, int argn) {
        Code where = (Code)args.get(argn);
        if (where.code() == 0 && ((Code.Constant)where).value() == null) {
            where = null;
        }
        return where;
    }

    protected Code.Callable getTupleOrNull(Codes args, int argn) {
        Code code = (Code)args.get(argn);
        if (code.code() == 0) {
            if (((Code.Constant)code).value() != null) {
                throw new ExpressionRuntimeException("Tupple or null expected in argument " + argn + " of function '" + this.name() + "'.");
            }
            return null;
        }
        if (code.code() != 2) {
            throw new ExpressionRuntimeException("Tupple or null expected in argument " + argn + " of function '" + this.name() + "'.");
        }
        Code.Callable caller = (Code.Callable)code;
        if (!StringUtils.equalsIgnoreCase((CharSequence)"TUPLE", (CharSequence)caller.name())) {
            throw new ExpressionRuntimeException("Tupple or null expected in argument " + argn + " of function '" + this.name() + "'.");
        }
        return caller;
    }

    protected Code removeOuterTablesReferences(Interpreter interpreter, Code where, FeatureType currentType) {
        try {
            SymbolTable symbolTable = interpreter.getSymbolTable();
            TableAttributeHandler table = (TableAttributeHandler)symbolTable.value("$TABLE");
            ArrayList replaces = new ArrayList();
            CodeBuilder codeBuilder = ExpressionUtils.createCodeBuilder();
            HashSet replacesToASkip = new HashSet();
            Code where2 = where.clone();
            where2.accept(o -> {
                if (o == null) {
                    return;
                }
                Code code = (Code)o;
                switch (code.code()) {
                    case 2: {
                        String columnName;
                        Object tt;
                        Code.Callable caller = (Code.Callable)code;
                        if (!StringUtils.equalsIgnoreCase((CharSequence)caller.name(), (CharSequence)"GETATTR")) break;
                        Codes args = caller.parameters();
                        Code arg0 = (Code)args.get(0);
                        Code arg1 = (Code)args.get(1);
                        replacesToASkip.add(arg1);
                        if (!(arg0 instanceof Code.Identifier) || !(arg1 instanceof Code.Constant) || !((tt = symbolTable.value(((Code.Identifier)arg0).name())) instanceof TableAttributeHandler) || !StringUtils.equalsIgnoreCase((CharSequence)((TableAttributeHandler)tt).getName(), (CharSequence)table.getName()) || (columnName = Objects.toString(((Code.Constant)arg1).value(), null)) == null) break;
                        Object value = table.get((Object)columnName);
                        replaces.add(new ImmutablePair((Object)caller, (Object)codeBuilder.constant(value)));
                    }
                }
            });
            where2.accept(o -> {
                if (o == null) {
                    return;
                }
                Code code = (Code)o;
                if (replacesToASkip.contains(code)) {
                    return;
                }
                switch (code.code()) {
                    case 1: {
                        Code.Identifier id = (Code.Identifier)code;
                        if (currentType.getAttributeDescriptor(id.name()) != null || !symbolTable.exists(id.name())) break;
                        Object value = symbolTable.value(id.name());
                        replaces.add(new ImmutablePair((Object)id, (Object)codeBuilder.constant(value)));
                    }
                }
            });
            if (replaces.isEmpty()) {
                return where;
            }
            for (Pair replace : replaces) {
                if (replace == null) continue;
                where2.replace((Code)replace.getLeft(), (Code)replace.getRight());
            }
            return where2;
        }
        catch (Exception ex) {
            throw new ExpressionRuntimeException("Can't remove references to outer tables.", (Throwable)ex);
        }
    }

    protected Code replaceLocalVariables(Interpreter interpreter, Code expression, FeatureType currentType) {
        try {
            SymbolTable symbolTable = interpreter.getSymbolTable();
            TableAttributeHandler table = (TableAttributeHandler)symbolTable.value("$TABLE");
            ArrayList replaces = new ArrayList();
            CodeBuilder codeBuilder = ExpressionUtils.createCodeBuilder();
            Code expression2 = expression.clone();
            expression2.accept(o -> {
                if (o == null) {
                    return;
                }
                Code code = (Code)o;
                switch (code.code()) {
                    case 1: {
                        Code.Identifier id = (Code.Identifier)code;
                        if (currentType.getAttributeDescriptor(id.name()) != null || !symbolTable.exists(id.name())) break;
                        Object value = symbolTable.value(id.name());
                        replaces.add(new ImmutablePair((Object)id, (Object)codeBuilder.constant(value)));
                    }
                }
            });
            if (replaces.isEmpty()) {
                return expression;
            }
            for (Pair replace : replaces) {
                if (replace == null) continue;
                expression2.replace((Code)replace.getLeft(), (Code)replace.getRight());
            }
            return expression2;
        }
        catch (Exception ex) {
            throw new ExpressionRuntimeException("Can't remove references to outer tables.", (Throwable)ex);
        }
    }

    protected DataStore getStore(String storeName) {
        DataManager dataManager = DALLocator.getDataManager();
        DataStore store = dataManager.getStoresRepository().getStore(storeName);
        return store;
    }

    protected FeatureStore getFeatureStore(String storeName) {
        DataManager dataManager = DALLocator.getDataManager();
        DataStore store = dataManager.getStoresRepository().getStore(storeName);
        if (store instanceof FeatureStore) {
            return (FeatureStore)store;
        }
        return null;
    }

    protected boolean isHostExpression(Code code) {
        if (code.code() != 2) {
            return false;
        }
        return StringUtils.equalsIgnoreCase((CharSequence)"$HOSTEXPRESSION", (CharSequence)((Code.Callable)code).name());
    }
}

