/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.expressionevaluator.impl.function.dataaccess;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.Range;
import org.gvsig.expressionevaluator.ExpressionRuntimeException;
import org.gvsig.expressionevaluator.Interpreter;
import org.gvsig.expressionevaluator.spi.AbstractFunction;
import org.gvsig.fmap.dal.AbstractStoresRepository;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.DataStore;
import org.gvsig.fmap.dal.DataStoreParameters;
import org.gvsig.fmap.dal.StoresRepository;
import org.gvsig.fmap.dal.feature.EditableFeatureType;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposeUtils;
import org.gvsig.tools.util.UnmodifiableBasicSet;
import org.gvsig.tools.util.UnmodifiableBasicSetAdapter;

public class CreateInMemoryTableFunction
extends AbstractFunction {
    public CreateInMemoryTableFunction() {
        super("Data access", "CREATE_IN_MEMORY_TABLE", Range.is((Comparable)Integer.valueOf(2)), "Create a table in memory with the same structure as the indicated table. Return a reference to the new table.", "CREATE IN MEMORY TABLE {{new_table_name}} FROM source_table_name", new String[]{"new_table_name - Name of the new table to create.", "source_table_name - Name of the table to copy their structure."}, "Table", false);
    }

    public boolean allowConstantFolding() {
        return false;
    }

    public Object call(Interpreter interpreter, Object[] args) throws Exception {
        DataManager dataManager = DALLocator.getDataManager();
        StoresRepository storesRepository = dataManager.getStoresRepository();
        MemoryStoresRepository repo = (MemoryStoresRepository)storesRepository.getSubrepository("Temporary");
        if (repo == null) {
            repo = new MemoryStoresRepository("Temporary");
            storesRepository.addRepository((StoresRepository)repo);
        }
        String targetName = this.getStr(args, 0);
        String sourceName = this.getStr(args, 1);
        FeatureStore source = (FeatureStore)storesRepository.getStore(sourceName);
        if (source == null) {
            throw new ExpressionRuntimeException("Can't locate source table '" + sourceName + "'.");
        }
        EditableFeatureType featureType = source.getDefaultFeatureType().getEditable();
        FeatureStore target = dataManager.createMemoryStore(null);
        target.edit();
        target.update(featureType);
        target.finishEditing();
        repo.add(targetName, target);
        return target;
    }

    private class MemoryStoresRepository
    extends AbstractStoresRepository {
        private final Map<String, FeatureStore> repository;

        public MemoryStoresRepository(String name) {
            super(name);
            this.repository = new HashMap<String, FeatureStore>();
        }

        public void add(String name, FeatureStore store) {
            this.repository.put(name, store);
        }

        protected DataStoreParameters getMyParameters(String name) {
            FeatureStore store = this.repository.get(name);
            return store.getParameters();
        }

        protected boolean isEmptyMyRepository() {
            return this.repository.isEmpty();
        }

        protected int getMySize() {
            return this.repository.size();
        }

        protected UnmodifiableBasicSet<String> getMyKeySet() {
            Set<String> keyset = this.repository.keySet();
            if (keyset == null || keyset.isEmpty()) {
                return UnmodifiableBasicSet.EMPTY_UNMODIFIABLEBASICSET;
            }
            return new UnmodifiableBasicSetAdapter(keyset);
        }

        public DataStore getStore(String name) {
            FeatureStore store = this.repository.get(name);
            DisposeUtils.bind((Disposable)store);
            return store;
        }

        public void add(String name, DataStoreParameters parameters) {
        }

        public boolean contains(DataStoreParameters parameters) {
            return false;
        }

        public boolean containsKey(String key) {
            return this.repository.containsKey(key);
        }

        public Iterator<DataStoreParameters> iterator() {
            return Collections.EMPTY_LIST.iterator();
        }

        public void remove(String name) {
            this.repository.remove(name);
        }
    }
}

