/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.expressionevaluator.impl.function.dataaccess;

import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.Range;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.expressionevaluator.ExpressionRuntimeException;
import org.gvsig.expressionevaluator.Interpreter;
import org.gvsig.expressionevaluator.impl.function.dataaccess.AbstractFeatureFunction;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.ForeingKey;
import org.gvsig.tools.util.UnmodifiableBasicList;
import org.gvsig.tools.util.UnmodifiableBasicListAdapter;
import org.gvsig.tools.util.UnmodifiableBasicListArrayAdapter;

public class ForeingValueFunction
extends AbstractFeatureFunction {
    public ForeingValueFunction() {
        super("Data access", "FOREIGN_VALUE", Range.is((Comparable)Integer.valueOf(1)), "Return the value of a field throw a relation from other tables.", "FOREIGN VALUE FROM {{foreign_key_field.field_name}}", new String[]{"foreign_key_field - Name of the field in the current table that contains the foreign key of the table that we want to access.", "field_name - Name of the field of the related table that we want to access."}, "OBJECT", true);
        this.addAlias("FOREING_VALUE");
    }

    public Object call(Interpreter interpreter, Object[] args) throws Exception {
        Feature feature;
        UnmodifiableBasicListArrayAdapter fieldNames;
        switch (args.length) {
            case 1: {
                Object fields_o = this.getObject(args, 0);
                if (fields_o == null) {
                    throw new ExpressionRuntimeException("Problems calling 'FOREIGN_VALUE' function, type of parameter 'null' not supported, use string or list.");
                }
                if (fields_o instanceof String[]) {
                    fieldNames = new UnmodifiableBasicListArrayAdapter((Object[])((String[])fields_o));
                    break;
                }
                if (fields_o instanceof List) {
                    fieldNames = new UnmodifiableBasicListAdapter((List)fields_o);
                    break;
                }
                if (fields_o instanceof String) {
                    fieldNames = new UnmodifiableBasicListAdapter(Arrays.asList(((String)fields_o).split("[.]")));
                    break;
                }
                if (fields_o instanceof UnmodifiableBasicList) {
                    fieldNames = (UnmodifiableBasicList)fields_o;
                    break;
                }
                throw new ExpressionRuntimeException("Problems calling 'FOREIGN_VALUE' function, type of parameter '" + fields_o.getClass().getSimpleName() + "' not supported, use string or list.");
            }
            case 2: {
                fieldNames = new UnmodifiableBasicListArrayAdapter((Object[])new String[]{this.getStr(args, 0), this.getStr(args, 1)});
                break;
            }
            default: {
                throw new ExpressionRuntimeException("Problems calling 'FOREIGN_VALUE' function, type of parameter  not supported, use string or list.");
            }
        }
        Feature currentFeature = feature = this.current_row(interpreter);
        try {
            Object value;
            String fieldName;
            if (currentFeature.hasExtraValue(StringUtils.join((Iterable)fieldNames, (String)"."))) {
                Object value2 = feature.getExtraValue(StringUtils.join((Iterable)fieldNames, (String)"."));
                return value2;
            }
            for (int i = 0; i < fieldNames.size() - 1; ++i) {
                ForeingKey foreingKey;
                fieldName = (String)fieldNames.get(i);
                value = currentFeature.get(fieldName);
                FeatureAttributeDescriptor attrdesc = currentFeature.getType().getAttributeDescriptor(fieldName);
                if (!attrdesc.isForeingKey() || (currentFeature = (foreingKey = attrdesc.getForeingKey()).getFeature(null, value)) != null) continue;
                return null;
            }
            fieldName = (String)fieldNames.get(fieldNames.size() - 1);
            value = currentFeature.get(fieldName);
            return value;
        }
        catch (ExpressionRuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExpressionRuntimeException("Problems calling 'FOREIGN_VALUE' function", (Throwable)ex);
        }
    }
}

