/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.expressionevaluator.impl.function.dataaccess;

import org.apache.commons.lang3.Range;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.expressionevaluator.Code;
import org.gvsig.expressionevaluator.Codes;
import org.gvsig.expressionevaluator.ExpressionBuilder;
import org.gvsig.expressionevaluator.ExpressionEvaluatorLocator;
import org.gvsig.expressionevaluator.ExpressionEvaluatorManager;
import org.gvsig.expressionevaluator.ExpressionRuntimeException;
import org.gvsig.expressionevaluator.Formatter;
import org.gvsig.expressionevaluator.Interpreter;
import org.gvsig.expressionevaluator.impl.function.dataaccess.AbstractSelectFunction;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.SQLBuilder;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureQuery;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.feature.spi.SQLBuilderBase;
import org.gvsig.fmap.dal.impl.expressionevaluator.DefaultFeatureExpressionEvaluator;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposeUtils;
import org.gvsig.tools.evaluator.Evaluator;

public class SelectAggregateFunction
extends AbstractSelectFunction {
    public static String FUNCTION_SELECT_AGGREGATE = "SELECT_AGGREGATE";
    private static final int TABLE = 0;
    private static final int WHERE = 1;
    private static final int AGGREGATE_FUNCTION = 2;
    private static final int AGGREGATE_COLUMN = 3;

    public SelectAggregateFunction() {
        super("Data access", FUNCTION_SELECT_AGGREGATE, Range.is((Comparable)Integer.valueOf(4)), "Returns the aggregate function of features of the table by applying the filter indicated.\nThe syntax is:\n\nSELECT aggregate_function(column1) FROM table WHERE boolean_expression;\n\nIndicate a filter expression with WHERE is optional.\nThe SELECT statement must always end with a semicolon.", "SELECT sum({{column1}}) FROM table WHERE filter ;", new String[]{"table - Name of the table", "filter - boolean expression with the filter to apply", "aggregate_function - aggregate function to use. Valid functions are SUM, COUNT, MAX, MIN, AVG", "column1 - name of column to use in aggregate function"}, "Object", true);
    }

    public boolean isHidden() {
        return false;
    }

    public boolean allowConstantFolding() {
        return false;
    }

    public boolean useArgumentsInsteadObjects() {
        return true;
    }

    public Object call(Interpreter interpreter, Object[] args) throws Exception {
        throw new UnsupportedOperationException();
    }

    public Object call(Interpreter interpreter, Codes args) throws Exception {
        String storeName = this.getIdentifier(args, 0);
        Code where = this.getWhereCode(args, 1);
        String aggregateFunction = this.getIdentifier(args, 2);
        String aggregateColumn = this.getIdentifier(args, 3);
        FeatureStore featureStore = null;
        Disposable set = null;
        try {
            Object object;
            featureStore = this.getFeatureStore(storeName);
            if (featureStore == null) {
                throw new ExpressionRuntimeException("Cant locate the feature store '" + storeName + "' in function '" + this.name() + "'.");
            }
            FeatureQuery query = featureStore.createFeatureQuery();
            if (where != null) {
                Code where2 = this.removeOuterTablesReferences(interpreter, where, featureStore.getDefaultFeatureTypeQuietly());
                DefaultFeatureExpressionEvaluator filter = new DefaultFeatureExpressionEvaluator(featureStore.getName(), where2.toString());
                filter.toSymbolTable().addSymbolTable(interpreter.getSymbolTable());
                query.addFilter((Evaluator)filter);
            }
            query.retrievesAllAttributes();
            query.addAggregate(aggregateFunction, aggregateColumn);
            Feature f = featureStore.findFirst(query);
            if (f == null) {
                object = null;
                return object;
            }
            object = f.get(aggregateColumn);
            return object;
        }
        catch (ExpressionRuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExpressionRuntimeException("Problems calling '" + this.name() + "' function", (Throwable)ex);
        }
        finally {
            DisposeUtils.disposeQuietly(set);
            DisposeUtils.disposeQuietly((Disposable)featureStore);
        }
    }

    public ExpressionBuilder.Value toValue(ExpressionBuilder builder, Codes args) {
        try {
            SQLBuilder sqlBuilder = (SQLBuilder)builder.getProperty("SQLBUILDER");
            if (sqlBuilder == null) {
                return super.toValue(builder, args);
            }
            FeatureType featureType = null;
            SQLBuilder.SelectBuilder select = sqlBuilder.createSelectBuilder();
            String builderTableName = (String)builder.getProperty("TableName");
            String storeName = this.getIdentifier(args, 0);
            Code where = this.getWhereCode(args, 1);
            String aggregateFunction = this.getIdentifier(args, 2);
            String aggregateColumn = this.getIdentifier(args, 3);
            if (storeName != null) {
                select.from().table().name(storeName);
            }
            SQLBuilder.TableNameBuilder table = select.from().table();
            String tableName = table.getName();
            select.column(aggregateColumn).value((ExpressionBuilder.Value)builder.function(aggregateFunction, new ExpressionBuilder.Value[]{builder.column(aggregateColumn)}));
            if (where != null) {
                ExpressionBuilder.Value value = where.toValue(builder);
                select.where().value(value);
                sqlBuilder.setProperties((ExpressionBuilder.Visitable)value, null, new Object[]{"ADD_TABLE_NAME", true});
            }
            if (featureType == null) {
                if (StringUtils.equalsIgnoreCase((CharSequence)builderTableName, (CharSequence)tableName)) {
                    featureType = (FeatureType)builder.getProperty("FeatureType");
                } else {
                    DataManager dataManager = DALLocator.getDataManager();
                    featureType = dataManager.getStoresRepository().getFeatureType(tableName);
                }
            }
            sqlBuilder.setProperties((ExpressionBuilder.Visitable)select, null, new Object[]{"FeatureType", featureType, "Table", table});
            return builder.group((ExpressionBuilder.Value)select);
        }
        catch (Exception ex) {
            return super.toValue(builder, args);
        }
    }

    public String toString(Codes args, Formatter<Code> formatter) {
        SQLBuilderBase sqlbuilder = new SQLBuilderBase();
        ExpressionEvaluatorManager expressionManager = ExpressionEvaluatorLocator.getExpressionEvaluatorManager();
        ExpressionBuilder expressionBuilder = expressionManager.createExpressionBuilder();
        expressionBuilder.setProperty("SQLBUILDER", (Object)sqlbuilder);
        ExpressionBuilder.Value values = this.toValue(expressionBuilder, args);
        return values.toString();
    }
}

