/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.expressionevaluator.impl.function.dataaccess;

import java.util.Iterator;
import java.util.function.Predicate;
import org.apache.commons.lang3.Range;
import org.gvsig.expressionevaluator.Code;
import org.gvsig.expressionevaluator.Codes;
import org.gvsig.expressionevaluator.ExpressionRuntimeException;
import org.gvsig.expressionevaluator.Interpreter;
import org.gvsig.expressionevaluator.impl.function.dataaccess.AbstractSelectFunction;
import org.gvsig.fmap.dal.feature.FeatureSelection;
import org.gvsig.fmap.dal.feature.FeatureSet;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.impl.expressionevaluator.DefaultFeatureExpressionEvaluator;
import org.gvsig.tools.evaluator.EvaluatorData;
import org.gvsig.tools.evaluator.EvaluatorException;
import org.gvsig.tools.util.ContainerUtils;
import org.gvsig.tools.util.FilteredIterator;

public class SelectCountFromSelectionFunction
extends AbstractSelectFunction {
    private static final int TABLE = 0;
    private static final int WHERE = 1;
    private static final int SELECCTION_IF_NOT_EMPTY = 2;

    public SelectCountFromSelectionFunction() {
        super("Data access", "SELECTCOUNTFROMSELECTION", Range.is((Comparable)Integer.valueOf(3)), "Returns the number of features of the table by applying the filter indicated.\nThe syntax is:\n\nSELECT COUNT(*) FROM SELECTION [IF NOT EMPTY] OF table WHERE boolean_expression;\n\nIndicate a filter expression with WHERE is optional.\nThe SELECT statement must always end with a semicolon.", "SELECT COUNT(*) FROM {{table}} WHERE filter ;", new String[]{"table - Name of the table", "filter - boolean expression with the filter to apply"}, "Long", false);
    }

    public boolean isHidden() {
        return false;
    }

    public boolean allowConstantFolding() {
        return false;
    }

    public boolean useArgumentsInsteadObjects() {
        return true;
    }

    public Object call(Interpreter interpreter, Object[] args) throws Exception {
        throw new UnsupportedOperationException();
    }

    public Object call(Interpreter interpreter, Codes args) throws Exception {
        String storeName = this.getIdentifier(args, 0);
        Code where = this.getWhereCode(args, 1);
        Object selection_if_not_empty = this.getObject(interpreter, args, 2);
        try {
            FeatureStore featureStore = this.getFeatureStore(storeName);
            if (featureStore == null) {
                throw new ExpressionRuntimeException("Cant locate the feature store '" + storeName + "' in function '" + this.name() + "'.");
            }
            Object features = featureStore.getFeatureSelection();
            if (((FeatureSet)features).isEmpty() && selection_if_not_empty != null) {
                features = featureStore.getFeatureSet();
            }
            if (where != null) {
                FeatureSelection baseSelection = features;
                DefaultFeatureExpressionEvaluator evaluator = new DefaultFeatureExpressionEvaluator(featureStore.getName(), where.toString());
                evaluator.toSymbolTable().addSymbolTable(interpreter.getSymbolTable());
                Predicate<Object> filter = t -> {
                    try {
                        return (Boolean)evaluator.evaluate((EvaluatorData)t);
                    }
                    catch (EvaluatorException ex1) {
                        throw new ExpressionRuntimeException("Can't evaluate expression for row.", (Throwable)ex1);
                    }
                };
                features = () -> SelectCountFromSelectionFunction.lambda$call$1((Iterable)baseSelection, filter);
            }
            return ContainerUtils.size64((Object)features);
        }
        catch (ExpressionRuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExpressionRuntimeException("Problems calling '" + this.name() + "' function", (Throwable)ex);
        }
    }

    private static /* synthetic */ Iterator lambda$call$1(Iterable baseSelection, Predicate filter) {
        return new FilteredIterator(baseSelection.iterator(), filter);
    }
}

