/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.expressionevaluator.impl.function.dataaccess;

import java.util.ArrayList;
import java.util.HashMap;
import org.apache.commons.lang3.Range;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.gvsig.expressionevaluator.Code;
import org.gvsig.expressionevaluator.CodeBuilder;
import org.gvsig.expressionevaluator.Codes;
import org.gvsig.expressionevaluator.ExpressionRuntimeException;
import org.gvsig.expressionevaluator.ExpressionUtils;
import org.gvsig.expressionevaluator.Interpreter;
import org.gvsig.expressionevaluator.Optimizer;
import org.gvsig.expressionevaluator.SymbolTable;
import org.gvsig.expressionevaluator.spi.AbstractFunction;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.DataStore;
import org.gvsig.fmap.dal.feature.EditableFeature;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureQuery;
import org.gvsig.fmap.dal.feature.FeatureSet;
import org.gvsig.fmap.dal.feature.FeatureStore;

public class UpdateFunction
extends AbstractFunction
implements Optimizer.FunctionOptimizer {
    private static final int TABLE = 0;
    private static final int WHERE = 1;

    public UpdateFunction() {
        super("Data access", "UPDATE", Range.is((Comparable)Integer.valueOf(6)), "bla bla bla", "UPDATE {{tablename}} SET column1 = exp1, column2 = exp2, ... WHERE expression;");
    }

    public boolean isHidden() {
        return false;
    }

    public boolean allowConstantFolding() {
        return false;
    }

    public boolean useArgumentsInsteadObjects() {
        return true;
    }

    public Object call(Interpreter interpreter, Object[] args) throws Exception {
        throw new UnsupportedOperationException();
    }

    public Object call(Interpreter interpreter, Codes args) throws Exception {
        SymbolTable symbolTable = interpreter.getSymbolTable();
        int num_columns = (args.size() - 2) / 2;
        int first_column = 2;
        int first_exp = num_columns + 2;
        Code.Identifier storeName = (Code.Identifier)args.get(0);
        Code where = (Code)args.get(1);
        if (where.code() == 0 && ((Code.Constant)where).value() == null) {
            where = null;
        }
        HashMap<String, Code> values = new HashMap<String, Code>();
        for (int i = 0; i < num_columns; ++i) {
            Code.Identifier column = (Code.Identifier)args.get(first_column + i);
            Code exp = (Code)args.get(first_exp + i);
            values.put(column.name(), exp);
        }
        try {
            FeatureSet features;
            DataStore store = this.getStore(storeName.name());
            if (store == null) {
                throw new ExpressionRuntimeException("Cant locate the store '" + storeName + "' in function '" + "SELECT" + "'.");
            }
            if (!(store instanceof FeatureStore)) {
                throw new ExpressionRuntimeException("The store'" + storeName + "' is not valid for function '" + "SELECT" + "', a FeatureStore is required.");
            }
            FeatureStore featureStore = (FeatureStore)store;
            if (where == null) {
                features = featureStore.getFeatureSet();
            } else {
                where = this.replaceLocalReferences(symbolTable, where);
                FeatureQuery query = featureStore.createFeatureQuery(where.toString(), (String)null, true);
                query.retrievesAllAttributes();
                features = featureStore.getFeatureSet(query);
            }
            if (features == null) {
                return 0;
            }
            long count = 0L;
            featureStore.edit();
            for (Feature feature : features) {
                EditableFeature ef = feature.getEditable();
                for (String column : values.keySet()) {
                    Code exp = (Code)values.get(column);
                    exp = this.replaceLocalReferences(symbolTable, exp);
                    Object value = interpreter.run(exp);
                    ef.set(column, value);
                    featureStore.update(ef);
                }
                ++count;
            }
            featureStore.finishEditing();
            return count;
        }
        catch (ExpressionRuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExpressionRuntimeException("Problems calling 'SELECT' function", (Throwable)ex);
        }
    }

    protected DataStore getStore(String storeName) {
        DataManager dataManager = DALLocator.getDataManager();
        DataStore store = dataManager.getStoresRepository().getStore(storeName);
        return store;
    }

    public Code optimize(Optimizer optimizer, Code.Callable caller) {
        return caller;
    }

    private Code replaceLocalReferences(SymbolTable symbolTable, Code where) {
        try {
            ArrayList replaces = new ArrayList();
            CodeBuilder codeBuilder = ExpressionUtils.createCodeBuilder();
            Code where2 = where.clone();
            where2.accept(o -> {
                String id;
                if (o == null) {
                    return;
                }
                Code code = (Code)o;
                if (code.code() == 1 && (id = ((Code.Identifier)code).name()).startsWith("@")) {
                    replaces.add(new ImmutablePair((Object)code, (Object)codeBuilder.constant(symbolTable.value(id.substring(1)))));
                }
            });
            if (replaces.isEmpty()) {
                return where;
            }
            for (Pair replace : replaces) {
                if (replace == null) continue;
                where2.replace((Code)replace.getLeft(), (Code)replace.getRight());
            }
            return where2;
        }
        catch (Exception ex) {
            throw new ExpressionRuntimeException("Can't resolve local variables.", (Throwable)ex);
        }
    }
}

