/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.expressionevaluator.impl.grammars;

import java.util.UUID;
import org.gvsig.expressionevaluator.Code;
import org.gvsig.expressionevaluator.CodeBuilder;
import org.gvsig.expressionevaluator.Codes;
import org.gvsig.expressionevaluator.ExpressionEvaluatorLocator;
import org.gvsig.expressionevaluator.ExpressionEvaluatorManager;
import org.gvsig.expressionevaluator.Grammar;
import org.gvsig.expressionevaluator.GrammarFactory;
import org.gvsig.expressionevaluator.MutableCodes;
import org.gvsig.expressionevaluator.Statement;
import org.gvsig.expressionevaluator.impl.DefaultCodeBuilder;
import org.gvsig.expressionevaluator.impl.DefaultStatement;
import org.gvsig.expressionevaluator.impl.function.dataaccess.SelectAggregateFunction;
import org.gvsig.expressionevaluator.spi.AbstractGrammarFactory;

public class DataAccessGrammarFactory
extends AbstractGrammarFactory {
    public static final String COMPATIBILITY_SELECT_ID = "SELECT";
    public static final String COMPATIBILITY_SELECT_OPTIONAL_SEMICOLON_AT_END = "OPTIONAL_SEMICOLON_AT_END";
    private Grammar grammar;

    public DataAccessGrammarFactory() {
        super("DataAccess", true);
    }

    public Grammar create(Object ... parameters) {
        ExpressionEvaluatorManager manager = ExpressionEvaluatorLocator.getManager();
        if (this.grammar == null) {
            Grammar theGrammar = manager.createGrammar(this.getName());
            theGrammar.addStatement(this.createCreateInMemoryTableStatement(theGrammar));
            theGrammar.addStatement(this.createCreateTableStatement(theGrammar));
            theGrammar.addStatement(this.createCreateTableStructureStatement(theGrammar));
            theGrammar.addStatement(this.createExistsStatement(theGrammar));
            theGrammar.addStatement(this.createForeingValueStatement(theGrammar));
            theGrammar.addStatement(this.createInsertIntoTableSelectStatement(theGrammar));
            theGrammar.addStatement(this.createSelectCountStatement(theGrammar));
            theGrammar.addStatement(this.createSelectAggregateStatement(theGrammar));
            theGrammar.addStatement(this.createSelectStatement(theGrammar));
            theGrammar.addStatement(this.createSelectCountFromSelectionStatement(theGrammar));
            this.grammar = theGrammar;
        }
        return this.grammar;
    }

    private Statement createExistsStatement(Grammar theGrammar) {
        theGrammar.addReservedWord("EXISTS");
        Statement stmt = theGrammar.createStatement("EXISTS");
        stmt.addRule(stmt.require_any_token(new String[]{"EXISTS"}));
        stmt.addRule(stmt.require_any_token(new String[]{"("}));
        stmt.addRule(stmt.require_expression().capture_as(new String[]{"LIST"}));
        stmt.addRule((Statement.Rule)stmt.optional_any_token(new String[]{","}).addRuleOnTrue(stmt.require_expression().capture_as(new String[]{"ID"})));
        stmt.addRule(stmt.require_any_token(new String[]{")"}));
        stmt.builder((Statement.StatementBuilder)new ExistsStatementBuilder("LIST", "ID"));
        return stmt;
    }

    private Statement createForeingValueStatement(Grammar theGrammar) {
        theGrammar.addReservedWord("FROM");
        Statement stmt = theGrammar.createStatement("FOREIGN_VALUE");
        stmt.addRule(stmt.require_any_token(new String[]{"FOREING", "FOREIGN"}));
        stmt.addRule(stmt.require_any_token(new String[]{"VALUE"}));
        stmt.addRule(stmt.require_any_token(new String[]{"FROM"}));
        stmt.addRule(stmt.require_identifiers_as_string(".").capture_as(new String[]{"IDENTIFIERS"}));
        stmt.code("FOREIGN_VALUE", stmt.args_names(new String[]{"IDENTIFIERS"}));
        return stmt;
    }

    private Statement createCreateInMemoryTableStatement(Grammar theGrammar) {
        theGrammar.addReservedWord("FROM");
        Statement stmt = theGrammar.createStatement("CREATE_IN_MEMORY_TABLE");
        stmt.addRule(stmt.require_any_token(new String[]{"CREATE"}));
        stmt.addRule(stmt.require_any_token(new String[]{"IN"}));
        stmt.addRule(stmt.require_any_token(new String[]{"MEMORY"}));
        stmt.addRule(stmt.require_any_token(new String[]{"TABLE"}));
        stmt.addRule(stmt.require_identifier().capture_as(new String[]{"NEWTABLE"}));
        stmt.addRule(stmt.require_any_token(new String[]{"FROM"}));
        stmt.addRule(stmt.require_identifier().capture_as(new String[]{"SOURCETABLE"}));
        stmt.code("FOREING_VALUE", stmt.args_names(new String[]{"NEWTABLE", "SOURCETABLE"}));
        return stmt;
    }

    private Statement createSelectStatement(Grammar theGrammar) {
        theGrammar.addReservedWord(COMPATIBILITY_SELECT_ID);
        theGrammar.addReservedWord("FROM");
        theGrammar.addReservedWord("WHERE");
        theGrammar.addReservedWord("ORDER");
        theGrammar.addReservedWord("BY");
        theGrammar.addReservedWord("DESC");
        theGrammar.addReservedWord("ASC");
        theGrammar.addReservedWord("LIMIT");
        ExpressionEvaluatorManager manager = ExpressionEvaluatorLocator.getManager();
        CodeBuilder codeBuilder = manager.createCodeBuilder();
        Statement stmt = theGrammar.createStatement(COMPATIBILITY_SELECT_ID);
        stmt.addRule(stmt.require_any_token(new String[]{COMPATIBILITY_SELECT_ID}));
        stmt.addRule((Statement.Rule)stmt.optional_any_token(new String[]{"*", "1"}).addRuleOnTrue(stmt.set_expression("COLUMNS", (Object)codeBuilder.tuple())).addRuleOnTrue((Statement.Rule)stmt.optional_any_token(new String[]{"INTO"}).addRuleOnTrue(stmt.require_identifier().capture_as(new String[]{"INTOVAR"}))).addRuleOnFalse(stmt.require_expressions(",").capture_as(new String[]{"COLUMNS"})));
        stmt.addRule(stmt.require_any_token(new String[]{"FROM"}));
        stmt.addRule((Statement.Rule)stmt.optional_any_token(new String[]{"SELECTION"}).capture_as(new String[]{"SELECTION"}).addRuleOnTrue((Statement.Rule)stmt.optional_any_token(new String[]{"IF"}).addRuleOnTrue(stmt.require_tokens(new String[]{"NOT", "EMPTY"}).capture_as(new String[]{"IF_NOT_EMPTY"}))).addRuleOnTrue((Statement.Rule)stmt.optional_any_token(new String[]{"OF"})));
        stmt.addRule(stmt.require_expression().capture_as(new String[]{"TABLE"}));
        stmt.addRule((Statement.Rule)stmt.optional_any_token(new String[]{"WHERE"}).addRuleOnTrue(stmt.require_expression().capture_as(new String[]{"WHERE"})));
        stmt.addRule((Statement.Rule)stmt.optional_any_token(new String[]{"ORDER"}).addRuleOnTrue(stmt.require_any_token(new String[]{"BY"})).addRuleOnTrue((Statement.Rule)stmt.repeat().addRule(stmt.require_expression().capture_as(new String[]{"ORDER#"})).addRule((Statement.Rule)stmt.switch_token().addCase("ASC", new Statement.Rule[]{stmt.set_expression("ORDER_MODE#", (Object)true)}).addCase("DESC", new Statement.Rule[]{stmt.set_expression("ORDER_MODE#", (Object)false)}).addDefault(new Statement.Rule[]{stmt.set_expression("ORDER_MODE#", (Object)true)})).addRule((Statement.Rule)stmt.optional_any_token(new String[]{"NULLS"}).addRuleOnTrue(stmt.require_any_token(new String[]{"LAST", "FIRST"}).capture_as(new String[]{"NULLS_MODE#"}))).addRule((Statement.Rule)stmt.optional_any_token(new String[]{","}).addRuleOnFalse(stmt.break_loop()))));
        stmt.addRule((Statement.Rule)stmt.optional_any_token(new String[]{"LIMIT"}).addRuleOnTrue(stmt.require_expression().capture_as(new String[]{"LIMIT"})));
        stmt.addRule((Statement.Rule)stmt.if_compatibility_contains(COMPATIBILITY_SELECT_ID, COMPATIBILITY_SELECT_OPTIONAL_SEMICOLON_AT_END).addRuleOnTrue((Statement.Rule)stmt.optional_any_token(new String[]{";"})));
        stmt.code(COMPATIBILITY_SELECT_ID, (Statement.ArgsBuilder)new SelectArgsBuilder());
        return stmt;
    }

    private Statement createSelectIntoStatement(Grammar theGrammar) {
        theGrammar.addReservedWord(COMPATIBILITY_SELECT_ID);
        theGrammar.addReservedWord("FROM");
        theGrammar.addReservedWord("WHERE");
        theGrammar.addReservedWord("ORDER");
        theGrammar.addReservedWord("BY");
        theGrammar.addReservedWord("DESC");
        theGrammar.addReservedWord("ASC");
        theGrammar.addReservedWord("LIMIT");
        Statement stmt = theGrammar.createStatement(COMPATIBILITY_SELECT_ID);
        stmt.addRule(stmt.require_any_token(new String[]{COMPATIBILITY_SELECT_ID}));
        stmt.addRule(stmt.require_any_token(new String[]{"*"}));
        stmt.addRule(stmt.require_any_token(new String[]{"INTO"}));
        stmt.addRule(stmt.require_identifier().capture_as(new String[]{"INTOVAR"}));
        stmt.addRule(stmt.require_any_token(new String[]{"FROM"}));
        stmt.addRule(stmt.require_expression().capture_as(new String[]{"TABLE"}));
        stmt.addRule((Statement.Rule)stmt.optional_any_token(new String[]{"WHERE"}).addRuleOnTrue(stmt.require_expression().capture_as(new String[]{"WHERE"})));
        stmt.addRule((Statement.Rule)stmt.optional_any_token(new String[]{"ORDER"}).addRuleOnTrue(stmt.require_any_token(new String[]{"BY"})).addRuleOnTrue((Statement.Rule)stmt.repeat().addRule(stmt.require_expression().capture_as(new String[]{"ORDER#"})).addRule((Statement.Rule)stmt.switch_token().addCase("ASC", new Statement.Rule[]{stmt.set_expression("ORDER_MODE#", (Object)true)}).addCase("DESC", new Statement.Rule[]{stmt.set_expression("ORDER_MODE#", (Object)false)}).addDefault(new Statement.Rule[]{stmt.set_expression("ORDER_MODE#", (Object)true)})).addRule((Statement.Rule)stmt.optional_any_token(new String[]{","}).addRuleOnFalse(stmt.break_loop()))));
        stmt.addRule((Statement.Rule)stmt.optional_any_token(new String[]{"LIMIT"}).addRuleOnTrue(stmt.require_expression().capture_as(new String[]{"LIMIT"})));
        stmt.code(COMPATIBILITY_SELECT_ID, (Statement.ArgsBuilder)new SelectArgsBuilder());
        return stmt;
    }

    private Statement createSelectFromSelectionStatement(Grammar theGrammar) {
        ExpressionEvaluatorManager manager = ExpressionEvaluatorLocator.getManager();
        CodeBuilder codeBuilder = manager.createCodeBuilder();
        Statement stmt = theGrammar.createStatement("SELECTFROMSELECTION");
        stmt.addRule(stmt.require_any_token(new String[]{COMPATIBILITY_SELECT_ID}));
        stmt.addRule((Statement.Rule)stmt.optional_any_token(new String[]{"*", "1"}).addRuleOnTrue(stmt.set_expression("COLUMNS", (Object)codeBuilder.tuple())).addRuleOnFalse(stmt.require_identifiers(",").capture_as(new String[]{"COLUMNS"})));
        stmt.addRule(stmt.require_any_token(new String[]{"FROM"}));
        stmt.addRule(stmt.require_any_token(new String[]{"SELECTION"}));
        stmt.addRule((Statement.Rule)stmt.optional_any_token(new String[]{"IF"}).addRuleOnTrue(stmt.require_tokens(new String[]{"NOT", "EMPTY"}).capture_as(new String[]{"IF_NOT_EMPTY"})));
        stmt.addRule((Statement.Rule)stmt.optional_any_token(new String[]{"OF"}));
        stmt.addRule(stmt.require_expression().capture_as(new String[]{"TABLE"}));
        stmt.addRule((Statement.Rule)stmt.optional_any_token(new String[]{"WHERE"}).addRuleOnTrue(stmt.require_expression().capture_as(new String[]{"WHERE"})));
        stmt.addRule((Statement.Rule)stmt.optional_any_token(new String[]{"LIMIT"}).addRuleOnTrue(stmt.require_expression().capture_as(new String[]{"LIMIT"})));
        stmt.addRule((Statement.Rule)stmt.optional_any_token(new String[]{";"}));
        stmt.code("SELECTFROMSELECTION", stmt.args_names(new String[]{"COLUMNS", "TABLE", "WHERE", "LIMIT", "IF_NOT_EMPTY"}));
        return stmt;
    }

    private Statement createInsertIntoTableSelectStatement(Grammar theGrammar) {
        theGrammar.addReservedWord("INSERT");
        theGrammar.addReservedWord("INTO");
        theGrammar.addReservedWord(COMPATIBILITY_SELECT_ID);
        theGrammar.addReservedWord("FROM");
        theGrammar.addReservedWord("WHERE");
        theGrammar.addReservedWord("ORDER");
        theGrammar.addReservedWord("BY");
        theGrammar.addReservedWord("LIMIT");
        ExpressionEvaluatorManager manager = ExpressionEvaluatorLocator.getManager();
        CodeBuilder codeBuilder = manager.createCodeBuilder();
        Statement stmt = theGrammar.createStatement("INSERT_INTO_SELECT");
        stmt.addRule(stmt.require_any_token(new String[]{"INSERT"}));
        stmt.addRule(stmt.require_any_token(new String[]{"INTO"}));
        stmt.addRule(stmt.require_identifier().capture_as(new String[]{"TARGETTABLE"}));
        stmt.addRule(stmt.require_any_token(new String[]{COMPATIBILITY_SELECT_ID}));
        stmt.addRule((Statement.Rule)stmt.optional_any_token(new String[]{"*"}).addRuleOnTrue(stmt.set_expression("COLUMNS", (Object)codeBuilder.tuple())).addRuleOnFalse(stmt.require_identifiers(",").capture_as(new String[]{"COLUMNS"})));
        stmt.addRule(stmt.require_any_token(new String[]{"FROM"}));
        stmt.addRule(stmt.require_identifier().capture_as(new String[]{"TABLE"}));
        stmt.addRule((Statement.Rule)stmt.optional_any_token(new String[]{"WHERE"}).addRuleOnTrue(stmt.require_expression().capture_as(new String[]{"WHERE"})));
        stmt.addRule((Statement.Rule)stmt.optional_any_token(new String[]{"ORDER"}).addRuleOnTrue(stmt.require_any_token(new String[]{"BY"})).addRuleOnTrue((Statement.Rule)stmt.repeat().addRule(stmt.require_expression().capture_as(new String[]{"ORDER#"})).addRule((Statement.Rule)stmt.switch_token().addCase("ASC", new Statement.Rule[]{stmt.set_expression("ORDER_MODE#", (Object)true)}).addCase("DESC", new Statement.Rule[]{stmt.set_expression("ORDER_MODE#", (Object)false)}).addDefault(new Statement.Rule[]{stmt.set_expression("ORDER_MODE#", (Object)true)})).addRule((Statement.Rule)stmt.optional_any_token(new String[]{","}).addRuleOnFalse(stmt.break_loop()))));
        stmt.addRule((Statement.Rule)stmt.optional_any_token(new String[]{"LIMIT"}).addRuleOnTrue(stmt.require_expression().capture_as(new String[]{"LIMIT"})));
        stmt.addRule((Statement.Rule)stmt.optional_any_token(new String[]{";"}));
        stmt.code("INSERT_INTO_TABLE", (Statement.ArgsBuilder)new InsertIntoArgsBuilder());
        return stmt;
    }

    private Statement createSelectCountStatement(Grammar theGrammar) {
        theGrammar.addReservedWord(COMPATIBILITY_SELECT_ID);
        theGrammar.addReservedWord("FROM");
        theGrammar.addReservedWord("WHERE");
        Statement stmt = theGrammar.createStatement("SELECT_COUNT");
        stmt.addRule(stmt.require_any_token(new String[]{COMPATIBILITY_SELECT_ID}));
        stmt.addRule(stmt.require_any_token(new String[]{"COUNT"}));
        stmt.addRule(stmt.require_any_token(new String[]{"("}));
        stmt.addRule(stmt.require_any_token(new String[]{"*"}));
        stmt.addRule(stmt.require_any_token(new String[]{")"}));
        stmt.addRule(stmt.require_any_token(new String[]{"FROM"}));
        stmt.addRule(stmt.require_expression().capture_as(new String[]{"TABLE"}));
        stmt.addRule((Statement.Rule)stmt.optional_any_token(new String[]{"WHERE"}).addRuleOnTrue(stmt.require_expression().capture_as(new String[]{"WHERE"})));
        stmt.addRule((Statement.Rule)stmt.optional_any_token(new String[]{";"}));
        stmt.code("SELECT_COUNT", (Statement.ArgsBuilder)new SelectCountArgsBuilder());
        return stmt;
    }

    private Statement createSelectAggregateStatement(Grammar theGrammar) {
        theGrammar.addReservedWord(COMPATIBILITY_SELECT_ID);
        theGrammar.addReservedWord("FROM");
        theGrammar.addReservedWord("WHERE");
        Statement stmt = theGrammar.createStatement("SELECT_COUNT");
        stmt.addRule(stmt.require_any_token(new String[]{COMPATIBILITY_SELECT_ID}));
        stmt.addRule(stmt.require_any_token(new String[]{"COUNT", "SUM", "MIN", "MAX", "AVG"}).capture_as(new String[]{"AGGREGATE_FUNCTION"}));
        stmt.addRule(stmt.require_any_token(new String[]{"("}));
        stmt.addRule(stmt.require_identifier().capture_as(new String[]{"AGGREGATE_COLUMN"}));
        stmt.addRule(stmt.require_any_token(new String[]{")"}));
        stmt.addRule(stmt.require_any_token(new String[]{"FROM"}));
        stmt.addRule(stmt.require_expression().capture_as(new String[]{"TABLE"}));
        stmt.addRule((Statement.Rule)stmt.optional_any_token(new String[]{"WHERE"}).addRuleOnTrue(stmt.require_expression().capture_as(new String[]{"WHERE"})));
        stmt.addRule((Statement.Rule)stmt.optional_any_token(new String[]{";"}));
        stmt.code(SelectAggregateFunction.FUNCTION_SELECT_AGGREGATE, (Statement.ArgsBuilder)new SelectAggregateArgsBuilder());
        return stmt;
    }

    private Statement createSelectCountFromSelectionStatement(Grammar theGrammar) {
        Statement stmt = theGrammar.createStatement("SELECT_COUNT_FROM_SELECTION");
        stmt.addRule(stmt.require_any_token(new String[]{COMPATIBILITY_SELECT_ID}));
        stmt.addRule(stmt.require_any_token(new String[]{"COUNT"}));
        stmt.addRule(stmt.require_any_token(new String[]{"("}));
        stmt.addRule(stmt.require_any_token(new String[]{"*"}));
        stmt.addRule(stmt.require_any_token(new String[]{")"}));
        stmt.addRule(stmt.require_any_token(new String[]{"FROM"}));
        stmt.addRule(stmt.require_any_token(new String[]{"SELECTION"}));
        stmt.addRule((Statement.Rule)stmt.optional_any_token(new String[]{"IF"}).addRuleOnTrue(stmt.require_tokens(new String[]{"NOT", "EMPTY"}).capture_as(new String[]{"IF_NOT_EMPTY"})));
        stmt.addRule(stmt.require_any_token(new String[]{"OF"}));
        stmt.addRule(stmt.require_expression().capture_as(new String[]{"TABLE"}));
        stmt.addRule((Statement.Rule)stmt.optional_any_token(new String[]{"WHERE"}).addRuleOnTrue(stmt.require_expression().capture_as(new String[]{"WHERE"})));
        stmt.addRule(stmt.require_any_token(new String[]{";"}));
        stmt.code("SELECTCOUNTFROMSELECTION", stmt.args_names(new String[]{"TABLE", "WHERE", "IF_NOT_EMPTY"}));
        return stmt;
    }

    private Statement createCreateTableStatement(Grammar theGrammar) {
        theGrammar.addReservedWord("CREATE");
        Statement stmt = theGrammar.createStatement("CREATE_TABLE");
        stmt.addRule(stmt.require_any_token(new String[]{"CREATE"}));
        stmt.addRule(stmt.require_any_token(new String[]{"TABLE"}));
        stmt.addRule(stmt.require_expression().capture_as(new String[]{"STRUCTURE"}));
        stmt.addRule(stmt.require_any_token(new String[]{"IN"}));
        stmt.addRule(stmt.require_expression().capture_as(new String[]{"LOCATION"}));
        stmt.code("CREATE_TABLE", stmt.args_names(new String[]{"STRUCTURE", "LOCATION"}));
        return stmt;
    }

    private Statement createCreateTableStructureStatement(Grammar theGrammar) {
        theGrammar.addReservedWord("CREATE");
        Statement stmt = theGrammar.createStatement("CREATE_TABLE_STRUCTURE");
        stmt.addRule(stmt.require_any_token(new String[]{"CREATE"}));
        stmt.addRule(stmt.require_any_token(new String[]{"TABLE"}));
        stmt.addRule(stmt.require_any_token(new String[]{"STRUCTURE"}));
        stmt.addRule(stmt.require_expression().capture_as(new String[]{"STRUCTURE"}));
        stmt.code("CREATE_TABLE_STRUCTURE", stmt.args_names(new String[]{"STRUCTURE"}));
        return stmt;
    }

    private Statement createInsertIntoTableStatement(Grammar theGrammar) {
        theGrammar.addReservedWord("INSERT");
        theGrammar.addReservedWord("INTO");
        Statement stmt = theGrammar.createStatement("INSERT_INTO");
        stmt.addRule(stmt.require_any_token(new String[]{"INSERT"}));
        stmt.addRule(stmt.require_any_token(new String[]{"INTO"}));
        stmt.addRule(stmt.require_identifier().capture_as(new String[]{"TARGETTABLE"}));
        stmt.addRule(stmt.require_any_token(new String[]{"("}));
        stmt.addRule(stmt.require_identifiers(",").capture_as(new String[]{"COLUMNS"}));
        stmt.addRule(stmt.require_any_token(new String[]{")"}));
        stmt.addRule(stmt.require_any_token(new String[]{"VALUES"}));
        stmt.addRule((Statement.Rule)stmt.optional_any_token(new String[]{"("}).addRuleOnTrue(stmt.require_expressions(",").capture_as(new String[]{"VALUES"})).addRuleOnTrue(stmt.require_any_token(new String[]{")"})).addRuleOnFalse(stmt.require_expression().capture_as(new String[]{"VALUES"})));
        stmt.addRule((Statement.Rule)stmt.optional_any_token(new String[]{";"}));
        return stmt;
    }

    private Statement createUpdateStatement(Grammar theGrammar) {
        theGrammar.addReservedWord("UPDATE");
        theGrammar.addReservedWord("WHERE");
        Statement stmt = theGrammar.createStatement("UPDATE");
        stmt.addRule(stmt.require_any_token(new String[]{"UPDATE"}));
        stmt.addRule(stmt.require_identifier().capture_as(new String[]{"TABLE"}));
        stmt.addRule(stmt.require_any_token(new String[]{"SET"}));
        stmt.addRule((Statement.Rule)stmt.repeat_until_any_tokens(new String[]{"WHERE"}).addRule(stmt.require_identifier().capture_as(new String[]{"#COLUMNS"})).addRule(stmt.require_any_token(new String[]{"="})).addRule(stmt.require_expression().capture_as(new String[]{"#VALUES"})));
        stmt.addRule(stmt.require_expression().capture_as(new String[]{"CONDITION"}));
        stmt.addRule((Statement.Rule)stmt.optional_any_token(new String[]{";"}));
        stmt.code("UPDATE", stmt.args_names(new String[]{"TABLE", "CONDITION", "#COLUMNS", "#VALUES"}));
        return stmt;
    }

    private Statement createDeleteFromTableStatement(Grammar theGrammar) {
        theGrammar.addReservedWord("DELETE");
        theGrammar.addReservedWord("WHERE");
        Statement stmt = theGrammar.createStatement("DELETE");
        stmt.addRule(stmt.require_any_token(new String[]{"DELETE"}));
        stmt.addRule(stmt.require_identifier().capture_as(new String[]{"TABLE"}));
        stmt.addRule(stmt.require_any_token(new String[]{"WHERE"}));
        stmt.addRule(stmt.require_expression().capture_as(new String[]{"CONDITION"}));
        stmt.addRule((Statement.Rule)stmt.optional_any_token(new String[]{";"}));
        return stmt;
    }

    public static final void selfRegister() {
        ExpressionEvaluatorManager manager = ExpressionEvaluatorLocator.getManager();
        manager.registerGrammar((GrammarFactory)new DataAccessGrammarFactory());
    }

    private static class SelectAggregateArgsBuilder
    implements Statement.ArgsBuilder {
        public String toString() {
            return "select_aggregate_args()";
        }

        public Codes build(Statement.StatementContext context) {
            context.trace(this.toString() + ".build");
            CodeBuilder codeBuilder = context.getCodeBuilder();
            MutableCodes args = codeBuilder.args();
            Code table = context.getCode("table");
            Code where = context.getCode("where");
            Code aggregateFunction = context.getCode("AGGREGATE_FUNCTION");
            Code aggregateColumn = context.getCode("AGGREGATE_COLUMN");
            args.add(table);
            if (where == null) {
                args.add((Code)codeBuilder.constant(null));
            } else {
                args.add(where);
            }
            args.add(aggregateFunction);
            args.add(aggregateColumn);
            return args;
        }
    }

    private static class SelectCountArgsBuilder
    implements Statement.ArgsBuilder {
        public String toString() {
            return "select_count_args()";
        }

        public Codes build(Statement.StatementContext context) {
            context.trace(this.toString() + ".build");
            CodeBuilder codeBuilder = context.getCodeBuilder();
            MutableCodes args = codeBuilder.args();
            Code table = context.getCode("table");
            Code where = context.getCode("where");
            args.add(table);
            if (where == null) {
                args.add((Code)codeBuilder.constant(null));
            } else {
                args.add(where);
            }
            return args;
        }
    }

    private static class InsertIntoArgsBuilder
    extends SelectArgsBuilder
    implements Statement.ArgsBuilder {
        @Override
        public String toString() {
            return "insert_into_args()";
        }

        @Override
        public Codes build(Statement.StatementContext context) {
            context.trace(this.toString() + ".build");
            CodeBuilder codeBuilder = context.getCodeBuilder();
            MutableCodes args = codeBuilder.args();
            Code table = context.getCode("TARGETTABLE");
            args.add((Code)codeBuilder.identifier((String)((Code.Constant)table).value()));
            return this.build(context, args);
        }
    }

    private static class SelectArgsBuilder
    implements Statement.ArgsBuilder {
        public String toString() {
            return "select_args()";
        }

        public Codes build(Statement.StatementContext context) {
            context.trace(this.toString() + ".build");
            CodeBuilder codeBuilder = context.getCodeBuilder();
            MutableCodes args = codeBuilder.args();
            return this.build(context, args);
        }

        public Codes build(Statement.StatementContext context, MutableCodes args) {
            String argNameX;
            Code code;
            CodeBuilder codeBuilder = context.getCodeBuilder();
            Code columns = context.getCode("COLUMNS");
            args.add(columns);
            Code table = context.getCode("TABLE");
            args.add(table);
            Code where = context.getCode("WHERE");
            if (where == null) {
                args.add((Code)codeBuilder.constant(null));
            } else {
                args.add(where);
            }
            int n = 1;
            MutableCodes argsX = codeBuilder.args();
            while ((code = context.getCode(argNameX = "ORDER" + String.valueOf(n))) != null) {
                argsX.add(code);
                ++n;
            }
            args.add((Code)codeBuilder.tuple((Codes)argsX));
            n = 1;
            argsX = codeBuilder.args();
            while ((code = context.getCode(argNameX = "ORDER_MODE" + String.valueOf(n))) != null) {
                argsX.add(code);
                ++n;
            }
            args.add((Code)codeBuilder.tuple((Codes)argsX));
            Code limit = context.getCode("LIMIT");
            if (limit == null) {
                args.add((Code)codeBuilder.constant(null));
            } else {
                args.add(limit);
            }
            Code intovar = context.getCode("INTOVAR");
            if (intovar != null) {
                args.add(intovar);
            }
            int mode = 0;
            Code selection = context.getCode("SELECTION");
            Code if_not_empty = context.getCode("IF_NOT_EMPTY");
            if (selection != null) {
                mode = if_not_empty == null ? 1 : 2;
            }
            if (mode != 0) {
                if (intovar == null) {
                    args.add(intovar);
                }
                args.add((Code)codeBuilder.constant((Object)mode));
            }
            return args;
        }
    }

    private static class ExistsStatementBuilder
    extends DefaultStatement.StatementBuilderBase {
        private final String listID;
        private final String existsID;

        public ExistsStatementBuilder(String listID, String existsID) {
            super("EXISTS", (Statement.ArgsBuilder)new DefaultStatement.ArgsBuilderFromNames(new String[]{listID, existsID}));
            this.listID = listID;
            this.existsID = existsID;
        }

        public Code build(Statement.StatementContext context) {
            CodeBuilder codeBuilder = context.getCodeBuilder();
            Code.Callable code = (Code.Callable)super.build(context);
            DefaultCodeBuilder.BaseCodes args = (DefaultCodeBuilder.BaseCodes)code.parameters();
            if (args.size() < 2) {
                String exists_id = "EXISTS" + UUID.randomUUID().toString().replaceAll("-", "");
                args.add((Code)codeBuilder.constant((Object)exists_id));
            } else if (args.get(1) == null) {
                String exists_id = "EXISTS" + UUID.randomUUID().toString().replaceAll("-", "");
                args.set(1, (Code)codeBuilder.constant((Object)exists_id));
            }
            code = codeBuilder.function("EXISTS", (Codes)args);
            return code;
        }
    }
}

