/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.complements.relatedfeatures;

import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.expressionevaluator.ExpressionBuilder;
import org.gvsig.expressionevaluator.ExpressionUtils;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.StoresRepository;
import org.gvsig.fmap.dal.complements.RelatedFeatures;
import org.gvsig.fmap.dal.complements.Search;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureQuery;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.feature.ForeingKey;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.complement.AbstractComplement;
import org.gvsig.tools.complement.ComplementFactory;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposeUtils;
import org.gvsig.tools.dynobject.Tagged;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RelatedFeaturesImpl
extends AbstractComplement<Tagged>
implements RelatedFeatures {
    protected static final Logger LOGGER = LoggerFactory.getLogger(RelatedFeaturesImpl.class);

    public RelatedFeaturesImpl(ComplementFactory<Tagged> factory, Tagged object) {
        super(factory, (Object)object);
    }

    public boolean isRelatedFeatures() {
        return this.isRelatedFeatures(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRelatedFeatures(RelatedFeatures.ContextRelatedFeatures context) {
        context = this.createLocalContextIfNull(context);
        try {
            String tableName = this.getTableName();
            if (StringUtils.isBlank((CharSequence)tableName) || StringUtils.isBlank((CharSequence)this.getUniqueKeyName())) {
                boolean bl = false;
                return bl;
            }
            Tagged attribute = (Tagged)this.getObject();
            if (!(attribute instanceof FeatureAttributeDescriptor)) {
                boolean bl = true;
                return bl;
            }
            FeatureStore store = ((FeatureAttributeDescriptor)attribute).getStore();
            if (store == null) {
                boolean bl = true;
                return bl;
            }
            StoresRepository repository = store.getStoresRepository();
            boolean bl = repository.containsKey((Object)tableName);
            return bl;
        }
        finally {
            this.disposeIfLocalContext(context);
        }
    }

    public String getUniqueKeyName() {
        Tagged attribute = (Tagged)this.getObject();
        String codeName = attribute.getTags().getString("DAL.RelatedFeatures.Unique.Field.Name", null);
        return codeName;
    }

    public String getTableName() {
        Tagged attribute = (Tagged)this.getObject();
        String tableName = attribute.getTags().getString("DAL.RelatedFeatures.Table", null);
        return tableName;
    }

    public RelatedFeatures.ContextRelatedFeatures createContext() {
        return new DefaultContextRelatedFeatures();
    }

    private void disposeIfLocalContext(RelatedFeatures.ContextRelatedFeatures context) {
        DefaultContextRelatedFeatures c = (DefaultContextRelatedFeatures)context;
        c.release();
        if (c.refs == 0) {
            context.dispose();
        }
    }

    private RelatedFeatures.ContextRelatedFeatures createLocalContextIfNull(RelatedFeatures.ContextRelatedFeatures context) {
        if (context == null) {
            return new DefaultContextRelatedFeatures();
        }
        DefaultContextRelatedFeatures c = (DefaultContextRelatedFeatures)context;
        c.addRef();
        return c;
    }

    public FeatureStore getFeatureStore(RelatedFeatures.ContextRelatedFeatures context) {
        context = this.createLocalContextIfNull(context);
        try {
            FeatureStore featureStore = context.getFeatureStore();
            return featureStore;
        }
        finally {
            this.disposeIfLocalContext(context);
        }
    }

    public Object getUniqueKey(RelatedFeatures.ContextRelatedFeatures context, Feature feature) {
        return feature.get(this.getUniqueKeyName());
    }

    public FeatureQuery getForeingKeyQuery(RelatedFeatures.ContextRelatedFeatures context, Object codeValue) {
        if (!(this.getObject() instanceof FeatureAttributeDescriptor)) {
            return null;
        }
        String me = ((FeatureAttributeDescriptor)this.getObject()).getStore().getName();
        FeatureType ftype = context.getFeatureType();
        for (FeatureAttributeDescriptor attr : ftype) {
            ForeingKey fkey;
            if (!attr.isForeingKey() || !StringUtils.equals((CharSequence)(fkey = attr.getForeingKey()).getTableName(), (CharSequence)me)) continue;
            return this.getQuery(context, fkey.getCodeName(), codeValue);
        }
        return null;
    }

    public FeatureQuery getUniqueKeyQuery(RelatedFeatures.ContextRelatedFeatures context, Object codeValue) {
        return this.getQuery(context, this.getUniqueKeyName(), codeValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FeatureQuery getQuery(RelatedFeatures.ContextRelatedFeatures context, String fieldName, Object codeValue) {
        context = this.createLocalContextIfNull(context);
        try {
            FeatureStore store = context.getFeatureStore();
            ExpressionBuilder builder = ExpressionUtils.createExpressionBuilder();
            FeatureQuery query = store.createFeatureQuery();
            query.setFilter(builder.eq((ExpressionBuilder.Value)builder.variable(fieldName), (ExpressionBuilder.Value)builder.constant(codeValue)).toString());
            query.retrievesAllAttributes();
            FeatureQuery featureQuery = query;
            return featureQuery;
        }
        finally {
            this.disposeIfLocalContext(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getColumns(RelatedFeatures.ContextRelatedFeatures context) {
        context = this.createLocalContextIfNull(context);
        try {
            List columnNames;
            Tagged attribute = (Tagged)this.getObject();
            String columns = attribute.getTags().getString("DAL.RelatedFeatures.Columns", null);
            if (StringUtils.isBlank((CharSequence)columns)) {
                FeatureType featureType = context.getFeatureType();
                if (featureType == null) {
                    List<String> list = null;
                    return list;
                }
                Search search = (Search)ToolsLocator.getComplementsManager().get("DAL.Search", (Object)featureType);
                columnNames = search.getResultColumnNames();
            } else {
                columnNames = Arrays.asList(this.split(columns, ":/;,|-"));
            }
            List list = columnNames;
            return list;
        }
        finally {
            this.disposeIfLocalContext(context);
        }
    }

    private String[] split(String value, String separators) {
        int firstSeparatorPosition = 1000000;
        Character sep = null;
        for (char ch : separators.toCharArray()) {
            int pos = value.indexOf(ch);
            if (pos <= 0 || pos >= firstSeparatorPosition) continue;
            sep = Character.valueOf(ch);
            firstSeparatorPosition = pos;
        }
        if (sep == null) {
            return new String[]{value};
        }
        return value.split("[" + sep + "]");
    }

    private class DefaultContextRelatedFeatures
    implements RelatedFeatures.ContextRelatedFeatures {
        private FeatureStore featureStore = null;
        private StoresRepository storesRepository = null;
        private int refs = 1;

        public void addRef() {
            ++this.refs;
        }

        public void release() {
            --this.refs;
        }

        public void dispose() {
            DisposeUtils.disposeQuietly((Disposable)this.featureStore);
            this.featureStore = null;
            this.storesRepository = null;
        }

        public RelatedFeatures.ContextRelatedFeatures setStoresRepository(StoresRepository repository) {
            this.storesRepository = repository;
            return this;
        }

        public StoresRepository getStoresRepository() {
            if (this.storesRepository == null) {
                FeatureStore store = null;
                if (RelatedFeaturesImpl.this.getObject() instanceof FeatureAttributeDescriptor) {
                    store = ((FeatureAttributeDescriptor)RelatedFeaturesImpl.this.getObject()).getStore();
                } else if (RelatedFeaturesImpl.this.getObject() instanceof FeatureType) {
                    store = ((FeatureType)RelatedFeaturesImpl.this.getObject()).getStore();
                }
                this.storesRepository = store == null ? DALLocator.getDataManager().getStoresRepository() : store.getStoresRepository();
            }
            return this.storesRepository;
        }

        public FeatureStore getFeatureStore() {
            if (this.featureStore == null) {
                StoresRepository repository;
                FeatureStore store;
                if (RelatedFeaturesImpl.this.getObject() instanceof FeatureAttributeDescriptor && (store = ((FeatureAttributeDescriptor)RelatedFeaturesImpl.this.getObject()).getStore()) != null && (repository = store.getStoresRepository()).containsKey((Object)RelatedFeaturesImpl.this.getTableName())) {
                    this.featureStore = (FeatureStore)repository.getStore(RelatedFeaturesImpl.this.getTableName());
                    if (this.featureStore != null) {
                        return this.featureStore;
                    }
                }
                StoresRepository repository2 = this.getStoresRepository();
                this.featureStore = (FeatureStore)repository2.getStore(RelatedFeaturesImpl.this.getTableName());
                if (this.featureStore == null) {
                    LOGGER.warn("Can't locate store '" + RelatedFeaturesImpl.this.getTableName() + "'.");
                    return null;
                }
            }
            return this.featureStore;
        }

        public FeatureType getFeatureType() {
            try {
                FeatureStore store = this.getFeatureStore();
                return store.getDefaultFeatureType();
            }
            catch (Exception ex) {
                return null;
            }
        }
    }
}

