/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.feature.impl;

import java.io.File;
import java.lang.ref.WeakReference;
import java.math.BigDecimal;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.cresques.cts.IProjection;
import org.gvsig.expressionevaluator.Expression;
import org.gvsig.expressionevaluator.ExpressionBuilder;
import org.gvsig.expressionevaluator.ExpressionUtils;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.SupportTransactions;
import org.gvsig.fmap.dal.exception.DataEvaluatorRuntimeException;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.exception.DataRuntimeException;
import org.gvsig.fmap.dal.feature.DataProfile;
import org.gvsig.fmap.dal.feature.EditableFeature;
import org.gvsig.fmap.dal.feature.EditableFeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureAttributeEmulator;
import org.gvsig.fmap.dal.feature.FeatureAttributeGetter;
import org.gvsig.fmap.dal.feature.FeatureExtraColumns;
import org.gvsig.fmap.dal.feature.FeatureReference;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.feature.ForeingKey;
import org.gvsig.fmap.dal.feature.exception.IllegalValueException;
import org.gvsig.fmap.dal.feature.exception.SetReadOnlyAttributeException;
import org.gvsig.fmap.dal.feature.impl.DefaultEditableFeature;
import org.gvsig.fmap.dal.feature.impl.DefaultFeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.impl.DefaultFeatureType;
import org.gvsig.fmap.dal.feature.impl.dynobjectutils.DynObjectFeatureFacade;
import org.gvsig.fmap.dal.feature.impl.featurereference.FeatureReferenceFactory;
import org.gvsig.fmap.dal.feature.spi.DefaultFeatureProvider;
import org.gvsig.fmap.dal.feature.spi.FeatureProvider;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.json.Json;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dataTypes.Coercion;
import org.gvsig.tools.dataTypes.CoercionException;
import org.gvsig.tools.dataTypes.DataType;
import org.gvsig.tools.dataTypes.DataTypesManager;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposeUtils;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.dynobject.Tags;
import org.gvsig.tools.evaluator.Evaluator;
import org.gvsig.tools.evaluator.EvaluatorData;
import org.gvsig.tools.evaluator.EvaluatorException;
import org.gvsig.tools.exception.BaseException;
import org.gvsig.tools.exception.BaseRuntimeException;
import org.gvsig.tools.lang.Cloneable;
import org.gvsig.tools.resourcesstorage.FilesResourcesStorage;
import org.gvsig.tools.resourcesstorage.ResourcesStorage;
import org.gvsig.tools.util.Bitmask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultFeature
implements Feature,
EvaluatorData,
Cloneable {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultFeature.class);
    private static DataTypesManager dataTypesManager = null;
    protected FeatureProvider data;
    protected FeatureReference reference;
    private WeakReference storeRef;
    private boolean inserted = false;
    private Object[] extraValuesData;
    private Map<String, Object> extraValues;
    public static final String TOJSON_MODE = "mode";
    public static final String FORMAT_MODE = "format";
    public static final String FORMAT_MODE_GVSIGDESKTOP = "gvsigdesktop";
    public static final String FORMAT_MODE_GEOJSON = "geojson";
    public static final int TOJSON_MODE_SHALLOW = 0;
    public static final int TOJSON_MODE_DEEP = 1;
    public static final int TOJSON_MODE_COMPUTEDS = 2;
    public static final int TOJSON_MODE_COLLECTIONS = 4;

    public DefaultFeature(FeatureStore store) {
        this.storeRef = new WeakReference<FeatureStore>(store);
        this.reference = null;
    }

    public DefaultFeature(FeatureStore store, FeatureProvider data) {
        this.data = data;
        this.extraValuesData = null;
        this.storeRef = new WeakReference<FeatureStore>(store);
        this.reference = null;
        this.inserted = !data.isNew();
    }

    DefaultFeature(DefaultFeature feature) {
        this.data = feature.data.getCopy();
        this.extraValuesData = ArrayUtils.clone((Object[])feature.extraValuesData);
        this.storeRef = feature.storeRef;
        this.reference = feature.reference;
        this.inserted = feature.isInserted();
    }

    public DefaultFeature(FeatureType targetType, Feature sourceFeature) {
        DefaultFeature defaultFeature = (DefaultFeature)sourceFeature;
        this.data = new DefaultFeatureProvider(targetType, (DefaultFeatureProvider)defaultFeature.getData());
        this.extraValuesData = null;
        this.storeRef = defaultFeature.storeRef;
        this.reference = defaultFeature.reference;
        this.inserted = defaultFeature.isInserted();
        FeatureType sourceType = sourceFeature.getType();
        for (FeatureAttributeDescriptor targetAttrDescriptor : targetType) {
            Object value;
            int sourceIndex;
            if (targetAttrDescriptor.isComputed() || (sourceIndex = sourceType.getIndex(targetAttrDescriptor.getName())) < 0 || (value = sourceFeature.get(sourceIndex)) == null && !targetAttrDescriptor.allowNull()) continue;
            this.setforced(targetAttrDescriptor.getIndex(), targetAttrDescriptor, value);
        }
    }

    public void setData(FeatureProvider data) {
        this.data = data;
        this.extraValuesData = null;
        this.reference = null;
        this.inserted = true;
    }

    public FeatureProvider getData() {
        return this.data;
    }

    protected DataTypesManager getDataTypesManager() {
        if (dataTypesManager == null) {
            dataTypesManager = ToolsLocator.getDataTypesManager();
        }
        return dataTypesManager;
    }

    public boolean canSetValue(String name) {
        return this.canSetValue(this.getType().getAttributeDescriptor(name), null);
    }

    public boolean canSetValue(FeatureAttributeDescriptor attr, Predicate<FeatureAttributeDescriptor> copy) {
        if (attr == null) {
            return false;
        }
        if (attr.isAutomatic() || attr.isComputed()) {
            return false;
        }
        if (this.isInserted() && attr.isReadOnly()) {
            return false;
        }
        return copy == null || copy.test(attr);
    }

    protected void set(FeatureAttributeDescriptor attribute, Object value) {
        int i = attribute.getIndex();
        if (this.isInserted() ? attribute.isReadOnly() : attribute.isComputed()) {
            throw new SetReadOnlyAttributeException(attribute.getName(), this.getType());
        }
        FeatureAttributeEmulator emulator = attribute.getFeatureAttributeEmulator();
        if (emulator != null) {
            emulator.set((EditableFeature)this, value);
            return;
        }
        if (value == null) {
            if (this.isInserted() && !attribute.allowNull() && !attribute.isAutomatic()) {
                throw new IllegalValueException(attribute, value);
            }
            this.data.set(i, null);
            return;
        }
        if (attribute.getFeatureAttributeGetter() != null) {
            value = attribute.getFeatureAttributeGetter().setter(value);
        }
        this.setforced(i, attribute, value);
    }

    private void setforced(int i, FeatureAttributeDescriptor attribute, Object value) {
        Class objectClass = attribute.getObjectClass();
        if (objectClass != null) {
            DataProfile dataProfile;
            if (objectClass.isInstance(value)) {
                if (attribute.getType() == 19) {
                    BigDecimal d = (BigDecimal)value;
                    if (d.scale() == attribute.getScale() && d.precision() <= attribute.getPrecision()) {
                        this.data.set(i, value);
                        return;
                    }
                } else {
                    if (attribute.getType() == 66) {
                        if (!attribute.getGeomType().equals(((Geometry)value).getGeometryType())) {
                            try {
                                Coercion coercer = attribute.getDataType().getCoercion();
                                value = coercer.coerce(value, attribute.getCoercionContext());
                            }
                            catch (CoercionException e) {
                                throw new IllegalArgumentException("Can't convert to " + attribute.getDataType().getName() + " from '" + value == null ? "NULL" : value.getClass().getName() + "' with value '" + Objects.toString(value) + "' and context '" + attribute.getCoercionContext() + "'.", e);
                            }
                        }
                        this.data.set(i, value);
                        return;
                    }
                    this.data.set(i, value);
                    return;
                }
            }
            if ((dataProfile = attribute.getDataProfile()) != null) {
                try {
                    value = dataProfile.coerce(attribute.getDataType(), value, attribute.getTags());
                }
                catch (CoercionException coercionException) {
                    // empty catch block
                }
            }
            try {
                Coercion coercer = attribute.getDataType().getCoercion();
                if (attribute.getType() == 8 && value instanceof Boolean) {
                    value = coercer.coerce(value, attribute.getCoercionContext());
                    value = StringUtils.left((String)((String)value), (int)attribute.getSize());
                } else {
                    value = coercer.coerce(value, attribute.getCoercionContext());
                }
            }
            catch (CoercionException e) {
                throw new IllegalArgumentException("Can't assign value [" + this.toStringQuietly(value) + "] of type '" + (value == null ? "NULL" : value.getClass().getName()) + "' to field '" + attribute.getName() + "' of type " + attribute.getDataType().getName() + ".", e);
            }
        }
        this.data.set(i, value);
    }

    private String toStringQuietly(Object v) {
        try {
            return Objects.toString(v);
        }
        catch (Throwable t) {
            return "ERROR";
        }
    }

    private Object get(int index, Class theClass, int type) {
        Object value = this.get(index);
        if (theClass.isInstance(value)) {
            return value;
        }
        try {
            return this.getDataTypesManager().coerce(type, value, this.getType().getAttributeDescriptor(index).getCoercionContext());
        }
        catch (CoercionException e) {
            if (value == null) {
                return null;
            }
            throw new IllegalArgumentException("Can't convert to " + theClass.getName() + " from '" + value.getClass().getName() + "' with value '" + value.toString() + "'.");
        }
    }

    public void initializeValues() {
        FeatureType type = this.getType();
        for (FeatureAttributeDescriptor attribute : type) {
            String s;
            if (attribute.isAutomatic() || attribute.isReadOnly() || attribute.isComputed() || attribute.getDefaultValue() == null && !attribute.allowNull()) continue;
            Object value = attribute.getDefaultValue();
            if (value instanceof CharSequence && ExpressionUtils.isDynamicText((String)(s = ((CharSequence)value).toString()))) {
                try {
                    value = ExpressionUtils.evaluateDynamicText((String)s);
                }
                catch (Throwable th) {
                    value = null;
                }
            }
            this.set(attribute, value);
        }
    }

    public void clear() {
        this.initializeValues();
    }

    public void initializeValues(Feature feature) {
        FeatureType myType = this.getType();
        FeatureType type = feature.getType();
        this.extraValuesData = null;
        for (FeatureAttributeDescriptor attribute : type) {
            FeatureAttributeDescriptor myAttribute = myType.getAttributeDescriptor(attribute.getName());
            if (myAttribute == null) continue;
            this.set(myAttribute, feature.get(attribute.getIndex()));
        }
    }

    public FeatureStore getStore() {
        return (FeatureStore)this.storeRef.get();
    }

    public FeatureType getType() {
        return this.data.getType();
    }

    public EditableFeature getEditable() {
        return new DefaultEditableFeature(this);
    }

    public Feature getCopy() {
        return new DefaultFeature(this);
    }

    public Object clone() throws CloneNotSupportedException {
        return new DefaultFeature(this);
    }

    public FeatureReference getReference() {
        if (!this.getType().supportReferences()) {
            return null;
        }
        if (this.reference == null) {
            if (!this.isInserted()) {
                return null;
            }
            this.reference = FeatureReferenceFactory.createFromFeature(this);
        }
        return this.reference;
    }

    public Object getOrDefault(String name, Object defaultValue) {
        int index = this.data.getType().getIndex(name);
        if (index < 0) {
            return defaultValue;
        }
        return this.get(index);
    }

    public Object getOrDefault(String name, int type, Object defaultValue) {
        DataType dataType = ToolsLocator.getDataTypesManager().get(type);
        return this.getOrDefault(name, dataType, defaultValue);
    }

    public Object getOrDefault(String name, DataType type, Object defaultValue) {
        int index = this.data.getType().getIndex(name);
        if (index < 0) {
            return defaultValue;
        }
        try {
            Object value = this.get(index);
            if (value == null) {
                return defaultValue;
            }
            return type.coerce(value);
        }
        catch (Throwable th) {
            return defaultValue;
        }
    }

    public String getStringOrDefault(String name, String defaultValue) {
        int index = this.data.getType().getIndex(name);
        if (index < 0) {
            return defaultValue;
        }
        try {
            return (String)this.get(index);
        }
        catch (Throwable th) {
            return defaultValue;
        }
    }

    public boolean getBooleanOrDefault(String name, boolean defaultValue) {
        int index = this.data.getType().getIndex(name);
        if (index < 0) {
            return defaultValue;
        }
        try {
            return this.getBoolean(index);
        }
        catch (Throwable th) {
            return defaultValue;
        }
    }

    public int getIntOrDefault(String name, int defaultValue) {
        int index = this.data.getType().getIndex(name);
        if (index < 0) {
            return defaultValue;
        }
        try {
            return this.getInt(index);
        }
        catch (Throwable th) {
            return defaultValue;
        }
    }

    public long getLongOrDefault(String name, long defaultValue) {
        int index = this.data.getType().getIndex(name);
        if (index < 0) {
            return defaultValue;
        }
        try {
            return this.getLong(index);
        }
        catch (Throwable th) {
            return defaultValue;
        }
    }

    public float getFloatOrDefault(String name, float defaultValue) {
        int index = this.data.getType().getIndex(name);
        if (index < 0) {
            return defaultValue;
        }
        try {
            return this.getFloat(index);
        }
        catch (Throwable th) {
            return defaultValue;
        }
    }

    public double getDoubleOrDefault(String name, double defaultValue) {
        int index = this.data.getType().getIndex(name);
        if (index < 0) {
            return defaultValue;
        }
        try {
            return this.getDouble(index);
        }
        catch (Throwable th) {
            return defaultValue;
        }
    }

    public BigDecimal getDecimalOrDefault(String name, BigDecimal defaultValue) {
        int index = this.data.getType().getIndex(name);
        if (index < 0) {
            return defaultValue;
        }
        try {
            return this.getDecimal(index);
        }
        catch (Throwable th) {
            return defaultValue;
        }
    }

    public Date getDateOrDefault(String name, Date defaultValue) {
        int index = this.data.getType().getIndex(name);
        if (index < 0) {
            return defaultValue;
        }
        try {
            return this.getDate(index);
        }
        catch (Throwable th) {
            return defaultValue;
        }
    }

    public Object getOrDefault(int index, Object defaultValue) {
        if (index < 0 || index >= this.data.getType().size()) {
            return defaultValue;
        }
        try {
            return this.get(index);
        }
        catch (Throwable th) {
            return defaultValue;
        }
    }

    public String getStringOrDefault(int index, String defaultValue) {
        if (index < 0 || index >= this.data.getType().size()) {
            return defaultValue;
        }
        try {
            return this.getString(index);
        }
        catch (Throwable th) {
            return defaultValue;
        }
    }

    public boolean getBooleanOrDefault(int index, boolean defaultValue) {
        if (index < 0 || index >= this.data.getType().size()) {
            return defaultValue;
        }
        try {
            return this.getBoolean(index);
        }
        catch (Throwable th) {
            return defaultValue;
        }
    }

    public int getIntOrDefault(int index, int defaultValue) {
        if (index < 0 || index >= this.data.getType().size()) {
            return defaultValue;
        }
        try {
            return this.getInt(index);
        }
        catch (Throwable th) {
            return defaultValue;
        }
    }

    public long getLongOrDefault(int index, long defaultValue) {
        if (index < 0 || index >= this.data.getType().size()) {
            return defaultValue;
        }
        try {
            return this.getLong(index);
        }
        catch (Throwable th) {
            return defaultValue;
        }
    }

    public float getFloatOrDefault(int index, float defaultValue) {
        if (index < 0 || index >= this.data.getType().size()) {
            return defaultValue;
        }
        try {
            return this.getFloat(index);
        }
        catch (Throwable th) {
            return defaultValue;
        }
    }

    public double getDoubleOrDefault(int index, double defaultValue) {
        if (index < 0 || index >= this.data.getType().size()) {
            return defaultValue;
        }
        try {
            return this.getDouble(index);
        }
        catch (Throwable th) {
            return defaultValue;
        }
    }

    public BigDecimal getDecimalOrDefault(int index, BigDecimal defaultValue) {
        if (index < 0 || index >= this.data.getType().size()) {
            return defaultValue;
        }
        try {
            return this.getDecimal(index);
        }
        catch (Throwable th) {
            return defaultValue;
        }
    }

    public Date getDateOrDefault(int index, Date defaultValue) {
        if (index < 0 || index >= this.data.getType().size()) {
            return defaultValue;
        }
        try {
            return this.getDate(index);
        }
        catch (Throwable th) {
            return defaultValue;
        }
    }

    public void validate(int check) throws DataException {
        ((DefaultFeatureType)this.data.getType()).validateFeature(this, check);
    }

    public boolean isBroken() {
        return this.data.isBroken();
    }

    public List getSRSs() {
        return null;
    }

    public Envelope getDefaultEnvelope() {
        Envelope envelope = this.data.getDefaultEnvelope();
        if (envelope == null) {
            int i = this.data.getType().getDefaultGeometryAttributeIndex();
            if (i < 0) {
                return null;
            }
            Geometry geom = this.getDefaultGeometry();
            if (geom != null) {
                envelope = geom.getEnvelope();
            }
        }
        return envelope;
    }

    public Geometry getDefaultGeometry() {
        Geometry geom = this.data.getDefaultGeometry();
        if (geom == null) {
            int i = this.data.getType().getDefaultGeometryAttributeIndex();
            if (i < 0) {
                return null;
            }
            Object x = this.get(i);
            geom = x instanceof Geometry ? (Geometry)x : this.getGeometry(i);
        }
        if (geom != null && geom.getProjection() == null) {
            FeatureType type = this.getType();
            DefaultFeatureAttributeDescriptor attrdesc = (DefaultFeatureAttributeDescriptor)type.get(type.getDefaultGeometryAttributeIndex());
            IProjection proj = attrdesc.getSRS(this.storeRef);
            geom.setProjection(proj);
        }
        return geom;
    }

    public IProjection getDefaultSRS() {
        IProjection srs = this.data.getType().getDefaultSRS();
        if (srs == null) {
            FeatureType type = this.getType();
            DefaultFeatureAttributeDescriptor attrdesc = (DefaultFeatureAttributeDescriptor)type.get(type.getDefaultGeometryAttributeIndex());
            srs = attrdesc.getSRS(this.storeRef);
        }
        return srs;
    }

    public List getGeometries() {
        return null;
    }

    public Object getFromProfile(int index) {
        FilesResourcesStorage.FileResource resource;
        ResourcesStorage storage;
        File f;
        FeatureAttributeDescriptor descriptor = this.data.getType().getAttributeDescriptor(index);
        Object value = this.get(index);
        String profileName = descriptor.getDataProfileName();
        if (StringUtils.isBlank((CharSequence)profileName)) {
            return value;
        }
        DataProfile profile = DALLocator.getDataManager().getDataProfile(profileName);
        if (profile == null) {
            return value;
        }
        if (value instanceof File && !(f = (File)value).isAbsolute() && (storage = this.getStore().getResourcesStorage()) instanceof FilesResourcesStorage && (resource = (FilesResourcesStorage.FileResource)storage.getResource(f.getPath())) != null && resource.exists()) {
            value = resource.getFile();
        }
        return profile.createData(value, descriptor.getTags());
    }

    public Object getFromProfile(String name) {
        FeatureAttributeDescriptor descriptor = this.data.getType().getAttributeDescriptor(name);
        return this.getFromProfile(descriptor.getIndex());
    }

    private Object get(String name, Class theClass, int type) {
        Object value = this.get(name);
        if (theClass.isInstance(value)) {
            return value;
        }
        try {
            return this.getDataTypesManager().coerce(type, value);
        }
        catch (CoercionException e) {
            if (value == null) {
                return null;
            }
            throw new IllegalArgumentException("Can't convert to " + theClass.getName() + " from '" + value.getClass().getName() + "' with value '" + value.toString() + "'.");
        }
    }

    public Object get(String name) {
        int index = this.data.getType().getIndex(name);
        if (index < 0) {
            if (this.hasExtraColumnValue(name)) {
                return this.getExtraColumnValue(name);
            }
            if (this.hasExtraValue(name)) {
                return this.getExtraValue(name);
            }
            throw new IllegalArgumentException("Attribute name '" + name + "' not found in the feature.");
        }
        return this.get(index);
    }

    public boolean isNull(int index) {
        FeatureType type = this.data.getType();
        if (index < 0 || index >= type.size()) {
            throw new IllegalArgumentException("Attribute index '" + index + "' out of range (0 to " + this.data.getType().size() + ".");
        }
        FeatureAttributeDescriptor attribute = type.getAttributeDescriptor(index);
        if (!this.data.getType().hasEvaluators()) {
            return this.data.get(index) == null;
        }
        Evaluator eval = attribute.getEvaluator();
        if (eval == null) {
            return this.data.get(index) == null;
        }
        Object value = this.data.get(index);
        if (value != null) {
            return true;
        }
        try {
            value = eval.evaluate((EvaluatorData)this);
        }
        catch (EvaluatorException e) {
            throw new DataEvaluatorRuntimeException((Throwable)e);
        }
        this.data.set(index, value);
        return value == null;
    }

    public boolean isNull(String name) {
        int index = this.data.getType().getIndex(name);
        if (index < 0) {
            throw new IllegalArgumentException("Attribute name '" + name + "' not found in the feature.");
        }
        return this.isNull(index);
    }

    public boolean has_key(String key) {
        Object x = this.getType().get(key);
        return x != null;
    }

    public List<String> keys() {
        ArrayList<String> ks = new ArrayList<String>();
        for (FeatureAttributeDescriptor attr : this.getType()) {
            ks.add(attr.getName());
        }
        return ks;
    }

    public Iterator<String> iterkeys() {
        final Iterator it = this.getType().iterator();
        return new Iterator<String>(){

            @Override
            public boolean hasNext() {
                return it.hasNext();
            }

            @Override
            public String next() {
                return ((FeatureAttributeDescriptor)it.next()).getName();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Not supported yet.");
            }
        };
    }

    public Iterator iteritems() {
        final Iterator it = this.getType().iterator();
        return new Iterator<Map.Entry>(){

            @Override
            public boolean hasNext() {
                return it.hasNext();
            }

            @Override
            public Map.Entry next() {
                final String name = ((FeatureAttributeDescriptor)it.next()).getName();
                return new Map.Entry<String, Object>(){

                    @Override
                    public String getKey() {
                        return name;
                    }

                    @Override
                    public Object getValue() {
                        return DefaultFeature.this.get(name);
                    }

                    @Override
                    public Object setValue(Object value) {
                        throw new UnsupportedOperationException("Not supported yet.");
                    }
                };
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Not supported yet.");
            }
        };
    }

    public Object get(int index) {
        Evaluator eval;
        FeatureType type = this.data.getType();
        if (index < 0 || index >= type.size()) {
            throw new IllegalArgumentException("Attribute index '" + index + "' out of range (0 to " + this.data.getType().size() + ".");
        }
        Object value = this.data.get(index);
        FeatureAttributeDescriptor attribute = type.getAttributeDescriptor(index);
        if (type.hasEvaluators() && (eval = attribute.getEvaluator()) != null && value == null) {
            try {
                value = eval.evaluate((EvaluatorData)this);
            }
            catch (EvaluatorException e) {
                throw new DataEvaluatorRuntimeException((Throwable)e);
            }
            this.data.set(index, value);
        }
        value = this.get(attribute, value);
        return value;
    }

    private Object get(FeatureAttributeDescriptor featureAttributeDescriptor, Object value) {
        FeatureAttributeEmulator emulator = featureAttributeDescriptor.getFeatureAttributeEmulator();
        if (emulator != null) {
            value = this.getExtraValue(featureAttributeDescriptor.getName());
            if (value == null) {
                value = emulator.get((Feature)this);
            }
        } else {
            FeatureAttributeGetter getter = featureAttributeDescriptor.getFeatureAttributeGetter();
            if (getter != null) {
                value = getter.getter(value);
            }
        }
        value = this.coerce(featureAttributeDescriptor, value);
        return value;
    }

    private Object coerce(FeatureAttributeDescriptor attr, Object value) {
        Geometry geom;
        if (value == null) {
            return null;
        }
        DataType dataType = attr.getDataType();
        Class theClass = dataType.getDefaultClass();
        if (theClass != null && !theClass.isInstance(value)) {
            try {
                value = this.getDataTypesManager().coerce(dataType.getType(), value);
            }
            catch (CoercionException e) {
                throw new IllegalArgumentException("Can't convert to " + theClass.getSimpleName() + " from '" + value == null ? "NULL" : value.getClass().getSimpleName() + "' with value '" + Objects.toString(value) + "'.");
            }
        }
        if (attr.getType() == 66 && value != null && (geom = (Geometry)value).getProjection() == null) {
            IProjection proj = ((DefaultFeatureAttributeDescriptor)attr).getSRS(this.storeRef);
            geom.setProjection(proj);
        }
        return value;
    }

    public byte[] getByteArray(String name) {
        return (byte[])this.get(name);
    }

    public byte[] getByteArray(int index) {
        return (byte[])this.get(index);
    }

    public Object[] getArray(String name) {
        return (Object[])this.get(name);
    }

    public Object[] getArray(int index) {
        return (Object[])this.get(index);
    }

    public boolean getBoolean(String name) {
        Boolean value = (Boolean)this.get(name, Boolean.class, 1);
        if (value == null) {
            return false;
        }
        return value;
    }

    public boolean getBoolean(int index) {
        Boolean value = (Boolean)this.get(index, Boolean.class, 1);
        if (value == null) {
            return false;
        }
        return value;
    }

    public byte getByte(String name) {
        Byte value = (Byte)this.get(name, Byte.class, 2);
        if (value == null) {
            return 0;
        }
        return value;
    }

    public byte getByte(int index) {
        Byte value = (Byte)this.get(index, Byte.class, 2);
        if (value == null) {
            return 0;
        }
        return value;
    }

    public java.sql.Date getDate(String name) {
        java.sql.Date value = (java.sql.Date)this.get(name, java.sql.Date.class, 9);
        return value;
    }

    public java.sql.Date getDate(int index) {
        java.sql.Date value = (java.sql.Date)this.get(index, java.sql.Date.class, 9);
        return value;
    }

    public Time getTime(String name) {
        Time value = (Time)this.get(name, Time.class, 10);
        return value;
    }

    public Time getTime(int index) {
        Time value = (Time)this.get(index, Time.class, 10);
        return value;
    }

    public Timestamp getTimestamp(String name) {
        Timestamp value = (Timestamp)this.get(name, Timestamp.class, 11);
        return value;
    }

    public Timestamp getTimestamp(int index) {
        Timestamp value = (Timestamp)this.get(index, Timestamp.class, 11);
        return value;
    }

    public double getDouble(String name) {
        Double value = (Double)this.get(name, Double.class, 7);
        if (value == null) {
            return 0.0;
        }
        return value;
    }

    public double getDouble(int index) {
        Double value = (Double)this.get(index, Double.class, 7);
        if (value == null) {
            return 0.0;
        }
        return value;
    }

    public BigDecimal getDecimal(String name) {
        BigDecimal value = (BigDecimal)this.get(name, BigDecimal.class, 19);
        return value;
    }

    public BigDecimal getDecimal(int index) {
        BigDecimal value = (BigDecimal)this.get(index, BigDecimal.class, 19);
        return value;
    }

    public Feature getFeature(String name) {
        return this.getFeature(this.data.getType().getIndex(name));
    }

    public Feature getFeature(int index) {
        return (Feature)this.get(index);
    }

    public float getFloat(String name) {
        Float value = (Float)this.get(name, Float.class, 6);
        if (value == null) {
            return 0.0f;
        }
        return value.floatValue();
    }

    public float getFloat(int index) {
        Float value = (Float)this.get(index, Float.class, 6);
        if (value == null) {
            return 0.0f;
        }
        return value.floatValue();
    }

    public Geometry getGeometry(String name) {
        return (Geometry)this.get(name, Geometry.class, 66);
    }

    public Geometry getGeometry(int index) {
        return (Geometry)this.get(index, Geometry.class, 66);
    }

    public int getInt(String name) {
        Integer value = (Integer)this.get(name, Integer.class, 4);
        if (value == null) {
            return 0;
        }
        return value;
    }

    public int getInt(int index) {
        Integer value = (Integer)this.get(index, Integer.class, 4);
        if (value == null) {
            return 0;
        }
        return value;
    }

    public long getLong(String name) {
        Long value = (Long)this.get(name, Long.class, 5);
        if (value == null) {
            return 0L;
        }
        return value;
    }

    public long getLong(int index) {
        Long value = (Long)this.get(index, Long.class, 5);
        if (value == null) {
            return 0L;
        }
        return value;
    }

    public String getString(String name) {
        return (String)this.get(name, String.class, 8);
    }

    public String getString(int index) {
        return (String)this.get(index, String.class, 8);
    }

    public Object getContextValue(String name) {
        if ((name = name.toLowerCase()).equals("store")) {
            return this.getStore();
        }
        if (name.equals("featuretype")) {
            return this.data.getType();
        }
        if (name.equals("feature")) {
            return this;
        }
        throw new IllegalArgumentException(name);
    }

    public Iterator getDataNames() {
        class DataNamesIterator
        implements Iterator {
            Iterator attributeIteraror;

            DataNamesIterator(DefaultFeature feature) {
                this.attributeIteraror = feature.getType().iterator();
            }

            @Override
            public boolean hasNext() {
                return this.attributeIteraror.hasNext();
            }

            public Object next() {
                return ((FeatureAttributeDescriptor)this.attributeIteraror.next()).getName();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        }
        return new DataNamesIterator(this);
    }

    public Object getDataValue(String name) {
        name = name.toLowerCase();
        try {
            return this.get(name);
        }
        catch (IllegalArgumentException ex) {
            if ("defaultgeometry".equalsIgnoreCase(name)) {
                return this.getDefaultGeometry();
            }
            throw ex;
        }
    }

    public Iterator getDataValues() {
        class DataValuesIterator
        implements Iterator {
            DefaultFeature feature;
            int current = 0;

            DataValuesIterator(DefaultFeature feature) {
                this.feature = feature;
            }

            @Override
            public boolean hasNext() {
                return this.current < this.feature.getType().size() - 1;
            }

            public Object next() {
                return this.feature.get(this.current++);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        }
        return new DataValuesIterator(this);
    }

    public boolean hasContextValue(String name) {
        if ((name = name.toLowerCase()).equals("store")) {
            return true;
        }
        if (name.equals("featuretype")) {
            return true;
        }
        return name.equals("feature");
    }

    public boolean hasDataValue(String name) {
        return this.hasValue(name);
    }

    public DynObject getAsDynObject() {
        DynObjectFeatureFacade facade = new DynObjectFeatureFacade(this);
        return facade;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        FeatureAttributeDescriptor[] attributeDescriptors = this.getType().getAttributeDescriptors();
        for (int i = 0; i < attributeDescriptors.length; ++i) {
            String name = attributeDescriptors[i].getName();
            Object value = this.get(name);
            builder.append(value);
            if (i >= attributeDescriptors.length - 1) continue;
            builder.append(", ");
        }
        return builder.toString();
    }

    public boolean isInserted() {
        return this.inserted;
    }

    public void setInserted(boolean inserted) {
        this.inserted = inserted;
    }

    public EvaluatorData getEvaluatorData() {
        return this;
    }

    public int size() {
        return this.data.getType().size();
    }

    public boolean isEmpty() {
        return false;
    }

    public Iterator<String> iterator() {
        final Iterator x = this.data.getType().iterator();
        return new Iterator<String>(){

            @Override
            public boolean hasNext() {
                return x.hasNext();
            }

            @Override
            public String next() {
                return ((FeatureAttributeDescriptor)x.next()).getName();
            }
        };
    }

    public boolean containsKey(String key) {
        return this.data.getType().get(key) != null;
    }

    public String getLabelOfValue(String name) {
        String label;
        Object value;
        FeatureAttributeDescriptor attrdesc = this.data.getType().getAttributeDescriptor(name);
        if (attrdesc == null) {
            FeatureExtraColumns extraColumns = this.data.getType().getExtraColumns();
            if (extraColumns == null) {
                return name;
            }
            attrdesc = extraColumns.get(name);
            if (attrdesc == null) {
                return name;
            }
            value = this.get(name);
        } else {
            value = this.get(attrdesc.getIndex());
        }
        try {
            label = attrdesc.getLabelOfValue(value);
        }
        catch (Throwable th) {
            label = Objects.toString(value, "");
        }
        return label;
    }

    public void setExtraValue(String name, Object value) {
        if (this.extraValues == null) {
            this.extraValues = new HashMap<String, Object>();
        }
        this.extraValues.put(name, value);
    }

    public Object getExtraColumnValue(String name) {
        FeatureExtraColumns columns = this.getType().getExtraColumns();
        int index = columns.getIndexOf(name);
        if (this.extraValues != null && this.extraValues.containsKey(name)) {
            Object value = this.extraValues.get(name);
            if (index >= 0) {
                EditableFeatureAttributeDescriptor attrdesc = columns.get(index);
                value = this.coerce((FeatureAttributeDescriptor)attrdesc, value);
            }
            return value;
        }
        if (index < 0) {
            throw new RuntimeException("Not extra column value found");
        }
        if (this.extraValuesData == null) {
            this.extraValuesData = new Object[columns.size()];
        }
        EditableFeatureAttributeDescriptor attrdesc = columns.get(index);
        Object value = this.extraValuesData[index];
        if (value != null) {
            return value;
        }
        value = this.getExtraValue(name);
        if (value == null && !this.hasExtraValue(name) && attrdesc.getFeatureAttributeEmulator() != null) {
            value = attrdesc.getFeatureAttributeEmulator().get((Feature)this);
            this.extraValuesData[index] = value = this.coerce((FeatureAttributeDescriptor)attrdesc, value);
        } else {
            this.extraValuesData[index] = value = this.coerce((FeatureAttributeDescriptor)attrdesc, value);
        }
        return value;
    }

    public Object getExtraValue(String name) {
        Object value = this.data.getExtraValue(name);
        return value;
    }

    public boolean hasExtraValue(String name) {
        return this.data.hasExtraValue(name);
    }

    private boolean hasExtraColumnValue(String name) {
        if (this.extraValues != null && this.extraValues.containsKey(name)) {
            return true;
        }
        FeatureExtraColumns columns = this.getType().getExtraColumns();
        int index = columns.getIndexOf(name);
        return index >= 0;
    }

    private EditableFeatureAttributeDescriptor getExtraColumn(String name) {
        FeatureExtraColumns columns = this.getType().getExtraColumns();
        return columns.get(name);
    }

    public boolean hasValue(String name) {
        name = name.toLowerCase();
        return this.data.getType().getIndex(name) >= 0 || this.hasExtraValue(name) || this.hasExtraColumnValue(name);
    }

    public Object getExtraValue(int index) {
        return this.data.getExtraValue(index);
    }

    public JsonObject toJson() {
        org.gvsig.json.JsonObjectBuilder builder = this.toJsonBuilder();
        return builder.build();
    }

    public JsonObject toJson(Map<String, Object> props) {
        org.gvsig.json.JsonObjectBuilder builder = this.toJsonBuilder(props);
        return builder.build();
    }

    public org.gvsig.json.JsonObjectBuilder toJsonBuilder() {
        return this.toJsonBuilder(null, Bitmask.createBitmask((int)0), null);
    }

    public org.gvsig.json.JsonObjectBuilder toJsonBuilder(Map<String, Object> props) {
        if (props == null) {
            return this.toJsonBuilderDefault(props);
        }
        String format = (String)props.getOrDefault(FORMAT_MODE, FORMAT_MODE_GVSIGDESKTOP);
        switch (format.toLowerCase()) {
            case "geojson": {
                return this.toJsonBuilderGeoJson(props);
            }
        }
        return this.toJsonBuilderDefault(props);
    }

    public org.gvsig.json.JsonObjectBuilder toJsonBuilderDefault(Map<String, Object> props) {
        Bitmask modemask = null;
        HashSet visiteds = null;
        int mode = 0;
        if (props != null) {
            modemask = Bitmask.createBitmask((int)(mode = ((Integer)props.getOrDefault(TOJSON_MODE, mode)).intValue()));
            if (modemask.isSetBits(1) && (visiteds = (HashSet)props.getOrDefault("visiteds", null)) == null) {
                visiteds = new HashSet();
                props.put("visiteds", visiteds);
            }
        } else {
            modemask = Bitmask.createBitmask((int)mode);
        }
        return this.toJsonBuilder(props, modemask, visiteds);
    }

    private org.gvsig.json.JsonObjectBuilder toJsonBuilderGeoJson(Map<String, Object> props) {
        String json_s;
        FeatureType ft = this.getType();
        Geometry geom = this.getDefaultGeometry();
        Bitmask mode = Bitmask.createBitmask((int)((Integer)props.getOrDefault(TOJSON_MODE, 0)));
        boolean skipNulls = (Boolean)props.getOrDefault("skipnulls", false);
        Object[] skipFields = props.getOrDefault("skipfields", null);
        HashMap<String, Object> properties = new HashMap<String, Object>();
        block14: for (FeatureAttributeDescriptor desc : ft) {
            if (desc.isComputed() && !mode.isSetBits(2) || ArrayUtils.contains((Object[])skipFields, (Object)desc.getName()) || desc.getType() == 66) continue;
            if (this.isNull(desc.getName())) {
                if (skipNulls) continue;
                properties.put(desc.getName(), null);
                continue;
            }
            switch (desc.getType()) {
                case 1: {
                    properties.put(desc.getName(), this.getBoolean(desc.getIndex()));
                    continue block14;
                }
                case 2: {
                    properties.put(desc.getName(), this.getByte(desc.getIndex()));
                    continue block14;
                }
                case 4: {
                    properties.put(desc.getName(), this.getInt(desc.getIndex()));
                    continue block14;
                }
                case 5: {
                    properties.put(desc.getName(), this.getLong(desc.getIndex()));
                    continue block14;
                }
                case 7: {
                    properties.put(desc.getName(), this.getDouble(desc.getIndex()));
                    continue block14;
                }
                case 6: {
                    properties.put(desc.getName(), Float.valueOf(this.getFloat(desc.getIndex())));
                    continue block14;
                }
                case 19: {
                    properties.put(desc.getName(), this.getDecimal(desc.getIndex()));
                    continue block14;
                }
                case 9: {
                    java.sql.Date date = this.getDate(desc.getIndex());
                    LocalDateTime localDateTime = LocalDateTime.ofInstant(new Date(date.getTime()).toInstant(), ZoneId.systemDefault());
                    String value = DateTimeFormatter.ISO_DATE.format(localDateTime);
                    properties.put(desc.getName(), value);
                    continue block14;
                }
                case 11: {
                    java.sql.Date date = this.getDate(desc.getIndex());
                    LocalDateTime localDateTime = LocalDateTime.ofInstant(new Date(date.getTime()).toInstant(), ZoneId.systemDefault());
                    String value = DateTimeFormatter.ISO_DATE_TIME.format(localDateTime);
                    properties.put(desc.getName(), value);
                    continue block14;
                }
                case 10: {
                    java.sql.Date date = this.getDate(desc.getIndex());
                    LocalDateTime localDateTime = LocalDateTime.ofInstant(new Date(date.getTime()).toInstant(), ZoneId.systemDefault());
                    String value = DateTimeFormatter.ISO_TIME.format(localDateTime);
                    properties.put(desc.getName(), value);
                    continue block14;
                }
            }
            properties.put(desc.getName(), this.getStringOrDefault(desc.getIndex(), ""));
        }
        try {
            json_s = geom.convertToGeoJson(properties, ((Boolean)props.getOrDefault("encodecrs", true)).booleanValue());
        }
        catch (Exception ex) {
            throw new ConvertFeatureToGeoJsonException(ex);
        }
        org.gvsig.json.JsonObjectBuilder json = Json.createObjectBuilder((String)json_s);
        return json;
    }

    private org.gvsig.json.JsonObjectBuilder toJsonBuilder(Map<String, Object> props, Bitmask mode, Set<String> visiteds) {
        org.gvsig.json.JsonObjectBuilder builder = Json.createObjectBuilder();
        FeatureType ft = this.getType();
        boolean hasVisited = false;
        if (visiteds != null) {
            FeatureReference ref = this.getReference();
            String code = ref.getCode();
            hasVisited = visiteds.contains(code);
            if (hasVisited) {
                return this.featureReferenceToJson(ref);
            }
            visiteds.add(code);
        }
        block25: for (FeatureAttributeDescriptor desc : ft) {
            String f;
            Object value;
            if (desc.isComputed() && !mode.isSetBits(2) && (!mode.isSetBits(4) || desc.getType() != 34)) continue;
            if (desc.getType() != 34 && this.isNull(desc.getName())) {
                builder.addNull(desc.getName());
                continue;
            }
            if (desc.isForeingKey() && !desc.getForeingKey().isClosedList() && mode.isSetBits(1) && desc.getRelationType() == 5 && (value = this.get(desc.getName())) != null && (f = desc.getForeingKey().getFeature(null, value)) != null) {
                String x = f.getReference().getCode();
                if (visiteds == null) {
                    if (f instanceof DefaultFeature) {
                        builder.add(desc.getName(), (JsonObjectBuilder)((DefaultFeature)((Object)f)).toJsonBuilder(props, mode, visiteds));
                        continue;
                    }
                    builder.add(desc.getName(), (JsonObjectBuilder)f.toJsonBuilder(props));
                    continue;
                }
                if (!visiteds.contains(x)) {
                    if (f instanceof DefaultFeature) {
                        builder.add(desc.getName(), (JsonObjectBuilder)((DefaultFeature)((Object)f)).toJsonBuilder(props, mode, visiteds));
                        continue;
                    }
                    builder.add(desc.getName(), (JsonObjectBuilder)f.toJsonBuilder(props));
                    continue;
                }
            }
            block0 : switch (desc.getType()) {
                case 66: {
                    Geometry geom = this.getGeometry(desc.getIndex());
                    if (geom == null) continue block25;
                    geom = this.getGeometry(desc.getIndex());
                    Tags tags = desc.getTags();
                    switch (tags.getString("geomformat", "WKB").toUpperCase()) {
                        default: {
                            builder.add(desc.getName(), geom.convertToHexWKBQuietly());
                            break block0;
                        }
                        case "EWKB": 
                        case "HEXEWKB": {
                            builder.add(desc.getName(), geom.convertToHexEWKBQuietly());
                            break block0;
                        }
                        case "WKT": 
                    }
                    builder.add(desc.getName(), geom.convertToWKTQuietly());
                    break;
                }
                case 1: {
                    builder.add(desc.getName(), this.getBoolean(desc.getIndex()));
                    break;
                }
                case 2: {
                    builder.add(desc.getName(), (int)this.getByte(desc.getIndex()));
                    break;
                }
                case 4: {
                    builder.add(desc.getName(), this.getInt(desc.getIndex()));
                    break;
                }
                case 5: {
                    builder.add(desc.getName(), this.getLong(desc.getIndex()));
                    break;
                }
                case 7: {
                    builder.add(desc.getName(), this.getDouble(desc.getIndex()));
                    break;
                }
                case 6: {
                    builder.add(desc.getName(), (double)this.getFloat(desc.getIndex()));
                    break;
                }
                case 19: {
                    builder.add(desc.getName(), this.getDecimal(desc.getIndex()));
                    break;
                }
                case 9: {
                    Date date = this.getDate(desc.getIndex());
                    if (date == null) {
                        builder.addNull(desc.getName());
                        break;
                    }
                    LocalDateTime localDateTime = LocalDateTime.ofInstant(new Date(date.getTime()).toInstant(), ZoneId.systemDefault());
                    String value2 = DateTimeFormatter.ISO_DATE.format(localDateTime);
                    builder.add(desc.getName(), value2);
                    break;
                }
                case 11: {
                    Date date = this.getTimestamp(desc.getIndex());
                    if (date == null) {
                        builder.addNull(desc.getName());
                        break;
                    }
                    LocalDateTime localDateTime = LocalDateTime.ofInstant(new Date(date.getTime()).toInstant(), ZoneId.systemDefault());
                    String value2 = DateTimeFormatter.ISO_DATE_TIME.format(localDateTime);
                    builder.add(desc.getName(), value2);
                    break;
                }
                case 10: {
                    Date date = this.getTime(desc.getIndex());
                    if (date == null) {
                        builder.addNull(desc.getName());
                        break;
                    }
                    LocalDateTime localDateTime = LocalDateTime.ofInstant(new Date(date.getTime()).toInstant(), ZoneId.systemDefault());
                    String value2 = DateTimeFormatter.ISO_TIME.format(localDateTime);
                    builder.add(desc.getName(), value2);
                    break;
                }
                case 34: {
                    if (!mode.isSetBits(4) || desc.getRelationType() != 3) continue block25;
                    org.gvsig.json.JsonArrayBuilder arraybuilder = Json.createArrayBuilder();
                    Object x = this.get(desc.getName());
                    if (x instanceof List) {
                        for (Object v : (List)x) {
                            if (v instanceof DefaultFeature) {
                                arraybuilder.add((JsonObjectBuilder)((DefaultFeature)v).toJsonBuilder(props, mode, visiteds));
                                continue;
                            }
                            if (!(v instanceof Feature)) continue;
                            arraybuilder.add((JsonObjectBuilder)((Feature)v).toJsonBuilder(props));
                        }
                    }
                    DisposeUtils.disposeQuietly((Object)x);
                    builder.add(desc.getName(), (JsonArrayBuilder)arraybuilder);
                    break;
                }
                default: {
                    builder.add(desc.getName(), this.getStringOrDefault(desc.getIndex(), ""));
                }
            }
        }
        return builder;
    }

    private org.gvsig.json.JsonObjectBuilder featureReferenceToJson(FeatureReference ref) {
        org.gvsig.json.JsonObjectBuilder builder = Json.createObjectBuilder();
        builder.add("$reference", (JsonObjectBuilder)ref.toJsonBuilder());
        return builder;
    }

    public List<String> getKeys() {
        ArrayList<String> l = new ArrayList<String>();
        for (FeatureAttributeDescriptor descriptor : this.getType()) {
            l.add(descriptor.getName());
        }
        return l;
    }

    public String format(String name) {
        int index = this.data.getType().getIndex(name);
        if (index < 0) {
            EditableFeatureAttributeDescriptor attribute = this.getExtraColumn(name);
            if (attribute != null) {
                Object value = this.getExtraColumnValue(name);
                return attribute.format(value);
            }
            throw new IllegalArgumentException("Attribute name '" + name + "' not found in the feature.");
        }
        return this.format(index);
    }

    public String format(int index) {
        Object value = this.get(index);
        FeatureType type = this.data.getType();
        FeatureAttributeDescriptor attribute = type.getAttributeDescriptor(index);
        return attribute.format(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Feature getForeignFeature(String attrName) {
        ForeingKey.ContextForeingKey context = null;
        try {
            Feature foreignfeat;
            FeatureAttributeDescriptor attr = this.getType().getAttributeDescriptor(attrName);
            if (attr == null) {
                Feature feature = null;
                return feature;
            }
            if (!attr.isForeingKey()) {
                Feature feature = null;
                return feature;
            }
            ForeingKey fk = attr.getForeingKey();
            if (fk == null) {
                Feature feature = null;
                return feature;
            }
            context = fk.createContext();
            FeatureStore store = this.getStore();
            if (store instanceof SupportTransactions) {
                context.setTransaction(((SupportTransactions)store).getTransaction());
            }
            Feature feature = foreignfeat = fk.getFeature(context, this.get(attrName));
            DisposeUtils.disposeQuietly((Disposable)context);
            return feature;
        }
        catch (Exception ex) {
            Feature feature = null;
            return feature;
        }
        finally {
            DisposeUtils.disposeQuietly(context);
        }
    }

    public Expression createFilter() {
        ExpressionBuilder builder = this.createBuilderFilter();
        Expression filter = ExpressionUtils.createExpression((String)builder.toString());
        return filter;
    }

    public ExpressionBuilder createBuilderFilter() {
        FeatureType ftype = this.getType();
        Object[] pk = ftype.getPrimaryKey();
        if (ArrayUtils.isEmpty((Object[])pk)) {
            return null;
        }
        ExpressionBuilder builder = ExpressionUtils.createExpressionBuilder();
        for (Object attrdesc : pk) {
            Object value = this.get(attrdesc.getName());
            if (value == null) {
                builder.and((ExpressionBuilder.Value)builder.is_null((ExpressionBuilder.Value)builder.column(attrdesc.getName())));
                continue;
            }
            builder.and((ExpressionBuilder.Value)builder.eq((ExpressionBuilder.Value)builder.column(attrdesc.getName()), (ExpressionBuilder.Value)builder.constant(value)));
        }
        return builder;
    }

    public int getDataStatus() {
        return this.data.getDataStatus();
    }

    private static class ConvertFeatureToGeoJsonException
    extends DataRuntimeException {
        private static final long serialVersionUID = -1L;
        private static final String MESSAGE_FORMAT = "Create GeoJson builder exception.";
        private static final String MESSAGE_KEY = "_ConvertFeatureToGeoJsonException";

        public ConvertFeatureToGeoJsonException(Throwable cause) {
            super(MESSAGE_FORMAT, cause, MESSAGE_KEY, -1L);
        }
    }

    class UnableToGetReferenceException
    extends BaseRuntimeException {
        private static final long serialVersionUID = 1812805035204824163L;

        public UnableToGetReferenceException(BaseException exception) {
            super("Unable to get reference", "_UnableToGetReferenceException", 1812805035204824163L);
            this.initCause(exception);
        }
    }
}

