/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.feature.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.gvsig.expressionevaluator.Code;
import org.gvsig.expressionevaluator.CodeBuilder;
import org.gvsig.expressionevaluator.Expression;
import org.gvsig.expressionevaluator.ExpressionEvaluator;
import org.gvsig.expressionevaluator.ExpressionUtils;
import org.gvsig.expressionevaluator.MutableCodes;
import org.gvsig.expressionevaluator.MutableSymbolTable;
import org.gvsig.expressionevaluator.SymbolTable;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.exception.InitializeException;
import org.gvsig.fmap.dal.expressionevaluator.FeatureAttributeEmulatorExpression;
import org.gvsig.fmap.dal.feature.EditableFeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureExtraColumns;
import org.gvsig.fmap.dal.feature.FeatureQuery;
import org.gvsig.fmap.dal.feature.FeatureQueryOrder;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.feature.impl.DefaultFeatureExtraColumns;
import org.gvsig.fmap.dal.feature.impl.DefaultFeatureQueryOrder;
import org.gvsig.fmap.dal.impl.expressionevaluator.DefaultFeatureExpressionEvaluator;
import org.gvsig.json.Json;
import org.gvsig.json.JsonObjectBuilder;
import org.gvsig.json.SupportToJson;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.evaluator.AndEvaluator;
import org.gvsig.tools.evaluator.Evaluator;
import org.gvsig.tools.evaluator.EvaluatorFieldsInfo;
import org.gvsig.tools.exception.BaseException;
import org.gvsig.tools.packageutils.Version;
import org.gvsig.tools.packageutils.impl.DefaultVersion;
import org.gvsig.tools.persistence.Persistent;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;
import org.gvsig.tools.visitor.VisitCanceledException;
import org.gvsig.tools.visitor.Visitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultFeatureQuery
implements FeatureQuery {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultFeatureQuery.class);
    public static final String SCALE_PARAM_NAME = "Scale";
    private static final Version VERSION_2_6_0 = ToolsLocator.getPackageManager().createVersion("2.6.0");
    private static final Version VERSION_2_6_0_1 = ToolsLocator.getPackageManager().createVersion("2.6.0-1");
    private Map<String, Object> queryParameters = new HashMap<String, Object>();
    private String featureTypeId = null;
    private List<String> attributeNames = new ArrayList<String>();
    private List<String> constantsAttributeNames = new ArrayList<String>();
    private Evaluator filter;
    private FeatureQueryOrder order = new DefaultFeatureQueryOrder();
    private long limit = -1L;
    private long pageSize = 0L;
    private List<String> groupByColumns;
    private Map<String, String> aggregateFunctions;
    private FeatureExtraColumns extraColumns = new DefaultFeatureExtraColumns();
    private MutableSymbolTable symbolTable;
    private String storeName;
    private boolean useSubquery = true;

    public DefaultFeatureQuery() {
    }

    public DefaultFeatureQuery(String storeName) {
        this();
        this.storeName = storeName;
    }

    public DefaultFeatureQuery(FeatureType featureType) {
        this();
        this.setFeatureType(featureType);
    }

    public DefaultFeatureQuery(FeatureType featureType, Evaluator filter) {
        this();
        this.setFeatureType(featureType);
        this.filter = filter;
    }

    public DefaultFeatureQuery(FeatureType featureType, Evaluator filter, double scale) {
        this();
        this.setFeatureType(featureType);
        this.filter = filter;
        this.setScale(scale);
    }

    public DefaultFeatureQuery(String[] attributeNames) {
        this();
        this.setAttributeNames(attributeNames);
    }

    public DefaultFeatureQuery(String[] attributeNames, Evaluator filter) {
        this();
        this.setAttributeNames(attributeNames);
        this.filter = filter;
    }

    public DefaultFeatureQuery(String[] attributeNames, Evaluator filter, double scale) {
        this();
        this.setAttributeNames(attributeNames);
        this.filter = filter;
        this.setScale(scale);
    }

    public double getScale() {
        Double scale = (Double)this.getQueryParameter(SCALE_PARAM_NAME);
        if (scale == null) {
            return 0.0;
        }
        return scale;
    }

    public final void setScale(double scale) {
        this.setQueryParameter(SCALE_PARAM_NAME, scale);
    }

    public Object getQueryParameter(String name) {
        return this.queryParameters.get(name);
    }

    public void setQueryParameter(String name, Object value) {
        this.queryParameters.put(name, value);
    }

    public final void setFeatureType(FeatureType featureType) {
        this.featureTypeId = featureType.getId();
    }

    public String[] getAttributeNames() {
        if (this.hasExtraColumnDeclaredAsGroupByField()) {
            this.retrievesAllAttributes();
        }
        if (this.extraColumns == null || this.extraColumns.isEmpty()) {
            return this.attributeNames.toArray(new String[this.attributeNames.size()]);
        }
        block0: for (EditableFeatureAttributeDescriptor extraColumn : this.extraColumns) {
            for (String attributeName : this.attributeNames) {
                if (!StringUtils.equalsIgnoreCase((CharSequence)attributeName, (CharSequence)extraColumn.getName())) continue;
                this.attributeNames.remove(attributeName);
                continue block0;
            }
        }
        return this.attributeNames.toArray(new String[this.attributeNames.size()]);
    }

    private boolean hasExtraColumnDeclaredAsGroupByField() {
        if (this.hasGroupByColumns()) {
            for (String groupByColumn : this.groupByColumns) {
                if (this.extraColumns.get(groupByColumn) == null) continue;
                return true;
            }
        }
        return false;
    }

    public final void setAttributeNames(String[] attributeNames) {
        this.attributeNames.clear();
        if (attributeNames != null) {
            this.attributeNames.addAll(Arrays.asList(attributeNames));
        }
    }

    public void retrievesAllAttributes() {
        this.attributeNames.clear();
    }

    public void addAttributeName(String attributeName) {
        for (int i = 0; i < this.attributeNames.size(); ++i) {
            if (!this.attributeNames.get(i).equals(attributeName)) continue;
            return;
        }
        this.attributeNames.add(attributeName);
    }

    public void addEssentialAttributeNames(FeatureStore store) {
        FeatureType storeType;
        try {
            storeType = store.getDefaultFeatureType();
        }
        catch (DataException ex) {
            throw new RuntimeException("Can't access to the default feature type of tghe store", ex);
        }
        Object[] pks = storeType.getPrimaryKey();
        if (storeType.hasOID() || ArrayUtils.isEmpty((Object[])pks)) {
            FeatureAttributeDescriptor attrInt = null;
            FeatureAttributeDescriptor attrStr = null;
            FeatureAttributeDescriptor attrNotGeom = null;
            for (FeatureAttributeDescriptor attr : storeType) {
                if (attrInt == null && (attr.getType() == 4 || attr.getType() == 5)) {
                    attrInt = attr;
                    continue;
                }
                if (attrStr == null && attr.getType() == 8) {
                    attrStr = attr;
                    continue;
                }
                if (attrNotGeom != null || attr.getType() == 66) continue;
                attrNotGeom = attr;
            }
            if (attrInt != null) {
                this.addAttributeName(attrInt.getName());
            } else if (attrStr != null) {
                this.addAttributeName(attrStr.getName());
            } else if (attrNotGeom != null) {
                this.addAttributeName(attrNotGeom.getName());
            } else {
                this.addAttributeName(storeType.getAttributeDescriptor(0).getName());
            }
        } else {
            for (Object attr : pks) {
                this.addAttributeName(attr.getName());
            }
        }
    }

    public void addPrimaryKeyAttributeNames(FeatureStore store) {
        FeatureType storeType;
        try {
            storeType = store.getDefaultFeatureType();
        }
        catch (DataException ex) {
            throw new RuntimeException("Can't access to the default feature type of tghe store", ex);
        }
        for (FeatureAttributeDescriptor attr : storeType.getPrimaryKey()) {
            this.addAttributeName(attr.getName());
        }
    }

    public boolean hasAttributeNames() {
        if (this.hasExtraColumnDeclaredAsGroupByField()) {
            return true;
        }
        if (this.extraColumns == null || this.extraColumns.isEmpty()) {
            return !this.attributeNames.isEmpty();
        }
        block0: for (EditableFeatureAttributeDescriptor extraColumn : this.extraColumns) {
            for (String attributeName : this.attributeNames) {
                if (!StringUtils.equalsIgnoreCase((CharSequence)attributeName, (CharSequence)extraColumn.getName())) continue;
                this.attributeNames.remove(attributeName);
                continue block0;
            }
        }
        return !this.attributeNames.isEmpty();
    }

    public void clearAttributeNames() {
        this.attributeNames = new ArrayList<String>();
    }

    public Evaluator getFilter() {
        if (this.filter instanceof ExpressionEvaluator) {
            ExpressionEvaluator eefilter = (ExpressionEvaluator)this.filter;
            if (this.symbolTable != null) {
                eefilter.addSymbolTable((SymbolTable)this.symbolTable);
            }
        }
        return this.filter;
    }

    public Expression getExpressionFilter() {
        if (this.filter instanceof ExpressionEvaluator) {
            ExpressionEvaluator eefilter = (ExpressionEvaluator)this.filter;
            if (this.symbolTable != null) {
                eefilter.addSymbolTable((SymbolTable)this.symbolTable);
            }
            return eefilter.toExpression();
        }
        return null;
    }

    public void setFilter(Expression filter) {
        if (filter == null) {
            this.clearFilter();
            return;
        }
        DefaultFeatureExpressionEvaluator x = new DefaultFeatureExpressionEvaluator(this.storeName, filter);
        this.setFilter((Evaluator)x);
    }

    public void setFilter(String filter) {
        if (StringUtils.isEmpty((CharSequence)filter)) {
            this.clearFilter();
            return;
        }
        try {
            this.setFilter(ExpressionUtils.createExpression((String)filter));
        }
        catch (Exception ex) {
            throw new RuntimeException("Can't create filter from '" + filter + "'", ex);
        }
    }

    public void setFilter(Evaluator filter) {
        if (filter == null) {
            this.clearFilter();
            return;
        }
        this.filter = filter;
        this.addFilterAttributes(filter);
    }

    public void addFilter(String filter) {
        if (StringUtils.isEmpty((CharSequence)filter)) {
            return;
        }
        this.addFilter(ExpressionUtils.createExpression((String)filter));
    }

    public void addFilter(Expression filter) {
        DefaultFeatureExpressionEvaluator x = new DefaultFeatureExpressionEvaluator(this.storeName, filter);
        this.addFilter((Evaluator)x);
    }

    public void addFilter(Evaluator evaluator) {
        if (evaluator == null) {
            return;
        }
        if (this.filter == null) {
            this.filter = evaluator;
        } else if (this.filter instanceof AndEvaluator) {
            ((AndEvaluator)this.filter).addEvaluator(evaluator);
        } else {
            this.filter = new AndEvaluator(this.filter);
            ((AndEvaluator)this.filter).addEvaluator(evaluator);
        }
        this.addFilterAttributes(evaluator);
    }

    public void clearFilter() {
        this.filter = null;
    }

    private void addFilterAttributes(Evaluator evaluator) {
        if (evaluator != null) {
            EvaluatorFieldsInfo fieldsInfo = evaluator.getFieldsInfo();
            if (fieldsInfo == null) {
                return;
            }
            String[] fieldNames = fieldsInfo.getFieldNames();
            if (fieldNames == null) {
                return;
            }
            for (String fieldName : fieldNames) {
                this.addAttributeName(fieldName);
            }
        }
    }

    public FeatureQueryOrder getOrder() {
        return this.order;
    }

    public void setOrder(FeatureQueryOrder order) {
        this.order = order == null ? new DefaultFeatureQueryOrder() : order;
    }

    public boolean hasFilter() {
        return this.filter != null;
    }

    public boolean hasLimit() {
        return this.limit != -1L;
    }

    public boolean hasOrder() {
        return this.order != null && this.order.size() > 0;
    }

    public Object clone() throws CloneNotSupportedException {
        DefaultFeatureQuery clone = (DefaultFeatureQuery)super.clone();
        if (this.attributeNames != null) {
            clone.attributeNames = new ArrayList<String>();
            for (int i = 0; i < this.attributeNames.size(); ++i) {
                clone.attributeNames.add(this.attributeNames.get(i));
            }
        }
        if (this.order != null) {
            clone.order = this.order.clone();
        }
        clone.extraColumns = this.extraColumns.getCopy();
        if (this.filter instanceof ExpressionEvaluator) {
            Expression exp = ((ExpressionEvaluator)this.filter).toExpression();
            clone.filter = new DefaultFeatureExpressionEvaluator(this.storeName, exp);
        }
        if (this.groupByColumns != null) {
            clone.groupByColumns = new ArrayList<String>();
            for (String value : this.groupByColumns) {
                clone.groupByColumns.add(value);
            }
        } else {
            clone.groupByColumns = null;
        }
        if (this.aggregateFunctions != null) {
            clone.aggregateFunctions = new HashMap<String, String>();
            for (String key : this.aggregateFunctions.keySet()) {
                clone.aggregateFunctions.put(key, this.aggregateFunctions.get(key));
            }
        } else {
            clone.aggregateFunctions = null;
        }
        if (this.symbolTable != null) {
            clone.symbolTable = this.symbolTable.clone();
        }
        return clone;
    }

    public FeatureQuery getCopy() {
        try {
            return (FeatureQuery)this.clone();
        }
        catch (CloneNotSupportedException e) {
            LOGGER.debug("Can't clone feature query", (Throwable)e);
            return null;
        }
    }

    public String getFeatureTypeId() {
        return this.featureTypeId;
    }

    public void setFeatureTypeId(String featureTypeId) {
        this.featureTypeId = featureTypeId;
    }

    public void saveToState(PersistentState state) throws PersistenceException {
        state.set("version", (Persistent)VERSION_2_6_0_1);
        state.set("queryParameters", this.queryParameters);
        state.set("featureTypeId", this.featureTypeId);
        state.set("attributeNames", this.attributeNames);
        ArrayList<Expression> filterList = new ArrayList<Expression>();
        if (this.filter instanceof DefaultFeatureExpressionEvaluator) {
            DefaultFeatureExpressionEvaluator filterExpression = (DefaultFeatureExpressionEvaluator)this.filter;
            filterList.add(filterExpression.toExpression());
        } else if (this.filter instanceof AndEvaluator) {
            AndEvaluator filterAnd = (AndEvaluator)this.filter;
            List evaluators = filterAnd.getEvaluators();
            for (Evaluator evaluator : evaluators) {
                if (evaluator instanceof DefaultFeatureExpressionEvaluator) {
                    DefaultFeatureExpressionEvaluator expressionEvaluator = (DefaultFeatureExpressionEvaluator)evaluator;
                    filterList.add(expressionEvaluator.toExpression());
                    continue;
                }
                filterList.clear();
                LOGGER.warn(StringUtils.join((Object[])new String[]{"Filters in this FeatureQuery will not persist:", this.toString()}));
                break;
            }
        } else {
            filterList.clear();
            if (this.filter != null) {
                LOGGER.warn(StringUtils.join((Object[])new String[]{"Filters in this FeatureQuery will not persist:", this.toString()}));
            }
        }
        state.set("filter", filterList);
        state.set("limit", this.limit);
        state.set("pageSize", this.pageSize);
        state.set("useSubquery", this.useSubquery);
        state.set("order", (Persistent)this.order);
        state.set("groupByColumns", this.groupByColumns);
        state.set("aggregateFunctions", this.aggregateFunctions);
        state.set("extraColumn", (Persistent)this.extraColumns);
        state.set("storeName", this.storeName);
    }

    public void loadFromState(PersistentState state) throws PersistenceException {
        Version version = (Version)state.get("version");
        this.queryParameters = (Map)state.get("queryParameters");
        this.featureTypeId = state.getString("featureTypeId");
        this.attributeNames = state.getList("attributeNames");
        List filterList = state.getList("filter");
        DataManager dataManager = DALLocator.getDataManager();
        if (filterList.isEmpty()) {
            this.filter = null;
        } else if (filterList.size() == 1) {
            Evaluator evaluator;
            Expression expression = (Expression)filterList.get(0);
            try {
                evaluator = dataManager.createFilter(expression);
            }
            catch (InitializeException ex) {
                LOGGER.warn("Can't create evaluator", (Throwable)ex);
                evaluator = null;
            }
            this.filter = evaluator;
        } else {
            AndEvaluator andEvaluator = null;
            for (Expression expression : filterList) {
                Evaluator evaluator;
                try {
                    evaluator = dataManager.createFilter(expression);
                    if (andEvaluator == null) {
                        andEvaluator = new AndEvaluator(evaluator);
                    } else {
                        andEvaluator.addEvaluator(evaluator);
                    }
                }
                catch (InitializeException ex) {
                    LOGGER.warn("Can't create AndEvaluator", (Throwable)ex);
                    break;
                }
                this.filter = evaluator;
            }
        }
        this.limit = state.getLong("limit");
        this.pageSize = state.getLong("pageSize");
        this.useSubquery = state.getBoolean("useSubquery", true);
        this.storeName = state.getString("storeName");
        this.order = (FeatureQueryOrder)state.get("order");
        List asListGroupByColumns = state.getList("groupByColumns");
        this.groupByColumns = asListGroupByColumns != null ? new ArrayList<String>(asListGroupByColumns) : null;
        Map asMapAggregateFunctions = state.getMap("aggregateFunctions");
        this.aggregateFunctions = asMapAggregateFunctions != null ? new HashMap<String, String>(asMapAggregateFunctions) : null;
        this.extraColumns = (FeatureExtraColumns)state.get("extraColumn");
        if (version == null || version.compareTo((Object)VERSION_2_6_0) < 0) {
            if (this.limit == 0L) {
                this.clearLimit();
            }
            Expression exp = this.getExpressionFilter();
            this.fixOldExistsSelect(exp);
            for (EditableFeatureAttributeDescriptor extraColumn : this.extraColumns) {
                if (!(extraColumn.getFeatureAttributeEmulator() instanceof FeatureAttributeEmulatorExpression)) continue;
                exp = ((FeatureAttributeEmulatorExpression)extraColumn.getFeatureAttributeEmulator()).getExpression();
                this.fixOldExistsSelect(exp);
            }
        }
    }

    public static void selfRegister() {
        DefaultFeatureQuery.registerPersistent();
        Json.registerSerializer(DefaultFeatureQuery.class);
    }

    private static void registerPersistent() {
        DynStruct definition = ToolsLocator.getPersistenceManager().addDefinition(DefaultFeatureQuery.class, "DefaultFeatureQuery", "DefaultFeatureQuery Persistent definition", null, null);
        definition.addDynFieldObject("version").setClassOfValue(DefaultVersion.class).setMandatory(false);
        definition.addDynFieldMap("queryParameters").setClassOfItems(Object.class).setMandatory(true);
        definition.addDynFieldString("featureTypeId").setMandatory(false);
        definition.addDynFieldList("attributeNames").setClassOfItems(String.class).setMandatory(false);
        definition.addDynFieldList("filter").setClassOfItems(Expression.class).setMandatory(false);
        definition.addDynFieldObject("order").setClassOfValue(FeatureQueryOrder.class).setMandatory(false);
        definition.addDynFieldLong("limit").setMandatory(false);
        definition.addDynFieldLong("pageSize").setMandatory(false);
        definition.addDynFieldBoolean("useSubquery").setMandatory(false);
        definition.addDynFieldList("groupByColumns").setClassOfItems(String.class);
        definition.addDynFieldMap("aggregateFunctions").setClassOfItems(String.class).setClassOfValue(String.class);
        definition.addDynFieldObject("extraColumn").setClassOfValue(DefaultFeatureExtraColumns.class);
        definition.addDynFieldString("storeName").setMandatory(false);
    }

    public long getLimit() {
        return this.limit;
    }

    public long getPageSize() {
        return this.pageSize;
    }

    public void setLimit(long limit) {
        this.limit = limit;
    }

    public void clearLimit() {
        this.limit = -1L;
    }

    public void setPageSize(long pageSize) {
        this.pageSize = pageSize;
    }

    public String[] getConstantsAttributeNames() {
        return this.constantsAttributeNames.toArray(new String[this.constantsAttributeNames.size()]);
    }

    public void setConstantsAttributeNames(String[] constantsAttributeNames) {
        this.constantsAttributeNames.clear();
        if (constantsAttributeNames != null) {
            this.constantsAttributeNames.addAll(Arrays.asList(constantsAttributeNames));
        }
    }

    public void addConstantAttributeName(String attributeName) {
        for (int i = 0; i < this.constantsAttributeNames.size(); ++i) {
            if (!this.constantsAttributeNames.get(i).equals(attributeName)) continue;
            return;
        }
        this.constantsAttributeNames.add(attributeName);
    }

    public boolean hasConstantsAttributeNames() {
        return !this.constantsAttributeNames.isEmpty();
    }

    public void clearConstantsAttributeNames() {
        this.constantsAttributeNames = new ArrayList<String>();
    }

    public boolean isAGroupByColumn(String name) {
        if (this.groupByColumns == null) {
            return false;
        }
        for (String columnName : this.groupByColumns) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)columnName)) continue;
            return true;
        }
        return false;
    }

    public List<String> getGroupByColumns() {
        if (this.groupByColumns == null) {
            this.groupByColumns = new ArrayList<String>();
        }
        return this.groupByColumns;
    }

    public void removeGroupByColumn(String colname) {
        if (this.groupByColumns == null) {
            return;
        }
        this.groupByColumns.remove(colname);
    }

    public void addAggregate(String funcName, String columnName) {
        Map<String, String> aggregateds = this.getAggregateFunctions();
        aggregateds.put(columnName, funcName);
    }

    public Map<String, String> getAggregateFunctions() {
        if (this.aggregateFunctions == null) {
            this.aggregateFunctions = new HashMap<String, String>();
        }
        return this.aggregateFunctions;
    }

    public void removeAggregateFunction(String colname) {
        if (this.aggregateFunctions == null) {
            return;
        }
        Iterator<Map.Entry<String, String>> iterator = this.getAggregateFunctions().entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, String> entry = iterator.next();
            String attrName = entry.getKey();
            String function = entry.getValue();
            if (!StringUtils.equalsIgnoreCase((CharSequence)colname, (CharSequence)attrName)) continue;
            iterator.remove();
            return;
        }
    }

    public String getAggregateFunction(String name) {
        for (Map.Entry<String, String> entry : this.getAggregateFunctions().entrySet()) {
            String attrName = entry.getKey();
            String function = entry.getValue();
            if (!StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)attrName)) continue;
            return function;
        }
        return null;
    }

    public String getAggregate(String name) {
        String fn = this.getAggregateFunction(name);
        if (StringUtils.isAlphanumeric((CharSequence)fn)) {
            return fn + "(\"" + name + "\")";
        }
        return fn;
    }

    public String getAggregate(String tableName, String name) {
        String fn = this.getAggregateFunction(name);
        if (!tableName.startsWith("\"")) {
            tableName = "\"" + tableName + "\"";
        }
        if (StringUtils.isAlphanumeric((CharSequence)fn)) {
            return fn + "(" + tableName + ".\"" + name + "\")";
        }
        return fn;
    }

    public boolean isAggregate(String name) {
        return this.getAggregateFunction(name) != null;
    }

    public boolean hasAggregateFunctions() {
        return this.aggregateFunctions != null && !this.aggregateFunctions.isEmpty();
    }

    public boolean hasGroupByColumns() {
        return this.groupByColumns != null && !this.groupByColumns.isEmpty();
    }

    private void clear() {
        this.queryParameters = new HashMap<String, Object>();
        this.clearConstantsAttributeNames();
        this.clearAttributeNames();
        this.clearFilter();
        this.clearLimit();
        this.setOrder(null);
        this.useSubquery = true;
        this.limit = -1L;
        this.pageSize = 0L;
        this.groupByColumns = null;
        this.aggregateFunctions = null;
        this.extraColumns = new DefaultFeatureExtraColumns();
        this.symbolTable = null;
    }

    public void copyFrom(FeatureQuery query) {
        if (query == null) {
            this.clear();
            return;
        }
        DefaultFeatureQuery other = (DefaultFeatureQuery)query;
        this.queryParameters = new HashMap<String, Object>();
        this.queryParameters.putAll(other.queryParameters);
        this.featureTypeId = other.featureTypeId;
        this.attributeNames.clear();
        this.attributeNames.addAll(other.attributeNames);
        this.constantsAttributeNames.clear();
        this.constantsAttributeNames.addAll(other.constantsAttributeNames);
        this.filter = other.filter;
        this.order.copyFrom(other.order);
        this.limit = other.limit;
        this.pageSize = other.pageSize;
        this.useSubquery = other.useSubquery;
        if (this.groupByColumns != null && other.groupByColumns != null) {
            this.groupByColumns.clear();
            this.groupByColumns.addAll(other.groupByColumns);
        } else if (other.groupByColumns != null) {
            this.groupByColumns = new ArrayList<String>();
            this.groupByColumns.addAll(other.groupByColumns);
        } else if (this.groupByColumns != null) {
            this.groupByColumns = null;
        }
        if (this.aggregateFunctions != null && other.aggregateFunctions != null) {
            this.aggregateFunctions.clear();
            this.aggregateFunctions.putAll(other.aggregateFunctions);
        } else if (other.aggregateFunctions != null) {
            this.aggregateFunctions = new HashMap<String, String>(other.aggregateFunctions);
        } else if (this.aggregateFunctions != null) {
            this.aggregateFunctions = null;
        }
        this.extraColumns.copyFrom(other.extraColumns);
        if (other.symbolTable != null) {
            try {
                this.symbolTable = other.symbolTable.clone();
            }
            catch (CloneNotSupportedException ex) {
                LOGGER.debug("Can't clone symbol table", (Throwable)ex);
            }
        }
        this.storeName = other.storeName;
    }

    public FeatureExtraColumns getExtraColumns() {
        return this.extraColumns;
    }

    @Deprecated
    public FeatureExtraColumns getExtraColumn() {
        return this.extraColumns;
    }

    public MutableSymbolTable getSymbolTable() {
        return this.symbolTable;
    }

    public void setSymbolTable(MutableSymbolTable symbolTable) {
        this.symbolTable = symbolTable;
    }

    public void setVar(String name, Object value) {
        if (this.symbolTable == null) {
            this.symbolTable = ExpressionUtils.createSymbolTable();
        }
        this.symbolTable.setVar(name, value);
    }

    public boolean isUseSubquery() {
        return this.useSubquery;
    }

    public void setUseSubquery(boolean useSubquery) {
        this.useSubquery = useSubquery;
    }

    public void fromJson(JsonObject json) {
        DataManager dataManager = DALLocator.getDataManager();
        String s = json.getString("version", null);
        Version version = s == null ? null : Version.valueOf((String)s);
        this.queryParameters = Json.toMap((JsonObject)json, (String)"queryParameters");
        this.featureTypeId = json.getString("featureTypeId", null);
        this.attributeNames = new ArrayList<String>();
        Collection theAttributeNames = Json.toCollection((JsonObject)json, (String)"attributeNames");
        if (theAttributeNames != null) {
            this.attributeNames.addAll(theAttributeNames);
        }
        ArrayList filterList = null;
        Collection theFilter = Json.toCollection((JsonObject)json, (String)"filter");
        if (theFilter != null) {
            filterList = new ArrayList(theFilter);
        }
        if (filterList == null || filterList.isEmpty()) {
            this.filter = null;
        } else if (filterList.size() == 1) {
            Evaluator evaluator;
            Expression expression = (Expression)filterList.get(0);
            try {
                evaluator = dataManager.createFilter(expression);
            }
            catch (InitializeException ex) {
                LOGGER.warn("Can't create evaluator", (Throwable)ex);
                evaluator = null;
            }
            this.filter = evaluator;
        } else {
            AndEvaluator andEvaluator = null;
            for (Expression expression : filterList) {
                Evaluator evaluator;
                try {
                    evaluator = dataManager.createFilter(expression);
                    if (andEvaluator == null) {
                        andEvaluator = new AndEvaluator(evaluator);
                    } else {
                        andEvaluator.addEvaluator(evaluator);
                    }
                }
                catch (InitializeException ex) {
                    LOGGER.warn("Can't create AndEvaluator", (Throwable)ex);
                    break;
                }
                this.filter = evaluator;
            }
        }
        this.limit = json.getInt("limit");
        if ((version == null || version.compareTo((Object)VERSION_2_6_0) < 0) && this.limit == 0L) {
            this.clearLimit();
        }
        this.pageSize = json.getInt("pageSize");
        this.useSubquery = json.getBoolean("useSubquery", true);
        this.storeName = json.getString("storeName");
        this.order = (FeatureQueryOrder)Json.toObject((JsonObject)json, (String)"order");
        Collection theGroupByColumns = Json.toCollection((JsonArray)json.getJsonArray("groupByColumns"));
        this.groupByColumns = theGroupByColumns != null ? new ArrayList<String>(theGroupByColumns) : null;
        Map asMapAggregateFunctions = Json.toMap((JsonObject)json, (String)"aggregateFunctions");
        this.aggregateFunctions = asMapAggregateFunctions != null ? new HashMap<String, String>(asMapAggregateFunctions) : null;
        this.extraColumns = (FeatureExtraColumns)Json.toObject((JsonObject)json, (String)"extraColumn");
    }

    public JsonObjectBuilder toJsonBuilder() {
        JsonObjectBuilder state = Json.createObjectBuilder();
        state.add("version", VERSION_2_6_0.toString());
        state.add("queryParameters", this.queryParameters);
        state.add("featureTypeId", this.featureTypeId);
        state.add("attributeNames", this.attributeNames);
        org.gvsig.json.JsonArrayBuilder filterList = Json.createArrayBuilder();
        if (this.filter instanceof DefaultFeatureExpressionEvaluator) {
            DefaultFeatureExpressionEvaluator filterExpression = (DefaultFeatureExpressionEvaluator)this.filter;
            filterList.add((SupportToJson)filterExpression.toExpression());
        } else if (this.filter instanceof AndEvaluator) {
            AndEvaluator filterAnd = (AndEvaluator)this.filter;
            List evaluators = filterAnd.getEvaluators();
            for (Evaluator evaluator : evaluators) {
                if (evaluator instanceof DefaultFeatureExpressionEvaluator) {
                    DefaultFeatureExpressionEvaluator expressionEvaluator = (DefaultFeatureExpressionEvaluator)evaluator;
                    filterList.add((SupportToJson)expressionEvaluator.toExpression());
                    continue;
                }
                filterList = Json.createArrayBuilder();
                LOGGER.warn(StringUtils.join((Object[])new String[]{"Filters in this FeatureQuery will not persist:", this.toString()}));
                break;
            }
        } else {
            filterList = Json.createArrayBuilder();
            if (this.filter != null) {
                LOGGER.warn(StringUtils.join((Object[])new String[]{"Filters in this FeatureQuery will not persist:", this.toString()}));
            }
        }
        state.add("filter", (JsonArrayBuilder)filterList);
        state.add("limit", this.limit);
        state.add("pageSize", this.pageSize);
        state.add("useSubquery", this.useSubquery);
        state.add("order", (SupportToJson)this.order);
        state.add("groupByColumns", this.groupByColumns);
        state.add("aggregateFunctions", this.aggregateFunctions);
        state.add("extraColumn", (SupportToJson)this.extraColumns);
        state.add("storeName", this.storeName);
        return state;
    }

    public String toString() {
        try {
            ToStringBuilder builder = new ToStringBuilder((Object)this);
            builder.append("storeName", (Object)this.storeName);
            builder.append("filter", (Object)this.filter, true);
            builder.append("order", (Object)this.order, true);
            builder.append("limit", this.limit);
            builder.append("attributeNames", this.attributeNames, true);
            builder.append("queryParameters", this.queryParameters, true);
            builder.append("pageSize", this.pageSize);
            builder.append("useSubquery", this.useSubquery);
            builder.append("groupByColumns", this.groupByColumns);
            builder.append("aggregateFunctions", this.aggregateFunctions);
            builder.append("featureTypeId", (Object)this.featureTypeId);
            builder.append("extraColumn", (Object)this.extraColumns);
            return builder.toString();
        }
        catch (Exception e) {
            return super.toString();
        }
    }

    private void fixOldExistsSelect(Expression exp) {
        try {
            if (exp == null || !StringUtils.containsIgnoreCase((CharSequence)exp.getPhrase(), (CharSequence)"SELECT") || !StringUtils.containsIgnoreCase((CharSequence)exp.getPhrase(), (CharSequence)"EXISTS")) {
                return;
            }
            final MutableBoolean modified = new MutableBoolean(false);
            Code code = exp.getCode();
            code.accept(new Visitor(){
                CodeBuilder codeBuilder = null;

                public void visit(Object obj) throws VisitCanceledException, BaseException {
                    Code.Callable fnSelect;
                    MutableCodes params;
                    Code.Callable fnExists;
                    if (Code.isFunction((Code)((Code)obj), (String)"EXISTS") && Code.isFunction((Code)((Code)(fnExists = (Code.Callable)obj).parameters().get(0)), (String)"SELECT") && Code.isFunction((Code)((Code)(params = (MutableCodes)(fnSelect = (Code.Callable)fnExists.parameters().get(0)).parameters()).get(0)), (String)"GETATTR")) {
                        if (this.codeBuilder == null) {
                            this.codeBuilder = ExpressionUtils.createCodeBuilder();
                        }
                        Code.Callable value = this.codeBuilder.tuple(new Code[]{this.codeBuilder.constant((Object)1)});
                        params.set(0, (Code)value);
                        modified.setTrue();
                    }
                }
            });
            if (modified.isTrue()) {
                code.link();
                exp.setPhrase(code.toString());
            }
        }
        catch (Exception ex) {
            LOGGER.debug("Can't fix old query with exists and select.", (Throwable)ex);
        }
    }

    public EditableFeatureAttributeDescriptor addExtraColumn(String name, int datatype, Expression expression) {
        this.getExtraColumns().remove(name);
        EditableFeatureAttributeDescriptor fad = this.getExtraColumns().add(name, datatype);
        fad.setFeatureAttributeEmulator(expression);
        this.addAttributeName(name);
        return fad;
    }

    public boolean hasAttributeName(String name) {
        if (CollectionUtils.isEmpty(this.attributeNames)) {
            return false;
        }
        for (String attributeName : this.attributeNames) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)attributeName)) continue;
            return true;
        }
        return false;
    }
}

