/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.feature.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonValue;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.gvsig.expressionevaluator.Expression;
import org.gvsig.expressionevaluator.ExpressionEvaluator;
import org.gvsig.fmap.dal.exception.DataEvaluatorRuntimeException;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureQueryOrder;
import org.gvsig.fmap.dal.impl.expressionevaluator.DefaultFeatureExpressionEvaluator;
import org.gvsig.json.Json;
import org.gvsig.json.JsonObjectBuilder;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.evaluator.Evaluator;
import org.gvsig.tools.evaluator.EvaluatorData;
import org.gvsig.tools.evaluator.EvaluatorException;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultFeatureQueryOrder
implements FeatureQueryOrder {
    private List<FeatureQueryOrder.FeatureQueryOrderMember> members = new ArrayList<FeatureQueryOrder.FeatureQueryOrderMember>();
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultFeatureQueryOrder.class);

    public void copyFrom(FeatureQueryOrder other) {
        ArrayList<FeatureQueryOrder.FeatureQueryOrderMember> theMembers = new ArrayList<FeatureQueryOrder.FeatureQueryOrderMember>();
        for (FeatureQueryOrder.FeatureQueryOrderMember member : other) {
            FeatureQueryOrder.FeatureQueryOrderMember m;
            try {
                m = member.clone();
            }
            catch (CloneNotSupportedException ex) {
                throw new RuntimeException("Can't copy member (" + member.toString() + ").", ex);
            }
            theMembers.add(m);
        }
        this.members = theMembers;
    }

    public Object add(String order) {
        String[] attributes;
        if (StringUtils.isEmpty((CharSequence)order)) {
            return null;
        }
        Object r = null;
        for (String attribute : attributes = StringUtils.split((String)order, (char)',')) {
            boolean ascending = true;
            if (attribute.startsWith("+")) {
                ascending = true;
                attribute = attribute.substring(1);
            } else if (attribute.startsWith("-")) {
                ascending = false;
                attribute = attribute.substring(1);
            }
            attribute = attribute.trim();
            r = this.add(attribute, ascending);
        }
        return r;
    }

    public Object add(String attributeName, boolean ascending) {
        FeatureQueryOrderMemberImpl member = new FeatureQueryOrderMemberImpl(attributeName, ascending);
        if (this.members.add(member)) {
            return member;
        }
        return null;
    }

    public Object add(Expression expr, boolean ascending) {
        DefaultFeatureExpressionEvaluator evaluator = new DefaultFeatureExpressionEvaluator(expr);
        FeatureQueryOrderMemberImpl member = new FeatureQueryOrderMemberImpl(evaluator, ascending);
        if (this.members.add(member)) {
            return member;
        }
        return null;
    }

    public Iterable<FeatureQueryOrder.FeatureQueryOrderMember> members() {
        return new Iterable<FeatureQueryOrder.FeatureQueryOrderMember>(){

            @Override
            public Iterator<FeatureQueryOrder.FeatureQueryOrderMember> iterator() {
                return DefaultFeatureQueryOrder.this.iterator();
            }
        };
    }

    public Iterator<FeatureQueryOrder.FeatureQueryOrderMember> iterator() {
        if (this.members == null) {
            return new Iterator<FeatureQueryOrder.FeatureQueryOrderMember>(){

                @Override
                public boolean hasNext() {
                    return false;
                }

                @Override
                public FeatureQueryOrder.FeatureQueryOrderMember next() {
                    throw new NoSuchElementException();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException("Not supported yet.");
                }
            };
        }
        return this.members.iterator();
    }

    public boolean remove(FeatureQueryOrder.FeatureQueryOrderMember member) {
        return this.members.remove(member);
    }

    public void remove(int index) {
        this.members.remove(index);
    }

    public void clear() {
        this.members.clear();
    }

    public int size() {
        return this.members.size();
    }

    public int getIndex(String attributeName) {
        int n = 0;
        for (FeatureQueryOrder.FeatureQueryOrderMember member : this.members) {
            if (member != null && StringUtils.equalsIgnoreCase((CharSequence)attributeName, (CharSequence)member.getAttributeName())) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public void movePrevious(String name) {
        int n = this.getIndex(name);
        if (n < 1) {
            return;
        }
        Collections.swap(this.members, n, n - 1);
    }

    public void moveNext(String name) {
        int n = this.getIndex(name);
        if (n >= this.members.size() - 1) {
            return;
        }
        Collections.swap(this.members, n, n + 1);
    }

    public boolean isEmpty() {
        return this.members == null || this.members.isEmpty();
    }

    public FeatureQueryOrder.FeatureQueryOrderMember get(String attributeName) {
        for (FeatureQueryOrder.FeatureQueryOrderMember member : this.members) {
            if (member == null || !StringUtils.equalsIgnoreCase((CharSequence)attributeName, (CharSequence)member.getAttributeName())) continue;
            return member;
        }
        return null;
    }

    public boolean contains(String attributeName) {
        for (FeatureQueryOrder.FeatureQueryOrderMember member : this.members) {
            if (member == null || !StringUtils.equalsIgnoreCase((CharSequence)attributeName, (CharSequence)member.getAttributeName())) continue;
            return true;
        }
        return false;
    }

    public Comparator<Feature> getFeatureComparator() {
        return new DefaultFeatureComparator(this);
    }

    public DefaultFeatureQueryOrder clone() throws CloneNotSupportedException {
        DefaultFeatureQueryOrder clone = (DefaultFeatureQueryOrder)super.clone();
        if (this.members != null) {
            clone.members = new ArrayList<FeatureQueryOrder.FeatureQueryOrderMember>(this.members.size());
            for (int i = 0; i < this.members.size(); ++i) {
                clone.members.add(this.members.get(i).clone());
            }
        }
        return clone;
    }

    public DefaultFeatureQueryOrder getCopy() {
        DefaultFeatureQueryOrder aCopy = new DefaultFeatureQueryOrder();
        for (FeatureQueryOrder.FeatureQueryOrderMember member : this.members) {
            if (member.hasEvaluator()) {
                LOGGER.warn("Evaluator is not being added to the filter in a class copy");
                continue;
            }
            aCopy.add(member.getAttributeName(), member.getAscending());
        }
        return aCopy;
    }

    public static void selfRegister() {
        DefaultFeatureQueryOrder.registerPersistent();
        Json.registerSerializer(DefaultFeatureQueryOrder.class);
        Json.registerSerializer(FeatureQueryOrderMemberImpl.class);
    }

    private static void registerPersistent() {
        DynStruct definitionMember = ToolsLocator.getPersistenceManager().addDefinition(FeatureQueryOrderMemberImpl.class, "FeatureQueryOrderMember", "FeatureQueryOrderMember Persistent definition", null, null);
        definitionMember.addDynFieldString("attributeName").setClassOfValue(String.class).setMandatory(false);
        definitionMember.addDynFieldObject("evaluator").setClassOfValue(ExpressionEvaluator.class).setMandatory(false);
        definitionMember.addDynFieldBoolean("ascending").setMandatory(false);
        DynStruct definition = ToolsLocator.getPersistenceManager().addDefinition(DefaultFeatureQueryOrder.class, "FeatureQueryOrder", "FeatureQueryOrder Persistent definition", null, null);
        definition.addDynFieldList("members").setClassOfItems(FeatureQueryOrderMemberImpl.class);
    }

    public void loadFromState(PersistentState state) throws PersistenceException {
        List stateMembers = (List)state.get("members");
        this.members = new ArrayList<FeatureQueryOrder.FeatureQueryOrderMember>();
        for (FeatureQueryOrder.FeatureQueryOrderMember stateMember : stateMembers) {
            this.members.add(stateMember);
        }
    }

    public void saveToState(PersistentState state) throws PersistenceException {
        state.set("members", this.members);
    }

    public void fromJson(JsonObject json) {
        JsonArray stateMembers = json.getJsonArray("members");
        this.members = new ArrayList<FeatureQueryOrder.FeatureQueryOrderMember>();
        for (JsonValue stateMember : stateMembers) {
            this.members.add((FeatureQueryOrder.FeatureQueryOrderMember)Json.toObject((JsonValue)stateMember));
        }
    }

    public JsonObjectBuilder toJsonBuilder() {
        JsonObjectBuilder state = Json.createObjectBuilder();
        state.add("members", this.members);
        return state;
    }

    public String toString() {
        try {
            ToStringBuilder builder = new ToStringBuilder((Object)this);
            builder.append("members", this.members, true);
            return builder.toString();
        }
        catch (Exception e) {
            return super.toString();
        }
    }

    private class DefaultFeatureComparator
    implements Comparator<Feature> {
        private final DefaultFeatureQueryOrder order;

        public DefaultFeatureComparator(DefaultFeatureQueryOrder order) {
            this.order = order;
        }

        private int myCompare(Object arg0, Object arg1) {
            if (arg0 == null) {
                if (arg1 == null) {
                    return 0;
                }
                return 1;
            }
            if (arg1 == null) {
                if (arg0 == null) {
                    return 0;
                }
                return 1;
            }
            if (arg0 instanceof Comparable) {
                return ((Comparable)arg0).compareTo(arg1);
            }
            if (arg1 instanceof Comparable) {
                return ((Comparable)arg1).compareTo(arg0) * -1;
            }
            if (arg0.equals(arg1)) {
                return 0;
            }
            return -1;
        }

        @Override
        public int compare(Feature f0, Feature f1) {
            Iterator<FeatureQueryOrder.FeatureQueryOrderMember> iter = this.order.iterator();
            int returnValue = 0;
            while (returnValue == 0 && iter.hasNext()) {
                FeatureQueryOrder.FeatureQueryOrderMember item = iter.next();
                if (item instanceof String) {
                    String attrName = (String)item;
                    returnValue = this.myCompare(f0.get(attrName), f1.get(attrName));
                    continue;
                }
                Evaluator evaluator = (Evaluator)item;
                try {
                    returnValue = this.myCompare(evaluator.evaluate((EvaluatorData)f0), evaluator.evaluate((EvaluatorData)f1));
                }
                catch (EvaluatorException e) {
                    throw new DataEvaluatorRuntimeException((Throwable)e);
                }
            }
            return returnValue;
        }
    }

    public static class FeatureQueryOrderMemberImpl
    implements FeatureQueryOrder.FeatureQueryOrderMember {
        String attributeName = null;
        Evaluator evaluator = null;
        boolean ascending;
        private final Logger LOGGER = LoggerFactory.getLogger(FeatureQueryOrder.FeatureQueryOrderMember.class);

        public FeatureQueryOrderMemberImpl() {
        }

        FeatureQueryOrderMemberImpl(String attributeName, boolean ascending) {
            this.attributeName = attributeName;
            this.ascending = ascending;
        }

        FeatureQueryOrderMemberImpl(Evaluator evaluator, boolean ascending) {
            this.evaluator = evaluator;
            this.LOGGER.warn("Creating evaluator that will not be able to persist");
            this.ascending = ascending;
        }

        FeatureQueryOrderMemberImpl(ExpressionEvaluator evaluator, boolean ascending) {
            this.evaluator = evaluator;
            this.ascending = ascending;
        }

        public String toString() {
            try {
                ToStringBuilder builder = new ToStringBuilder((Object)this);
                if (this.evaluator == null) {
                    builder.append("attributeName", (Object)this.attributeName);
                } else {
                    builder.append("evaluator", (Object)this.evaluator.getSQL());
                }
                builder.append("ascending", (Object)(this.ascending ? "ASC" : "DESC"));
                return builder.toString();
            }
            catch (Exception e) {
                return super.toString();
            }
        }

        public boolean hasEvaluator() {
            return this.evaluator != null;
        }

        public Evaluator getEvaluator() {
            return this.evaluator;
        }

        public boolean getAscending() {
            return this.ascending;
        }

        public String getAttributeName() {
            return this.attributeName;
        }

        public void loadFromState(PersistentState state) throws PersistenceException {
            this.attributeName = state.getString("attributeName");
            this.ascending = state.getBoolean("ascending");
            this.evaluator = (Evaluator)state.get("evaluator");
        }

        public void saveToState(PersistentState state) throws PersistenceException {
            state.set("attributeName", this.attributeName);
            state.set("ascending", this.ascending);
            if (this.evaluator instanceof ExpressionEvaluator) {
                state.set("evaluator", (Object)this.evaluator);
            } else {
                state.setNull("evaluator");
            }
        }

        public FeatureQueryOrder.FeatureQueryOrderMember clone() throws CloneNotSupportedException {
            return (FeatureQueryOrder.FeatureQueryOrderMember)super.clone();
        }

        public void setAscending(boolean ascending) {
            this.ascending = ascending;
        }

        public void fromJson(JsonObject json) {
            this.attributeName = json.getString("attributeName", null);
            this.ascending = json.getBoolean("ascending", true);
            this.evaluator = (Evaluator)Json.toObject((JsonObject)json, (String)"evaluator");
        }

        public JsonObjectBuilder toJsonBuilder() {
            JsonObjectBuilder state = Json.createObjectBuilder();
            state.add("attributeName", this.attributeName);
            state.add("ascending", this.ascending);
            if (this.evaluator instanceof ExpressionEvaluator) {
                state.add("evaluator", (Object)this.evaluator);
            } else {
                state.addNull("evaluator");
            }
            return state;
        }
    }
}

