/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.feature.impl;

import java.util.ArrayList;
import java.util.Iterator;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;
import org.gvsig.expressionevaluator.Expression;
import org.gvsig.expressionevaluator.impl.DefaultFeatureRuleExpression;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.EditableFeature;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureRule;
import org.gvsig.fmap.dal.feature.FeatureRules;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.impl.DefaultFeature;
import org.gvsig.json.Json;
import org.gvsig.json.SupportJson;
import org.gvsig.tools.dynobject.exception.DynFieldValidateException;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultFeatureRules
extends ArrayList<FeatureRule>
implements FeatureRules,
SupportJson {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultFeatureRules.class);
    private static final long serialVersionUID = -8084546505498274121L;

    @Override
    public boolean add(FeatureRule rule) {
        return super.add(rule);
    }

    public boolean add(String name, String description, boolean checkAtUpdate, boolean checkAtFinishEdition, Expression expression) {
        DefaultFeatureRuleExpression rule = new DefaultFeatureRuleExpression(name, description, checkAtUpdate, checkAtFinishEdition, expression);
        return this.add((FeatureRule)rule);
    }

    public FeatureRule getRule(int index) {
        return (FeatureRule)super.get(index);
    }

    public boolean remove(FeatureRule rule) {
        return super.remove(rule);
    }

    public FeatureRules getCopy() {
        DefaultFeatureRules copy = new DefaultFeatureRules();
        copy.addAll(this);
        return copy;
    }

    public void validate(Feature feature, int mode) throws DataException {
        if (feature == null) {
            return;
        }
        if (feature instanceof EditableFeature) {
            this.validate((EditableFeature)feature, mode);
            return;
        }
        this.validate(feature.getEditable(), mode);
    }

    public void validate(EditableFeature feature, int check) throws DataException {
        FeatureStore store;
        if (feature == null) {
            return;
        }
        if ((check & 4) == 4) {
            this.checkRequireds((Feature)feature);
        }
        if ((check & 8) == 8) {
            this.checkBasics((Feature)feature);
        }
        if ((check & 2) == 2) {
            store = ((DefaultFeature)feature).getStore();
            for (FeatureRule rule : this) {
                if (rule == null || !rule.checkAtFinishEditing()) continue;
                rule.validate(feature, store);
            }
        }
        if ((check & 1) == 1) {
            store = ((DefaultFeature)feature).getStore();
            for (FeatureRule rule : this) {
                if (rule == null || !rule.checkAtUpdate()) continue;
                rule.validate(feature, store);
            }
        }
    }

    private void checkRequireds(Feature feature) {
        for (FeatureAttributeDescriptor attr : feature.getType()) {
            if (attr.isAutomatic() || attr.isComputed() || !attr.isPrimaryKey() && attr.allowNull() || feature.get(attr.getIndex()) != null) continue;
            String featstr = "unknown";
            String storename = "unknown";
            try {
                featstr = feature.toJsonBuilder().toString();
            }
            catch (Throwable th) {
                LOGGER.debug("Can't convert feature to string", th);
            }
            try {
                storename = feature.getStore().getName();
            }
            catch (Throwable th) {
                LOGGER.debug("Can't convert feature to string", th);
            }
            throw new IllegalStateException(String.format("The field '%s' in store '%s' can't have null values (%s).", attr.getName(), storename, featstr));
        }
    }

    private void checkBasics(Feature feature) {
        for (FeatureAttributeDescriptor attr : feature.getType()) {
            if (attr.isComputed()) continue;
            try {
                Object value = feature.get(attr.getName());
                attr.validate(value);
            }
            catch (DynFieldValidateException ex) {
                String featstr = "unknown";
                try {
                    featstr = feature.toJsonBuilder().toString();
                }
                catch (Throwable th) {
                    LOGGER.debug("Can't convert feature to string", th);
                }
                String storename = "unknown";
                try {
                    storename = feature.getStore().getName();
                }
                catch (Throwable th) {
                    LOGGER.debug("Can't convert feature to string", th);
                }
                throw new IllegalStateException(String.format("The field '%s' in store '%s' can't have a invalid value. %s. (%s).", attr.getName(), storename, ex.getMessage(), featstr));
            }
        }
    }

    public void saveToState(PersistentState state) throws PersistenceException {
        state.set("rules", this.iterator());
    }

    public void loadFromState(PersistentState state) throws PersistenceException {
        this.clear();
        Iterator it = state.getIterator("rules");
        while (it.hasNext()) {
            FeatureRule rule = (FeatureRule)it.next();
            if (rule == null) continue;
            this.add(rule);
        }
    }

    public void fromJson(JsonObject json) {
        JsonArray items = json.getJsonArray("items");
        if (items != null) {
            for (JsonValue item : items) {
                FeatureRule rule = (FeatureRule)Json.toObject((JsonValue)item);
                if (rule == null) continue;
                this.add(rule);
            }
        }
    }

    public JsonObject toJson() {
        return this.toJsonBuilder().build();
    }

    public org.gvsig.json.JsonObjectBuilder toJsonBuilder() {
        org.gvsig.json.JsonArrayBuilder arraybuilder = Json.createArrayBuilder();
        for (FeatureRule rule : this) {
            if (!(rule instanceof SupportJson)) continue;
            arraybuilder.add((JsonObjectBuilder)((SupportJson)rule).toJsonBuilder());
        }
        org.gvsig.json.JsonObjectBuilder builder = Json.createObjectBuilder();
        builder.add_class((Object)this);
        builder.add("items", (JsonArrayBuilder)arraybuilder);
        return builder;
    }

    public static void selfRegister() {
        Json.registerSerializer(DefaultFeatureRules.class);
    }
}

