/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.feature.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.exception.DataRuntimeException;
import org.gvsig.fmap.dal.feature.EditableFeature;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureQuery;
import org.gvsig.fmap.dal.feature.FeatureReference;
import org.gvsig.fmap.dal.feature.FeatureReferenceIterator;
import org.gvsig.fmap.dal.feature.FeatureSelection;
import org.gvsig.fmap.dal.feature.FeatureSet;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureStoreNotification;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.feature.exception.ReversedSelectionIteratorException;
import org.gvsig.fmap.dal.feature.impl.DefaultFeatureQuery;
import org.gvsig.fmap.dal.feature.impl.DefaultFeatureReferenceSelection;
import org.gvsig.fmap.dal.feature.impl.DefaultFeatureStore;
import org.gvsig.fmap.dal.feature.impl.FeatureSelectionHelper;
import org.gvsig.fmap.dal.feature.impl.featurereference.FeatureReferenceIteratorToFeatureIterator;
import org.gvsig.fmap.dal.feature.impl.featureset.AbstractFeatureSet;
import org.gvsig.fmap.dal.feature.impl.featureset.DefaultFeatureSet;
import org.gvsig.fmap.dal.feature.impl.undo.FeatureCommandsStack;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposableIterator;
import org.gvsig.tools.dispose.DisposeUtils;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.exception.BaseException;
import org.gvsig.tools.observer.Observable;
import org.gvsig.tools.observer.Observer;
import org.gvsig.tools.persistence.PersistenceManager;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;
import org.gvsig.tools.visitor.Visitor;

public class DefaultFeatureSelection
extends AbstractFeatureSet
implements FeatureSelection {
    private Map featureTypeCounts = new HashMap(1);
    private Map<Feature, Iterator> featureIterators = new HashMap<Feature, Iterator>();
    private DefaultFeatureReferenceSelection featureReferenceSelection;
    private boolean disposed = false;

    public DefaultFeatureSelection(DefaultFeatureStore featureStore) throws DataException {
        DisposeUtils.bind((Disposable)this);
        this.featureReferenceSelection = new DefaultFeatureReferenceSelection(featureStore);
    }

    public DefaultFeatureSelection(FeatureStore featureStore, FeatureSelectionHelper helper) throws DataException {
        DisposeUtils.bind((Disposable)this);
        this.featureReferenceSelection = new DefaultFeatureReferenceSelection(featureStore, helper);
    }

    public DefaultFeatureSelection() {
        DisposeUtils.bind((Disposable)this);
        this.featureReferenceSelection = new DefaultFeatureReferenceSelection();
    }

    @Override
    public FeatureStore getFeatureStore() {
        return this.featureReferenceSelection.getFeatureStore();
    }

    private void notifyObservers(String notificationType) {
        this.featureReferenceSelection.notifyObservers(notificationType);
    }

    public FeatureCommandsStack getCommands() {
        return this.featureReferenceSelection.getCommands();
    }

    public void enableNotifications() {
        this.featureReferenceSelection.enableNotifications();
    }

    public void disableNotifications() {
        this.featureReferenceSelection.disableNotifications();
    }

    public boolean isReversed() {
        return this.featureReferenceSelection.isReversed();
    }

    public long getSelectedCount() {
        return this.featureReferenceSelection.getSelectedCount();
    }

    public DefaultFeatureReferenceSelection.SelectionData getData() {
        return this.featureReferenceSelection.getData();
    }

    public boolean select(FeatureReference reference) {
        return this.featureReferenceSelection.select(reference);
    }

    public boolean select(FeatureReference reference, boolean undoable) {
        return this.featureReferenceSelection.select(reference, undoable);
    }

    public boolean deselect(FeatureReference reference) {
        return this.featureReferenceSelection.deselect(reference);
    }

    public boolean deselect(FeatureReference reference, boolean undoable) {
        return this.featureReferenceSelection.deselect(reference, undoable);
    }

    public FeatureReferenceIterator referenceIterator() {
        return this.featureReferenceSelection.referenceIterator();
    }

    public Iterable<FeatureReference> referenceIterable() {
        return this.featureReferenceSelection.referenceIterable();
    }

    public void selectAll() throws DataException {
        this.featureReferenceSelection.selectAll();
    }

    public void deselectAll() throws DataException {
        this.featureReferenceSelection.deselectAll();
    }

    public void deselectAll(boolean undoable) throws DataException {
        this.featureReferenceSelection.deselectAll(undoable);
    }

    public boolean isSelected(FeatureReference reference) {
        return this.featureReferenceSelection.isSelected(reference);
    }

    public void reverse() {
        this.featureReferenceSelection.reverse();
    }

    public final synchronized void dispose() {
        if (!this.disposed && DisposeUtils.release((Disposable)this)) {
            try {
                this.doDispose();
            }
            catch (Exception ex) {
                LOG.error("Error performing dispose", (Throwable)ex);
            }
            finally {
                this.disposed = true;
            }
        }
    }

    public void update(Observable o, Object o1) {
        this.featureReferenceSelection.update(o, o1);
    }

    public void addObserver(Observer obsrvr) {
        this.featureReferenceSelection.addObserver(obsrvr);
    }

    public void deleteObserver(Observer obsrvr) {
        this.featureReferenceSelection.deleteObserver(obsrvr);
    }

    public void deleteObservers() {
        this.featureReferenceSelection.deleteObservers();
    }

    public void beginComplexNotification() {
        this.featureReferenceSelection.beginComplexNotification();
    }

    public void endComplexNotification() {
        this.featureReferenceSelection.endComplexNotification();
    }

    public void saveToState(PersistentState ps) throws PersistenceException {
        this.featureReferenceSelection.saveToState(ps);
    }

    public boolean select(Feature feature) {
        return this.select(feature, true);
    }

    public boolean select(Feature feature, boolean undoable) {
        if (feature == null) {
            return false;
        }
        if (this.isReversed()) {
            this.removeFeatureTypeCount(feature.getType());
        } else {
            this.addFeatureTypeCount(feature.getType());
        }
        return this.select(feature.getReference(), undoable);
    }

    public boolean select(FeatureSet features) throws DataException {
        return this.select(features, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean select(FeatureSet features, boolean undoable) throws DataException {
        boolean change = false;
        boolean inComplex = false;
        if (undoable && this.featureReferenceSelection.getFeatureStore().isEditing() && !this.featureReferenceSelection.getCommands().inComplex()) {
            this.featureReferenceSelection.getCommands().startComplex("_selectionSelectFeatureSet");
            inComplex = this.featureReferenceSelection.getCommands().inComplex();
        }
        this.disableNotifications();
        DisposableIterator iter = null;
        try {
            iter = features.fastIterator();
            while (iter.hasNext()) {
                change |= this.select((Feature)iter.next(), undoable);
            }
        }
        finally {
            DisposeUtils.disposeQuietly((Disposable)iter);
        }
        this.enableNotifications();
        if (undoable && this.getFeatureStore().isEditing() && inComplex) {
            this.getCommands().endComplex();
        }
        if (change) {
            this.notifyObservers("after_SelectionChange_DataStore");
        }
        return change;
    }

    public boolean deselect(Feature feature) {
        return this.deselect(feature, true);
    }

    public boolean deselect(Feature feature, boolean undoable) {
        if (feature == null) {
            return false;
        }
        LOG.debug("Deselected feature: {}", (Object)feature);
        if (this.isReversed()) {
            this.addFeatureTypeCount(feature.getType());
        } else {
            this.removeFeatureTypeCount(feature.getType());
        }
        return this.deselect(feature.getReference(), undoable);
    }

    public boolean deselect(FeatureSet features) throws DataException {
        return this.deselect(features, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deselect(FeatureSet features, boolean undoable) throws DataException {
        boolean change = false;
        if (undoable && this.getFeatureStore().isEditing()) {
            this.getCommands().startComplex("_selectionDeselectFeatureSet");
        }
        this.disableNotifications();
        DisposableIterator iter = null;
        try {
            iter = features.fastIterator();
            while (iter.hasNext()) {
                change |= this.deselect((Feature)iter.next(), undoable);
            }
        }
        finally {
            DisposeUtils.disposeQuietly((Disposable)iter);
        }
        this.enableNotifications();
        if (undoable && this.getFeatureStore().isEditing()) {
            this.getCommands().endComplex();
        }
        if (change) {
            this.notifyObservers("after_SelectionChange_DataStore");
        }
        return change;
    }

    public boolean isSelected(Feature feature) {
        if (feature == null) {
            return false;
        }
        if (this.featureReferenceSelection.isEmpty()) {
            return false;
        }
        if (this.getData().isReversed()) {
            return this.getData().getSize() == 0 || !this.getData().contains(feature.getReference());
        }
        return this.getData().getSize() > 0 && this.getData().contains(feature.getReference());
    }

    public FeatureType getDefaultFeatureType() {
        try {
            return this.getFeatureStore().getDefaultFeatureType();
        }
        catch (DataException ex) {
            LOG.error("Error getting the default feature type of the FeatureStore: " + this.getFeatureStore(), (Throwable)ex);
            return null;
        }
    }

    public List getFeatureTypes() {
        ArrayList<FeatureType> types = new ArrayList<FeatureType>();
        for (Map.Entry entry : this.featureTypeCounts.entrySet()) {
            FeatureType type = (FeatureType)entry.getKey();
            Long count = (Long)entry.getValue();
            if (count <= 0L) continue;
            types.add(type);
        }
        return types;
    }

    public long getSize() throws DataException {
        return this.getSelectedCount();
    }

    public DisposableIterator iterator(long index) {
        return this.iterator(index, 0L, false);
    }

    public DisposableIterator iterator(long index, long elements) {
        return this.iterator(index, elements, false);
    }

    public DisposableIterator fastIterator(long index) {
        return this.fastIterator(index, 0L);
    }

    public DisposableIterator fastIterator(long index, long elements) {
        return this.iterator(index, elements, true);
    }

    protected void clearFeatureReferences() {
        this.featureReferenceSelection.clearFeatureReferences();
        this.featureTypeCounts.clear();
    }

    private DisposableIterator iterator(long index, long elements, boolean fastIterator) {
        if (this.isReversed()) {
            ReversedFeatureIteratorFacade iter = new ReversedFeatureIteratorFacade(this.getData(), this.getFeatureStore(), fastIterator);
            for (long l = 0L; l < index && iter.hasNext(); ++l) {
                iter.next();
            }
            return iter;
        }
        Iterator<FeatureReference> iterReferences = this.getData().getSelected().iterator();
        for (long l = 0L; l < index && iterReferences.hasNext(); ++l) {
            iterReferences.next();
        }
        FeatureReferenceIteratorToFeatureIterator iterFeatures = new FeatureReferenceIteratorToFeatureIterator(this.getFeatureStore(), iterReferences);
        return iterFeatures;
    }

    private Long removeFeatureTypeCount(FeatureType featureType) {
        Long count = (Long)this.featureTypeCounts.get(featureType);
        count = count == null ? Long.valueOf(-1L) : Long.valueOf(count - 1L);
        this.featureTypeCounts.put(featureType, count);
        return count;
    }

    private Long addFeatureTypeCount(FeatureType featureType) {
        Long count = (Long)this.featureTypeCounts.get(featureType);
        count = count == null ? Long.valueOf(1L) : Long.valueOf(count + 1L);
        this.featureTypeCounts.put(featureType, count);
        return count;
    }

    public void delete(Feature feature) throws DataException {
        Iterator it = this.featureIterators.get(feature);
        if (it != null) {
            it.remove();
            return;
        }
        feature.getStore().delete(feature);
    }

    public void insert(EditableFeature feature) throws DataException {
        feature.getStore().insert(feature);
    }

    public void update(EditableFeature feature) throws DataException {
        feature.getStore().update(feature);
    }

    public void commitChanges() throws DataException {
    }

    public void loadFromState(PersistentState state) throws PersistenceException {
        this.featureReferenceSelection.loadFromState(state);
    }

    protected void doDispose() throws BaseException {
        DisposeUtils.disposeQuietly((Disposable)this.featureReferenceSelection);
        this.featureTypeCounts.clear();
        this.featureTypeCounts = null;
        this.featureReferenceSelection = null;
        this.featureIterators = null;
    }

    public static void registerPersistent() {
        PersistenceManager manager = ToolsLocator.getPersistenceManager();
        DynStruct definition = manager.addDefinition(DefaultFeatureSelection.class, "DefaultFeatureSelection", "DefaultFeatureSelection Persistent definition", null, null);
        definition.extend(manager.getDefinition("DefaultFeatureReferenceSelection"));
        definition.addDynFieldMap("featureTypeCounts").setClassOfItems(Long.class).setMandatory(false);
    }

    public Object clone() throws CloneNotSupportedException {
        DefaultFeatureSelection clone = (DefaultFeatureSelection)((Object)super.clone());
        clone.featureTypeCounts = new HashMap(this.featureTypeCounts);
        clone.featureReferenceSelection = (DefaultFeatureReferenceSelection)((Object)this.featureReferenceSelection.clone());
        clone.featureIterators = new HashMap<Feature, Iterator>();
        return clone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doAccept(Visitor visitor, long firstValueIndex, long elements) throws BaseException {
        if (this.featureReferenceSelection.isEmpty()) {
            return;
        }
        DisposableIterator iterator = this.fastIterator(firstValueIndex, elements);
        if (iterator != null) {
            try {
                while (iterator.hasNext()) {
                    Feature feature = (Feature)iterator.next();
                    visitor.visit((Object)feature);
                }
            }
            finally {
                iterator.dispose();
            }
        }
    }

    public boolean isAvailable() {
        return this.featureReferenceSelection.isAvailable();
    }

    public String toString() {
        ToStringBuilder builder = new ToStringBuilder((Object)this);
        builder.append("store", (Object)this.featureReferenceSelection.getFeatureStore(), true);
        return builder.toString();
    }

    private static class IgnoreInsertAndUpdateFeatureSet
    extends DefaultFeatureSet {
        public IgnoreInsertAndUpdateFeatureSet(DefaultFeatureStore store, FeatureQuery query) throws DataException {
            super(store, query);
        }

        @Override
        public void update(Observable obsevable, Object notification) {
            String type = ((FeatureStoreNotification)notification).getType();
            if (type.equalsIgnoreCase("after_Insert_Feature") || type.equalsIgnoreCase("after_Update_Feature")) {
                return;
            }
            super.update(obsevable, notification);
        }
    }

    private class ReversedFeatureIteratorFacade
    implements DisposableIterator {
        private DefaultFeatureReferenceSelection.SelectionData selectionData;
        private DisposableIterator iterator;
        private Feature nextFeature = null;
        private Feature currentFeature = null;
        private FeatureSet featureSet;

        public ReversedFeatureIteratorFacade(DefaultFeatureReferenceSelection.SelectionData selectionData, FeatureStore featureStore, boolean fastIterator) {
            this.selectionData = selectionData;
            try {
                this.featureSet = new IgnoreInsertAndUpdateFeatureSet((DefaultFeatureStore)featureStore, new DefaultFeatureQuery(featureStore.getDefaultFeatureType()));
                this.iterator = this.featureSet.fastIterator();
            }
            catch (DataException ex) {
                throw new ReversedSelectionIteratorException((Throwable)ex);
            }
            this.positionInNextElement();
        }

        public boolean hasNext() {
            return this.nextFeature != null;
        }

        public Object next() {
            DefaultFeatureSelection.this.featureIterators.remove(this.currentFeature);
            this.currentFeature = this.nextFeature.getCopy();
            DefaultFeatureSelection.this.featureIterators.put(this.currentFeature, this);
            this.positionInNextElement();
            return this.currentFeature;
        }

        public void remove() {
            try {
                this.featureSet.delete(this.currentFeature);
            }
            catch (DataException e) {
                throw new RemoveFromFeatureSelectionException(e);
            }
        }

        private void positionInNextElement() {
            this.nextFeature = null;
            while (this.iterator.hasNext()) {
                this.nextFeature = (Feature)this.iterator.next();
                if (!this.selectionData.contains(this.nextFeature.getReference())) break;
                this.nextFeature = null;
            }
        }

        public void dispose() {
            this.featureSet.dispose();
            this.iterator.dispose();
            this.selectionData = null;
            this.nextFeature = null;
        }
    }

    public class RemoveFromFeatureSelectionException
    extends DataRuntimeException {
        private static final long serialVersionUID = 2636692469445838928L;
        private static final String MESSAGE_FORMAT = "Can't remove feature from reversed selection.";
        private static final String MESSAGE_KEY = "_RemoveFromFeatureSelectionException";

        public RemoveFromFeatureSelectionException(Throwable cause) {
            super(MESSAGE_FORMAT, cause, MESSAGE_KEY, 2636692469445838928L);
        }
    }
}

