/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.feature.impl;

import java.io.File;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.zip.CRC32;
import javax.json.JsonObject;
import javax.json.JsonValue;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.cresques.cts.IProjection;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.EditableFeature;
import org.gvsig.fmap.dal.feature.EditableFeatureType;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureAttributeEmulator;
import org.gvsig.fmap.dal.feature.FeatureExtraColumns;
import org.gvsig.fmap.dal.feature.FeatureRules;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.feature.impl.DALFile;
import org.gvsig.fmap.dal.feature.impl.DefaultEditableFeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.impl.DefaultEditableFeatureType;
import org.gvsig.fmap.dal.feature.impl.DefaultFeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.impl.DefaultFeatureExtraColumns;
import org.gvsig.fmap.dal.feature.impl.DefaultFeatureRules;
import org.gvsig.fmap.dal.feature.impl.DefaultFeatureStore;
import org.gvsig.fmap.dal.feature.impl.FeatureTypeToStoreProviderAdapter;
import org.gvsig.fmap.dal.feature.impl.RecentUsedsAttributesImpl;
import org.gvsig.json.Json;
import org.gvsig.json.JsonManager;
import org.gvsig.json.JsonObjectBuilder;
import org.gvsig.json.SupportToJson;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynClass;
import org.gvsig.tools.dynobject.DynField;
import org.gvsig.tools.dynobject.DynMethod;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.dynobject.DynObjectValueItem;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.dynobject.DynStruct_v2;
import org.gvsig.tools.dynobject.Tags;
import org.gvsig.tools.dynobject.exception.DynMethodException;
import org.gvsig.tools.dynobject.exception.DynObjectValidateException;
import org.gvsig.tools.dynobject.impl.DefaultTags;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.lang.Cloneable;
import org.gvsig.tools.persistence.PersistenceManager;
import org.gvsig.tools.persistence.Persistent;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;

public class DefaultFeatureType
extends ArrayList<FeatureAttributeDescriptor>
implements FeatureType,
Persistent,
DynClass,
DynStruct_v2,
Cloneable {
    private static final long serialVersionUID = -7988721447349282215L;
    public static final RecentUsedsAttributesImpl RECENTS_USEDS = new RecentUsedsAttributesImpl();
    private DefaultFeatureRules rules;
    protected boolean hasEvaluators = false;
    protected boolean hasEmulators = false;
    protected String defaultGeometryAttributeName = null;
    protected String defaultTimeAttributeName = null;
    protected int defaultGeometryAttributeIndex = -1;
    protected int defaultTimeAttributeIndex = -1;
    private String id = "default";
    protected boolean hasOID;
    protected boolean allowAtomaticValues = false;
    protected FeatureAttributeDescriptor[] pk = null;
    protected String internalID = Integer.toHexString((int)(Math.random() * 100000.0)).toUpperCase();
    private List srsList = null;
    private WeakReference storeRef;
    private boolean requiredFields;
    private String description;
    private String label;
    private Tags tags;
    private FeatureExtraColumns extraColumns;
    protected boolean checkFeaturesAtFinishEditing = false;
    protected boolean checkFeaturesAtInsert = true;
    protected boolean fixed = false;
    private static final String FEATTYPE_PERSISTENCE_DEFINITION_NAME = "FeatureType";

    public DefaultFeatureType() {
        this.rules = new DefaultFeatureRules();
        this.tags = new DefaultTags();
        this.extraColumns = new DefaultFeatureExtraColumns();
    }

    protected DefaultFeatureType(FeatureStore store, String id) {
        this();
        if (StringUtils.isEmpty((CharSequence)id)) {
            id = "default";
        }
        this.id = id;
        this.setStore(store);
    }

    protected DefaultFeatureType(FeatureStore store) {
        this(store, null);
    }

    protected DefaultFeatureType(DefaultFeatureType other) {
        this(other.getStore(), null);
        this.copyFrom(other, true);
    }

    protected DefaultFeatureType(DefaultFeatureType other, boolean copyAttributes) {
        this(other.getStore(), null);
        this.copyFrom(other, copyAttributes);
    }

    public void copyFrom(FeatureType other) {
        String internalIDSaved = this.internalID;
        String idSaved = this.id;
        this.copyFrom((DefaultFeatureType)other, true);
        this.id = idSaved;
        this.internalID = internalIDSaved;
    }

    public boolean isCheckFeaturesAtFinishEditing() {
        return this.checkFeaturesAtFinishEditing;
    }

    public boolean isCheckFeaturesAtInsert() {
        return this.checkFeaturesAtInsert;
    }

    protected void addAll(FeatureType attributes) {
        for (FeatureAttributeDescriptor attribute : attributes) {
            DefaultFeatureAttributeDescriptor copy = this.getCopyAttributeDescriptor((DefaultFeatureAttributeDescriptor)attribute);
            super.add(copy);
        }
        DefaultFeatureType ft = (DefaultFeatureType)attributes;
        this.pk = null;
        this.defaultGeometryAttributeName = ft.defaultGeometryAttributeName;
        this.defaultTimeAttributeName = ft.defaultTimeAttributeName;
        this.defaultGeometryAttributeIndex = ft.defaultGeometryAttributeIndex;
        this.defaultTimeAttributeIndex = ft.defaultTimeAttributeIndex;
        this.fixed = false;
    }

    protected void copyFrom(DefaultFeatureType other, boolean copyAttributes) {
        this.id = other.getId();
        if (copyAttributes) {
            this.addAll(other);
        }
        this.defaultGeometryAttributeName = other.defaultGeometryAttributeName;
        this.defaultTimeAttributeName = other.defaultTimeAttributeName;
        this.defaultGeometryAttributeIndex = other.defaultGeometryAttributeIndex;
        this.defaultTimeAttributeIndex = other.defaultTimeAttributeIndex;
        this.hasEvaluators = other.hasEvaluators;
        this.hasEmulators = other.hasEmulators;
        this.rules = (DefaultFeatureRules)(other.rules == null ? null : other.rules.getCopy());
        this.hasOID = other.hasOID;
        this.id = other.id;
        this.internalID = other.internalID;
        this.label = other.label;
        this.description = other.description;
        this.extraColumns = other.extraColumns.getCopy();
        try {
            this.tags = other.tags.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        this.checkFeaturesAtFinishEditing = other.checkFeaturesAtFinishEditing;
        this.checkFeaturesAtInsert = other.checkFeaturesAtInsert;
        this.fixed = false;
    }

    protected DefaultFeatureAttributeDescriptor getCopyAttributeDescriptor(DefaultFeatureAttributeDescriptor src) {
        DefaultFeatureAttributeDescriptor copy = new DefaultFeatureAttributeDescriptor(src);
        copy.setFeatureType(this);
        return copy;
    }

    public String getId() {
        return this.id;
    }

    public Object get(String name) {
        for (FeatureAttributeDescriptor attr : this) {
            if (!attr.getName().equalsIgnoreCase(name)) continue;
            return attr;
        }
        return null;
    }

    public FeatureAttributeDescriptor getAttributeDescriptor(String name) {
        for (FeatureAttributeDescriptor attr : this) {
            if (!attr.getName().equalsIgnoreCase(name)) continue;
            return attr;
        }
        return null;
    }

    public FeatureAttributeDescriptor getAttributeDescriptorFromAll(String name) {
        FeatureAttributeDescriptor attrdesc = this.getAttributeDescriptor(name);
        if (attrdesc == null && this.getExtraColumns().get(name) != null) {
            attrdesc = this.getExtraColumns().get(name);
        }
        return attrdesc;
    }

    public FeatureAttributeDescriptor getAttributeDescriptor(int index) {
        return (FeatureAttributeDescriptor)super.get(index);
    }

    public String getAttributeName(int index) {
        try {
            return ((FeatureAttributeDescriptor)super.get(index)).getName();
        }
        catch (Exception ex) {
            return null;
        }
    }

    public FeatureType getCopy() {
        return new DefaultFeatureType(this);
    }

    @Override
    public Object clone() {
        return this.getCopy();
    }

    public int getDefaultGeometryAttributeIndex() {
        return this.defaultGeometryAttributeIndex;
    }

    public String getDefaultGeometryAttributeName() {
        return this.defaultGeometryAttributeName;
    }

    public int getDefaultTimeAttributeIndex() {
        return this.defaultTimeAttributeIndex;
    }

    public String getDefaultTimeAttributeName() {
        return this.defaultTimeAttributeName;
    }

    public EditableFeatureType getEditable() {
        return new DefaultEditableFeatureType(this);
    }

    public int getIndex(String name) {
        for (FeatureAttributeDescriptor attr : this) {
            if (!attr.getName().equalsIgnoreCase(name)) continue;
            return attr.getIndex();
        }
        return -1;
    }

    public FeatureRules getRules() {
        return this.rules;
    }

    public boolean hasEvaluators() {
        return this.hasEvaluators;
    }

    public boolean hasEmulators() {
        return this.hasEmulators;
    }

    public boolean hasRequiredFields() {
        return this.requiredFields;
    }

    public List getSRSs() {
        if (this.srsList == null) {
            ArrayList<IProjection> tmp = new ArrayList<IProjection>();
            for (FeatureAttributeDescriptor attr : this) {
                if (attr.getDataType().getType() != 66 || attr.getSRS() == null) continue;
                boolean allreadyHave = false;
                for (IProjection tmpSRS : tmp) {
                    if (!tmpSRS.getAbrev().equals(attr.getSRS().getAbrev())) continue;
                    allreadyHave = true;
                    break;
                }
                if (allreadyHave) continue;
                tmp.add(attr.getSRS());
            }
            this.srsList = Collections.unmodifiableList(tmp);
        }
        return this.srsList;
    }

    public IProjection getDefaultSRS() {
        if (this.getDefaultGeometryAttributeIndex() < 0) {
            return null;
        }
        return this.getAttributeDescriptor(this.getDefaultGeometryAttributeIndex()).getSRS();
    }

    public void validateFeature(EditableFeature feature, int check) throws DataException {
        DefaultFeatureRules theRules = (DefaultFeatureRules)this.getRules();
        theRules.validate(feature, check);
    }

    public void validateFeature(Feature feature, int check) throws DataException {
        DefaultFeatureRules theRules = (DefaultFeatureRules)this.getRules();
        theRules.validate(feature, check);
    }

    public FeatureType getSubtype() throws DataException {
        return new SubtypeFeatureType(this, null, null, true);
    }

    public FeatureType getSubtype(String[] names) throws DataException {
        return this.getSubtype(names, null, true);
    }

    public FeatureType getSubtype(String[] names, String[] constantsNames) throws DataException {
        return this.getSubtype(names, constantsNames, true);
    }

    public FeatureType getSubtype(String[] names, String[] constantsNames, boolean includePk) throws DataException {
        if (ArrayUtils.isEmpty((Object[])names) && ArrayUtils.isEmpty((Object[])constantsNames)) {
            return (FeatureType)this.clone();
        }
        return new SubtypeFeatureType(this, names, constantsNames, includePk);
    }

    public boolean isSubtypeOf(FeatureType featureType) {
        return false;
    }

    public List<FeatureAttributeDescriptor> toList() {
        return Collections.unmodifiableList(this);
    }

    public Tags getTags() {
        return this.tags;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
        this.fixed = false;
    }

    public DynField addDynField(String name, int type) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public FeatureExtraColumns getExtraColumns() {
        return this.extraColumns;
    }

    public void setExtraColumn(FeatureExtraColumns extraColumn) {
        this.extraColumns = extraColumn;
        this.fixed = false;
    }

    public Iterable<FeatureAttributeDescriptor> getAllAttributeDescriptors() {
        HashSet<FeatureAttributeDescriptor> all = new HashSet<FeatureAttributeDescriptor>();
        for (FeatureAttributeDescriptor attributeDescriptor : this.getAttributeDescriptors()) {
            all.add(attributeDescriptor);
        }
        for (FeatureAttributeDescriptor extraColumn : this.getExtraColumns().getColumns()) {
            all.add(extraColumn);
        }
        return all;
    }

    public boolean hasOID() {
        return this.hasOID;
    }

    @Override
    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append(this.getId());
        s.append(":[");
        for (int i = 0; i < this.size(); ++i) {
            String attName = ((FeatureAttributeDescriptor)this.get(i)).getName().toString();
            s.append(attName);
            if (i >= this.size() - 1) continue;
            s.append(',');
        }
        s.append(']');
        return s.toString();
    }

    @Override
    public Iterator<FeatureAttributeDescriptor> iterator() {
        return this.getIterator(super.iterator());
    }

    protected Iterator getIterator(Iterator iter) {
        return new DelegatedIterator(iter);
    }

    public boolean allowAutomaticValues() {
        return this.allowAtomaticValues;
    }

    public FeatureAttributeDescriptor[] getAttributeDescriptors() {
        return super.toArray(new FeatureAttributeDescriptor[super.size()]);
    }

    public boolean hasPrimaryKey() {
        if (this.pk != null) {
            return this.pk.length > 0;
        }
        for (FeatureAttributeDescriptor attr : this) {
            if (!attr.isPrimaryKey()) continue;
            return true;
        }
        return false;
    }

    public boolean supportReferences() {
        return this.hasOID() || this.hasPrimaryKey();
    }

    public FeatureAttributeDescriptor[] getPrimaryKey() {
        if (this.pk == null) {
            ArrayList<FeatureAttributeDescriptor> pks = new ArrayList<FeatureAttributeDescriptor>();
            Iterator iter = super.iterator();
            while (iter.hasNext()) {
                FeatureAttributeDescriptor attr = (FeatureAttributeDescriptor)iter.next();
                if (!attr.isPrimaryKey()) continue;
                pks.add(attr);
            }
            this.pk = pks.isEmpty() ? new FeatureAttributeDescriptor[0] : pks.toArray(new FeatureAttributeDescriptor[pks.size()]);
        }
        return this.pk;
    }

    public FeatureAttributeDescriptor getDefaultGeometryAttribute() {
        if (this.defaultGeometryAttributeIndex < 0) {
            return null;
        }
        return (FeatureAttributeDescriptor)super.get(this.defaultGeometryAttributeIndex);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DefaultFeatureType)) {
            return false;
        }
        DefaultFeatureType other = (DefaultFeatureType)o;
        if (!this.id.equals(other.id)) {
            return false;
        }
        if (this.size() != other.size()) {
            return false;
        }
        Iterator<FeatureAttributeDescriptor> iter = this.iterator();
        Iterator<FeatureAttributeDescriptor> iterOther = other.iterator();
        while (iter.hasNext()) {
            FeatureAttributeDescriptor attrOther;
            FeatureAttributeDescriptor attr = iter.next();
            if (attr.equals(attrOther = iterOther.next())) continue;
            return false;
        }
        if (!StringUtils.equals((CharSequence)this.defaultGeometryAttributeName, (CharSequence)other.defaultGeometryAttributeName)) {
            return false;
        }
        return StringUtils.equals((CharSequence)this.defaultTimeAttributeName, (CharSequence)other.defaultTimeAttributeName);
    }

    public DynField addDynField(String name) {
        throw new UnsupportedOperationException();
    }

    public DynField getDeclaredDynField(String name) {
        return this.getAttributeDescriptor(name);
    }

    public DynField[] getDeclaredDynFields() {
        return (DynField[])this.getAttributeDescriptors();
    }

    public String getDescription() {
        return this.description;
    }

    public DynField getDynField(String name) {
        return this.getAttributeDescriptor(name);
    }

    public DynField[] getDynFields() {
        return (DynField[])this.getAttributeDescriptors();
    }

    public String getName() {
        return this.id + "_" + this.internalID;
    }

    public void removeDynField(String name) {
        throw new UnsupportedOperationException();
    }

    public void addDynMethod(DynMethod dynMethod) {
        throw new UnsupportedOperationException();
    }

    public void extend(DynClass dynClass) {
        throw new UnsupportedOperationException();
    }

    public void extend(String dynClassName) {
        throw new UnsupportedOperationException();
    }

    public void extend(String namespace, String dynClassName) {
        throw new UnsupportedOperationException();
    }

    public DynMethod getDeclaredDynMethod(String name) throws DynMethodException {
        return null;
    }

    public DynMethod[] getDeclaredDynMethods() throws DynMethodException {
        return null;
    }

    public DynMethod getDynMethod(String name) throws DynMethodException {
        return null;
    }

    public DynMethod getDynMethod(int code) throws DynMethodException {
        return null;
    }

    public DynMethod[] getDynMethods() throws DynMethodException {
        return null;
    }

    public DynClass[] getSuperDynClasses() {
        return null;
    }

    public boolean isInstance(DynObject dynObject) {
        return dynObject.getDynClass().getName() == this.getName();
    }

    public DynObject newInstance() {
        throw new UnsupportedOperationException();
    }

    public void removeDynMethod(String name) {
        throw new UnsupportedOperationException();
    }

    public DynField addDynFieldChoice(String name, int type, Object defaultValue, DynObjectValueItem[] values, boolean mandatory, boolean persistent) {
        throw new UnsupportedOperationException();
    }

    public DynField addDynFieldRange(String name, int type, Object defaultValue, Object min, Object max, boolean mandatory, boolean persistent) {
        throw new UnsupportedOperationException();
    }

    public DynField addDynFieldSingle(String name, int type, Object defaultValue, boolean mandatory, boolean persistent) {
        throw new UnsupportedOperationException();
    }

    public void validate(DynObject object) throws DynObjectValidateException {
        Feature fea;
        if (object instanceof Feature && (fea = (Feature)object).getType().equals(this)) {
            return;
        }
        throw new DynObjectValidateException(this.id);
    }

    public DynField addDynFieldLong(String name) {
        throw new UnsupportedOperationException();
    }

    public DynField addDynFieldChoice(String name, int type, Object defaultValue, DynObjectValueItem[] values) {
        throw new UnsupportedOperationException();
    }

    public DynField addDynFieldRange(String name, int type, Object defaultValue, Object min, Object max) {
        throw new UnsupportedOperationException();
    }

    public DynField addDynFieldSingle(String name, int type, Object defaultValue) {
        throw new UnsupportedOperationException();
    }

    public DynField addDynFieldString(String name) {
        throw new UnsupportedOperationException();
    }

    public DynField addDynFieldInt(String name) {
        throw new UnsupportedOperationException();
    }

    public DynField addDynFieldDouble(String name) {
        throw new UnsupportedOperationException();
    }

    public DynField addDynFieldFloat(String name) {
        throw new UnsupportedOperationException();
    }

    public DynField addDynFieldBoolean(String name) {
        throw new UnsupportedOperationException();
    }

    public DynField addDynFieldList(String name) {
        throw new UnsupportedOperationException();
    }

    public DynField addDynFieldMap(String name) {
        throw new UnsupportedOperationException();
    }

    public DynField addDynFieldObject(String name) {
        throw new UnsupportedOperationException();
    }

    public DynField addDynFieldSet(String name) {
        throw new UnsupportedOperationException();
    }

    public DynField addDynFieldArray(String name) {
        throw new UnsupportedOperationException();
    }

    public DynField addDynFieldDate(String name) {
        throw new UnsupportedOperationException();
    }

    public void extend(DynStruct struct) {
        throw new UnsupportedOperationException();
    }

    public String getFullName() {
        return this.id;
    }

    public String getNamespace() {
        return "DALFeature";
    }

    public DynStruct[] getSuperDynStructs() {
        return null;
    }

    public void setDescription(String description) {
        this.description = description;
        this.fixed = false;
    }

    public void setNamespace(String namespace) {
        throw new UnsupportedOperationException();
    }

    public DynField addDynFieldFile(String name) {
        throw new UnsupportedOperationException();
    }

    public DynField addDynFieldFolder(String name) {
        throw new UnsupportedOperationException();
    }

    public DynField addDynFieldURL(String name) {
        throw new UnsupportedOperationException();
    }

    public DynField addDynFieldURI(String name) {
        throw new UnsupportedOperationException();
    }

    public boolean isExtendable(DynStruct dynStruct) {
        return false;
    }

    public void extend(DynStruct[] structs) {
    }

    public void remove(DynStruct superDynStruct) {
    }

    public void removeAll(DynStruct[] superDynStruct) {
    }

    public FeatureAttributeDescriptor getDefaultTimeAttribute() {
        if (this.defaultTimeAttributeIndex < 0) {
            return null;
        }
        return (FeatureAttributeDescriptor)super.get(this.defaultTimeAttributeIndex);
    }

    public void setDefaultTimeAttributeName(String name) {
        if (name == null || name.length() == 0) {
            this.defaultTimeAttributeIndex = -1;
            return;
        }
        DefaultFeatureAttributeDescriptor attr = (DefaultFeatureAttributeDescriptor)this.get(name);
        if (attr == null) {
            throw new IllegalArgumentException("Attribute '" + name + "' not found.");
        }
        if (attr.getIndex() < 0) {
            this.fixAll();
        }
        this.defaultTimeAttributeIndex = attr.getIndex();
        this.fixed = false;
    }

    protected void fixAll() {
        if (this.fixed) {
            return;
        }
        int i = 0;
        Iterator iter = super.iterator();
        while (iter.hasNext()) {
            DefaultFeatureAttributeDescriptor attr = (DefaultFeatureAttributeDescriptor)iter.next();
            attr.setIndex(i++);
            if (attr.getOder() < 1) {
                attr.setOrder(i * 10);
            }
            attr.fixAll();
            if (attr.getEvaluator() != null) {
                this.hasEvaluators = true;
            }
            if (attr.getFeatureAttributeEmulator() != null) {
                this.hasEmulators = true;
                Object[] x = attr.getFeatureAttributeEmulator().getRequiredFieldNames();
                if (!ArrayUtils.isEmpty((Object[])x)) {
                    this.requiredFields = true;
                }
            }
            switch (attr.getType()) {
                case 66: {
                    if (this.defaultGeometryAttributeName != null && this.get(this.defaultGeometryAttributeName) != null) break;
                    this.defaultGeometryAttributeName = attr.getName();
                    break;
                }
                case 9: 
                case 68: 
                case 69: {
                    if (this.defaultTimeAttributeName != null || !attr.isTime()) break;
                    this.defaultTimeAttributeName = attr.getName();
                }
            }
        }
        if (this.defaultGeometryAttributeName != null) {
            this.defaultGeometryAttributeIndex = this.getIndex(this.defaultGeometryAttributeName);
        }
        if (this.defaultTimeAttributeName != null) {
            this.defaultTimeAttributeIndex = this.getIndex(this.defaultTimeAttributeName);
        }
        this.internalID = Long.toHexString(this.getCRC());
        this.fixed = true;
    }

    protected long getCRC() {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < this.size(); ++i) {
            FeatureAttributeDescriptor x = this.getAttributeDescriptor(i);
            buffer.append(x.getName());
            buffer.append(x.getDataTypeName());
            buffer.append(x.getSize());
        }
        CRC32 crc = new CRC32();
        byte[] data = buffer.toString().getBytes();
        crc.update(data);
        return crc.getValue();
    }

    public FeatureStore getStore() {
        if (this.storeRef == null) {
            return null;
        }
        return (FeatureStore)this.storeRef.get();
    }

    public void setStore(FeatureStore store) {
        this.storeRef = store == null ? null : new WeakReference<FeatureStore>(store);
        this.fixed = false;
    }

    public List<FeatureAttributeDescriptor> getFilteredAttributes(Predicate<FeatureAttributeDescriptor> filter, int max) {
        ArrayList<FeatureAttributeDescriptor> attrs = new ArrayList<FeatureAttributeDescriptor>();
        for (FeatureAttributeDescriptor attribute : this) {
            if (filter.test(attribute)) {
                attrs.add(attribute);
            }
            if (max <= 0 || attrs.size() < max) continue;
            break;
        }
        return attrs;
    }

    public List<FeatureAttributeDescriptor> getRecentUseds() {
        return RECENTS_USEDS.getAttributes(this);
    }

    public void loadFromState(PersistentState state) throws PersistenceException {
        this.hasEvaluators = state.getBoolean("hasEvaluators");
        this.hasEmulators = state.getBoolean("hasEmulators");
        this.defaultGeometryAttributeName = state.getString("defaultGeometryAttributeName");
        this.defaultTimeAttributeName = state.getString("defaultTimeAttributeName");
        this.defaultGeometryAttributeIndex = state.getInt("defaultGeometryAttributeIndex");
        this.defaultTimeAttributeIndex = state.getInt("defaultTimeAttributeIndex");
        this.id = state.getString("id");
        this.hasOID = state.getBoolean("hasOID");
        this.allowAtomaticValues = state.getBoolean("allowAtomaticValues");
        this.requiredFields = state.getBoolean("requiredFields");
        this.internalID = state.getString("internalID");
        this.tags = (Tags)state.get("tags");
        if (this.tags == null) {
            this.tags = new DefaultTags();
        }
        this.checkFeaturesAtFinishEditing = state.getBoolean("checkFeaturesAtFinishEditing");
        this.checkFeaturesAtInsert = state.getBoolean("checkFeaturesAtInsert");
        List elements = state.getList("elements");
        for (FeatureAttributeDescriptor element : elements) {
            ((DefaultFeatureAttributeDescriptor)element).setFeatureType(this);
            super.add(element);
        }
        this.pk = null;
        this.rules = new DefaultFeatureRules();
        List stateRules = state.getList("rules");
        if (stateRules != null) {
            this.rules.addAll(state.getList("rules"));
        }
        this.label = state.getString("label");
        this.description = state.getString("description");
        this.fixAll();
    }

    public void saveToState(PersistentState state) throws PersistenceException {
        state.set("hasEvaluators", this.hasEvaluators);
        state.set("hasEmulators", this.hasEmulators);
        state.set("defaultGeometryAttributeName", this.defaultGeometryAttributeName);
        state.set("defaultTimeAttributeName", this.defaultTimeAttributeName);
        state.set("defaultGeometryAttributeIndex", this.defaultGeometryAttributeIndex);
        state.set("defaultTimeAttributeIndex", this.defaultTimeAttributeIndex);
        state.set("id", this.id);
        state.set("hasOID", this.hasOID);
        state.set("allowAtomaticValues", this.allowAtomaticValues);
        state.set("requiredFields", this.requiredFields);
        state.set("internalID", this.internalID);
        ArrayList<FeatureAttributeDescriptor> elements = new ArrayList<FeatureAttributeDescriptor>();
        elements.addAll(this);
        state.set("elements", elements);
        state.set("tags", (Persistent)this.tags);
        state.set("checkFeaturesAtFinishEditing", this.checkFeaturesAtFinishEditing);
        state.set("checkFeaturesAtInsert", this.checkFeaturesAtInsert);
        state.set("rules", this.rules == null ? null : this.rules.iterator());
        state.set("label", this.label);
        state.set("description", this.description);
    }

    public static void registerPersistenceDefinition() {
        PersistenceManager manager = ToolsLocator.getPersistenceManager();
        if (manager.getDefinition(FEATTYPE_PERSISTENCE_DEFINITION_NAME) == null) {
            DynStruct definition = manager.addDefinition(DefaultFeatureType.class, FEATTYPE_PERSISTENCE_DEFINITION_NAME, "FeatureType persistent definition", null, null);
            definition.addDynFieldBoolean("hasEvaluators");
            definition.addDynFieldBoolean("hasEmulators");
            definition.addDynFieldString("defaultGeometryAttributeName");
            definition.addDynFieldString("defaultTimeAttributeName");
            definition.addDynFieldInt("defaultGeometryAttributeIndex");
            definition.addDynFieldInt("defaultTimeAttributeIndex");
            definition.addDynFieldString("id");
            definition.addDynFieldBoolean("hasOID");
            definition.addDynFieldBoolean("allowAtomaticValues");
            definition.addDynFieldBoolean("requiredFields");
            definition.addDynFieldString("internalID");
            definition.addDynFieldList("elements").setClassOfItems(FeatureAttributeDescriptor.class);
            definition.addDynFieldObject("tags").setClassOfValue(Tags.class);
            definition.addDynFieldBoolean("checkFeaturesAtFinishEditing").setMandatory(false).setDefaultFieldValue((Object)false);
            definition.addDynFieldBoolean("checkFeaturesAtInsert").setMandatory(false).setDefaultFieldValue((Object)true);
            definition.addDynFieldList("rules").setClassOfItems(FeatureRules.class);
            definition.addDynFieldString("label").setMandatory(false);
            definition.addDynFieldString("description").setMandatory(false);
        }
    }

    public FeatureStore getAsFeatureStore() {
        FeatureStore store = FeatureTypeToStoreProviderAdapter.createFeatureStore(this);
        return store;
    }

    public String getNewFieldName() {
        String fieldName;
        I18nManager i18n = ToolsLocator.getI18nManager();
        String prefix = i18n.getTranslation("_Field");
        for (int i = 1; i < 1000; ++i) {
            fieldName = prefix + i;
            if (this.get(fieldName) != null) continue;
            return fieldName;
        }
        fieldName = prefix + new Date().getTime();
        return fieldName;
    }

    public FeatureType getOriginalFeatureType() {
        DefaultFeatureStore store = (DefaultFeatureStore)this.getStore();
        if (store == null) {
            return null;
        }
        return store.getOriginalFeatureType(this);
    }

    public boolean hasOnlyMetadataChanges(FeatureType old) {
        if (old == null) {
            throw new NullPointerException();
        }
        for (FeatureAttributeDescriptor attr : this) {
            if (attr.isComputed() || old.getAttributeDescriptor(attr.getName()) != null) continue;
            return false;
        }
        for (FeatureAttributeDescriptor attr : old) {
            if (attr.isComputed() || this.getAttributeDescriptor(attr.getName()) != null) continue;
            return false;
        }
        for (FeatureAttributeDescriptor attr : this) {
            FeatureAttributeDescriptor attrold = old.getAttributeDescriptor(attr.getName());
            if (attr.isComputed() || attr.hasOnlyMetadataChanges(attrold)) continue;
            return false;
        }
        return true;
    }

    public void writeAsDALFile(File file) {
        this.writeAsDALFile(file, "bin");
    }

    public void writeAsDALFile(File file, String format) {
        try {
            DALFile dalFile = DALFile.getDALFile();
            dalFile.setFeatureType(this);
            if (!dalFile.isEmpty()) {
                dalFile.write(file, format);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException("Can't write as DAL file (" + Objects.toString(file) + ").", ex);
        }
    }

    public JsonObject toJson() {
        return this.toJsonBuilder().build();
    }

    public JsonObjectBuilder toJsonBuilder() {
        JsonObjectBuilder builder = Json.createObjectBuilder();
        builder.add_class((Object)this);
        builder.add("id", this.id);
        builder.add("internalID", this.internalID);
        builder.add("label", this.label);
        builder.add("description", this.description);
        builder.add("allowAtomaticValues", this.allowAtomaticValues);
        builder.add("hasOID", this.hasOID);
        builder.add("defaultGeometryAttributeName", this.defaultGeometryAttributeName);
        builder.add("defaultTimeAttributeName", this.defaultTimeAttributeName);
        builder.add("checkFeaturesAtFinishEditing", this.checkFeaturesAtFinishEditing);
        builder.add("checkFeaturesAtInsert", this.checkFeaturesAtInsert);
        builder.add("tags", (Iterable)this.tags);
        builder.add("rules", (SupportToJson)this.rules);
        builder.add("extraColumns", (SupportToJson)this.extraColumns);
        builder.add("descriptors", this.iterator());
        return builder;
    }

    public void fromJson(JsonObject json) {
        this.clear();
        this.id = json.getString("id", null);
        this.internalID = json.getString("internalID", null);
        this.label = json.getString("label", null);
        this.description = json.getString("description", null);
        this.allowAtomaticValues = json.getBoolean("allowAtomaticValues", false);
        this.checkFeaturesAtFinishEditing = json.getBoolean("checkFeaturesAtFinishEditing", false);
        this.checkFeaturesAtInsert = json.getBoolean("checkFeaturesAtInsert", true);
        this.hasOID = json.getBoolean("hasOID", false);
        this.defaultGeometryAttributeName = json.getString("defaultGeometryAttributeName", null);
        this.defaultTimeAttributeName = json.getString("defaultTimeAttributeName", null);
        this.tags = (Tags)Json.toObject((JsonObject)json, (String)"tags");
        this.rules = (DefaultFeatureRules)Json.toObject((JsonObject)json, (String)"rules");
        this.extraColumns = (FeatureExtraColumns)Json.toObject((JsonObject)json, (String)"extraColumns");
        if (json.containsKey((Object)"descriptors")) {
            for (JsonValue jsonValue : json.getJsonArray("descriptors")) {
                DefaultEditableFeatureAttributeDescriptor attr = new DefaultEditableFeatureAttributeDescriptor(this, false);
                attr.fromJson((JsonObject)jsonValue);
                this.add(attr);
            }
        }
        this.fixed = false;
    }

    public static void selfRegister() {
        Json.registerSerializer((JsonManager.JsonSerializer)new TheJsonSerializer());
    }

    private static class TheJsonSerializer
    implements JsonManager.JsonSerializer {
        public Class getObjectClass() {
            return DefaultFeatureType.class;
        }

        public Object toObject(JsonObject json) {
            DefaultFeatureType o = new DefaultFeatureType();
            o.fromJson(json);
            return o;
        }

        public JsonObjectBuilder toJsonBuilder(Object value) {
            return ((SupportToJson)value).toJsonBuilder();
        }
    }

    protected class DelegatedIterator
    implements Iterator {
        protected Iterator iterator;

        public DelegatedIterator(Iterator iter) {
            this.iterator = iter;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        public Object next() {
            return this.iterator.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public class SubtypeFeatureTypeNameException
    extends DataException {
        private static final long serialVersionUID = -4414242486723260101L;
        private static final String MESSAGE_FORMAT = "Attribute name '%(name)' not found in type (%(type)).";
        private static final String MESSAGE_KEY = "_SubtypeFeatureTypeNameException";

        public SubtypeFeatureTypeNameException(String name, String type) {
            super(MESSAGE_FORMAT, MESSAGE_KEY, -4414242486723260101L);
            this.setValue("name", name);
            this.setValue("type", type);
        }
    }

    class SubtypeFeatureType
    extends DefaultFeatureType {
        private static final long serialVersionUID = 6913732960073922540L;
        WeakReference parent;

        /*
         * WARNING - void declaration
         */
        SubtypeFeatureType(DefaultFeatureType parent, String[] names, String[] constantsNames, boolean includePk) throws DataException {
            super(parent, false);
            LinkedHashSet<String> attrnames = new LinkedHashSet<String>();
            HashSet<String> requiredAttrnames = new HashSet<String>();
            if (ArrayUtils.isEmpty((Object[])names)) {
                for (FeatureAttributeDescriptor attrdesc : parent) {
                    attrnames.add(attrdesc.getName().toLowerCase());
                }
            } else {
                void var11_16;
                String[] stringArray = names;
                int attrdesc = stringArray.length;
                boolean bl = false;
                while (var11_16 < attrdesc) {
                    Object object = stringArray[var11_16];
                    String string = ((String)object).toLowerCase();
                    attrnames.add(string);
                    requiredAttrnames.add(string);
                    ++var11_16;
                }
            }
            if (parent.hasEmulators) {
                for (FeatureAttributeDescriptor attrdesc : parent) {
                    FeatureAttributeEmulator featureAttributeEmulator = attrdesc.getFeatureAttributeEmulator();
                    if (featureAttributeEmulator == null || !attrnames.contains(attrdesc.getName().toLowerCase())) continue;
                    String[] stringArray = featureAttributeEmulator.getRequiredFieldNames();
                    if (names == null) continue;
                    for (String name : stringArray) {
                        name = name.toLowerCase();
                        attrnames.add(name);
                        requiredAttrnames.add(name);
                    }
                }
            }
            if (includePk && !parent.hasOID()) {
                for (FeatureAttributeDescriptor attrdesc : parent) {
                    if (!attrdesc.isPrimaryKey()) continue;
                    String string = attrdesc.getName().toLowerCase();
                    attrnames.add(string);
                    requiredAttrnames.add(string);
                }
            }
            int i = 0;
            for (String string : attrnames) {
                DefaultFeatureAttributeDescriptor defaultFeatureAttributeDescriptor = (DefaultFeatureAttributeDescriptor)parent.get(string);
                if (defaultFeatureAttributeDescriptor == null) {
                    throw new SubtypeFeatureTypeNameException(string, parent.getId());
                }
                DefaultFeatureAttributeDescriptor attrcopy = new DefaultFeatureAttributeDescriptor(defaultFeatureAttributeDescriptor);
                this.add(attrcopy);
                attrcopy.index = i++;
            }
            if (!ArrayUtils.isEmpty((Object[])constantsNames)) {
                void var12_28;
                String[] stringArray = constantsNames;
                int n = stringArray.length;
                boolean bl = false;
                while (var12_28 < n) {
                    DefaultFeatureAttributeDescriptor attr;
                    String name = stringArray[var12_28];
                    if (!requiredAttrnames.contains(name.toLowerCase()) && (attr = (DefaultFeatureAttributeDescriptor)this.get(name)) != null) {
                        attr.setConstantValue(true);
                    }
                    ++var12_28;
                }
            }
            this.defaultGeometryAttributeIndex = this.getIndex(this.defaultGeometryAttributeName);
            if (this.defaultGeometryAttributeIndex < 0) {
                this.defaultGeometryAttributeName = null;
            }
            this.defaultTimeAttributeIndex = this.getIndex(this.defaultTimeAttributeName);
            if (this.defaultTimeAttributeIndex < 0) {
                this.defaultTimeAttributeName = null;
            }
            this.parent = new WeakReference<DefaultFeatureType>(parent);
        }

        public FeatureType getSubtype(String[] names, boolean includePk) throws DataException {
            return new SubtypeFeatureType((DefaultFeatureType)this.parent.get(), names, null, includePk);
        }

        @Override
        public boolean isSubtypeOf(FeatureType featureType) {
            if (featureType == null) {
                return false;
            }
            FeatureType parent = (FeatureType)this.parent.get();
            return featureType.equals(parent);
        }

        @Override
        public EditableFeatureType getEditable() {
            throw new UnsupportedOperationException();
        }
    }
}

