/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.feature.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.exception.ReadRuntimeException;
import org.gvsig.fmap.dal.feature.EditableFeature;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureReference;
import org.gvsig.fmap.dal.feature.FeatureSet;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.feature.impl.DefaultFeature;
import org.gvsig.fmap.dal.feature.impl.featurereference.FeatureReferenceFactory;
import org.gvsig.fmap.dal.feature.impl.featureset.AbstractFeatureSet;
import org.gvsig.fmap.dal.feature.spi.FeatureProvider;
import org.gvsig.fmap.dal.feature.spi.FeatureReferenceProviderServices;
import org.gvsig.fmap.dal.feature.spi.FeatureSetProvider;
import org.gvsig.fmap.dal.feature.spi.FeatureStoreProvider;
import org.gvsig.fmap.dal.feature.spi.FeatureStoreProviderServices;
import org.gvsig.fmap.dal.feature.spi.LongList;
import org.gvsig.fmap.dal.feature.spi.index.FeatureIndexProviderServices;
import org.gvsig.tools.dispose.DisposableIterator;

public class IndexFeatureSet
extends AbstractFeatureSet
implements FeatureSet,
FeatureSetProvider,
Iterable<Feature> {
    LongList featureReferences = null;
    FeatureStoreProvider storeProvider = null;
    FeatureStoreProviderServices store = null;
    FeatureIndexProviderServices index = null;
    List featureTypes = null;

    public IndexFeatureSet(FeatureIndexProviderServices index, LongList featureReferences) {
        this.featureReferences = featureReferences;
        this.store = index.getFeatureStoreProviderServices();
        this.storeProvider = this.store.getProvider();
        this.index = index;
    }

    public boolean canFilter() {
        return false;
    }

    public boolean canIterateFromIndex() {
        return true;
    }

    public boolean canOrder() {
        return false;
    }

    public DisposableIterator fastIterator(long index) throws DataException {
        return this.fastIterator(index, 0L);
    }

    public DisposableIterator fastIterator(long index, long elements) throws DataException {
        if (this.store.getFeatureStore().isEditing()) {
            return this.iterator(index, elements);
        }
        return new FastIndexIterator(this.featureReferences.iterator(index));
    }

    public long getSize() throws DataException {
        return this.featureReferences.getSize();
    }

    @Override
    public boolean isEmpty() {
        return this.featureReferences.isEmpty();
    }

    public DisposableIterator iterator(long index) throws DataException {
        return new IndexIterator(this.featureReferences.iterator(index));
    }

    public DisposableIterator iterator(long index, long elements) throws DataException {
        return new IndexIterator(this.featureReferences.iterator(index));
    }

    public void delete(Feature feature) throws DataException {
        this.index.delete(feature);
        this.store.getFeatureStore().delete(feature);
    }

    public void commitChanges() throws DataException {
        this.store.getFeatureStore().commitChanges();
    }

    public FeatureType getDefaultFeatureType() {
        return this.index.getFeatureType();
    }

    public List getFeatureTypes() {
        ArrayList<FeatureType> types = new ArrayList<FeatureType>();
        types.add(this.index.getFeatureType());
        return Collections.unmodifiableList(types);
    }

    public void insert(EditableFeature feature) throws DataException {
        this.index.insert((Feature)feature);
        this.store.getFeatureStore().insert(feature);
    }

    public void update(EditableFeature feature) throws DataException {
        this.store.getFeatureStore().update(feature);
        this.index.delete((Feature)feature);
        this.index.insert((Feature)feature);
    }

    public void dispose() {
    }

    @Override
    public FeatureStore getFeatureStore() {
        return this.store.getFeatureStore();
    }

    public class FastIndexIterator
    implements DisposableIterator {
        Iterator it = null;
        DefaultFeature feature = null;

        public FastIndexIterator(Iterator it) throws DataException {
            this.it = it;
            this.feature = (DefaultFeature)IndexFeatureSet.this.store.createFeature(IndexFeatureSet.this.storeProvider.createFeatureProvider(IndexFeatureSet.this.index.getFeatureType()));
        }

        public boolean hasNext() {
            return this.it.hasNext();
        }

        public Object next() {
            Object oid = this.it.next();
            try {
                FeatureReference ref = FeatureReferenceFactory.createFromOID(IndexFeatureSet.this.store.getFeatureStore(), oid);
                FeatureProvider data = IndexFeatureSet.this.storeProvider.getFeatureProviderByReference((FeatureReferenceProviderServices)ref);
                this.feature.setData(data);
                return this.feature;
            }
            catch (DataException e) {
                throw new ReadRuntimeException(IndexFeatureSet.this.store.getName(), oid, (Throwable)e);
            }
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        public void dispose() {
            this.it = null;
            this.feature = null;
        }
    }

    public class IndexIterator
    implements DisposableIterator {
        Iterator it = null;

        public IndexIterator(Iterator it) {
            this.it = it;
        }

        public boolean hasNext() {
            return this.it.hasNext();
        }

        public Object next() {
            Object oid = this.it.next();
            FeatureReference ref = FeatureReferenceFactory.createFromOID(IndexFeatureSet.this.store.getFeatureStore(), oid);
            try {
                return IndexFeatureSet.this.store.getFeatureStore().getFeatureByReference(ref);
            }
            catch (DataException e) {
                throw new ReadRuntimeException(IndexFeatureSet.this.store.getName(), oid, (Throwable)e);
            }
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        public void dispose() {
            this.it = null;
        }
    }
}

