/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.feature.impl.dynobjectutils;

import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureSet;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureStoreNotification;
import org.gvsig.fmap.dal.feature.impl.dynobjectutils.DynObjectFeatureFacade;
import org.gvsig.fmap.dal.feature.impl.dynobjectutils.DynObjectIteratorFeatureIteratorFacade;
import org.gvsig.tools.dispose.DisposableIterator;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.dynobject.DynObjectSet;
import org.gvsig.tools.exception.BaseException;
import org.gvsig.tools.observer.Observable;
import org.gvsig.tools.observer.Observer;
import org.gvsig.tools.observer.WeakReferencingObservable;
import org.gvsig.tools.observer.impl.BaseWeakReferencingObservable;
import org.gvsig.tools.visitor.VisitCanceledException;
import org.gvsig.tools.visitor.Visitor;

public class DynObjectSetFeatureSetFacade
extends BaseWeakReferencingObservable
implements DynObjectSet,
Observer {
    private final FeatureSet featureSet;
    private final FeatureStore store;
    private final DynObjectFeatureFacade featureFacade = new DynObjectFeatureFacade(null);
    private final boolean fast;

    public DynObjectSetFeatureSetFacade(FeatureSet featureSet, FeatureStore store) {
        this(featureSet, store, true);
    }

    public DynObjectSetFeatureSetFacade(FeatureSet featureSet, FeatureStore store, boolean fast) {
        this.featureSet = featureSet;
        this.store = store;
        store.addObserver((Observer)this);
        this.fast = fast;
    }

    public void dispose() {
        this.store.deleteObserver((Observer)this);
    }

    public void accept(final Visitor visitor, long firstValueIndex) throws BaseException {
        this.featureSet.accept(new Visitor(){

            public void visit(Object obj) throws VisitCanceledException, BaseException {
                DynObjectFeatureFacade feature = DynObjectSetFeatureSetFacade.this.fast ? DynObjectSetFeatureSetFacade.this.featureFacade : new DynObjectFeatureFacade();
                feature.setFeature(((Feature)obj).getCopy());
                visitor.visit((Object)feature);
            }
        }, firstValueIndex);
    }

    public void accept(final Visitor visitor) throws BaseException {
        this.featureSet.accept(new Visitor(){

            public void visit(Object obj) throws VisitCanceledException, BaseException {
                DynObjectSetFeatureSetFacade.this.featureFacade.setFeature(((Feature)obj).getCopy());
                visitor.visit((Object)DynObjectSetFeatureSetFacade.this.featureFacade);
            }
        });
    }

    public long getSize() throws BaseException {
        return this.featureSet.getSize();
    }

    public DisposableIterator iterator(long index) throws BaseException {
        if (this.fast) {
            return new DynObjectIteratorFeatureIteratorFacade(this.featureSet.fastIterator(index), this.featureFacade);
        }
        return new DynObjectIteratorFeatureIteratorFacade(this.featureSet.fastIterator(index));
    }

    public DisposableIterator iterator() throws BaseException {
        if (this.fast) {
            return new DynObjectIteratorFeatureIteratorFacade(this.featureSet.fastIterator(), this.featureFacade);
        }
        return new DynObjectIteratorFeatureIteratorFacade(this.featureSet.fastIterator());
    }

    public boolean isEmpty() throws BaseException {
        return this.featureSet.isEmpty();
    }

    public boolean isDeleteEnabled() {
        return this.store.isEditing();
    }

    public void delete(DynObject dynObject) throws BaseException {
        DynObjectFeatureFacade facade = (DynObjectFeatureFacade)dynObject;
        this.featureSet.delete(facade.getFeature());
    }

    public boolean isUpdateEnabled() {
        return this.store.isEditing();
    }

    public void update(DynObject dynObject) throws BaseException {
        DynObjectFeatureFacade facade = (DynObjectFeatureFacade)dynObject;
        this.featureSet.update(facade.getEditableFeature());
    }

    public void update(Observable observable, Object notification) {
        FeatureStoreNotification event;
        if (observable.equals(this.store) && notification instanceof FeatureStoreNotification && ((event = (FeatureStoreNotification)notification).getType() == "after_StartEditing_DataStore" || event.getType() == "after_FinishEditing_DataStore" || event.getType() == "after_CancelEditing_DataStore")) {
            this.setChanged();
            this.notify((WeakReferencingObservable)this, new DynObjectSet.Notification(){

                public String getType() {
                    return "edition_status_change_DynObjectSet";
                }
            });
        }
    }
}

