/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.feature.impl.editing.memory;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.AbstractFeatureStoreTransform;
import org.gvsig.fmap.dal.feature.EditableFeature;
import org.gvsig.fmap.dal.feature.EditableFeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.EditableFeatureType;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureStoreTransform;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.feature.impl.DefaultFeatureStoreTransforms;
import org.gvsig.fmap.dal.feature.impl.editing.memory.ExpansionAdapter;
import org.gvsig.fmap.dal.feature.impl.editing.memory.MemoryExpansionAdapter;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;

public class FeatureTypeManager {
    private final ExpansionAdapter expansionAdapter;
    private final Map<String, Integer> added = new HashMap<String, Integer>();
    private final Map<String, Integer> modifiedFromOriginal = new HashMap<String, Integer>();
    private final List<String> deleted = new ArrayList<String>();
    private final FeatureTypeManagerFeatureStoreTransforms transforms;
    private final FeatureStore store;
    private int deltaSize = 0;
    private boolean first = true;
    private FeatureType originalType = null;

    public FeatureTypeManager(FeatureStore store) {
        this.expansionAdapter = new MemoryExpansionAdapter();
        this.store = store;
        this.transforms = new FeatureTypeManagerFeatureStoreTransforms();
        this.transforms.setFeatureStore(store);
    }

    public void dispose() {
        this.expansionAdapter.close();
        this.deleted.clear();
        this.transforms.clear();
        this.added.clear();
        this.modifiedFromOriginal.clear();
    }

    public FeatureType getType(String id) throws DataException {
        Integer num = this.added.get(id);
        if (num == null && (num = this.modifiedFromOriginal.get(id)) == null) {
            return null;
        }
        if (num == -1) {
            return null;
        }
        FeatureType type = (FeatureType)this.expansionAdapter.getObject(num);
        return type;
    }

    public int update(FeatureType type, FeatureType oldType) {
        if (this.first) {
            this.originalType = oldType;
            this.first = false;
        }
        int oldNum = -1;
        int num = this.expansionAdapter.addObject(type.getCopy());
        String id = type.getId();
        if (this.added.containsKey(id)) {
            oldNum = this.added.get(id);
            this.added.put(id, num);
        } else {
            if (this.modifiedFromOriginal.get(id) != null) {
                oldNum = this.modifiedFromOriginal.get(id);
            }
            this.modifiedFromOriginal.put(id, num);
        }
        try {
            this.transforms.add((FeatureStoreTransform)new UpdateFeatureTypeTransform(this.store, oldType, type));
        }
        catch (DataException e) {
            throw new RuntimeException();
        }
        return oldNum;
    }

    public void restore(String id) {
        this.deleted.remove(id);
        ++this.deltaSize;
    }

    public void restore(String id, int num) {
        if (this.added.containsKey(id)) {
            this.added.put(id, num);
        } else {
            this.modifiedFromOriginal.put(id, num);
        }
    }

    public boolean isDeleted(FeatureType type) {
        return this.deleted.contains(type.getId());
    }

    public boolean isDeleted(String id) {
        return this.deleted.contains(id);
    }

    public void clear() {
        this.added.clear();
        this.modifiedFromOriginal.clear();
        this.expansionAdapter.close();
        this.deleted.clear();
        this.deltaSize = 0;
    }

    public boolean hasChanges() {
        return this.added.size() > 0 || this.modifiedFromOriginal.size() > 0 || this.deleted.size() > 0;
    }

    public Iterator newsIterator() {
        return this.added.values().iterator();
    }

    public boolean hasNews() {
        return !this.added.isEmpty();
    }

    public long getDeltaSize() {
        return this.deltaSize;
    }

    public FeatureType getOriginalFeatureType() {
        return this.originalType;
    }

    public DefaultFeatureStoreTransforms getTransforms() {
        return this.transforms;
    }

    public List<FeatureType.FeatureTypeChanged> getFeatureTypesChanged() throws DataException {
        ArrayList<FeatureType.FeatureTypeChanged> list = new ArrayList<FeatureType.FeatureTypeChanged>();
        if (this.modifiedFromOriginal.size() > 0) {
            FeatureType src = this.getOriginalFeatureType();
            list.add(new FeatureTypesChangedItem(src, this.store.getFeatureType(src.getId())));
        }
        return list;
    }

    public class FeatureTypesChangedItem
    implements FeatureType.FeatureTypeChanged {
        private final FeatureType source;
        private final FeatureType target;

        public FeatureTypesChangedItem(FeatureType source, FeatureType target) {
            this.source = source;
            this.target = target;
        }

        public FeatureType getSource() {
            return this.source;
        }

        public FeatureType getTarget() {
            return this.target;
        }
    }

    public class FeatureTypeManagerFeatureStoreTransforms
    extends DefaultFeatureStoreTransforms {
        private FeatureTypeManagerFeatureStoreTransforms() {
        }

        @Override
        protected void checkEditingMode() {
        }

        @Override
        protected void notifyChangeToStore() {
        }

        public PersistentState getState() throws PersistenceException {
            throw new UnsupportedOperationException();
        }

        public void loadState(PersistentState state) throws PersistenceException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void loadFromState(PersistentState state) throws PersistenceException {
            throw new UnsupportedOperationException();
        }

        @Override
        public FeatureStoreTransform add(FeatureStoreTransform transform) throws DataException {
            if (!(transform instanceof UpdateFeatureTypeTransform)) {
                throw new IllegalArgumentException();
            }
            return super.add(transform);
        }
    }

    private class UpdateFeatureTypeTransform
    extends AbstractFeatureStoreTransform {
        private final FeatureType ftSource;
        private EditableFeatureType ftTarget_editable;
        private final FeatureType ftTarget_non_editable;
        private WeakReference wkRefStore;
        private List ftypes = null;
        private List attrInSourceToUse;

        UpdateFeatureTypeTransform(FeatureStore featureStore, FeatureType ftSource, FeatureType ftTarget) {
            this.ftSource = ftSource;
            if (ftTarget instanceof EditableFeatureType) {
                this.ftTarget_editable = (EditableFeatureType)ftTarget;
                this.ftTarget_non_editable = this.ftTarget_editable.getNotEditableCopy();
            } else {
                this.ftTarget_non_editable = ftTarget;
            }
            this.wkRefStore = new WeakReference<FeatureStore>(featureStore);
            this.initializeAttributesToUse();
        }

        private void initializeAttributesToUse() {
            this.attrInSourceToUse = new ArrayList();
            Iterator iter = this.ftTarget_editable != null ? this.ftTarget_editable.iterator() : this.ftTarget_non_editable.iterator();
            while (iter.hasNext()) {
                EditableFeatureAttributeDescriptor ead;
                FeatureAttributeDescriptor tAttr = (FeatureAttributeDescriptor)iter.next();
                FeatureAttributeDescriptor sAttr = this.ftSource.getAttributeDescriptor(tAttr.getName());
                if (sAttr == null && (!(tAttr instanceof EditableFeatureAttributeDescriptor) || (ead = (EditableFeatureAttributeDescriptor)tAttr).getOriginalName() == null || (sAttr = this.ftSource.getAttributeDescriptor(ead.getOriginalName())) == null) || tAttr.getType() != sAttr.getType()) continue;
                this.attrInSourceToUse.add(sAttr.getName());
            }
        }

        public void setUp() throws Exception {
        }

        public void applyTransform(Feature source, EditableFeature target) throws DataException {
            for (FeatureAttributeDescriptor tAttr : target.getType()) {
                FeatureAttributeDescriptor srcAtt;
                String s_name;
                String t_name;
                if (tAttr.isComputed()) continue;
                if (this.ftTarget_editable != null) {
                    s_name = t_name = tAttr.getName();
                    FeatureAttributeDescriptor tAttr_edi = this.ftTarget_editable.getAttributeDescriptor(t_name);
                    if (tAttr_edi instanceof EditableFeatureAttributeDescriptor) {
                        EditableFeatureAttributeDescriptor eatd = (EditableFeatureAttributeDescriptor)tAttr_edi;
                        s_name = eatd.getOriginalName();
                    }
                    if (s_name == null) {
                        s_name = tAttr.getName();
                    }
                } else {
                    s_name = t_name = tAttr.getName();
                }
                if ((srcAtt = source.getType().getAttributeDescriptor(s_name)) != null) {
                    try {
                        target.set(t_name, source.get(s_name));
                    }
                    catch (Throwable th) {
                        target.set(t_name, tAttr.getDefaultValue());
                    }
                    continue;
                }
                target.set(t_name, tAttr.getDefaultValue());
            }
        }

        public FeatureType getDefaultFeatureType() throws DataException {
            return this.ftTarget_non_editable;
        }

        public FeatureStore getFeatureStore() {
            return (FeatureStore)this.wkRefStore.get();
        }

        public List getFeatureTypes() throws DataException {
            if (this.ftypes == null) {
                this.ftypes = Arrays.asList(this.ftTarget_non_editable);
            }
            return this.ftypes;
        }

        public FeatureType getSourceFeatureTypeFrom(FeatureType targetFeatureType) {
            EditableFeatureType orgType = this.ftSource.getEditable();
            Iterator iter = orgType.iterator();
            while (iter.hasNext()) {
                FeatureAttributeDescriptor attr = (FeatureAttributeDescriptor)iter.next();
                if (this.attrInSourceToUse.contains(attr.getName())) continue;
                if (attr instanceof EditableFeatureAttributeDescriptor) {
                    EditableFeatureAttributeDescriptor efad = (EditableFeatureAttributeDescriptor)attr;
                    if (efad.getOriginalName() == null || this.attrInSourceToUse.contains(efad.getOriginalName())) continue;
                    iter.remove();
                    continue;
                }
                iter.remove();
            }
            return orgType.getNotEditableCopy();
        }

        public void setFeatureStore(FeatureStore featureStore) {
            this.wkRefStore = new WeakReference<FeatureStore>(featureStore);
        }

        public boolean isTransformsOriginalValues() {
            return false;
        }
    }
}

