/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.feature.impl.featurereference;

import java.lang.ref.WeakReference;
import java.util.Base64;
import java.util.Objects;
import javax.json.JsonObject;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureReference;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.feature.impl.DefaultFeatureStore;
import org.gvsig.fmap.dal.feature.spi.FeatureReferenceProviderServices;
import org.gvsig.json.Json;
import org.gvsig.json.JsonObjectBuilder;
import org.gvsig.tools.persistence.Persistent;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;

public class FeatureReferenceOID
implements FeatureReferenceProviderServices,
Persistent {
    public static final String OID_TYPE = "oid";
    private Object oid;
    private WeakReference storeRef;
    private String featureTypeId;

    FeatureReferenceOID(FeatureStore store, Object oid) {
        this.oid = oid;
        this.storeRef = new WeakReference<FeatureStore>(store);
        this.featureTypeId = store.getDefaultFeatureTypeQuietly().getId();
    }

    FeatureReferenceOID(FeatureStore store, JsonObject code) {
        this(store, Json.toObject((JsonObject)code, (String)OID_TYPE));
    }

    public FeatureReferenceOID() {
    }

    public Object getOID() {
        return this.oid;
    }

    public String[] getKeyNames() {
        return null;
    }

    public Object getKeyValue(String name) {
        return null;
    }

    public String getFeatureTypeId() {
        return this.featureTypeId;
    }

    public Feature getFeature() throws DataException {
        return this.getStore().getFeatureByReference((FeatureReference)this);
    }

    public Feature getFeatureQuietly() {
        try {
            return this.getFeature();
        }
        catch (Exception e) {
            return null;
        }
    }

    public Feature getFeature(FeatureType featureType) throws DataException {
        return this.getStore().getFeatureByReference((FeatureReference)this, featureType);
    }

    private DefaultFeatureStore getStore() {
        return (DefaultFeatureStore)((Object)this.storeRef.get());
    }

    public boolean isNewFeature() {
        return false;
    }

    public String getCode() {
        String s = this.toJsonBuilder().toString();
        String r = Base64.getEncoder().encodeToString(s.getBytes());
        return r;
    }

    public void saveToState(PersistentState state) throws PersistenceException {
        state.set("type", OID_TYPE);
        state.set(OID_TYPE, this.oid);
        state.set("store", (Persistent)this.storeRef.get());
        state.set("featureTypeId", this.featureTypeId);
        state.set("isNewFeature", this.isNewFeature());
    }

    public void loadFromState(PersistentState state) throws PersistenceException {
        this.oid = state.get(OID_TYPE);
        this.storeRef = new WeakReference<Object>(state.get("store"));
        this.featureTypeId = state.getString("featureTypeId");
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof FeatureReferenceOID)) {
            return false;
        }
        FeatureReferenceOID other = (FeatureReferenceOID)obj;
        FeatureStore otherStore = (FeatureStore)other.storeRef.get();
        FeatureStore myrStore = (FeatureStore)this.storeRef.get();
        if (otherStore == null || myrStore == null) {
            return false;
        }
        if (!myrStore.equals(otherStore)) {
            return false;
        }
        if (this.oid == other.oid) {
            return true;
        }
        if (this.oid != null) {
            if (this.oid instanceof Number && other.oid instanceof Number) {
                return ((Number)this.oid).longValue() == ((Number)other.oid).longValue();
            }
            return this.oid.equals(other.oid);
        }
        return false;
    }

    public int hashCode() {
        if (this.oid != null) {
            return this.oid.hashCode();
        }
        return -1;
    }

    public JsonObjectBuilder toJsonBuilder() {
        JsonObjectBuilder builder = Json.createObjectBuilder();
        builder.add("type", OID_TYPE);
        builder.add(OID_TYPE, this.oid);
        return builder;
    }

    public String toString() {
        return Objects.toString(this.oid);
    }
}

