/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.feature.impl.featureset;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.impl.DefaultFeature;
import org.gvsig.fmap.dal.feature.impl.featureset.DefaultFeatureSet;
import org.gvsig.fmap.dal.feature.spi.FeatureProvider;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposableIterator;
import org.gvsig.tools.dispose.DisposeUtils;
import org.gvsig.tools.dispose.impl.AbstractDisposable;
import org.gvsig.tools.exception.BaseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DefaultIterator
extends AbstractDisposable
implements DisposableIterator {
    protected static final Logger LOGGER = LoggerFactory.getLogger(DefaultIterator.class);
    protected Iterator<FeatureProvider> iterator;
    protected DefaultFeatureSet fset;
    protected Feature lastFeature = null;

    public DefaultIterator(DefaultFeatureSet featureSet) {
        this.fset = featureSet;
        DisposeUtils.bind((Disposable)this.fset);
    }

    public DefaultIterator(DefaultFeatureSet featureSet, long index, long elements) throws DataException {
        this.fset = featureSet;
        DisposeUtils.bind((Disposable)this.fset);
        if (index > 0L) {
            if (featureSet.provider.canIterateFromIndex()) {
                try {
                    this.iterator = featureSet.provider.iterator(index, elements);
                }
                catch (UnsupportedOperationException e) {
                    this.iterator = featureSet.provider.iterator();
                    this.skypto(index);
                }
            } else {
                this.iterator = featureSet.provider.iterator();
                this.skypto(index);
            }
        } else {
            this.iterator = featureSet.provider.iterator();
        }
    }

    protected void skypto(long index) {
        for (long n = 0L; n <= index && this.getIterator().hasNext(); ++n) {
            this.getIterator().next();
        }
    }

    public boolean hasNext() {
        if (this.fset == null) {
            return false;
        }
        this.fset.checkSourceStoreModified();
        if (this.getIterator().hasNext()) {
            return true;
        }
        try {
            this.dispose();
        }
        catch (Exception ex) {
            throw new RuntimeException("Can't dispose iterator.", ex);
        }
        return false;
    }

    public Object next() {
        if (this.fset == null) {
            throw new NoSuchElementException();
        }
        this.fset.checkSourceStoreModified();
        this.lastFeature = null;
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        try {
            Object x = this.getIterator().next();
            this.lastFeature = x instanceof Feature ? (Feature)x : this.createFeature((FeatureProvider)x);
            return this.lastFeature;
        }
        catch (DataException e) {
            throw new RuntimeException(e);
        }
    }

    public void remove() {
        if (!this.fset.store.isEditing()) {
            throw new UnsupportedOperationException();
        }
        if (this.lastFeature == null) {
            throw new IllegalStateException();
        }
        try {
            this.fset.delete(this.lastFeature);
        }
        catch (DataException e) {
            throw new RuntimeException(e);
        }
        this.lastFeature = null;
    }

    protected DefaultFeature createFeature(FeatureProvider fData) throws DataException {
        fData.setNew(false);
        if (this.fset.transform.isEmpty()) {
            return new DefaultFeature(this.fset.store, fData);
        }
        return (DefaultFeature)this.fset.transform.applyTransform(new DefaultFeature(this.fset.store, fData), this.fset.getDefaultFeatureType());
    }

    protected Iterator getIterator() {
        return this.iterator;
    }

    protected void doNext() throws DataException {
    }

    protected void doDispose() throws BaseException {
        DisposeUtils.disposeQuietly(this.iterator);
        this.iterator = null;
        DisposeUtils.disposeQuietly((Disposable)this.fset);
        this.fset = null;
        this.lastFeature = null;
    }
}

