/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.feature.impl.featureset;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.EditableFeature;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureReference;
import org.gvsig.fmap.dal.feature.exception.ConcurrentDataModificationException;
import org.gvsig.fmap.dal.feature.impl.DefaultFeature;
import org.gvsig.fmap.dal.feature.impl.DefaultFeatureStore;
import org.gvsig.fmap.dal.feature.impl.editing.memory.FeatureManager;
import org.gvsig.fmap.dal.feature.impl.featurereference.FeatureReferenceFactory;
import org.gvsig.fmap.dal.feature.impl.featureset.DefaultFeatureSet;
import org.gvsig.fmap.dal.feature.impl.featureset.FilteredIterator;
import org.gvsig.fmap.dal.feature.spi.FeatureProvider;
import org.gvsig.fmap.dal.feature.spi.FeatureSetProvider;
import org.gvsig.tools.dispose.DisposableIterator;
import org.gvsig.tools.dispose.DisposeUtils;
import org.gvsig.tools.exception.BaseException;
import org.gvsig.tools.util.ChainedIterator;

public class EditedIterator
extends FilteredIterator {
    private DefaultFeatureStore store;
    protected FeatureManager featureManager;
    private Set<FeatureReference> visitedReferences;
    private int deletedCount;
    private long elements;
    private long servedFeaturesCount;

    public EditedIterator(DefaultFeatureSet featureSet) {
        super(featureSet);
        this.store = featureSet.store;
        this.featureManager = this.store.getFeatureManager();
        this.visitedReferences = new HashSet<FeatureReference>();
        this.servedFeaturesCount = 0L;
        this.elements = 0L;
    }

    public EditedIterator(DefaultFeatureSet featureSet, long index, long elements) throws DataException {
        this(featureSet);
        boolean canDelegateInProvider;
        this.elements = elements;
        Iterator<EditableFeature> insertedFeatures = this.featureManager.getInsertedFeatures();
        Iterator<EditableFeature> updatedFeatures = this.featureManager.getUpdatedFeatures();
        FeatureSetProvider provider = featureSet.provider;
        this.deletedCount = this.featureManager.getDeletedCount();
        boolean bl = canDelegateInProvider = provider.canFilter() && provider.canIterateFromIndex();
        DisposableIterator providerIterator = canDelegateInProvider ? (elements > 0L ? provider.iterator(index, elements + (long)this.deletedCount) : provider.iterator(index, elements)) : provider.iterator();
        DisposableIterator<FeatureProvider> wrappedProviderIterator = new DisposableIterator<FeatureProvider>((Iterator)providerIterator){
            final /* synthetic */ Iterator val$providerIterator;
            {
                this.val$providerIterator = iterator;
            }

            public boolean hasNext() {
                return this.val$providerIterator.hasNext();
            }

            public FeatureProvider next() {
                DefaultFeature modified;
                FeatureProvider data = (FeatureProvider)this.val$providerIterator.next();
                FeatureReference ref = FeatureReferenceFactory.createFromFeatureProvider(EditedIterator.this.store, data);
                try {
                    modified = EditedIterator.this.featureManager.get(ref, EditedIterator.this.store);
                }
                catch (DataException ex) {
                    return data;
                }
                if (modified != null) {
                    EditedIterator.this.visitedReferences.add(ref);
                    return modified.getData();
                }
                return data;
            }

            public void remove() {
                EditedIterator.super.remove();
            }

            public void dispose() {
                DisposeUtils.disposeQuietly((Object)this.val$providerIterator);
            }
        };
        this.iterator = new ChainedIterator(new Iterator[]{wrappedProviderIterator, insertedFeatures, updatedFeatures});
        if (!canDelegateInProvider) {
            if (index > 0L) {
                this.skypto(index);
            }
        } else if (!wrappedProviderIterator.hasNext()) {
            long n = index - provider.getSize();
            this.skypto(n);
        }
    }

    @Override
    public void remove() {
        this.iterator.remove();
    }

    @Override
    public boolean hasNext() {
        if (this.store.isEditing()) {
            return super.hasNext();
        }
        throw new ConcurrentDataModificationException(this.store.getFullName());
    }

    @Override
    public Object next() {
        if (this.store.isEditing()) {
            Feature n = (Feature)super.next();
            this.visitedReferences.add(n.getReference());
            return n;
        }
        throw new ConcurrentDataModificationException(this.store.getFullName());
    }

    protected ChainedIterator getIterator() {
        return (ChainedIterator)this.iterator;
    }

    @Override
    protected DefaultFeature createFeature(FeatureProvider data) throws DataException {
        DefaultFeature f = this.featureManager.get(data);
        if (f == null) {
            f = new DefaultFeature(this.store, data);
        }
        if (this.fset.transform.isEmpty()) {
            return f;
        }
        return (DefaultFeature)this.fset.transform.applyTransform(f, this.fset.getDefaultFeatureType());
    }

    @Override
    protected void doNext() throws DataException {
        this.nextChecked = true;
        while (this.getIterator().hasNext()) {
            DefaultFeature feature;
            Object obj = this.getIterator().next();
            if (obj == null) continue;
            if (obj instanceof FeatureProvider) {
                FeatureProvider data = (FeatureProvider)obj;
                feature = this.createFeature(data);
            } else {
                feature = (DefaultFeature)obj;
            }
            if (!this.matchButNotSkip(feature)) continue;
            this.current = feature;
            return;
        }
        this.current = null;
    }

    private boolean matchButNotSkip(DefaultFeature feature) throws DataException {
        if (this.deletedCount > 0 && this.elements > 0L && this.servedFeaturesCount >= this.elements) {
            return false;
        }
        try {
            switch (this.getIterator().getCurrent()) {
                case 0: {
                    if (!this.featureManager.isDeleted(feature.getData())) break;
                    return false;
                }
                case 1: {
                    break;
                }
                case 2: {
                    FeatureReference ref = FeatureReferenceFactory.createFromFeatureProvider(this.store, feature.getData());
                    if (!this.visitedReferences.contains(ref)) break;
                    return false;
                }
            }
        }
        catch (Exception ex) {
            LOGGER.warn("Can't check if must skip feature.", (Throwable)ex);
        }
        if (!this.match(feature)) {
            return false;
        }
        ++this.servedFeaturesCount;
        return true;
    }

    @Override
    protected void doDispose() throws BaseException {
        super.doDispose();
        this.featureManager = null;
        this.store = null;
    }
}

