/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.feature.impl.featureset;

import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.impl.DefaultFeature;
import org.gvsig.fmap.dal.feature.impl.featureset.DefaultFeatureSet;
import org.gvsig.fmap.dal.feature.impl.featureset.DefaultIterator;
import org.gvsig.fmap.dal.feature.spi.FeatureProvider;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposeUtils;
import org.gvsig.tools.exception.BaseException;

public class FastDefaultIterator
extends DefaultIterator {
    DefaultFeature myFeature;

    public FastDefaultIterator(DefaultFeatureSet featureSet, long index, long elements) throws DataException {
        super(featureSet);
        try {
            this.initializeFeature();
            if (index > 0L || elements > 0L) {
                if (featureSet.provider.canIterateFromIndex()) {
                    try {
                        this.iterator = featureSet.provider.fastIterator(index, elements);
                    }
                    catch (UnsupportedOperationException e) {
                        this.iterator = featureSet.provider.fastIterator();
                        this.skypto(index);
                    }
                } else {
                    this.iterator = featureSet.provider.fastIterator();
                    this.skypto(index);
                }
            } else {
                this.iterator = featureSet.provider.fastIterator();
            }
        }
        catch (Throwable t) {
            DisposeUtils.dispose((Disposable)this.fset);
            DisposeUtils.dispose((Disposable)this);
            throw t;
        }
    }

    @Override
    protected DefaultFeature createFeature(FeatureProvider fData) throws DataException {
        fData.setNew(false);
        this.myFeature.setData(fData);
        if (this.fset.transform.isEmpty()) {
            return this.myFeature;
        }
        return (DefaultFeature)this.fset.transform.applyTransform(this.myFeature, this.fset.getDefaultFeatureType());
    }

    protected void initializeFeature() {
        this.myFeature = new DefaultFeature(this.fset.store);
    }

    @Override
    public void remove() {
        super.remove();
        this.initializeFeature();
    }

    @Override
    protected void doDispose() throws BaseException {
        super.doDispose();
        this.myFeature = null;
    }
}

