/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.feature.impl.featureset;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.gvsig.compat.CompatLocator;
import org.gvsig.fmap.dal.exception.DataEvaluatorRuntimeException;
import org.gvsig.fmap.dal.feature.FeatureQueryOrder;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.feature.impl.DefaultFeature;
import org.gvsig.fmap.dal.feature.impl.DefaultFeatureStore;
import org.gvsig.fmap.dal.feature.spi.FeatureProvider;
import org.gvsig.tools.evaluator.Evaluator;
import org.gvsig.tools.evaluator.EvaluatorData;
import org.gvsig.tools.evaluator.EvaluatorException;

public class FeatureProviderComparator
implements Comparator {
    private FeatureQueryOrder order;
    private DefaultFeature feat1;
    private DefaultFeature feat2;
    private DefaultFeatureStore store;
    private List<OrderElement> elements = null;

    public FeatureProviderComparator(DefaultFeatureStore store, FeatureQueryOrder order) {
        this.order = order;
        this.store = store;
        this.feat1 = new DefaultFeature(this.store);
        this.feat2 = new DefaultFeature(this.store);
    }

    private void initElements(FeatureType type) {
        this.elements = new ArrayList<OrderElement>();
        for (FeatureQueryOrder.FeatureQueryOrderMember orderMember : this.order) {
            OrderElement cur;
            int index = type.getIndex(orderMember.getAttributeName());
            if (index >= 0) {
                cur = new OrderElement();
                cur.order = orderMember;
                cur.fieldIndex = index;
                this.elements.add(cur);
                continue;
            }
            if (!orderMember.hasEvaluator()) continue;
            cur = new OrderElement();
            cur.order = orderMember;
            cur.fieldIndex = index;
            this.elements.add(cur);
        }
    }

    public int compare(Object arg0, Object arg1) {
        DefaultFeature f2;
        DefaultFeature f1;
        if (arg0 instanceof DefaultFeature) {
            f1 = (DefaultFeature)arg0;
        } else {
            f1 = this.feat1;
            f1.setData((FeatureProvider)arg0);
        }
        if (arg1 instanceof DefaultFeature) {
            f2 = (DefaultFeature)arg1;
        } else {
            f2 = this.feat2;
            f2.setData((FeatureProvider)arg1);
        }
        if (this.elements == null) {
            this.initElements(f1.getType());
        }
        for (OrderElement element : this.elements) {
            int v;
            Object o2;
            Object o1;
            if (element.order.hasEvaluator()) {
                Evaluator evaluator = element.order.getEvaluator();
                try {
                    o1 = evaluator.evaluate((EvaluatorData)f1);
                    o2 = evaluator.evaluate((EvaluatorData)f2);
                }
                catch (EvaluatorException e) {
                    throw new DataEvaluatorRuntimeException((Throwable)e);
                }
            } else {
                o1 = f1.get(element.fieldIndex);
                o2 = f2.get(element.fieldIndex);
            }
            if (o1 == null) {
                if (o2 == null) {
                    return 0;
                }
                v = 1;
            } else if (o1 instanceof String && o2 instanceof String) {
                v = CompatLocator.getStringUtils().compare((String)o1, (String)o2, true);
            } else if (o1 instanceof Comparable && o2 instanceof Comparable) {
                Comparable v1 = (Comparable)o1;
                Comparable v2 = (Comparable)o2;
                v = v1.compareTo(v2);
            } else {
                v = -1;
            }
            if (v == 0) continue;
            if (element.order.getAscending()) {
                return v;
            }
            return -v;
        }
        return 0;
    }

    private class OrderElement {
        FeatureQueryOrder.FeatureQueryOrderMember order = null;
        int fieldIndex = -1;

        private OrderElement() {
        }
    }
}

