/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.feature.impl.indexes.geometry;

import java.util.Iterator;
import java.util.List;
import org.apache.commons.collections4.IteratorUtils;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.exception.FeatureIndexException;
import org.gvsig.fmap.dal.feature.spi.FeatureReferenceProviderServices;
import org.gvsig.fmap.dal.feature.spi.index.AbstractFeatureIndexProvider;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.SpatialIndex;
import org.gvsig.fmap.geom.primitive.Envelope;

public class GeometryIndexProvider
extends AbstractFeatureIndexProvider {
    private SpatialIndex index = null;

    public void initialize() {
    }

    protected Envelope getEnvelope(Object value) {
        Envelope env = null;
        if (value instanceof Envelope) {
            env = (Envelope)value;
        } else if (value instanceof Geometry) {
            env = ((Geometry)value).getEnvelope();
        }
        return env;
    }

    public void insert(Object value, FeatureReferenceProviderServices fref) {
        this.index.insert(this.getEnvelope(value), (Object)fref);
    }

    public void delete(Object value, FeatureReferenceProviderServices fref) {
        this.index.remove(this.getEnvelope(value), (Object)fref);
    }

    public List match(Object value) throws FeatureIndexException {
        return this.index.queryAsList(this.getEnvelope(value));
    }

    public List nearest(int count, Object value) {
        if (!this.index.getFactory().isNearestQuerySupported()) {
            throw new UnsupportedOperationException();
        }
        if (value == null) {
            throw new IllegalArgumentException("value is null");
        }
        Iterator x = this.index.queryNearest(this.getEnvelope(value), (long)count);
        return IteratorUtils.toList((Iterator)x);
    }

    public boolean isMatchSupported() {
        return true;
    }

    public boolean isNearestSupported() {
        return this.index.getFactory().isNearestQuerySupported();
    }

    public boolean isNearestToleranceSupported() {
        return false;
    }

    public boolean isRangeSupported() {
        return false;
    }

    public List nearest(int count, Object value, Object tolerance) throws FeatureIndexException {
        throw new UnsupportedOperationException();
    }

    public List range(Object value1, Object value2) throws FeatureIndexException {
        throw new UnsupportedOperationException();
    }

    public void clear() throws DataException {
        this.index.removeAll();
    }
}

