/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.feature.impl.indexes.memoryspatial;

import java.util.List;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.exception.FeatureIndexException;
import org.gvsig.fmap.dal.feature.spi.FeatureReferenceProviderServices;
import org.gvsig.fmap.dal.feature.spi.index.AbstractFeatureIndexProvider;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.SpatialIndex;
import org.gvsig.fmap.geom.primitive.Envelope;

public class MemorySpatialIndexProvider
extends AbstractFeatureIndexProvider {
    private SpatialIndex index = null;

    public void initialize() {
        try {
            this.index = GeometryLocator.getGeometryManager().createDefaultMemorySpatialIndex();
        }
        catch (Exception e) {
            throw new RuntimeException();
        }
    }

    public void delete(Object o, FeatureReferenceProviderServices fref) {
        Geometry geom = (Geometry)o;
        this.index.remove(geom, fref.getOID());
    }

    public void insert(Object o, FeatureReferenceProviderServices fref) {
        if (o == null) {
            return;
        }
        Geometry geom = (Geometry)o;
        this.index.insert(geom, fref.getOID());
    }

    public List match(Object value) throws FeatureIndexException {
        Envelope env = null;
        if (value instanceof Envelope) {
            env = (Envelope)value;
        } else if (value instanceof Geometry) {
            env = ((Geometry)value).getEnvelope();
        }
        return new AbstractFeatureIndexProvider.LongList((AbstractFeatureIndexProvider)this, this.index.queryAsList(env));
    }

    public List match(Object min, Object max) {
        throw new UnsupportedOperationException("Can't perform this kind of search.");
    }

    public List nearest(int count, Object value) throws FeatureIndexException {
        throw new UnsupportedOperationException("Can't perform this kind of search.");
    }

    public boolean isMatchSupported() {
        return true;
    }

    public boolean isNearestSupported() {
        return false;
    }

    public boolean isNearestToleranceSupported() {
        return false;
    }

    public boolean isRangeSupported() {
        return false;
    }

    public List nearest(int count, Object value, Object tolerance) throws FeatureIndexException {
        throw new UnsupportedOperationException();
    }

    public List range(Object value1, Object value2) throws FeatureIndexException {
        throw new UnsupportedOperationException();
    }

    public void clear() throws DataException {
        this.index.removeAll();
    }
}

