/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.feature.impl.undo;

import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.EditableFeature;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureReference;
import org.gvsig.fmap.dal.feature.FeatureSelection;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.feature.impl.DefaultFeatureReferenceSelection;
import org.gvsig.fmap.dal.feature.impl.DefaultFeatureStore;
import org.gvsig.fmap.dal.feature.impl.editing.memory.FeatureManager;
import org.gvsig.fmap.dal.feature.impl.editing.memory.FeatureTypeManager;
import org.gvsig.fmap.dal.feature.impl.editing.memory.SpatialManager;
import org.gvsig.fmap.dal.feature.impl.undo.FeatureCommandsStack;
import org.gvsig.fmap.dal.feature.impl.undo.command.FTypeUpdateCommand;
import org.gvsig.fmap.dal.feature.impl.undo.command.FeatureDeleteCommand;
import org.gvsig.fmap.dal.feature.impl.undo.command.FeatureInsertCommand;
import org.gvsig.fmap.dal.feature.impl.undo.command.FeatureUpdateCommand;
import org.gvsig.fmap.dal.feature.impl.undo.command.SelectionCommandReverse;
import org.gvsig.fmap.dal.feature.impl.undo.command.SelectionCommandSelect;
import org.gvsig.fmap.dal.feature.impl.undo.command.SelectionCommandSelectAll;
import org.gvsig.fmap.dal.feature.impl.undo.command.SelectionCommandSet;
import org.gvsig.tools.undo.command.Command;
import org.gvsig.tools.undo.command.impl.DefaultUndoRedoCommandStack;

public class DefaultFeatureCommandsStack
extends DefaultUndoRedoCommandStack
implements FeatureCommandsStack {
    private FeatureManager expansionManager;
    private SpatialManager spatialManager;
    private FeatureTypeManager featureTypeManager;
    private DefaultFeatureStore featureStore;

    public DefaultFeatureCommandsStack(DefaultFeatureStore featureStore, FeatureManager expansionManager, SpatialManager spatialManager, FeatureTypeManager featureTypeManager) {
        this.featureStore = featureStore;
        this.expansionManager = expansionManager;
        this.spatialManager = spatialManager;
        this.featureTypeManager = featureTypeManager;
    }

    public void clear() {
        super.clear();
        this.expansionManager.clear();
        this.featureTypeManager.clear();
        this.spatialManager.clear();
    }

    @Override
    public void deselect(DefaultFeatureReferenceSelection selection, FeatureReference reference) {
        SelectionCommandSelect command = new SelectionCommandSelect(selection, reference, false, "_selectionDeselect");
        this.add((Command)command);
    }

    @Override
    public void deselectAll(DefaultFeatureReferenceSelection selection) throws DataException {
        if (this.isSameLastCommand("_selectionDeselectAll")) {
            return;
        }
        SelectionCommandSelectAll command = new SelectionCommandSelectAll(selection, false, "_selectionDeselectAll");
        this.add((Command)command);
    }

    private boolean isSameLastCommand(String description) {
        Command lastCommand;
        return this.getUndoInfos().size() > 0 && (lastCommand = this.getNextUndoCommand()).getDescription().equals(description);
    }

    @Override
    public void select(DefaultFeatureReferenceSelection selection, FeatureReference reference) {
        SelectionCommandSelect command = new SelectionCommandSelect(selection, reference, true, "_selectionSelect");
        this.add((Command)command);
    }

    @Override
    public void selectAll(DefaultFeatureReferenceSelection selection) throws DataException {
        if (this.isSameLastCommand("_selectionSelectAll")) {
            return;
        }
        SelectionCommandSelectAll command = new SelectionCommandSelectAll(selection, true, "_selectionSelectAll");
        this.add((Command)command);
    }

    @Override
    public void selectionReverse(DefaultFeatureReferenceSelection selection) {
        SelectionCommandReverse command = new SelectionCommandReverse(selection, "_selectionReverse");
        this.add((Command)command);
    }

    @Override
    public void selectionSet(DefaultFeatureStore store, FeatureSelection oldSelection, FeatureSelection newSelection) {
        SelectionCommandSet command = new SelectionCommandSet(store, oldSelection, newSelection, "_selectionSet");
        this.add((Command)command);
    }

    @Override
    public void delete(Feature feature) throws DataException {
        FeatureDeleteCommand command = new FeatureDeleteCommand(this.featureStore, feature, "_featureDelete");
        this.add((Command)command);
        command.execute();
    }

    @Override
    public void insert(EditableFeature feature) throws DataException {
        FeatureInsertCommand command = new FeatureInsertCommand(this.featureStore, feature, "_featureInsert");
        this.add((Command)command);
        command.execute();
    }

    @Override
    public void update(EditableFeature feature, Feature oldFeature) throws DataException {
        FeatureUpdateCommand command = new FeatureUpdateCommand(this.featureStore, feature, oldFeature, "_featureUpdate");
        this.add((Command)command);
        command.execute();
    }

    @Override
    public void update(FeatureType featureType, FeatureType oldFeatureType) {
        FTypeUpdateCommand command = new FTypeUpdateCommand(this.featureTypeManager, featureType, oldFeatureType, "_typeUpdate");
        this.add((Command)command);
        command.execute();
    }
}

