/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.impl;

import org.apache.commons.lang3.reflect.ConstructorUtils;
import org.gvsig.fmap.dal.DataServerExplorer;
import org.gvsig.fmap.dal.DataServerExplorerParameters;
import org.gvsig.fmap.dal.exception.InitializeException;
import org.gvsig.fmap.dal.spi.AbstractDataServerExplorerFactory;
import org.gvsig.fmap.dal.spi.DataServerExplorerProviderServices;
import org.gvsig.tools.dynobject.DynObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataServerExplorerToDataExplorerFactoryWrapper
extends AbstractDataServerExplorerFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataServerExplorerToDataExplorerFactoryWrapper.class);
    private final Class explorerClass;
    private final Class parametersClass;

    public DataServerExplorerToDataExplorerFactoryWrapper(String name, String description, Class explorerClass, Class parametersClass) {
        super(name, description);
        this.explorerClass = explorerClass;
        this.parametersClass = parametersClass;
        LOGGER.warn("Creating wrapper for old style DataServerExplorer (" + explorerClass.getName() + ").");
    }

    public DataServerExplorer create(DataServerExplorerParameters parameters, DataServerExplorerProviderServices providerServices) throws InitializeException {
        try {
            DataServerExplorer explorer = (DataServerExplorer)ConstructorUtils.invokeConstructor((Class)this.explorerClass, (Object[])new Object[]{parameters, providerServices});
            return explorer;
        }
        catch (Exception ex) {
            throw new InitializeException((Throwable)ex);
        }
    }

    public DynObject createParameters() {
        try {
            return (DynObject)this.parametersClass.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isStoreSupported(String name) {
        return false;
    }
}

