/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.impl;

import java.lang.reflect.Constructor;
import org.gvsig.fmap.dal.DataFactoryUnit;
import org.gvsig.fmap.dal.DataParameters;
import org.gvsig.fmap.dal.DataStoreProvider;
import org.gvsig.fmap.dal.ExternalStoreProviderFactory;
import org.gvsig.fmap.dal.exception.InitializeException;
import org.gvsig.fmap.dal.spi.AbstractDataStoreProviderFactory;
import org.gvsig.fmap.dal.spi.DataStoreProviderServices;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.service.spi.Services;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataStoreProviderToCoverageProviderFactoryWrapper
extends AbstractDataStoreProviderFactory
implements ExternalStoreProviderFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataStoreProviderToCoverageProviderFactoryWrapper.class);
    private Class providerClass = null;
    private Class parametersClass = null;

    public DataStoreProviderToCoverageProviderFactoryWrapper(String name, String description, Class provider, Class parametersClass) {
        super(name, description);
        this.providerClass = provider;
        this.parametersClass = parametersClass;
        LOGGER.warn("Creating wrapper for old style CoverageProvider (" + this.providerClass.getName() + ").");
    }

    public DataFactoryUnit create(DynObject parameters, Services providerServices) {
        try {
            return this.createProvider((DataParameters)parameters, (DataStoreProviderServices)providerServices);
        }
        catch (InitializeException ex) {
            throw new RuntimeException(ex);
        }
    }

    public DataStoreProvider createProvider(DataParameters parameters, DataStoreProviderServices providerServices) throws InitializeException {
        try {
            Class[] argsTypes = new Class[]{DataParameters.class, DataStoreProviderServices.class};
            Object[] args = new Object[]{parameters, providerServices};
            Constructor contructor = this.findConstructor(this.providerClass, argsTypes);
            return (DataStoreProvider)contructor.newInstance(args);
        }
        catch (Throwable e) {
            throw new InitializeException(e);
        }
    }

    public final DynObject createParameters() {
        try {
            return (DynObject)this.parametersClass.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected Constructor findConstructor(Class clazz, Class[] types) throws SecurityException, NoSuchMethodException {
        try {
            return clazz.getConstructor(types);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            Constructor<?>[] constrs;
            for (Constructor<?> constr : constrs = clazz.getConstructors()) {
                Class<?>[] paramTypes = constr.getParameterTypes();
                if (paramTypes.length != types.length) continue;
                boolean allMatch = true;
                for (int j = 0; j < paramTypes.length; ++j) {
                    if (this.isParameterCompatible(types[j], paramTypes[j])) continue;
                    allMatch = false;
                    break;
                }
                if (!allMatch) continue;
                return constr;
            }
            StringBuilder strb = new StringBuilder();
            strb.append(clazz.getName());
            strb.append('(');
            if (types.length > 0) {
                for (int i = 0; i < types.length - 1; ++i) {
                    strb.append(types[i].getName());
                    strb.append(',');
                }
                strb.append(types[types.length - 1].getName());
            }
            strb.append(')');
            throw new NoSuchMethodException(strb.toString());
        }
    }

    private boolean isParameterCompatible(Class current, Class defined) {
        if (current == null) {
            return !defined.isPrimitive();
        }
        return current.isAssignableFrom(defined);
    }
}

