/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.impl;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections4.map.LRUMap;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.expressionevaluator.ExpressionBuilder;
import org.gvsig.expressionevaluator.ExpressionEvaluatorLocator;
import org.gvsig.expressionevaluator.ExpressionUtils;
import org.gvsig.expressionevaluator.SymbolTable;
import org.gvsig.expressionevaluator.spi.AbstractSymbolTable;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.DataServerExplorer;
import org.gvsig.fmap.dal.DataServerExplorerParameters;
import org.gvsig.fmap.dal.DataStore;
import org.gvsig.fmap.dal.DataStoreParameters;
import org.gvsig.fmap.dal.DataTransaction;
import org.gvsig.fmap.dal.DatabaseWorkspaceManager;
import org.gvsig.fmap.dal.NewDataStoreParameters;
import org.gvsig.fmap.dal.StoresRepository;
import org.gvsig.fmap.dal.SupportTransactionsHelper;
import org.gvsig.fmap.dal.feature.EditableFeature;
import org.gvsig.fmap.dal.feature.EditableFeatureType;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.NewFeatureStoreParameters;
import org.gvsig.fmap.dal.feature.spi.LocalTransaction;
import org.gvsig.fmap.dal.impl.DatabaseWorkspaceStoresRepository;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposeUtils;
import org.gvsig.tools.dynobject.DynClass;
import org.gvsig.tools.dynobject.DynField;
import org.gvsig.tools.resourcesstorage.FilesResourcesStorage;
import org.gvsig.tools.resourcesstorage.ResourcesStorage;
import org.gvsig.tools.util.Bitmask;
import org.gvsig.tools.util.CachedValue;
import org.gvsig.tools.util.FileTools;
import org.gvsig.tools.util.HasAFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultDatabaseWorkspaceManager
extends AbstractSymbolTable
implements DatabaseWorkspaceManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultDatabaseWorkspaceManager.class);
    private static final String CONFIG_NAME_BASEFOLDER = "BASEFOLDER";
    private static final String CONFIG_NAME_ALTERNATIVE_RESOURCES_PATH = "ALTERNATIVE_RESOURCES_PATH";
    private SupportTransactionsHelper transactionsHelper;
    private final DataServerExplorerParameters serverParameters;
    private Boolean existsConfiguration = null;
    private StoresRepository storesRepository;
    private CachedConfigValue alternativeResourcesFolder = null;
    private CachedValue<File> baseFolder;
    private Map<String, CachedConfigValue> cachedConfigValues;

    public DefaultDatabaseWorkspaceManager(DataServerExplorerParameters serverParameters) {
        this.serverParameters = serverParameters;
        this.transactionsHelper = new SupportTransactionsHelper();
        this.baseFolder = new CachedValue(){

            protected void reload() {
                String s = DefaultDatabaseWorkspaceManager.this.getConfigValue(DefaultDatabaseWorkspaceManager.CONFIG_NAME_BASEFOLDER);
                if (StringUtils.isBlank((CharSequence)s)) {
                    this.setValue(null);
                } else {
                    s = ExpressionUtils.evaluateDynamicText((SymbolTable)DefaultDatabaseWorkspaceManager.this, (String)s);
                    this.setValue(new File(s));
                }
            }
        };
        this.baseFolder.setExpireTime(20000L);
        this.alternativeResourcesFolder = new CachedConfigValue(CONFIG_NAME_ALTERNATIVE_RESOURCES_PATH, null, 30000L);
        this.cachedConfigValues = new LRUMap(20, 20);
        ExpressionEvaluatorLocator.getExpressionEvaluatorManager().populateSymbolTable((SymbolTable)this);
    }

    public String toString() {
        return this.getLabel();
    }

    public String getId() {
        String id = this.get("StoresRepository.id");
        return id;
    }

    public String getLabel() {
        String label = this.get("StoresRepository.label");
        if (StringUtils.isBlank((CharSequence)label)) {
            return this.getId();
        }
        return label;
    }

    public DatabaseWorkspaceManager getValue() {
        return this;
    }

    public boolean existsTable(int tableid) {
        switch (tableid) {
            case 0: {
                return this.existsTable("GVSIGD_RESOURCES");
            }
            case 1: {
                return this.existsTable("GVSIGD_REPOSITORY");
            }
            case 2: {
                return this.existsTable("GVSIGD_CONFIG");
            }
        }
        throw new IllegalArgumentException("Invalid table identitier " + tableid);
    }

    public void createTable(int tableid) {
        switch (tableid) {
            case 0: {
                this.createTableResources();
                break;
            }
            case 1: {
                this.createTableRepository();
                break;
            }
            case 2: {
                this.createTableConfiguration();
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid table identitier " + tableid);
            }
        }
    }

    public void dropTable(int tableid) {
        switch (tableid) {
            case 0: {
                this.dropTable("GVSIGD_RESOURCES");
                break;
            }
            case 1: {
                this.dropTable("GVSIGD_REPOSITORY");
                break;
            }
            case 2: {
                this.dropTable("GVSIGD_CONFIG");
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid table identitier " + tableid);
            }
        }
    }

    public FeatureStore getTable(int tableid) {
        switch (tableid) {
            case 0: {
                return this.getTable("GVSIGD_RESOURCES");
            }
            case 1: {
                return this.getTable("GVSIGD_REPOSITORY");
            }
            case 2: {
                return this.getTable("GVSIGD_CONFIG");
            }
        }
        throw new IllegalArgumentException("Invalid table identitier " + tableid);
    }

    public DataServerExplorer getServerExplorer() {
        DataManager dataManager = DALLocator.getDataManager();
        DataServerExplorer server = null;
        LocalTransaction trans = new LocalTransaction(dataManager, new DataTransaction[]{this.getTransaction()});
        try {
            trans.begin();
            trans.add((Object)this);
            server = dataManager.openServerExplorer(this.serverParameters.getProviderName(), this.serverParameters);
            trans.add(server);
            trans.commit();
            DataServerExplorer dataServerExplorer = server;
            return dataServerExplorer;
        }
        catch (Exception ex) {
            trans.abortQuietly();
            throw new RuntimeException("Can't get server explorer for workspace '" + Objects.toString(this.serverParameters) + "'", ex);
        }
        finally {
            trans.closeQuietly();
        }
    }

    public DataServerExplorerParameters getServerExplorerParameters() {
        return this.serverParameters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean existsTable(String tableName) {
        boolean bl;
        LocalTransaction trans;
        DataServerExplorer server;
        block9: {
            server = null;
            trans = new LocalTransaction(null, new DataTransaction[]{this.getTransaction()});
            try {
                trans.begin();
                trans.add((Object)this);
                server = this.getServerExplorer();
                trans.add(server);
                List list = server.list();
                if (list != null) {
                    for (DataStoreParameters params : server.list()) {
                        String theTableName = (String)params.getDynValue("Table");
                        if (!StringUtils.equals((CharSequence)theTableName, (CharSequence)tableName)) continue;
                        trans.commit();
                        bl = true;
                        break block9;
                    }
                }
                trans.commit();
            }
            catch (Exception ex) {
                try {
                    LOGGER.warn("Can't check if the table '" + tableName + "' exists.", (Throwable)ex);
                    trans.abortQuietly();
                }
                catch (Throwable throwable) {
                    trans.closeQuietly();
                    DisposeUtils.disposeQuietly(server);
                    throw throwable;
                }
                trans.closeQuietly();
                DisposeUtils.disposeQuietly((Disposable)server);
            }
            trans.closeQuietly();
            DisposeUtils.disposeQuietly((Disposable)server);
            if (StringUtils.equals((CharSequence)tableName, (CharSequence)"GVSIGD_CONFIG")) {
                return this.existsLocalWorkspaceConfiguration();
            }
            if (StringUtils.equals((CharSequence)tableName, (CharSequence)"GVSIGD_REPOSITORY")) {
                return this.existsLocalWorkspaceRepository();
            }
            return false;
        }
        trans.closeQuietly();
        DisposeUtils.disposeQuietly((Disposable)server);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FeatureStore getTable(String tableName) {
        LocalTransaction trans;
        DataServerExplorer server;
        block6: {
            server = null;
            trans = new LocalTransaction(null, new DataTransaction[]{this.getTransaction()});
            trans.begin();
            trans.add((Object)this);
            DataManager dataManager = DALLocator.getDataManager();
            server = this.getServerExplorer();
            trans.add(server);
            DataStoreParameters params = server.get(tableName);
            if (params == null) break block6;
            FeatureStore store = (FeatureStore)dataManager.openStore(this.getTransaction(), params.getProviderName(), params, true);
            trans.commit();
            FeatureStore featureStore = store;
            trans.closeQuietly();
            DisposeUtils.disposeQuietly((Disposable)server);
            return featureStore;
        }
        try {
            trans.commit();
        }
        catch (Exception ex) {
            block7: {
                FeatureStore featureStore;
                try {
                    FeatureStore store;
                    if (!StringUtils.equals((CharSequence)tableName, (CharSequence)"GVSIGD_CONFIG") || (store = this.openLocalWorkspaceConfiguration()) == null) break block7;
                    featureStore = store;
                }
                catch (Throwable throwable) {
                    trans.closeQuietly();
                    DisposeUtils.disposeQuietly(server);
                    throw throwable;
                }
                trans.closeQuietly();
                DisposeUtils.disposeQuietly((Disposable)server);
                return featureStore;
            }
            LOGGER.warn("Can't open table '" + tableName + "'.", (Throwable)ex);
            trans.abortQuietly();
            trans.closeQuietly();
            DisposeUtils.disposeQuietly((Disposable)server);
        }
        trans.closeQuietly();
        DisposeUtils.disposeQuietly((Disposable)server);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dropTable(String tableName) {
        DataServerExplorer server = null;
        LocalTransaction trans = new LocalTransaction(null, new DataTransaction[]{this.getTransaction()});
        try {
            trans.begin();
            trans.add((Object)this);
            server = this.getServerExplorer();
            trans.add(server);
            DataStoreParameters params = server.get(tableName);
            if (params != null) {
                server.remove(params);
            }
            trans.commit();
        }
        catch (Exception ex) {
            try {
                LOGGER.warn("Can't drop table '" + tableName + "'.", (Throwable)ex);
                trans.abortQuietly();
            }
            catch (Throwable throwable) {
                trans.closeQuietly();
                DisposeUtils.disposeQuietly(server);
                throw throwable;
            }
            trans.closeQuietly();
            DisposeUtils.disposeQuietly((Disposable)server);
        }
        trans.closeQuietly();
        DisposeUtils.disposeQuietly((Disposable)server);
    }

    public void createTableResources(String tableName) throws RuntimeException {
        DataServerExplorer server = null;
        LocalTransaction trans = new LocalTransaction(null, new DataTransaction[]{this.getTransaction()});
        try {
            trans.begin();
            trans.add((Object)this);
            server = this.getServerExplorer();
            trans.add(server);
            NewFeatureStoreParameters params = (NewFeatureStoreParameters)server.getAddParameters(tableName);
            EditableFeatureType ft = params.getDefaultFeatureType();
            ft.add("name", 8, 150).setAllowNull(false).setIsPrimaryKey(true);
            ft.add("resource", 12).setAllowNull(true);
            server.add(tableName, (NewDataStoreParameters)params, false);
            trans.commit();
        }
        catch (Exception ex) {
            try {
                LOGGER.debug("Can't create resources table '" + tableName + "'.", (Throwable)ex);
                trans.abortQuietly();
                throw new RuntimeException("Can't create resources table '" + tableName + "'.", ex);
            }
            catch (Throwable throwable) {
                trans.closeQuietly();
                DisposeUtils.disposeQuietly(server);
                throw throwable;
            }
        }
        trans.closeQuietly();
        DisposeUtils.disposeQuietly((Disposable)server);
    }

    private void createTableResources() {
        this.createTableResources("GVSIGD_RESOURCES");
    }

    public void createTableRepository(String tableName) throws RuntimeException {
        DataServerExplorer server = null;
        LocalTransaction trans = new LocalTransaction(null, new DataTransaction[]{this.getTransaction()});
        try {
            trans.begin();
            trans.add((Object)this);
            server = this.getServerExplorer();
            trans.add(server);
            NewFeatureStoreParameters params = (NewFeatureStoreParameters)server.getAddParameters(tableName);
            EditableFeatureType ft = params.getDefaultFeatureType();
            ft.add("name", 8, 150).setAllowNull(false).setIsPrimaryKey(true);
            ft.add("parameters", 12).setAllowNull(true);
            ft.add("flags", 4).setAllowNull(false).setDefaultValue((Object)0);
            ft.add("extra", 8).setSize(4096).setAllowNull(true);
            server.add(tableName, (NewDataStoreParameters)params, false);
            trans.commit();
        }
        catch (Exception ex) {
            try {
                LOGGER.debug("Can't create repository table '" + tableName + "'.", (Throwable)ex);
                trans.abortQuietly();
                throw new RuntimeException("Can't create repository table '" + tableName + "'.", ex);
            }
            catch (Throwable throwable) {
                trans.closeQuietly();
                DisposeUtils.disposeQuietly(server);
                throw throwable;
            }
        }
        trans.closeQuietly();
        DisposeUtils.disposeQuietly((Disposable)server);
    }

    private void createTableRepository() {
        this.createTableRepository("GVSIGD_REPOSITORY");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createTableConfiguration() {
        String tableName = "GVSIGD_CONFIG";
        DataServerExplorer server = null;
        FeatureStore store = null;
        LocalTransaction trans = new LocalTransaction(null, new DataTransaction[]{this.getTransaction()});
        try {
            trans.begin();
            trans.add((Object)this);
            server = this.getServerExplorer();
            trans.add(server);
            NewFeatureStoreParameters params = (NewFeatureStoreParameters)server.getAddParameters(tableName);
            EditableFeatureType ft = params.getDefaultFeatureType();
            ft.add("name", 8, 200).setAllowNull(false).setIsPrimaryKey(true);
            ft.add("value", 8, 10240).setAllowNull(true);
            server.add(tableName, (NewDataStoreParameters)params, false);
            DataStoreParameters openParams = server.get("GVSIGD_CONFIG");
            store = (FeatureStore)DALLocator.getDataManager().openStore(this.getTransaction(), openParams.getProviderName(), openParams);
            store.edit();
            EditableFeature efeature = store.createNewFeature();
            efeature.set("name", (Object)CONFIG_NAME_ALTERNATIVE_RESOURCES_PATH);
            efeature.set("value", null);
            store.insert(efeature);
            store.finishEditing();
            this.existsConfiguration = null;
            trans.commit();
        }
        catch (Exception ex) {
            try {
                LOGGER.warn("Can't create table '" + tableName + "'.", (Throwable)ex);
                trans.abortQuietly();
            }
            catch (Throwable throwable) {
                trans.closeQuietly();
                DisposeUtils.disposeQuietly(server);
                DisposeUtils.disposeQuietly(store);
                throw throwable;
            }
            trans.closeQuietly();
            DisposeUtils.disposeQuietly((Disposable)server);
            DisposeUtils.disposeQuietly(store);
        }
        trans.closeQuietly();
        DisposeUtils.disposeQuietly((Disposable)server);
        DisposeUtils.disposeQuietly((Disposable)store);
    }

    private boolean existsConfiguration() {
        if (this.existsConfiguration == null) {
            this.existsConfiguration = this.existsTable("GVSIGD_CONFIG");
        }
        return this.existsConfiguration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String get(String name) {
        LocalTransaction trans = new LocalTransaction(null, new DataTransaction[]{this.getTransaction()});
        try {
            trans.begin();
            trans.add((Object)this);
            if (!this.existsConfiguration()) {
                trans.commit();
                String string = null;
                return string;
            }
            if (StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)CONFIG_NAME_BASEFOLDER)) {
                String s = Objects.toString(this.baseFolder.get(), null);
                trans.commit();
                String string = s;
                return string;
            }
            if (StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)CONFIG_NAME_ALTERNATIVE_RESOURCES_PATH)) {
                String s = Objects.toString(this.alternativeResourcesFolder.get(), null);
                trans.commit();
                String string = s;
                return string;
            }
            CachedConfigValue cachedValue = this.cachedConfigValues.get(name);
            if (cachedValue != null) {
                String s = (String)cachedValue.get();
                trans.commit();
                String string = s;
                return string;
            }
            String value = this.getConfigValue(name);
            this.cachedConfigValues.put(name, new CachedConfigValue(name, value, 15000L));
            value = ExpressionUtils.evaluateDynamicText((SymbolTable)this, (String)value);
            trans.commit();
            String string = value;
            return string;
        }
        catch (Exception ex) {
            LOGGER.warn("Can't read configuration value '" + name + "'", (Throwable)ex);
            trans.abortQuietly();
            String string = null;
            return string;
        }
        finally {
            trans.closeQuietly();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getConfigValue(String name) {
        String string;
        Feature feature;
        LocalTransaction trans;
        FeatureStore store;
        block9: {
            block8: {
                block7: {
                    store = null;
                    trans = new LocalTransaction(null, new DataTransaction[]{this.getTransaction()});
                    trans.begin();
                    trans.add((Object)this);
                    if (this.existsConfiguration()) break block7;
                    trans.commit();
                    String string2 = null;
                    trans.closeQuietly();
                    DisposeUtils.disposeQuietly((Disposable)store);
                    return string2;
                }
                store = this.getTable(2);
                if (store != null) break block8;
                trans.commit();
                String string3 = null;
                trans.closeQuietly();
                DisposeUtils.disposeQuietly((Disposable)store);
                return string3;
            }
            trans.add((DataStore)store);
            ExpressionBuilder builder = ExpressionUtils.createExpressionBuilder();
            String filter = builder.eq((ExpressionBuilder.Value)builder.column("name"), (ExpressionBuilder.Value)builder.constant((Object)name)).toString();
            feature = store.findFirst(filter);
            if (feature != null) break block9;
            trans.commit();
            String string4 = null;
            trans.closeQuietly();
            DisposeUtils.disposeQuietly((Disposable)store);
            return string4;
        }
        try {
            String value = feature.getString("value");
            trans.commit();
            string = value;
        }
        catch (Exception ex) {
            String string5;
            try {
                LOGGER.warn("Can't read configuration value '" + name + "'", (Throwable)ex);
                trans.abortQuietly();
                string5 = null;
            }
            catch (Throwable throwable) {
                trans.closeQuietly();
                DisposeUtils.disposeQuietly(store);
                throw throwable;
            }
            trans.closeQuietly();
            DisposeUtils.disposeQuietly((Disposable)store);
            return string5;
        }
        trans.closeQuietly();
        DisposeUtils.disposeQuietly((Disposable)store);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean set(String name, String value) {
        boolean bl;
        LocalTransaction trans;
        FeatureStore store;
        block12: {
            block11: {
                store = null;
                trans = new LocalTransaction(null, new DataTransaction[]{this.getTransaction()});
                trans.begin();
                trans.add((Object)this);
                if (this.existsConfiguration()) break block11;
                trans.commit();
                boolean bl2 = false;
                trans.closeQuietly();
                DisposeUtils.disposeQuietly((Disposable)store);
                return bl2;
            }
            store = this.getTable(2);
            if (store != null) break block12;
            trans.commit();
            boolean bl3 = false;
            trans.closeQuietly();
            DisposeUtils.disposeQuietly((Disposable)store);
            return bl3;
        }
        try {
            trans.add((DataStore)store);
            store.edit();
            ExpressionBuilder builder = ExpressionUtils.createExpressionBuilder();
            String filter = builder.eq((ExpressionBuilder.Value)builder.column("name"), (ExpressionBuilder.Value)builder.constant((Object)name)).toString();
            Feature feature = store.findFirst(filter);
            if (feature == null) {
                EditableFeature efeature = store.createNewFeature();
                efeature.set("name", (Object)name);
                efeature.set("value", (Object)value);
                store.insert(efeature);
            } else {
                EditableFeature efeature = feature.getEditable();
                efeature.set("value", (Object)value);
                store.update(efeature);
            }
            store.finishEditing();
            if (StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)CONFIG_NAME_ALTERNATIVE_RESOURCES_PATH)) {
                this.alternativeResourcesFolder.expired();
            } else if (this.cachedConfigValues.containsKey(name)) {
                value = ExpressionUtils.evaluateDynamicText((SymbolTable)this, (String)value);
                this.cachedConfigValues.get(name).set(value);
            }
            trans.commit();
            bl = true;
        }
        catch (Exception ex) {
            boolean bl4;
            try {
                LOGGER.warn("Can't write configuration value '" + name + "'", (Throwable)ex);
                trans.abortQuietly();
                bl4 = false;
            }
            catch (Throwable throwable) {
                trans.closeQuietly();
                DisposeUtils.disposeQuietly(store);
                throw throwable;
            }
            trans.closeQuietly();
            DisposeUtils.disposeQuietly((Disposable)store);
            return bl4;
        }
        trans.closeQuietly();
        DisposeUtils.disposeQuietly((Disposable)store);
        return bl;
    }

    public StoresRepository getStoresRepository() {
        if (this.storesRepository == null) {
            String id = this.get("StoresRepository.id");
            String label = this.get("StoresRepository.label");
            this.storesRepository = new DatabaseWorkspaceStoresRepository(id, label, this);
        }
        return this.storesRepository;
    }

    public boolean contains(DataStoreParameters parameters) {
        boolean c = this.getStoresRepository().contains(parameters);
        return c;
    }

    public boolean canAnonymousUserWriteInTheTables() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public File getBaseFolder() {
        return (File)this.baseFolder.get();
    }

    public void setBaseFolder(File baseFolder) {
        this.baseFolder.set((Object)baseFolder);
        this.set(CONFIG_NAME_BASEFOLDER, baseFolder.toString());
    }

    public File getWorkspaceFile() {
        if (this.serverParameters instanceof HasAFile) {
            return ((HasAFile)this.serverParameters).getFile();
        }
        return null;
    }

    private DataStoreParameters replaceInFilesToUseBaseFolder(DataStoreParameters parameters) {
        DynClass dynClass = parameters.getDynClass();
        if (dynClass == null) {
            return parameters;
        }
        File theBaseFolder = this.getBaseFolder();
        File wsfile = this.getWorkspaceFile();
        if (theBaseFolder == null && wsfile == null) {
            return parameters;
        }
        DataStoreParameters replaced = parameters;
        block3: for (DynField dynField : dynClass.getDynFields()) {
            switch (dynField.getType()) {
                case 13: 
                case 14: {
                    File frel;
                    File f = (File)parameters.getDynValue(dynField.getName());
                    File newf = null;
                    if (f == null) continue block3;
                    if (wsfile != null && wsfile.equals(f)) {
                        ExpressionBuilder builder = ExpressionUtils.createExpressionBuilder();
                        newf = ExpressionUtils.createDynamicFile((ExpressionBuilder.Value)builder.ifnull((ExpressionBuilder.Value)builder.variable("WORKSPACEFILE"), (ExpressionBuilder.Value)builder.constant((Object)f.toString()), (ExpressionBuilder.Value)builder.variable("WORKSPACEFILE")));
                    }
                    if (newf == null && (frel = FileTools.relativizeFile((File)theBaseFolder, (File)f)) != f) {
                        ExpressionBuilder builder = ExpressionUtils.createExpressionBuilder();
                        newf = ExpressionUtils.createDynamicFile((ExpressionBuilder.Value)builder.concat(new ExpressionBuilder.Value[]{builder.variable(CONFIG_NAME_BASEFOLDER), builder.constant((Object)"/"), builder.variable(frel.getPath())}));
                    }
                    if (newf == null) continue block3;
                    if (replaced == parameters) {
                        replaced = (DataStoreParameters)replaced.getCopy();
                    }
                    replaced.setDynValue(dynField.getName(), newf);
                }
            }
        }
        return replaced;
    }

    public boolean writeStoresRepositoryEntry(String name, DataStoreParameters parameters) {
        return this.writeStoresRepositoryEntry(name, parameters, Bitmask.createBitmask((int)0).setBit(0).setBit(1).setBit(2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean writeStoresRepositoryEntry(String name, DataStoreParameters parameters, Bitmask flags) {
        boolean bl;
        FeatureStore store = null;
        LocalTransaction trans = new LocalTransaction(null, new DataTransaction[]{this.getTransaction()});
        try {
            trans.begin();
            trans.add((Object)this);
            parameters = this.replaceInFilesToUseBaseFolder(parameters);
            byte[] data = parameters.toByteArray();
            if (data == null) {
                throw new RuntimeException("Can't convert parameters to byte array.");
            }
            store = this.getTable(1);
            trans.add((DataStore)store);
            store.edit();
            ExpressionBuilder builder = ExpressionUtils.createExpressionBuilder();
            String filter = builder.eq((ExpressionBuilder.Value)builder.column("name"), (ExpressionBuilder.Value)builder.constant((Object)name)).toString();
            Feature feature = store.findFirst(filter);
            if (feature == null) {
                EditableFeature efeature = store.createNewFeature();
                efeature.set("name", (Object)name);
                efeature.set("parameters", (Object)data);
                efeature.set("flags", (Object)flags.get());
                store.insert(efeature);
            } else {
                EditableFeature efeature = feature.getEditable();
                efeature.set("parameters", (Object)data);
                efeature.set("flags", (Object)flags.get());
                store.update(efeature);
            }
            store.finishEditing();
            this.storesRepository = null;
            trans.commit();
            bl = true;
        }
        catch (Exception ex) {
            boolean bl2;
            try {
                LOGGER.warn("Can't save entry '" + name + "' in repository information", (Throwable)ex);
                trans.abortQuietly();
                bl2 = false;
            }
            catch (Throwable throwable) {
                trans.closeQuietly();
                DisposeUtils.disposeQuietly(store);
                throw throwable;
            }
            trans.closeQuietly();
            DisposeUtils.disposeQuietly((Disposable)store);
            return bl2;
        }
        trans.closeQuietly();
        DisposeUtils.disposeQuietly((Disposable)store);
        return bl;
    }

    public boolean isValid() {
        try {
            String id = this.get("StoresRepository.id");
            return !StringUtils.isBlank((CharSequence)id);
        }
        catch (Exception ex) {
            return false;
        }
    }

    public boolean isValidStoresRepository() {
        if (!this.isValid()) {
            return false;
        }
        return this.existsTable("GVSIGD_REPOSITORY");
    }

    public ResourcesStorage getAlternativeResourcesStorage(String tableName) {
        String s = (String)this.alternativeResourcesFolder.get();
        if (StringUtils.isBlank((CharSequence)s)) {
            return null;
        }
        File folder = new File(s = ExpressionUtils.evaluateDynamicText((SymbolTable)this, (String)s));
        if (folder == null) {
            return null;
        }
        String resourcesRoot = folder.getAbsolutePath().replace("\\", "/") + "/" + tableName;
        FilesResourcesStorage resources = new FilesResourcesStorage(resourcesRoot);
        return resources;
    }

    public boolean hasAlternativeResourcesStorage() {
        String path = this.get(CONFIG_NAME_ALTERNATIVE_RESOURCES_PATH);
        return StringUtils.isNotBlank((CharSequence)path);
    }

    public void setAlternativeResourcesStorage(String resourcesPath) {
        this.set(CONFIG_NAME_ALTERNATIVE_RESOURCES_PATH, resourcesPath);
    }

    public void drop() {
        if (!this.existsTable(0)) {
            this.dropTable(0);
        }
        if (!this.existsTable(2)) {
            this.dropTable(2);
        }
        if (!this.existsTable(1)) {
            this.dropTable(1);
        }
    }

    public void create(String id, String description) {
        LocalTransaction trans = new LocalTransaction(null, new DataTransaction[]{this.getTransaction()});
        try {
            trans.begin();
            trans.add((Object)this);
            if (!this.existsTable(0)) {
                this.createTable(0);
            }
            if (!this.existsTable(2)) {
                this.createTable(2);
            }
            if (!this.existsTable(1)) {
                this.createTable(1);
            }
            this.set("StoresRepository.id", id);
            this.set("StoresRepository.label", description);
            this.set("CanAnonymousUserWriteInTheTables", "true");
            this.set(CONFIG_NAME_ALTERNATIVE_RESOURCES_PATH, "");
            File theBaseFolder = this.getBaseFolder();
            if (this.serverParameters instanceof HasAFile && theBaseFolder == null) {
                File f = ((HasAFile)this.serverParameters).getFile();
                if (f != null) {
                    theBaseFolder = f.getParentFile();
                    this.setBaseFolder(theBaseFolder);
                } else {
                    this.set(CONFIG_NAME_BASEFOLDER, "");
                }
            } else {
                this.set(CONFIG_NAME_BASEFOLDER, "");
            }
            trans.commit();
        }
        catch (RuntimeException ex) {
            trans.abortQuietly();
            throw ex;
        }
        catch (Exception ex) {
            trans.abortQuietly();
            throw new RuntimeException("Can't create table " + id, ex);
        }
        finally {
            trans.closeQuietly();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean exists(String name) {
        boolean bl;
        LocalTransaction trans;
        FeatureStore store;
        block15: {
            boolean wsfile22;
            block14: {
                store = null;
                trans = new LocalTransaction(null, new DataTransaction[]{this.getTransaction()});
                try {
                    File wsfile22;
                    trans.begin();
                    trans.add((Object)this);
                    if (StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)"WORKSPACEFILE") && (wsfile22 = this.getWorkspaceFile()) != null) {
                        trans.commit();
                        boolean bl2 = true;
                        return bl2;
                    }
                    if (this.existsConfiguration()) {
                        ExpressionBuilder builder;
                        String filter;
                        Feature feature;
                        if (StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)CONFIG_NAME_BASEFOLDER)) {
                            trans.commit();
                            boolean wsfile22 = true;
                            return wsfile22;
                        }
                        if (this.cachedConfigValues.containsKey(name)) {
                            trans.commit();
                            wsfile22 = true;
                            trans.closeQuietly();
                            break block14;
                        }
                        store = this.getTable(2);
                        trans.add((DataStore)store);
                        if (store != null && (feature = store.findFirst(filter = (builder = ExpressionUtils.createExpressionBuilder()).eq((ExpressionBuilder.Value)builder.column("name"), (ExpressionBuilder.Value)builder.constant((Object)name)).toString())) != null) {
                            String value = feature.getString("value");
                            value = ExpressionUtils.evaluateDynamicText((SymbolTable)this, (String)value);
                            this.cachedConfigValues.put(name, new CachedConfigValue(name, value, 15000L));
                            trans.commit();
                            bl = true;
                            trans.closeQuietly();
                            break block15;
                        }
                    }
                    boolean b = super.exists(name);
                    trans.commit();
                    boolean bl3 = b;
                    return bl3;
                }
                catch (Exception ex) {
                    LOGGER.warn("Can't read configuration value '" + name + "'", (Throwable)ex);
                    trans.abortQuietly();
                    boolean bl4 = false;
                    return bl4;
                }
            }
            DisposeUtils.disposeQuietly((Disposable)store);
            return wsfile22;
        }
        DisposeUtils.disposeQuietly((Disposable)store);
        return bl;
        finally {
            trans.closeQuietly();
            DisposeUtils.disposeQuietly(store);
        }
    }

    public Object value(String name) {
        File wsfile;
        if (StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)"WORKSPACEFILE") && (wsfile = this.getWorkspaceFile()) != null) {
            return wsfile.toString();
        }
        String v = this.get(name);
        if (v != null) {
            return v;
        }
        return super.value(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<String> localvariables() {
        ArrayList<String> arrayList;
        FeatureStore store = null;
        LocalTransaction trans = new LocalTransaction(null, new DataTransaction[]{this.getTransaction()});
        try {
            trans.begin();
            trans.add((Object)this);
            ArrayList<String> theVars = new ArrayList<String>();
            if (this.existsConfiguration() && (store = this.getTable(2)) != null) {
                store.accept(obj -> {
                    Feature feature = (Feature)obj;
                    theVars.add(feature.getString("name"));
                });
            }
            trans.commit();
            arrayList = theVars;
            trans.closeQuietly();
        }
        catch (Exception ex) {
            LOGGER.warn("Can't read configuration variables", (Throwable)ex);
            trans.abortQuietly();
            List list = Collections.EMPTY_LIST;
            return list;
        }
        finally {
            trans.closeQuietly();
            DisposeUtils.disposeQuietly(store);
        }
        DisposeUtils.disposeQuietly((Disposable)store);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResourcesStorage getResourcesStorage() {
        ResourcesStorage resourcesStorage;
        DataServerExplorer server = null;
        LocalTransaction trans = new LocalTransaction(null, new DataTransaction[]{this.getTransaction()});
        try {
            trans.begin();
            trans.add((Object)this);
            server = this.getServerExplorer();
            trans.add(server);
            ResourcesStorage resourcesStorage2 = server.getResourcesStorage();
            trans.commit();
            resourcesStorage = resourcesStorage2;
        }
        catch (Exception ex) {
            ResourcesStorage resourcesStorage3;
            try {
                trans.abortQuietly();
                LOGGER.warn("Can't get resorces storage.", (Throwable)ex);
                resourcesStorage3 = null;
            }
            catch (Throwable throwable) {
                trans.closeQuietly();
                DisposeUtils.disposeQuietly(server);
                throw throwable;
            }
            trans.closeQuietly();
            DisposeUtils.disposeQuietly((Disposable)server);
            return resourcesStorage3;
        }
        trans.closeQuietly();
        DisposeUtils.disposeQuietly((Disposable)server);
        return resourcesStorage;
    }

    public void fix() {
        if (!(this.serverParameters instanceof HasAFile)) {
            return;
        }
        HasAFile f = (HasAFile)this.serverParameters;
        if (f.getFile() == null) {
            return;
        }
        if (!this.isValid()) {
            return;
        }
        this.set(CONFIG_NAME_BASEFOLDER, f.getFile().getParent());
    }

    public void connect() {
        DataManager manager = DALLocator.getDataManager();
        this.fix();
        manager.addDatabaseWorkspace((DatabaseWorkspaceManager)this);
    }

    public void disconnect() {
        DataManager manager = DALLocator.getDataManager();
        manager.removeDatabaseWorkspace((DatabaseWorkspaceManager)this);
    }

    public boolean isConnected() {
        DataManager manager = DALLocator.getDataManager();
        DatabaseWorkspaceManager ws = manager.getDatabaseWorkspace(this.getId());
        if (ws == null) {
            return false;
        }
        return ws.getServerExplorerParameters().isTheSameServerExplorer(this.getServerExplorerParameters());
    }

    public String getLabelOrId() {
        String label = this.getLabel();
        if (StringUtils.isBlank((CharSequence)label)) {
            label = this.getId();
        }
        return label;
    }

    public void setTransaction(DataTransaction transaction) {
        this.transactionsHelper.setTransaction(transaction);
    }

    public DataTransaction getTransaction() {
        return this.transactionsHelper.getTransaction();
    }

    private FeatureStore openLocalWorkspaceConfiguration() {
        try {
            DataManager dataManager = DALLocator.getDataManager();
            File f = dataManager.getLocalResourcesFolder(this.getServerExplorerParameters());
            if (f == null) {
                return null;
            }
            if (!f.exists()) {
                f.mkdirs();
            }
            DataStoreParameters params = dataManager.createStoreParameters("CSV");
            ((HasAFile)params).setFile(new File(f, "config.csv"));
            FeatureStore store = (FeatureStore)dataManager.openStore("CSV", params);
            return store;
        }
        catch (Throwable ex) {
            LOGGER.debug("Can't open local workspace config file.", ex);
            return null;
        }
    }

    private boolean existsLocalWorkspaceConfiguration() {
        try {
            DataManager dataManager = DALLocator.getDataManager();
            File folder = dataManager.getLocalResourcesFolder(this.getServerExplorerParameters());
            if (folder == null) {
                return false;
            }
            if (!folder.exists()) {
                folder.mkdirs();
            }
            File f = new File(folder, "config.csv");
            return f.exists();
        }
        catch (Throwable ex) {
            LOGGER.debug("Can't check if exists local workspace config file.", ex);
            return false;
        }
    }

    private boolean existsLocalWorkspaceRepository() {
        try {
            DataManager dataManager = DALLocator.getDataManager();
            File folder = dataManager.getLocalResourcesFolder(this.getServerExplorerParameters());
            if (folder == null) {
                return false;
            }
            if (!folder.exists()) {
                folder.mkdirs();
            }
            File repoFolder = new File(folder, "repository");
            return repoFolder.exists();
        }
        catch (Throwable ex) {
            LOGGER.debug("Can't check if exists local workspace config file.", ex);
            return false;
        }
    }

    private class CachedConfigValue
    extends CachedValue<String> {
        private final String name;

        public CachedConfigValue(String name, String value) {
            this.setValue(value);
            this.name = name;
        }

        public CachedConfigValue(String name, String value, long expireTime) {
            this.name = name;
            this.setValue(value);
            this.setExpireTime(expireTime);
        }

        protected void reload() {
            String s = DefaultDatabaseWorkspaceManager.this.getConfigValue(this.name);
            if (StringUtils.isBlank((CharSequence)s)) {
                this.setValue(null);
            } else {
                this.setValue(s);
            }
        }

        public String toString() {
            return this.name + " = " + (String)this.getValue();
        }
    }
}

