/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.fmap.dal.DataServerExplorer;
import org.gvsig.fmap.dal.DataStore;
import org.gvsig.fmap.dal.DataTransaction;
import org.gvsig.fmap.dal.SupportTransactions;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.spi.DataTransactionServices;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposeUtils;
import org.gvsig.tools.dispose.impl.AbstractDisposable;
import org.gvsig.tools.observer.BaseNotification;
import org.gvsig.tools.observer.Observable;
import org.gvsig.tools.observer.ObservableHelper;
import org.gvsig.tools.observer.Observer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultTransaction
extends AbstractDisposable
implements DataTransactionServices {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultTransaction.class);
    private final String code = UUID.randomUUID().toString().replace("-", "");
    private final Map<String, DataServerExplorer> explorers;
    private final Map<String, DataTransactionServices.ConnectionService> connections;
    private Map<String, StoreInfo> stores = new HashMap<String, StoreInfo>();
    private boolean inProgress = false;
    private List<Disposable> disposables;
    private ObservableHelper observableHelper;
    private Set<SupportTransactions> supportTransactions;

    public DefaultTransaction() {
        this.explorers = new HashMap<String, DataServerExplorer>();
        this.disposables = new ArrayList<Disposable>();
        this.supportTransactions = new HashSet<SupportTransactions>();
        this.connections = new HashMap<String, DataTransactionServices.ConnectionService>();
        this.observableHelper = new ObservableHelper();
    }

    public String getCode() {
        return this.code;
    }

    public void begin() throws DataException {
        if (this.inProgress) {
            throw new IllegalStateException("Transaction already started.");
        }
        this.observableHelper.notifyObservers((Observable)this, (Object)new BaseNotification("BEGIN", null));
        this.inProgress = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() throws DataException {
        if (!this.isInProgress()) {
            throw new IllegalStateException("Can't commit transaction without begin.");
        }
        try {
            LOGGER.debug("commit in " + this.getCode());
            boolean needretry = false;
            for (int retries = 5; retries > 0; --retries) {
                needretry = false;
                ArrayList<StoreInfo> theStores = new ArrayList<StoreInfo>(this.stores.values());
                for (StoreInfo item : theStores) {
                    FeatureStore fstore;
                    DataStore store = this.getStore(item);
                    if (!(store instanceof FeatureStore) || (fstore = (FeatureStore)store) == null || fstore.getMode() == 0) continue;
                    LOGGER.debug("commit: finishEditing " + store.getFullName());
                    fstore.finishEditing();
                    needretry = true;
                }
                if (!needretry) break;
                LOGGER.debug("commit: retry store finish editing");
            }
            for (DataTransactionServices.ConnectionService connection : this.connections.values()) {
                connection.finish();
            }
            this.observableHelper.notifyObservers((Observable)this, (Object)new BaseNotification("COMMIT", null));
            this.inProgress = false;
        }
        finally {
            LOGGER.debug("commit out " + this.getCode());
        }
    }

    public void setKeepEditingMode(DataStore store, boolean keep) {
        for (StoreInfo item : this.stores.values()) {
            if (store != item.getStore()) continue;
            item.setKeepEditingMode(true);
        }
    }

    public void rollback() throws DataException {
        if (!this.isInProgress()) {
            throw new IllegalStateException("Can't rollback transaction without begin.");
        }
        for (StoreInfo item : this.stores.values()) {
            FeatureStore fstore;
            DataStore store;
            if (item.isKeepEditingMode() || !((store = this.getStore(item)) instanceof FeatureStore) || (fstore = (FeatureStore)store).getMode() == 0) continue;
            fstore.cancelEditing();
        }
        for (DataTransactionServices.ConnectionService connection : this.connections.values()) {
            connection.abort();
        }
        this.observableHelper.notifyObservers((Observable)this, (Object)new BaseNotification("ROLLBACK", null));
        this.inProgress = false;
    }

    public void rollbackQuietly() {
        try {
            this.rollback();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void add(DataStore store) {
        this.add(store, null, true);
    }

    public void add(DataStore store, String id) {
        this.add(store, id, true);
    }

    public void add(DataStore store, boolean local) {
        this.add(store, null, local);
    }

    public void add(DataStore store, String id, boolean local) {
        if (store == null) {
            throw new IllegalArgumentException("The store is required.");
        }
        String theId = id;
        if (StringUtils.isBlank((CharSequence)id)) {
            theId = store.hashCode() + "@" + store.getFullName();
        } else {
            DataStore theStore = this.getStore(this.stores.get(theId));
            if (theStore != null) {
                if (theStore == store) {
                    return;
                }
                throw new IllegalArgumentException("The id '" + id + "' is already used.");
            }
        }
        if (store instanceof SupportTransactions) {
            ((SupportTransactions)store).setTransaction((DataTransaction)this);
        }
        if (!local) {
            DisposeUtils.bind((Disposable)store);
        }
        StoreInfo storeInfo = new StoreInfo(store, local);
        this.stores.put(theId, storeInfo);
    }

    public FeatureStore getFeatureStore(String id) {
        FeatureStore store = (FeatureStore)this.getStore(this.stores.get(id));
        if (store == null) {
            for (StoreInfo value : this.stores.values()) {
                DataStore currentStore = this.getStore(value);
                if (!StringUtils.equalsIgnoreCase((CharSequence)id, (CharSequence)currentStore.getName())) continue;
                if (store != null && !StringUtils.equals((CharSequence)store.getFullName(), (CharSequence)currentStore.getFullName())) {
                    return null;
                }
                store = (FeatureStore)this.getStore(value);
            }
        }
        return store;
    }

    public void add(DataServerExplorer explorer) {
        this.add(explorer, null, true);
    }

    public void add(DataServerExplorer explorer, String id) {
        this.add(explorer, id, true);
    }

    public void add(DataServerExplorer explorer, boolean local) {
        this.add(explorer, null, local);
    }

    public void add(DataServerExplorer explorer, String id, boolean local) {
        if (explorer == null) {
            throw new IllegalArgumentException("The explorer is required.");
        }
        String theId = id;
        if (StringUtils.isBlank((CharSequence)id)) {
            theId = String.valueOf(explorer.hashCode());
        } else {
            DataServerExplorer theExplorer = this.explorers.get(theId);
            if (theExplorer != null) {
                if (theExplorer == explorer) {
                    return;
                }
                throw new IllegalArgumentException("The id '" + id + "' is already used.");
            }
        }
        if (explorer instanceof SupportTransactions) {
            ((SupportTransactions)explorer).setTransaction((DataTransaction)this);
        }
        if (!local) {
            DisposeUtils.bind((Disposable)explorer);
        }
        this.explorers.put(theId, explorer);
    }

    public DataServerExplorer getServerExplorer(String id) {
        return this.explorers.get(id);
    }

    public void add(Disposable resource) throws DataException {
        this.disposables.add(resource);
    }

    public void add(SupportTransactions obj, boolean local) throws DataException {
        if (obj == null) {
            throw new IllegalArgumentException("The transaction supplier is required.");
        }
        if (obj instanceof DataStore) {
            this.add((DataStore)obj, local);
            return;
        }
        if (obj instanceof DataServerExplorer) {
            this.add((DataServerExplorer)obj, local);
            return;
        }
        obj.setTransaction((DataTransaction)this);
        if (!local) {
            DisposeUtils.bind((Object)obj);
        }
        this.supportTransactions.add(obj);
    }

    public void remove(DataStore store) {
        if (this.inProgress && !DisposeUtils.isNullOrDisposed((Disposable)store)) {
            throw new IllegalStateException("Can't remove store from a in progress transaction.");
        }
        String id = null;
        for (Map.Entry<String, StoreInfo> entry : this.stores.entrySet()) {
            if (store != this.getStore(entry.getValue())) continue;
            id = entry.getKey();
            break;
        }
        if (id == null) {
            return;
        }
        if (store instanceof SupportTransactions) {
            ((SupportTransactions)store).setTransaction(null);
        }
        this.stores.remove(id);
        DisposeUtils.dispose((Disposable)store);
    }

    public void remove(DataServerExplorer serverExplorer) {
        if (this.inProgress) {
            throw new IllegalStateException("Can't remove server explorer from a in progress transaction.");
        }
        String id = null;
        for (Map.Entry<String, DataServerExplorer> entry : this.explorers.entrySet()) {
            if (serverExplorer != entry.getValue()) continue;
            id = entry.getKey();
            break;
        }
        if (id == null) {
            return;
        }
        if (serverExplorer instanceof SupportTransactions) {
            ((SupportTransactions)serverExplorer).setTransaction(null);
        }
        this.explorers.remove(id);
        DisposeUtils.dispose((Disposable)serverExplorer);
    }

    public boolean isInProgress() {
        return this.inProgress;
    }

    public void doDispose() {
        if (this.inProgress) {
            this.rollbackQuietly();
        }
        for (StoreInfo item : this.stores.values()) {
            DataStore store = this.getStore(item);
            if (store instanceof SupportTransactions) {
                ((SupportTransactions)store).setTransaction(null);
            }
            DisposeUtils.disposeQuietly((Disposable)store);
        }
        for (DataServerExplorer explorer : this.explorers.values()) {
            if (explorer instanceof SupportTransactions) {
                ((SupportTransactions)explorer).setTransaction(null);
            }
            DisposeUtils.disposeQuietly((Disposable)explorer);
        }
        for (Disposable resource : this.disposables) {
            if (resource instanceof SupportTransactions) {
                ((SupportTransactions)resource).setTransaction(null);
            }
            DisposeUtils.disposeQuietly((Disposable)resource);
        }
        for (SupportTransactions obj : this.supportTransactions) {
            obj.setTransaction(null);
            DisposeUtils.disposeQuietly((Object)obj);
        }
        for (DataTransactionServices.ConnectionService connection : this.connections.values()) {
            connection.dispose();
        }
        this.supportTransactions = null;
        this.disposables = null;
        this.stores = null;
    }

    public void close() throws Exception {
        this.dispose();
    }

    public void addConnection(DataTransactionServices.ConnectionService connection) {
        if (this.connections.containsKey(connection.getId())) {
            return;
        }
        this.connections.put(connection.getId(), connection);
    }

    public DataTransactionServices.ConnectionService getConnection(String id) {
        return this.connections.get(id);
    }

    public void removeConnection(String id) {
        this.connections.remove(id);
    }

    public boolean existsConnection(String id) {
        return this.connections.containsKey(id);
    }

    public void addObserver(Observer obsrvr) {
        this.observableHelper.addObserver(obsrvr);
    }

    public void deleteObserver(Observer obsrvr) {
        this.observableHelper.deleteObserver(obsrvr);
    }

    public void deleteObservers() {
        this.observableHelper.deleteObservers();
    }

    public boolean contains(DataServerExplorer explorer) {
        for (DataServerExplorer value : this.explorers.values()) {
            if (explorer != value) continue;
            return true;
        }
        return false;
    }

    public boolean contains(DataStore store) {
        for (StoreInfo item : this.stores.values()) {
            DataStore value = this.getStore(item);
            if (store != value) continue;
            return true;
        }
        return false;
    }

    private DataStore getStore(StoreInfo item) {
        if (item == null) {
            return null;
        }
        return item.getStore();
    }

    private static class StoreInfo {
        private final DataStore store;
        private final boolean local;
        private boolean keepEditingMode;
        private boolean hasPendingChangesAtAdd;

        StoreInfo(DataStore store, boolean local) {
            this.store = store;
            this.local = local;
            this.hasPendingChangesAtAdd = false;
            if (store instanceof FeatureStore) {
                this.hasPendingChangesAtAdd = ((FeatureStore)store).getPendingChangesCount() > 0L;
            }
        }

        private DataStore getStore() {
            return this.store;
        }

        public boolean isLocal() {
            return this.local;
        }

        private void setKeepEditingMode(boolean b) {
            this.keepEditingMode = b;
        }

        public boolean isKeepEditingMode() {
            return this.keepEditingMode;
        }
    }
}

