/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.impl;

import java.util.Iterator;
import java.util.List;
import org.gvsig.fmap.dal.DataFactory;
import org.gvsig.fmap.dal.DataFactoryUnit;
import org.gvsig.fmap.dal.DataParameters;
import org.gvsig.fmap.dal.Register;
import org.gvsig.fmap.dal.exception.InitializeException;
import org.gvsig.fmap.dal.exception.ProviderNotRegisteredException;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.extensionpoint.ExtensionPoint;
import org.gvsig.tools.extensionpoint.ExtensionSingleton;
import org.gvsig.tools.service.spi.Services;

public class RegisterImpl
implements Register {
    private final String name;
    private final String description;

    public RegisterImpl(String name, String description) {
        this.name = name;
        this.description = description;
        ToolsLocator.getExtensionPointManager().add(this.name, this.description);
    }

    private ExtensionPoint getFactories() {
        ExtensionPoint factories = ToolsLocator.getExtensionPointManager().get(this.name);
        return factories;
    }

    public void register(DataFactory factory) {
        ExtensionPoint factories = this.getFactories();
        factories.append(factory.getName(), factory.getDescription(), (ExtensionSingleton)factory);
    }

    public DataFactory getFactory(String name) {
        try {
            ExtensionPoint factories = this.getFactories();
            DataFactory factory = (DataFactory)factories.create(name);
            return factory;
        }
        catch (Exception ex) {
            return null;
        }
    }

    public DataFactoryUnit create(String name, DataParameters parameters, Services services) throws ProviderNotRegisteredException, InitializeException {
        DataFactory factory = this.getFactory(name);
        if (factory == null) {
            throw new ProviderNotRegisteredException(name);
        }
        DataFactoryUnit unit = factory.create((DynObject)parameters, services);
        return unit;
    }

    public boolean exits(String name) {
        ExtensionPoint factories = this.getFactories();
        return factories.has(name);
    }

    public List<String> getFactoryNames() {
        ExtensionPoint factories = this.getFactories();
        List names = factories.getNames();
        return names;
    }

    public Iterator<DataFactory> iterator() {
        ExtensionPoint factories = this.getFactories();
        return new FactoriesIterator(factories.iterator());
    }

    private class FactoriesIterator
    implements Iterator<DataFactory> {
        private final Iterator<ExtensionPoint.Extension> factories;

        public FactoriesIterator(Iterator<ExtensionPoint.Extension> factories) {
            this.factories = factories;
        }

        @Override
        public boolean hasNext() {
            return this.factories.hasNext();
        }

        @Override
        public DataFactory next() {
            try {
                ExtensionPoint.Extension x = this.factories.next();
                return (DataFactory)x.create();
            }
            catch (Exception ex) {
                throw new RuntimeException("Can't retrive next factory.", ex);
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }
}

