/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.raster.impl;

import org.gvsig.fmap.dal.raster.RasterKernel;
import org.gvsig.raster.lib.buffer.api.Buffer;

public class DefaultRasterKernel
implements RasterKernel {
    Buffer buffer;
    int row;
    int column;

    public DefaultRasterKernel(Buffer buffer) {
        this.buffer = buffer;
    }

    public void set(int row, int column) {
        this.row = row;
        this.column = column;
    }

    public int getBandCount() {
        return this.buffer.getBandCount();
    }

    public int getRow() {
        return this.row;
    }

    public int getColumn() {
        return this.column;
    }

    public Object[] getValue() {
        Object[] value = new Object[this.getBandCount()];
        for (int i = 0; i < this.getBandCount(); ++i) {
            value[i] = this.buffer.getBand(i).get(this.row, this.column);
        }
        return value;
    }

    public Object[][][] getValues() {
        int maxRows = this.buffer.getRows();
        int maxColumns = this.buffer.getColumns();
        Object[][][] value = new Object[3][3][this.getBandCount()];
        for (int i = -1; i < 2; ++i) {
            for (int j = -1; j < 2; ++j) {
                for (int b = 0; b < this.getBandCount(); ++b) {
                    Object obj = null;
                    if (this.row + i >= 0 && this.row + i <= maxRows && this.column + j >= 0 && this.column + j <= maxColumns) {
                        obj = this.buffer.getBand(b).get(this.row + i, this.column + j);
                    }
                    value[1 + i][1 + j][b] = obj;
                }
            }
        }
        return value;
    }
}

