/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.raster.impl;

import java.awt.image.BufferedImage;
import java.util.Iterator;
import org.cresques.cts.ICoordTrans;
import org.cresques.cts.IProjection;
import org.gvsig.fmap.dal.DataStore;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.raster.RasterQuery;
import org.gvsig.fmap.dal.raster.RasterSet;
import org.gvsig.fmap.dal.raster.RasterStore;
import org.gvsig.fmap.dal.raster.exceptions.RasterSetInitializeException;
import org.gvsig.fmap.dal.raster.impl.DefaultRasterKernel;
import org.gvsig.fmap.dal.raster.impl.DefaultRasterStore;
import org.gvsig.fmap.dal.raster.spi.RasterStoreProvider;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.exception.CreateEnvelopeException;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.raster.lib.buffer.api.Band;
import org.gvsig.raster.lib.buffer.api.BandInfo;
import org.gvsig.raster.lib.buffer.api.Buffer;
import org.gvsig.raster.lib.buffer.api.BufferDimensions;
import org.gvsig.raster.lib.buffer.api.NoData;
import org.gvsig.raster.lib.buffer.api.exceptions.BandException;
import org.gvsig.raster.lib.buffer.api.exceptions.BufferException;
import org.gvsig.raster.lib.buffer.api.statistics.Statistics;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposableManager;
import org.gvsig.tools.dispose.DisposeUtils;
import org.gvsig.tools.exception.BaseException;
import org.gvsig.tools.locator.LocatorException;
import org.gvsig.tools.observer.Observable;
import org.gvsig.tools.observer.Observer;
import org.gvsig.tools.task.SimpleTaskStatus;
import org.gvsig.tools.visitor.VisitCanceledException;
import org.gvsig.tools.visitor.Visitor;
import org.gvsig.tools.visitor.impl.AbstractIndexedVisitable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultRasterSet
extends AbstractIndexedVisitable
implements RasterSet,
Observer {
    protected static final Logger logger = LoggerFactory.getLogger(DefaultRasterSet.class);
    private DefaultRasterStore store;
    protected RasterQuery query;
    protected Buffer buffer;
    private final Object lock = new Object();
    private boolean disposed = false;

    public DefaultRasterSet(RasterStore store, RasterQuery query) throws DataException {
        if (ToolsLocator.getDisposableManager() != null) {
            ToolsLocator.getDisposableManager().bind((Disposable)this);
        } else {
            logger.warn("Can't retrieve the disposable manager,");
        }
        DisposableManager disposableManager = ToolsLocator.getDisposableManager();
        disposableManager.bind((Disposable)store);
        this.store = (DefaultRasterStore)store;
        this.query = query;
        RasterStoreProvider provider = this.store.getProvider();
        try {
            this.buffer = provider.createBuffer(query);
            if (this.buffer != null && query != null && query.getClip() != null) {
                Buffer clip = this.buffer.clip(query.getClip());
                DisposeUtils.dispose((Disposable)this.buffer);
                this.buffer = clip;
            }
        }
        catch (BufferException e) {
            throw new RasterSetInitializeException((Throwable)e);
        }
        this.store.addObserver(this);
    }

    public int getBandCount() {
        if (this.buffer != null) {
            return this.buffer.getBandCount();
        }
        return 0;
    }

    public Band[] getBands() {
        if (this.buffer != null) {
            return this.buffer.getBands();
        }
        return null;
    }

    public int getColumns() {
        if (this.buffer != null) {
            return this.buffer.getColumns();
        }
        return 0;
    }

    public int getRows() {
        if (this.buffer != null) {
            return this.buffer.getRows();
        }
        return 0;
    }

    public boolean areAllBandsOfTheSameType() {
        if (this.buffer != null) {
            return this.buffer.areAllBandsOfTheSameType();
        }
        return true;
    }

    public Envelope getEnvelope() throws LocatorException, CreateEnvelopeException {
        if (this.buffer != null) {
            return this.buffer.getEnvelope();
        }
        return GeometryLocator.getGeometryManager().createEnvelope(0);
    }

    public IProjection getProjection() {
        if (this.buffer != null) {
            return this.buffer.getProjection();
        }
        return null;
    }

    public boolean isInside(int cellX, int cellY) {
        if (this.buffer != null) {
            return this.buffer.isInside(cellX, cellY);
        }
        return false;
    }

    public boolean isInside(Point point) {
        if (this.buffer != null) {
            return this.buffer.isInside(point);
        }
        return false;
    }

    public void addBand(Band band) {
        if (this.buffer != null) {
            this.buffer.addBand(band);
        }
    }

    public void setBand(int pos, Band band) throws BandException {
        if (this.buffer != null) {
            this.buffer.setBand(pos, band);
        }
    }

    public void removeBand(int pos) {
        if (this.buffer != null) {
            this.buffer.removeBand(pos);
        }
    }

    public Band getBand(int pos) {
        if (this.buffer != null) {
            return this.buffer.getBand(pos);
        }
        return null;
    }

    public Band.BandByte getBandByte(int pos) {
        if (this.buffer != null) {
            return this.buffer.getBandByte(pos);
        }
        return null;
    }

    public Band.BandShort getBandShort(int pos) {
        if (this.buffer != null) {
            return this.buffer.getBandShort(pos);
        }
        return null;
    }

    public Band.BandInt getBandInt(int pos) {
        if (this.buffer != null) {
            return this.buffer.getBandInt(pos);
        }
        return null;
    }

    public Band.BandFloat getBandFloat(int pos) {
        if (this.buffer != null) {
            return this.buffer.getBandFloat(pos);
        }
        return null;
    }

    public Band.BandDouble getBandDouble(int pos) {
        if (this.buffer != null) {
            return this.buffer.getBandDouble(pos);
        }
        return null;
    }

    public void switchBands(int[] positions) {
        if (this.buffer != null) {
            this.buffer.switchBands(positions);
        }
    }

    public void switchBands(int pos1, int pos2) {
        if (this.buffer != null) {
            this.buffer.switchBands(pos1, pos2);
        }
    }

    public Buffer createInterpolated(int rows, int columns, int interpolationMode, SimpleTaskStatus status) throws LocatorException, BufferException {
        if (this.buffer != null) {
            return this.buffer.createInterpolated(rows, columns, interpolationMode, status);
        }
        return null;
    }

    public Buffer convert(ICoordTrans ct, SimpleTaskStatus status) throws BufferException {
        if (this.buffer != null) {
            return this.buffer.convert(ct, status);
        }
        return null;
    }

    public int[] getBandTypes() {
        if (this.buffer != null) {
            return this.buffer.getBandTypes();
        }
        return null;
    }

    public NoData[] getBandNoData() {
        if (this.buffer != null) {
            return this.buffer.getBandNoData();
        }
        return null;
    }

    public Buffer clip(Envelope envelope) throws BufferException {
        if (this.buffer != null) {
            return this.buffer.clip(envelope);
        }
        return null;
    }

    public double getPixelSizeX() {
        if (this.buffer != null) {
            return this.buffer.getPixelSizeX();
        }
        return Double.NaN;
    }

    public double getPixelSizeY() {
        if (this.buffer != null) {
            return this.buffer.getPixelSizeY();
        }
        return Double.NaN;
    }

    public Statistics getStatistics(SimpleTaskStatus status) {
        if (this.buffer != null) {
            return this.buffer.getStatistics(status);
        }
        return null;
    }

    public void addObserver(Observer o) {
        if (this.buffer != null) {
            this.buffer.addObserver(o);
        }
    }

    public void deleteObserver(Observer o) {
        if (this.buffer != null) {
            this.buffer.deleteObserver(o);
        }
    }

    public void deleteObservers() {
        if (this.buffer != null) {
            this.buffer.deleteObservers();
        }
    }

    public Iterator<Band> iterator() {
        if (this.buffer != null) {
            return this.buffer.iterator();
        }
        return null;
    }

    public boolean isFromStore(DataStore store) {
        return ((Object)((Object)this.store)).equals(store);
    }

    public void update(Observable observable, Object notification) {
    }

    protected void doAccept(Visitor visitor, long firstValueIndex) throws VisitCanceledException, BaseException {
        if (this.buffer != null) {
            DefaultRasterKernel kernel = new DefaultRasterKernel(this.buffer);
            for (int row = 0; row < this.buffer.getRows(); ++row) {
                for (int column = 0; column < this.buffer.getColumns(); ++column) {
                    kernel.set(row, column);
                    visitor.visit((Object)kernel);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void dispose() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.disposed && ToolsLocator.getDisposableManager().release((Disposable)this)) {
                try {
                    this.doDispose();
                }
                catch (BaseException ex) {
                    logger.error("Error performing dispose", (Throwable)ex);
                }
                this.disposed = true;
            }
        }
    }

    public void doDispose() throws BaseException {
        DisposeUtils.dispose((Disposable)this.store);
        this.store = null;
        DisposeUtils.dispose((Disposable)this.buffer);
        this.buffer = null;
        this.query = null;
    }

    protected void finalize() throws Throwable {
        super.finalize();
    }

    public BufferedImage getBufferedImage() {
        if (this.buffer != null) {
            return this.buffer.getBufferedImage();
        }
        return null;
    }

    public boolean isEmpty() {
        return this.buffer == null;
    }

    public BufferDimensions getDimensions() {
        return this.buffer.getDimensions();
    }

    public BandInfo[] getBandsInfo() {
        if (this.buffer != null) {
            return this.buffer.getBandsInfo();
        }
        return null;
    }
}

