/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.resource.impl;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataParameters;
import org.gvsig.fmap.dal.exception.CopyParametersException;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.exception.InitializeException;
import org.gvsig.fmap.dal.resource.Resource;
import org.gvsig.fmap.dal.resource.ResourceParameters;
import org.gvsig.fmap.dal.resource.exception.AccessResourceException;
import org.gvsig.fmap.dal.resource.exception.DisposeResorceManagerException;
import org.gvsig.fmap.dal.resource.exception.ResourceException;
import org.gvsig.fmap.dal.resource.exception.ResourceNotClosedOnDisposeManagerException;
import org.gvsig.fmap.dal.resource.exception.ResourceNotRegisteredException;
import org.gvsig.fmap.dal.resource.spi.AbstractResource;
import org.gvsig.fmap.dal.resource.spi.ResourceManagerProviderServices;
import org.gvsig.fmap.dal.resource.spi.ResourceProvider;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.observer.Observer;
import org.gvsig.tools.observer.WeakReferencingObservable;
import org.gvsig.tools.observer.impl.BaseWeakReferencingObservable;
import org.gvsig.tools.observer.impl.DelegateWeakReferencingObservable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultResourceManager
implements ResourceManagerProviderServices {
    private static final String DATA_MANAGER_RESOURCE = "Data.manager.resources";
    private static final String DATA_MANAGER_RESOURCE_PARAMS = "Data.manager.resources.params";
    private static final String DATA_MANAGER_RESOURCE_DESCRIPTION = "DAL Resources types";
    private static final String DATA_MANAGER_RESOURCE_PARAMS_DESCRIPTION = "DAL Resources types Parameters";
    private Map<String, Resource> resources = new HashMap<String, Resource>();
    private DelegateWeakReferencingObservable delegateObservable = new DelegateWeakReferencingObservable((WeakReferencingObservable)this);
    private Timer timer = null;
    private Logger logger;
    private long mlsecondsToBeIdle = 0L;

    public DefaultResourceManager() {
        ToolsLocator.getExtensionPointManager().add(DATA_MANAGER_RESOURCE, DATA_MANAGER_RESOURCE_DESCRIPTION);
        ToolsLocator.getExtensionPointManager().add(DATA_MANAGER_RESOURCE_PARAMS, DATA_MANAGER_RESOURCE_PARAMS_DESCRIPTION);
    }

    public Logger getLogger() {
        if (this.logger == null) {
            this.logger = LoggerFactory.getLogger(this.getClass());
        }
        return this.logger;
    }

    public synchronized void remove(Resource resource) throws DataException {
        this.remove(resource.getName());
    }

    public synchronized void remove(String name) throws DataException {
        ResourceProvider res = (ResourceProvider)this.resources.get(name);
        if (res == null) {
            throw new IllegalArgumentException("Resource not register:" + name);
        }
        if (res.getConsumersCount() < 1) {
            this.resources.remove(name);
            res.notifyDispose();
        }
        res = null;
    }

    public synchronized Resource getResource(String key) {
        return this.resources.get(key);
    }

    public synchronized Iterator<Resource> iterator() {
        return this.resources.values().iterator();
    }

    public void addObserver(Observer o) {
        this.delegateObservable.addObserver(o);
    }

    public void deleteObserver(Observer o) {
        this.delegateObservable.deleteObserver(o);
    }

    public void deleteObservers() {
        this.delegateObservable.deleteObservers();
    }

    public synchronized void collectResources() throws DataException {
        Iterator<Map.Entry<String, Resource>> iter = this.resources.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<String, Resource> entry = iter.next();
            ResourceProvider res = (ResourceProvider)entry.getValue();
            if (res.getConsumersCount() < 1) {
                res.closeRequest();
                res.notifyDispose();
                iter.remove();
                continue;
            }
            if (this.mlsecondsToBeIdle > 0L && System.currentTimeMillis() - res.getLastTimeUsed() <= this.mlsecondsToBeIdle) continue;
        }
    }

    private synchronized AbstractResource findResource(ResourceParameters params) {
        for (AbstractResource abstractResource : this.resources.values()) {
            try {
                if (!abstractResource.isThis(params)) continue;
                return abstractResource;
            }
            catch (ResourceException e) {
                this.getLogger().warn("Se ha producido un error comprobando si se puede reutilizar el recurso.", (Throwable)e);
            }
            catch (CopyParametersException e) {
                this.getLogger().warn("Se ha producido un error comprobando si se puede reutilizar el recurso.", (Throwable)e);
            }
        }
        return null;
    }

    private synchronized AbstractResource addResource(AbstractResource resource) throws AccessResourceException {
        this.resources.put(resource.getName(), (Resource)resource);
        resource.addObservers((BaseWeakReferencingObservable)this.delegateObservable);
        return resource;
    }

    public void startResourceCollector(long milis, Observer observer) {
        if (this.timer == null) {
            this.timer = new Timer();
        } else {
            this.timer.cancel();
        }
        this.timer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                try {
                    DALLocator.getResourceManager().collectResources();
                }
                catch (DataException dataException) {
                    // empty catch block
                }
            }
        }, milis, milis);
    }

    public void stopResourceCollector() {
        if (this.timer != null) {
            this.timer.cancel();
        }
    }

    public DataParameters createParameters(String type, Object[] args) throws InitializeException {
        try {
            ResourceParameters parameters = args == null ? (ResourceParameters)ToolsLocator.getExtensionPointManager().get(DATA_MANAGER_RESOURCE_PARAMS).create(type) : (ResourceParameters)ToolsLocator.getExtensionPointManager().get(DATA_MANAGER_RESOURCE_PARAMS).create(type, args);
            if (parameters == null) {
                throw new ResourceNotRegisteredException(type);
            }
            return parameters;
        }
        catch (Exception e) {
            throw new InitializeException(type, (Throwable)e);
        }
    }

    public DataParameters createParameters(String type) throws InitializeException {
        return this.createParameters(type, null);
    }

    public ResourceProvider createAddResource(String type, Object[] params) throws InitializeException {
        return this.createAddResource((ResourceParameters)this.createParameters(type, params));
    }

    public ResourceProvider createResource(String type, Object[] params) throws InitializeException {
        return this.createResource((ResourceParameters)this.createParameters(type, params));
    }

    public ResourceProvider createResource(ResourceParameters params) throws InitializeException {
        AbstractResource resource = this.findResource(params);
        if (resource != null) {
            return resource;
        }
        try {
            resource = (AbstractResource)ToolsLocator.getExtensionPointManager().get(DATA_MANAGER_RESOURCE).create(params.getTypeName(), new Object[]{params});
            if (resource == null) {
                throw new ResourceNotRegisteredException(params.getTypeName());
            }
        }
        catch (InstantiationException e) {
            throw new InitializeException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new InitializeException((Throwable)e);
        }
        catch (SecurityException e) {
            throw new InitializeException((Throwable)e);
        }
        catch (IllegalArgumentException e) {
            throw new InitializeException((Throwable)e);
        }
        catch (NoSuchMethodException e) {
            throw new InitializeException((Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new InitializeException((Throwable)e);
        }
        return resource;
    }

    public ResourceProvider createAddResource(ResourceParameters params) throws InitializeException {
        try {
            String name = params.getResurceID();
            Resource res = this.resources.get(name);
            if (res != null) {
                return (AbstractResource)res;
            }
            return this.addResource((AbstractResource)this.createResource(params));
        }
        catch (AccessResourceException e) {
            throw new InitializeException(params.getTypeName(), (Throwable)e);
        }
    }

    public boolean register(String type, String description, Class resourceHandler, Class resourceParams) {
        ToolsLocator.getExtensionPointManager().add(DATA_MANAGER_RESOURCE, DATA_MANAGER_RESOURCE_DESCRIPTION).append(type, description, resourceHandler);
        ToolsLocator.getExtensionPointManager().add(DATA_MANAGER_RESOURCE_PARAMS, DATA_MANAGER_RESOURCE_PARAMS_DESCRIPTION).append(type, description, resourceParams);
        return true;
    }

    public List getResourceProviders() {
        return ToolsLocator.getExtensionPointManager().get(DATA_MANAGER_RESOURCE).getNames();
    }

    public synchronized void closeResources() throws DataException {
        this.collectResources();
        for (Resource res : this.resources.values()) {
            res.closeRequest();
        }
    }

    public synchronized void dispose() throws DisposeResorceManagerException {
        DisposeResorceManagerException exception = new DisposeResorceManagerException();
        try {
            this.collectResources();
        }
        catch (DataException e) {
            exception.add((Object)e);
        }
        Iterator<Resource> iter = this.resources.values().iterator();
        while (iter.hasNext()) {
            Resource res = iter.next();
            try {
                if (res.openCount() > 0) {
                    exception.add((Object)new ResourceNotClosedOnDisposeManagerException(res));
                }
                res.closeRequest();
                iter.remove();
            }
            catch (ResourceException e) {
                exception.add((Object)e);
            }
        }
        this.resources = null;
        this.delegateObservable.deleteObservers();
        this.delegateObservable = null;
        if (!exception.isEmpty()) {
            throw exception;
        }
    }

    public int getTimeToBeIdle() {
        if (this.mlsecondsToBeIdle == 0L) {
            return 0;
        }
        return (int)(this.mlsecondsToBeIdle / 1000L);
    }

    public void setTimeToBeIdle(int seconds) {
        if (seconds < 0) {
            throw new IllegalArgumentException("seconds must be >= 0");
        }
        this.mlsecondsToBeIdle = seconds * 1000;
    }
}

