/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.online.app.mainplugin;

import java.awt.Dimension;
import java.io.File;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.mutable.MutableObject;
import org.gvsig.andami.LocaleManager;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.PluginsLocator;
import org.gvsig.andami.PluginsManager;
import org.gvsig.andami.plugins.Extension;
import org.gvsig.andami.preferences.IPreference;
import org.gvsig.andami.preferences.IPreferenceExtension;
import org.gvsig.app.ApplicationLocator;
import org.gvsig.app.ApplicationManager;
import org.gvsig.app.extension.AddLayer;
import org.gvsig.app.project.ProjectManager;
import org.gvsig.app.project.documents.view.ViewDocument;
import org.gvsig.app.project.documents.view.ViewManager;
import org.gvsig.desktopopen.DesktopOpen;
import org.gvsig.fmap.dal.EditingNotificationManager;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.swing.DALSwingLocator;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.fmap.mapcontext.layers.FLayers;
import org.gvsig.fmap.mapcontext.layers.vectorial.VectorLayer;
import org.gvsig.online.app.mainplugin.EditingNotificationObserver;
import org.gvsig.online.app.mainplugin.OnlineDialogsHelper;
import org.gvsig.online.app.mainplugin.OnlineSwingServicesImpl;
import org.gvsig.online.app.mainplugin.addlayer.WizardOnlineTabular;
import org.gvsig.online.app.mainplugin.addlayer.WizardOnlineVectorial;
import org.gvsig.online.app.mainplugin.preferencespages.OnlinePage;
import org.gvsig.online.lib.api.OnlineLocator;
import org.gvsig.online.lib.api.OnlineManager;
import org.gvsig.online.lib.api.workingcopy.OnlineWorkingcopy;
import org.gvsig.online.swing.api.OnlineJDownload;
import org.gvsig.online.swing.api.OnlineJInitWorkingcopy;
import org.gvsig.online.swing.api.OnlinePanel;
import org.gvsig.online.swing.api.OnlineSwingLocator;
import org.gvsig.online.swing.api.OnlineSwingManager;
import org.gvsig.online.swing.api.OnlineSwingServices;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.arguments.Arguments;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposeUtils;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.observer.Observer;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingUtils;
import org.gvsig.tools.swing.api.threadsafedialogs.ThreadSafeDialogsManager;
import org.gvsig.tools.swing.api.windowmanager.WindowManager;
import org.gvsig.tools.swing.api.windowmanager.WindowManager_v2;
import org.gvsig.tools.util.ToolsUtilLocator;

public class OnlineExtension
extends Extension
implements IPreferenceExtension {
    private OnlineDialogsHelper dialogsHelper;

    public void initialize() {
        ToolsSwingUtils.registerIcons(((Object)((Object)this)).getClass(), (String)"/images/action", (String)"online", (String[][])new String[][]{{"action", "tools-online-init-workspace", "online"}, {"action", "tools-online-download", "online"}, {"action", "tools-online-showchanges", "online"}});
        ToolsSwingUtils.registerSubgroupIconDescription((String)"action", (String)"online", (String)"Acciones asociadas al complemento de Online.\nSe encuentran en el menu 'Heramientas/Online'");
        this.dialogsHelper = new OnlineDialogsHelper();
    }

    public void postInitialize() {
        super.postInitialize();
        ToolsSwingUtils.registerIcons(((Object)((Object)this)).getClass(), (String)"/images/preferences", (String)"online", (String[][])new String[][]{{"preferences", "online-preferences", "online"}});
        ApplicationManager application = ApplicationLocator.getApplicationManager();
        OnlineManager manager = OnlineLocator.getOnlineManager();
        OnlineSwingManager swingManager = OnlineSwingLocator.getOnlineSwingManager();
        swingManager.setDefaultServices((OnlineSwingServices)new OnlineSwingServicesImpl());
        DynObject pluginProperties = this.getPlugin().getPluginProperties();
        Map workspaces = (Map)pluginProperties.getDynValue("workspaces");
        manager.restoreWorkingcopy(workspaces);
        manager.setMaxFeaturesPerTile(((Integer)pluginProperties.getDynValue("MaxFeaturesPerTile")).intValue());
        manager.setContinueWhenUploadFails(((Boolean)pluginProperties.getDynValue("ContinueWhenUploadFails")).booleanValue());
        PluginsLocator.getPluginsManager().addShutdownTask("OnlineSave", () -> {
            DynObject pluginProps = this.getPlugin().getPluginProperties();
            pluginProps.setDynValue("workspaces", (Object)manager.getWorkingcopy());
            pluginProps.setDynValue("MaxFeaturesPerTile", (Object)manager.getMaxFeaturesPerTile());
            pluginProps.setDynValue("ContinueWhenUploadFails", (Object)manager.getContinueWhenUploadFails());
        }, false, 100);
        ApplicationLocator.getManager().registerAddTableWizard("Online", "Online", WizardOnlineTabular.class);
        AddLayer.addWizard(WizardOnlineVectorial.class);
        application.getProjectManager().addProjectListener(e -> {
            if (e instanceof ProjectManager.ProjectEvent) {
                ProjectManager.ProjectEvent pe = (ProjectManager.ProjectEvent)e;
                switch (pe.getId()) {
                    case 14: {
                        OnlineSwingServicesImpl services = (OnlineSwingServicesImpl)OnlineSwingLocator.getOnlineSwingManager().getDefaultServices();
                        services.projectLoaded(pe.getProject());
                        break;
                    }
                }
            }
        });
        EditingNotificationManager editingNotificationManager = DALSwingLocator.getEditingNotificationManager();
        editingNotificationManager.addObserver((Observer)new EditingNotificationObserver());
    }

    public void execute(String actionCommand) {
        this.execute(actionCommand, null);
    }

    public void execute(String actionCommand, Object[] args) {
        Arguments arguments = Arguments.create((Object[])args);
        switch (actionCommand) {
            case "tools-online-showchanges": {
                this.showChangesDialog((OnlineWorkingcopy)arguments.get("workspace", OnlineWorkingcopy.class, null), arguments.getListOf("tablenames", String.class), (Timestamp)arguments.get("efectivedate", Timestamp.class, null), (String)arguments.get("comment", String.class, null));
                break;
            }
            case "tools-online-init-workspace": {
                this.showInitWorkspaceDialog();
                break;
            }
            case "tools-online-download": {
                this.showDownloadDialog((OnlineWorkingcopy)arguments.get("workspace", OnlineWorkingcopy.class, null), arguments.getListOf("tablenames", String.class), (Boolean)arguments.get("overwrite", Boolean.class, null));
                break;
            }
            case "tools-online-simple-search": {
                FeatureStore store = (FeatureStore)arguments.get("store", FeatureStore.class, null);
                if (store == null) {
                    store = this.getActiveOnlineStore();
                    this.showSimpleSearchDialog(store, arguments);
                    DisposeUtils.dispose((Disposable)store);
                    break;
                }
                this.showSimpleSearchDialog(store, arguments);
                break;
            }
            case "help-online-showman": {
                this.showLocalManual("online-man");
            }
        }
    }

    public boolean isEnabled() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEnabled(String action) {
        if (StringUtils.equals((CharSequence)action, (CharSequence)"tools-online-simple-search")) {
            FeatureStore store = null;
            try {
                store = this.getActiveOnlineStore();
                boolean bl = store != null;
                return bl;
            }
            catch (Throwable th) {
                logger.warn("Can't check if is enabled online action '" + action + "'", th);
                boolean bl = false;
                return bl;
            }
            finally {
                DisposeUtils.disposeQuietly((Disposable)store);
            }
        }
        if (StringUtils.equals((CharSequence)action, (CharSequence)"help-online-showuserguide")) {
            return this.getManPrefix("online_user_guide") != null;
        }
        return this.isEnabled();
    }

    public boolean canQueryByAction() {
        return true;
    }

    public boolean isVisible() {
        return true;
    }

    private void showInitWorkspaceDialog() {
        OnlineSwingManager swingManager = OnlineSwingLocator.getOnlineSwingManager();
        I18nManager i18n = ToolsLocator.getI18nManager();
        OnlineDialogsHelper.OnlineDialogInfo dialog = this.dialogsHelper.getOrCreateDialog("InitializeWorkingCopy", (OnlinePanel)swingManager.createInitWorkspacePanel(), i18n.getTranslation("_Online_Initialize_workingcopy"), i18n.getTranslation("_Initialize_workingcopy"), i18n.getTranslation("_Initialize_workingcopy"), () -> {
            ThreadSafeDialogsManager dialogsManager = ToolsSwingLocator.getThreadSafeDialogsManager();
            OnlineJInitWorkingcopy panelInitWorkspace = (OnlineJInitWorkingcopy)this.dialogsHelper.getDialog("InitializeWorkingCopy").getPanel();
            int r = panelInitWorkspace.actionPerformed();
            if (r != 0 && r != 17) {
                dialogsManager.messageDialog(i18n.getTranslation("_Cant_initialize_workingcopy_XworkingcopynameX", new String[]{panelInitWorkspace.getWorkspaceName()}), i18n.getTranslation("_Online_Initialize_workingcopy"), 2);
            }
        });
        dialog.setAutoclose(true);
        dialog.show(Collections.singletonMap("align", 10));
    }

    private void showDownloadDialog(OnlineWorkingcopy workspace, List<String> tableNames, Boolean overwrite) {
        OnlineSwingManager swingManager = OnlineSwingLocator.getOnlineSwingManager();
        OnlineDialogsHelper.OnlineDialogInfo dialog = this.dialogsHelper.getOrCreateDialog("Download", (OnlinePanel)swingManager.createDownloadPanel(workspace, tableNames, overwrite), "_Online_Download", "_Download", "_Download", () -> {
            I18nManager i18n = ToolsLocator.getI18nManager();
            ThreadSafeDialogsManager dialogsManager = ToolsSwingLocator.getThreadSafeDialogsManager();
            OnlineJDownload downloadPanel = (OnlineJDownload)this.dialogsHelper.getDialog("Download").getPanel();
            int r = downloadPanel.actionPerformed();
            if (r != 0 && r != 17) {
                List layerNames = downloadPanel.getSelectedLayerNames();
                dialogsManager.messageDialog(i18n.getTranslation("_Failed_download_of_{0}", new String[]{StringUtils.join((Iterable)layerNames, (String)" ")}), i18n.getTranslation("_Online_Download"), 2);
            }
        });
        Dimension screensize = ApplicationLocator.getApplicationManager().getUIManager().getInternalSize();
        Dimension panelsize = dialog.getPanel().asJComponent().getPreferredSize();
        ToolsSwingUtils.ensureHeightWitdh((JComponent)dialog.getPanel().asJComponent(), (int)Math.max(3 * (screensize.height / 4), panelsize.height), (int)Math.max(2 * (screensize.width / 4), panelsize.width), (int)(7 * (screensize.height / 8)), (int)(3 * (screensize.width / 4)));
        dialog.show(Collections.singletonMap("align", 10));
    }

    private void showChangesDialog(OnlineWorkingcopy workspace, List<String> tableNames, Timestamp efectivedate, String comment) {
        OnlineSwingManager swingManager = OnlineSwingLocator.getOnlineSwingManager();
        OnlineDialogsHelper.OnlineDialogInfo dialog = this.dialogsHelper.getOrCreateDialog("Changes", (OnlinePanel)swingManager.createChangesPanel(workspace, tableNames, efectivedate, comment), "_Online_Changes");
        Dimension screensize = ApplicationLocator.getApplicationManager().getUIManager().getInternalSize();
        Dimension panelsize = dialog.getPanel().asJComponent().getPreferredSize();
        ToolsSwingUtils.ensureHeightWitdh((JComponent)dialog.getPanel().asJComponent(), (int)Math.max(3 * (screensize.height / 4), panelsize.height), (int)Math.max(2 * (screensize.width / 4), panelsize.width), (int)(7 * (screensize.height / 8)), (int)(3 * (screensize.width / 4)));
        dialog.show(Collections.singletonMap("align", 10));
    }

    public IPreference[] getPreferencesPages() {
        ArrayList<OnlinePage> prefs = new ArrayList<OnlinePage>();
        prefs.add(new OnlinePage());
        return prefs.toArray(new IPreference[prefs.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FeatureStore getActiveOnlineStore() {
        ViewDocument view = (ViewDocument)ApplicationLocator.getManager().getActiveDocument(ViewManager.TYPENAME);
        if (view == null) {
            return null;
        }
        FLayers layers = view.getMapContext().getLayers();
        if (CollectionUtils.isEmpty((Collection)layers)) {
            return null;
        }
        FLayer[] activeLayers = layers.getActives();
        if (activeLayers == null || activeLayers.length != 1) {
            return null;
        }
        OnlineManager onlineManager = OnlineLocator.getOnlineManager();
        FLayer activeLayer = activeLayers[0];
        if (activeLayer instanceof VectorLayer) {
            FeatureStore store = ((VectorLayer)activeLayer).getFeatureStore();
            if (store == null) {
                return null;
            }
            OnlineWorkingcopy wc = null;
            try {
                wc = onlineManager.getWorkingcopy(store);
                if (wc != null) {
                    DisposeUtils.bind((Disposable)store);
                    FeatureStore featureStore = store;
                    return featureStore;
                }
            }
            finally {
                DisposeUtils.dispose((Disposable)wc);
            }
        }
        return null;
    }

    private void showSimpleSearchDialog(FeatureStore store, Arguments arguments) {
        OnlineSwingManager swingManager = OnlineSwingLocator.getOnlineSwingManager();
        WindowManager_v2 winmanager = (WindowManager_v2)ToolsSwingLocator.getWindowManager();
        winmanager.showWindow(swingManager.createSimpleSearchPanel(store, arguments).asJComponent(), ToolsSwingUtils.makeTitle((String)"_Online_Simple_search", (String)store.getLabel(), null), WindowManager.MODE.WINDOW, Collections.singletonMap("align", 10));
    }

    public void showLocalManual(String manId) {
        File f;
        LocaleManager localeManager = PluginsLocator.getLocaleManager();
        PluginsManager pluginsManager = PluginsLocator.getManager();
        PluginServices plugin = pluginsManager.getPlugin((Object)this);
        String prefix = this.getManPrefix(manId);
        if (prefix == null) {
            return;
        }
        Locale locale = localeManager.getCurrentLocale();
        String localeid = locale.getLanguage();
        Object[] localeAlternatives = localeManager.getLocaleAlternatives(locale);
        if (!ArrayUtils.isEmpty((Object[])localeAlternatives)) {
            localeid = ((Locale)localeAlternatives[0]).getLanguage();
        }
        if (!(f = FileUtils.getFile((File)plugin.getPluginDirectory(), (String[])new String[]{"man", prefix + "-" + localeid + ".pdf"})).exists()) {
            f = FileUtils.getFile((File)plugin.getPluginDirectory(), (String[])new String[]{"man", prefix + "-es.pdf"});
        }
        DesktopOpen desktop = ToolsUtilLocator.getToolsUtilManager().createDesktopOpen();
        desktop.open(f);
    }

    private String getManPrefix(String manId) {
        PluginsManager pluginsManager = PluginsLocator.getManager();
        PluginServices plugin = pluginsManager.getPlugin((Object)this);
        Pattern p = Pattern.compile("(gvsig-[0-9.]+-" + manId + "-[0-9.]+)-[a-z]+[.]pdf");
        MutableObject prefix = new MutableObject();
        File folder = FileUtils.getFile((File)plugin.getPluginDirectory(), (String[])new String[]{"man"});
        Object[] ff = folder.list((dir, name) -> {
            Matcher m = p.matcher(name);
            if (m == null || !m.matches()) {
                return false;
            }
            prefix.setValue((Object)m.group(1));
            return true;
        });
        if (ArrayUtils.isEmpty((Object[])ff)) {
            return null;
        }
        return (String)prefix.getValue();
    }
}

