/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.online.app.mainplugin.addlayer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.text.JTextComponent;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.app.gui.WizardPanel;
import org.gvsig.expressionevaluator.swing.ExpressionEvaluatorSwingLocator;
import org.gvsig.expressionevaluator.swing.ExpressionEvaluatorSwingManager;
import org.gvsig.fmap.dal.DataStoreParameters;
import org.gvsig.fmap.dal.store.jdbc.JDBCStoreParameters;
import org.gvsig.fmap.dal.swing.DALSwingLocator;
import org.gvsig.fmap.dal.swing.DataSwingManager;
import org.gvsig.fmap.mapcontext.MapContext;
import org.gvsig.geodb.TableInfo;
import org.gvsig.geodb.TableInfoController;
import org.gvsig.online.app.mainplugin.addlayer.AbstractWizardOnlineView;
import org.gvsig.online.app.mainplugin.addlayer.OnlineTableInfo;
import org.gvsig.online.lib.api.workingcopy.OnlineEntity;
import org.gvsig.online.lib.api.workingcopy.OnlineWorkingcopy;
import org.gvsig.online.swing.api.OnlineEntitySelectorController;
import org.gvsig.online.swing.api.OnlineJDownload;
import org.gvsig.online.swing.api.OnlineJInitWorkingcopy;
import org.gvsig.online.swing.api.OnlineSwingLocator;
import org.gvsig.online.swing.api.OnlineSwingManager;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dispose.DisposeUtils;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.swing.api.InitComponentsListener;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingManager;
import org.gvsig.tools.swing.api.ToolsSwingUtils;
import org.gvsig.tools.swing.api.pickercontroller.PickerController;
import org.gvsig.tools.swing.api.task.TaskStatusController;
import org.gvsig.tools.swing.api.task.TaskStatusSwingManager;
import org.gvsig.tools.swing.api.threadsafedialogs.ThreadSafeDialogsManager;
import org.gvsig.tools.swing.api.windowmanager.Dialog;
import org.gvsig.tools.swing.api.windowmanager.WindowManager;
import org.gvsig.tools.swing.api.windowmanager.WindowManager_v2;
import org.gvsig.tools.swing.icontheme.IconTheme;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractWizardOnline
extends WizardPanel {
    protected static final Logger LOGGER = LoggerFactory.getLogger(AbstractWizardOnline.class);
    protected WizardOnlineViewExtended view;
    private PickerController<OnlineWorkingcopy> workspacePicker;
    protected Map<String, TableInfo> tablesInfo = null;
    private boolean processing;
    private TaskStatusController taskStatusController;
    private TableInfoController tableInfoController;
    private OnlineEntitySelectorController entitySelector;

    public AbstractWizardOnline() {
        this.createComponents();
    }

    private static void waitCursor(Component component, Runnable action) {
        Cursor saved_cursor = component.getCursor();
        try {
            component.setCursor(Cursor.getPredefinedCursor(3));
            action.run();
        }
        finally {
            component.setCursor(saved_cursor);
        }
    }

    private void createComponents() {
        ToolsSwingUtils.addInitComponentsListener((JComponent)((Object)this), (InitComponentsListener)new InitComponentsListener(){

            public void doDisposeComponents() {
                AbstractWizardOnline.this.disposeComponents();
            }

            public void doInitComponents() {
                AbstractWizardOnline.this.initComponents();
            }
        });
        this.view = new WizardOnlineViewExtended();
        this.tableInfoController = new OnlineTableInfoController(this.view.btnDeselectAllColumns, this.view.btnSelectAllColumns, this.view.lstColumns, this.view.txtName, this.view.cboIdField, this.view.cboGeometryField, this.view.txtProjection, this.view.btnProjection, this.view.txtFilter, this.view.btnFilter, this.view.btnFilterBookmarks, this.view.btnFilterHistory, this.view.btnAdvancedProperties, this.view.lblReadOnlyNotification, null, this.view.btnChangeViewProjection, this.view.chkVisible);
    }

    private void disposeComponents() {
        DisposeUtils.disposeQuietly((Object)this.entitySelector);
    }

    private void initComponents() {
        if (this.entitySelector != null) {
            return;
        }
        DataSwingManager dataSwingManager = DALSwingLocator.getDataSwingManager();
        ToolsSwingManager toolsSwingManager = ToolsSwingLocator.getToolsSwingManager();
        ExpressionEvaluatorSwingManager expressionSwingManager = ExpressionEvaluatorSwingLocator.getManager();
        OnlineSwingManager swingManager = OnlineSwingLocator.getOnlineSwingManager();
        this.entitySelector = swingManager.createEntitySelectorController(this.view.treeTables, (JTextComponent)this.view.txtTablesFilter, this.view.btnTablesFilter);
        Predicate<OnlineEntity> entitySelectorFilter = OnlineEntitySelectorController.ALL_ENTITIES;
        if (this.requireGeometry()) {
            entitySelectorFilter = t -> StringUtils.isNotBlank((CharSequence)t.getGeometryFieldName());
        }
        this.entitySelector.setFilter(entitySelectorFilter);
        this.entitySelector.setViewFilter(entitySelectorFilter);
        this.entitySelector.setLabelEntityFormatter(this.getLabelEntityFormatter());
        this.entitySelector.setChecksEnabled(true);
        TaskStatusSwingManager taskStatusManager = ToolsSwingLocator.getTaskStatusSwingManager();
        this.taskStatusController = taskStatusManager.createTaskStatusController(this.view.lblStatusTitle, this.view.lblStatusMessages, this.view.pbStatus);
        this.taskStatusController.setShowCancelButton(false);
        this.taskStatusController.setShowRemoveTaskButton(false);
        this.taskStatusController.bind(ToolsLocator.getTaskStatusManager());
        toolsSwingManager.translate((JComponent)this.view.lblColumns);
        toolsSwingManager.translate(this.view.lblWorkspace);
        toolsSwingManager.translate(this.view.lblFilter);
        toolsSwingManager.translate(this.view.lblGeometryField);
        toolsSwingManager.translate(this.view.lblIdField);
        toolsSwingManager.translate(this.view.lblName);
        toolsSwingManager.translate(this.view.lblProjection);
        toolsSwingManager.translate((JComponent)this.view.lblTable);
        toolsSwingManager.translate((JComponent)this.view.cboWorkspaces);
        toolsSwingManager.translate((AbstractButton)this.view.btnAddWorkspace);
        toolsSwingManager.translate((AbstractButton)this.view.btnDownload);
        toolsSwingManager.translate((AbstractButton)this.view.btnInitWorkspace);
        toolsSwingManager.translate((AbstractButton)this.view.btnTablesCheckAll);
        toolsSwingManager.translate((AbstractButton)this.view.btnTablesUncheckAll);
        toolsSwingManager.translate((AbstractButton)this.view.btnTablesCollapseAll);
        toolsSwingManager.translate((AbstractButton)this.view.btnTablesExpandAll);
        toolsSwingManager.translate(this.view.tabTableInfo);
        toolsSwingManager.translate(this.view.lblVisible);
        this.view.btnInitWorkspace.setText(this.toHTML(this.view.btnInitWorkspace.getText()));
        toolsSwingManager.addClearButton((JTextComponent)this.view.txtName);
        toolsSwingManager.setDefaultPopupMenu((JTextComponent)this.view.txtName);
        this.view.btnInitWorkspace.setCursor(Cursor.getPredefinedCursor(12));
        this.view.btnAddWorkspace.setCursor(Cursor.getPredefinedCursor(12));
        this.workspacePicker = swingManager.createPickerWorkspaceController(this.view.cboWorkspaces, this.view.btnAddWorkspace);
        this.workspacePicker.addChangeListener(e -> AbstractWizardOnline.waitCursor((Component)((Object)this), () -> {
            this.doChangeWorkspace();
            this.doUpdateComponents();
        }));
        this.entitySelector.addActionListener(e -> {
            switch (e.getID()) {
                case 2: {
                    this.doReloadTablesInfo();
                    break;
                }
                case 3: 
                case 4: {
                    this.doUpdateComponents();
                    break;
                }
                case 0: {
                    this.doChangeTableSelected();
                    break;
                }
                case 1: {
                    this.doChangeTableChecked();
                    this.doUpdateComponents();
                }
            }
        });
        this.view.btnTablesCheckAll.addActionListener(e -> AbstractWizardOnline.waitCursor((Component)((Object)this), () -> {
            ArrayList<String> entityCodes = new ArrayList<String>();
            Collection entities = this.entitySelector.getEntities();
            for (OnlineEntity entity : entities) {
                entityCodes.add(entity.getEntityCode());
            }
            this.entitySelector.setCheck(entityCodes, true);
        }));
        this.view.btnTablesUncheckAll.addActionListener(e -> this.entitySelector.clearChecks());
        this.view.btnTablesCollapseAll.addActionListener(e -> this.entitySelector.collapseAll());
        this.view.btnTablesExpandAll.addActionListener(e -> this.entitySelector.expandAll());
        this.view.btnInitWorkspace.addActionListener(e -> this.doShowInitWorkspace());
        this.view.btnDownload.setEnabled(true);
        this.view.btnDownload.addActionListener(e -> this.doDownload());
        this.view.btnChangeViewProjection.setVisible(this.requireGeometry());
        this.view.btnInitWorkspace.setBackground(UIManager.getColor("Panel.background"));
        this.clearTables();
        this.setLayout(new BorderLayout());
        this.add(this.view, "Center");
        ToolsSwingUtils.ensureRowsCols((JComponent)((Object)this), (int)22, (int)90, (int)25, (int)100);
        this.doUpdateComponents();
    }

    protected abstract boolean requireGeometry();

    protected Collection<TableInfo> getTablesInformation() {
        this.updateTableInfoFromUI();
        if (this.tablesInfo == null) {
            this.tablesInfo = new HashMap<String, TableInfo>();
        }
        return this.tablesInfo.values();
    }

    private void clearTables() {
        this.entitySelector.clear();
        this.tableInfoController.clear();
    }

    private void doChangeWorkspace() {
        if (AbstractWizardOnline.notInSwingThreadInvokeLater(this::doChangeWorkspace)) {
            return;
        }
        OnlineWorkingcopy workspace = (OnlineWorkingcopy)this.workspacePicker.get();
        this.entitySelector.setWorkspace(workspace);
    }

    private TableInfo getTableInfo(OnlineEntity entity) {
        Collection<TableInfo> tablesInformation = this.getTablesInformation();
        for (TableInfo tableInfo : tablesInformation) {
            OnlineEntity tableInfoEntity = (OnlineEntity)tableInfo.getProperty("entity");
            if (tableInfoEntity == null || !StringUtils.equals((CharSequence)tableInfoEntity.getEntityCode(), (CharSequence)entity.getEntityCode())) continue;
            return tableInfo;
        }
        return null;
    }

    private void doChangeTableSelected() {
        if (AbstractWizardOnline.notInSwingThreadInvokeLater(() -> this.doChangeTableSelected())) {
            return;
        }
        OnlineEntity selected = this.entitySelector.getSelectedEntity();
        if (selected == null) {
            this.tableInfoController.put(null);
            return;
        }
        TableInfo tableInfo = this.getTableInfo(selected);
        if (tableInfo != null) {
            this.updateTableInfoFromUI();
            this.tableInfoController.put(tableInfo);
            this.tableInfoController.setEnabled(true);
        } else {
            this.tableInfoController.clear();
            this.tableInfoController.setEnabled(false);
        }
        this.showMessage("");
        this.doUpdateComponents();
    }

    private void doChangeTableChecked() {
        List checkedEntities = this.entitySelector.getCheckedEntities();
        ArrayList<String> entityCodes = new ArrayList<String>();
        for (OnlineEntity checkedEntity : checkedEntities) {
            if (checkedEntity == null || checkedEntity instanceof OnlineEntity) continue;
            entityCodes.add(checkedEntity.getEntityCode());
        }
        this.entitySelector.setCheck(entityCodes, false);
        Collection<TableInfo> tablesInformation = this.getTablesInformation();
        for (TableInfo tableInfo : tablesInformation) {
            OnlineEntity tableInfoEntity = (OnlineEntity)tableInfo.getProperty("entity");
            tableInfo.setSelected(checkedEntities.contains(tableInfoEntity));
        }
        this.checkFinishable();
    }

    private void updateTableInfoFromUI() {
        TableInfo previousInfo;
        String previousId = this.tableInfoController.getId();
        if (previousId == null) {
            return;
        }
        if (this.tablesInfo != null && !this.tablesInfo.isEmpty() && (previousInfo = this.tablesInfo.get(previousId)) != null) {
            this.tableInfoController.fetch(previousInfo);
        }
    }

    public void initWizard() {
        I18nManager i18n = ToolsLocator.getI18nManager();
        this.setTabName(i18n.getTranslation("_Online"));
    }

    public boolean areSettingsValid() {
        if (this.processing) {
            return false;
        }
        boolean hasInvalidValues = false;
        boolean hasSelectedTables = false;
        for (TableInfo tableInfo : this.getTablesInformation()) {
            if (!tableInfo.isSelected()) continue;
            hasSelectedTables = true;
            if (tableInfo.hasValidValues()) continue;
            hasInvalidValues = true;
        }
        return hasSelectedTables && !hasInvalidValues;
    }

    public DataStoreParameters[] getParameters() {
        int sz = 0;
        for (TableInfo tableInfo : this.getTablesInformation()) {
            if (!tableInfo.isSelected()) continue;
            ++sz;
        }
        if (sz == 0) {
            return null;
        }
        DataStoreParameters[] dbParameters = new DataStoreParameters[sz];
        int n = 0;
        for (TableInfo tableInfo : this.getTablesInformation()) {
            if (!tableInfo.isSelected()) continue;
            dbParameters[n++] = tableInfo.getParameters();
        }
        return dbParameters;
    }

    public void execute() {
        this.executeWizard();
    }

    public void close() {
    }

    protected void checkFinishable() {
        boolean finishable = this.areSettingsValid();
        this.callStateChanged(finishable);
    }

    private void doUpdateComponents() {
        OnlineEntity entity = this.entitySelector.getSelectedEntity();
        boolean theProcessing = this.processing || this.entitySelector.isProcessing();
        OnlineWorkingcopy ws = this.getWorkspace();
        this.view.btnDownload.setEnabled(ws != null);
        if (entity == null) {
            this.tableInfoController.setEnabled(false);
        } else if (entity instanceof OnlineEntity) {
            this.tableInfoController.setEditable(!theProcessing && ws != null);
            this.tableInfoController.setEnabled(ws != null);
        } else {
            this.tableInfoController.setEnabled(false);
        }
        this.entitySelector.setEnabled(!theProcessing && ws != null);
        this.view.btnTablesCheckAll.setEnabled(this.entitySelector.isEnabled());
        this.view.btnTablesUncheckAll.setEnabled(this.entitySelector.isEnabled());
        this.view.btnTablesCollapseAll.setEnabled(this.entitySelector.isEnabled());
        this.view.btnTablesExpandAll.setEnabled(this.entitySelector.isEnabled());
        this.workspacePicker.setEnabled(!theProcessing);
        this.view.btnInitWorkspace.setEnabled(!theProcessing);
        this.setVisibleStatus(theProcessing);
        this.checkFinishable();
    }

    private void doShowInitWorkspace() {
        I18nManager i18nManager = ToolsLocator.getI18nManager();
        WindowManager_v2 winManager = (WindowManager_v2)ToolsSwingLocator.getWindowManager();
        OnlineSwingManager swingManager = OnlineSwingLocator.getOnlineSwingManager();
        OnlineJInitWorkingcopy panelInitWorkspace = swingManager.createInitWorkspacePanel();
        Dialog dialogInitWorkspace = winManager.createDialog(panelInitWorkspace.asJComponent(), i18nManager.getTranslation("_Online_Initialize_workingcopy"), i18nManager.getTranslation("_Online_Initialize_workingcopy"), 3);
        panelInitWorkspace.setDialog(dialogInitWorkspace);
        dialogInitWorkspace.setButtonLabel(1, i18nManager.getTranslation("_Online_Initialize_workingcopy"));
        dialogInitWorkspace.addActionListener(e -> {
            switch (dialogInitWorkspace.getAction()) {
                case 1: {
                    int r = panelInitWorkspace.actionPerformed();
                    if (r == 0) {
                        this.workspacePicker = swingManager.createPickerWorkspaceController(this.view.cboWorkspaces, this.view.btnAddWorkspace);
                        break;
                    }
                    String message = "_Cant_initialize_workingcopy_XworkingcopynameX";
                    StringBuilder compoundMessage = new StringBuilder();
                    String[] messageArgs = new String[]{panelInitWorkspace.getWorkspaceName()};
                    compoundMessage.append(i18nManager.getTranslation(message, messageArgs));
                    ThreadSafeDialogsManager dialogsManager = ToolsSwingLocator.getThreadSafeDialogsManager();
                    dialogsManager.messageDialog(compoundMessage.toString(), i18nManager.getTranslation("_Online_Initialize_workingcopy"), 2);
                }
            }
        });
        dialogInitWorkspace.show(WindowManager.MODE.DIALOG);
    }

    public OnlineWorkingcopy getWorkspace() {
        return (OnlineWorkingcopy)this.workspacePicker.get();
    }

    private void doReloadTablesInfo() {
        if (AbstractWizardOnline.notInSwingThreadInvokeLater(() -> this.doReloadTablesInfo())) {
            return;
        }
        I18nManager i18n = ToolsLocator.getI18nManager();
        try {
            Collection entities = this.entitySelector.getEntities();
            for (OnlineEntity entity : entities) {
                if (!(entity instanceof OnlineEntity)) continue;
                JDBCStoreParameters parameters = this.getWorkspace().getExplorer().get(entity.getEntityName());
                OnlineTableInfo tableInfo = new OnlineTableInfo(entity, parameters, this.requireGeometry(), false);
                if (StringUtils.isNotBlank((CharSequence)entity.getLabel())) {
                    tableInfo.setDocumentName(entity.getLabel());
                }
                tableInfo.setProperty("entity", entity);
                this.tablesInfo.put(tableInfo.getId(), tableInfo);
            }
        }
        catch (Exception e) {
            LOGGER.warn("_Cant_update_layers_list", (Throwable)e);
            ThreadSafeDialogsManager dialogs = ToolsSwingLocator.getThreadSafeDialogsManager();
            dialogs.messageDialog(i18n.getTranslation("_Cant_update_layers_list") + "\n" + e.getMessage(), i18n.getTranslation("_Add_layer"), 2);
        }
    }

    private void doDownload() {
        OnlineWorkingcopy workspace = this.getWorkspace();
        if (workspace == null) {
            return;
        }
        WindowManager_v2 winmgr = (WindowManager_v2)ToolsSwingLocator.getWindowManager();
        I18nManager i18n = ToolsLocator.getI18nManager();
        OnlineSwingManager onlineSwingManager = OnlineSwingLocator.getOnlineSwingManager();
        OnlineJDownload panel = onlineSwingManager.createDownloadPanel(workspace, null, null);
        Dialog dialog = winmgr.createDialog(panel.asJComponent(), i18n.getTranslation("_Online_Download"), i18n.getTranslation("_Online_Download"), 3);
        dialog.addActionListener(e -> {
            if (dialog.getAction() == 1) {
                panel.actionPerformed();
            }
        });
        dialog.show(WindowManager.MODE.DIALOG);
    }

    private void showMessage(String message) {
        if (AbstractWizardOnline.notInSwingThreadInvokeLater(() -> this.showMessage(message))) {
            return;
        }
        this.view.lblStatusMessages.setText(message);
    }

    public boolean isProcessing() {
        return this.processing;
    }

    public void setVisibleStatus(boolean visible) {
        if (AbstractWizardOnline.notInSwingThreadInvokeLater(() -> this.setVisibleStatus(visible))) {
            return;
        }
        this.view.lblStatusTitle.setVisible(visible);
        this.view.pbStatus.setVisible(visible);
        this.view.lblStatusMessages.setVisible(true);
    }

    public TaskStatusController getTaskStatusController() {
        return this.taskStatusController;
    }

    public static boolean notInSwingThreadInvokeLater(Runnable x) {
        if (SwingUtilities.isEventDispatchThread()) {
            return false;
        }
        SwingUtilities.invokeLater(x);
        return true;
    }

    private String toHTML(String s) {
        s = StringUtils.replace((String)s, (String)"\n", (String)"<br>");
        s = StringUtils.replace((String)s, (String)"<html>", (String)"");
        s = StringUtils.replace((String)s, (String)"</html>", (String)"");
        s = "<html>" + s + "</html>";
        return s;
    }

    protected void downloadAndRegisterResources(String tableName) {
        OnlineWorkingcopy workspace = this.getWorkspace();
        OnlineEntity entity = workspace.getWorkspaceEntityByName(tableName);
        if (entity == null) {
            return;
        }
        OnlineEntity lEntity = workspace.getEntity(entity.getEntityCode());
    }

    public void setMapContext(MapContext mapContext) {
        super.setMapContext(mapContext);
        this.tableInfoController.setMapContext(mapContext);
    }

    protected Function<OnlineEntity, String> getLabelEntityFormatter() {
        return null;
    }

    protected String getCategory(OnlineEntity entity) {
        return this.entitySelector.getCategory(entity);
    }

    protected static class WizardOnlineViewExtended
    extends AbstractWizardOnlineView {
        protected WizardOnlineViewExtended() {
        }

        @Override
        public ImageIcon loadImage(String imageName) {
            String name = FilenameUtils.getBaseName((String)imageName);
            IconTheme theme = ToolsSwingLocator.getIconThemeManager().getDefault();
            if (theme.exists(name)) {
                return theme.get(name);
            }
            URL url = WizardOnlineViewExtended.class.getResource("images/" + name + ".png");
            if (url == null) {
                return null;
            }
            return new ImageIcon(url);
        }
    }

    private class OnlineTableInfoController
    extends TableInfoController {
        public OnlineTableInfoController(JButton btnDeselectAllColumns, JButton btnSelectAllColumns, JList lstColumns, JTextField txtName, JComboBox cboIdField, JComboBox cboGeometryField, JTextField txtProjection, JButton btnProjection, JTextField txtFilter, JButton btnFilter, JButton btnFilterBookmarks, JButton btnFilterHistory, JButton btnAdvancedProperties, JLabel lblReadOnlyNotification, JComponent pnlCfgActions, JButton btnChangeViewProjection, JCheckBox visible) {
            super(btnDeselectAllColumns, btnSelectAllColumns, lstColumns, txtName, cboIdField, cboGeometryField, txtProjection, btnProjection, txtFilter, btnFilter, btnFilterBookmarks, btnFilterHistory, btnAdvancedProperties, lblReadOnlyNotification, pnlCfgActions, btnChangeViewProjection, visible);
        }

        public void put(TableInfo tableInfo) {
            OnlineEntity entity;
            Boolean v;
            if (tableInfo != null && (v = tableInfo.getVisible()) == null && (entity = ((OnlineTableInfo)tableInfo).getEntity()) != null) {
                String category = AbstractWizardOnline.this.getCategory(entity);
                boolean defaultVisibility = entity.getCategoryTags(category).getBoolean("visibility", true);
                tableInfo.setVisible(Boolean.valueOf(defaultVisibility));
            }
            super.put(tableInfo);
        }
    }
}

