/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.online.app.mainplugin.addlayer;

import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.StoresRepository;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.store.jdbc.JDBCStoreParameters;
import org.gvsig.fmap.geom.type.GeometryType;
import org.gvsig.geodb.TableInfo;
import org.gvsig.online.lib.api.workingcopy.OnlineEntity;

public class OnlineTableInfo
extends TableInfo {
    private OnlineEntity entity;

    public OnlineTableInfo(OnlineEntity entity, JDBCStoreParameters parameters, boolean requireGeometry, boolean isView) {
        super(entity.getEntityName(), parameters, requireGeometry, isView);
        this.entity = entity;
    }

    public OnlineEntity getEntity() {
        return this.entity;
    }

    protected void fetchFromStore() {
        if (this.featureType != null) {
            return;
        }
        try {
            this.featureType = this.entity.getFeatureType();
            this.table = this.featureType.getTags().getString("Layer.name", this.table);
            FeatureAttributeDescriptor attr = this.featureType.getDefaultGeometryAttribute();
            if (attr != null) {
                GeometryType geomType = attr.getGeomType();
                if (geomType != null) {
                    if (this.getGeometryType() == -1) {
                        this.setGeometryType(geomType.getType());
                    }
                    if (this.getGeometrySubtype() == 4) {
                        this.setGeometrySubtype(geomType.getSubType());
                    }
                }
                if (this.getProjection() == null) {
                    this.setProjection(attr.getSRS());
                }
            }
            if (this.readOnly == null) {
                this.readOnly = false;
            }
            this.getGeomFieldComboModel();
            this.getIdFieldComboModel();
        }
        catch (Exception ex) {
            LOGGER.trace("Can't get feature type.", (Throwable)ex);
        }
    }

    public boolean existsDALInfo() {
        return true;
    }

    boolean needConnectToModel() {
        OnlineEntity e = this.getEntity();
        DataManager dataManager = DALLocator.getDataManager();
        StoresRepository globalRepository = dataManager.getStoresRepository();
        boolean connected = false;
        boolean hasModels = false;
        for (String dataModel : e.getDataModelsAsList()) {
            if (dataModel == null) continue;
            hasModels = true;
            if (globalRepository.getSubrepository(dataModel) == null) continue;
            connected = true;
            break;
        }
        if (!hasModels) {
            return false;
        }
        return !connected;
    }
}

