/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.online.app.mainplugin.addlayer;

import java.util.ArrayList;
import org.gvsig.app.ApplicationLocator;
import org.gvsig.app.ApplicationManager;
import org.gvsig.app.project.documents.table.TableDocument;
import org.gvsig.app.project.documents.table.TableManager;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.DataStoreParameters;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.store.jdbc.JDBCStoreParameters;
import org.gvsig.geodb.TableInfo;
import org.gvsig.online.app.mainplugin.addlayer.AbstractWizardOnline;
import org.gvsig.online.app.mainplugin.addlayer.OnlineTableInfo;
import org.gvsig.online.lib.api.workingcopy.OnlineWorkingcopy;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposeUtils;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.threadsafedialogs.ThreadSafeDialogsManager;

public class WizardOnlineTabular
extends AbstractWizardOnline {
    @Override
    protected boolean requireGeometry() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object executeWizard() {
        DataManager man = DALLocator.getDataManager();
        ApplicationManager application = ApplicationLocator.getManager();
        OnlineWorkingcopy workspace = this.getWorkspace();
        for (TableInfo tableInfo : this.getTablesInformation()) {
            if (!tableInfo.isSelected() || !((OnlineTableInfo)tableInfo).needConnectToModel()) continue;
            I18nManager i18n = ToolsLocator.getI18nManager();
            ThreadSafeDialogsManager threadSafeDialogsManager = ToolsSwingLocator.getThreadSafeDialogsManager();
            int n = threadSafeDialogsManager.confirmDialog(i18n.getTranslation("_Some_of_the_selected_tables_require_connection_to_a_data_model") + "\n" + i18n.getTranslation("_It_is_recommended_that_you_connect_to_the_data_model_before_loading_the_tables") + "\n" + i18n.getTranslation("_Do_you_want_to_add_the_selected_tables_anyway"), i18n.getTranslation("_AddTable"), 0, 3, "_Some_of_the_selected_tables_require_connection_to_a_data_model");
            if (n == 0) continue;
            return null;
        }
        ArrayList<TableDocument> tabledocs = new ArrayList<TableDocument>();
        ArrayList<OnlineTableInfo> tablesInformation = new ArrayList<OnlineTableInfo>();
        for (TableInfo tableInfo : this.getTablesInformation()) {
            if (!tableInfo.isSelected()) continue;
            tablesInformation.add((OnlineTableInfo)tableInfo);
        }
        for (OnlineTableInfo onlineTableInfo : tablesInformation) {
            JDBCStoreParameters storeParams = onlineTableInfo.getParameters();
            FeatureStore store = null;
            try {
                try {
                    store = (FeatureStore)man.openStore(storeParams.getDataStoreName(), (DataStoreParameters)storeParams);
                }
                catch (Exception e) {
                    LOGGER.warn("Can't open store ", (Throwable)e);
                    Object var11_17 = null;
                    DisposeUtils.disposeQuietly((Disposable)store);
                    return var11_17;
                }
            }
            catch (Throwable throwable) {
                DisposeUtils.disposeQuietly(store);
                throw throwable;
            }
            TableDocument document = (TableDocument)application.getProjectManager().createDocument(TableManager.TYPENAME, onlineTableInfo.getDocumentName());
            document.setStore(store);
            tabledocs.add(document);
            DisposeUtils.disposeQuietly((Disposable)store);
        }
        return tabledocs;
    }
}

