/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.tilecache.provider;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.cresques.cts.IProjection;
import org.gvsig.fmap.dal.DataServerExplorer;
import org.gvsig.fmap.dal.DataStoreParameters;
import org.gvsig.fmap.dal.exception.CloseException;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.exception.InitializeException;
import org.gvsig.fmap.dal.exception.OpenException;
import org.gvsig.fmap.dal.exception.ReadException;
import org.gvsig.fmap.dal.exception.ValidateDataParametersException;
import org.gvsig.fmap.dal.raster.RasterQuery;
import org.gvsig.fmap.dal.raster.spi.AbstractRasterStoreProvider;
import org.gvsig.fmap.dal.raster.spi.RasterCacheStoreProvider;
import org.gvsig.fmap.dal.raster.spi.RasterStoreProvider;
import org.gvsig.fmap.dal.spi.DataStoreProviderServices;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.raster.lib.buffer.api.Buffer;
import org.gvsig.raster.lib.buffer.api.BufferDimensions;
import org.gvsig.raster.lib.buffer.api.BufferLocator;
import org.gvsig.raster.lib.buffer.api.BufferManager;
import org.gvsig.raster.lib.buffer.api.NoData;
import org.gvsig.raster.lib.buffer.api.PageManager;
import org.gvsig.raster.lib.buffer.api.TileStruct;
import org.gvsig.raster.lib.buffer.api.exceptions.BufferException;
import org.gvsig.raster.tilecache.provider.TileCacheBandPageManager;
import org.gvsig.raster.tilecache.provider.TileCacheStructImage;
import org.gvsig.raster.tilecache.provider.TileStructImage;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposeUtils;
import org.gvsig.tools.dispose.impl.AbstractDisposable;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.dynobject.exception.DynFieldNotFoundException;
import org.gvsig.tools.exception.BaseException;

public abstract class AbstractTileCacheStoreProvider
extends AbstractRasterStoreProvider
implements RasterCacheStoreProvider {
    private TileCacheStructImage tileStructImage = null;
    protected Envelope envelope = null;
    protected Map<Integer, List<PageManager>> pageManagersPerZoomLevel = null;
    protected RasterStoreProvider innerProvider;
    protected int bandsNumber;

    public AbstractTileCacheStoreProvider(DataStoreParameters params, DataStoreProviderServices storeServices, DynObject metadata) {
        super(params, storeServices, metadata);
    }

    public Buffer createBuffer(RasterQuery rasterQuery) throws BufferException {
        BufferManager bufferManager = BufferLocator.getBufferManager();
        ArrayList<PageManager> pageManagers = new ArrayList<PageManager>();
        int[] bandDataTypes = new int[this.bandsNumber];
        NoData[] bandNoData = new NoData[this.bandsNumber];
        double pixelSize = rasterQuery.getPixelSize();
        int zoomLevel = 0;
        if (pixelSize != 0.0) {
            zoomLevel = this.tileStructImage.getZoomLvlForPixelSize(pixelSize);
        }
        List<PageManager> pageManagersInZoom = this.getPageManagersInZoom(zoomLevel);
        for (int i = 0; i < this.tileStructImage.getBandNumber(); ++i) {
            bandDataTypes[i] = this.getBandDescriptor(i).getDataType();
            bandNoData[i] = this.getNoData(rasterQuery, i);
            pageManagers.add(pageManagersInZoom.get(i));
        }
        this.envelope = this.tileStructImage.getEnvelope();
        Buffer buffer = bufferManager.createBuffer(this.tileStructImage.getRows(zoomLevel), this.tileStructImage.getColumns(zoomLevel), bandDataTypes, bandNoData, (IProjection)this.innerProvider.getDynValue("CRS"), this.envelope, pageManagers);
        return buffer;
    }

    public int getBands() {
        return this.bandsNumber;
    }

    public DataServerExplorer getExplorer() throws ReadException, ValidateDataParametersException {
        return null;
    }

    public void open() throws OpenException {
        if (this.tileStructImage != null) {
            return;
        }
    }

    protected List<PageManager> getPageManagersInZoom(int zoomLevel) {
        List<PageManager> pageManagersInZoom = this.pageManagersPerZoomLevel.get(zoomLevel);
        if (pageManagersInZoom == null) {
            pageManagersInZoom = new ArrayList<PageManager>();
            for (int i = 0; i < this.tileStructImage.getBandNumber(); ++i) {
                pageManagersInZoom.add((PageManager)new TileCacheBandPageManager(this.tileStructImage, zoomLevel, i));
            }
            this.pageManagersPerZoomLevel.put(zoomLevel, pageManagersInZoom);
        }
        return pageManagersInZoom;
    }

    public Object getDynValue(String name) throws DynFieldNotFoundException {
        if ("Envelope".equalsIgnoreCase(name)) {
            return this.envelope;
        }
        if ("CRS".equalsIgnoreCase(name)) {
            return this.innerProvider.getDynValue(name);
        }
        return super.getDynValue(name);
    }

    public TileStruct getTileStruct() {
        return this.innerProvider.getTileStruct();
    }

    protected void setTileStructImage(TileCacheStructImage tileStructImage) {
        this.tileStructImage = tileStructImage;
        for (int i = 0; i < this.tileStructImage.getBandNumber(); ++i) {
            this.getBandDescriptor(i).setDataType(this.tileStructImage.getDataTypes()[i]);
        }
    }

    public TileStructImage getTileStructImage() {
        return this.tileStructImage;
    }

    public void deleteAll() {
        this.tileStructImage.forgetCache();
    }

    public void close() throws CloseException {
        this.tileStructImage = null;
    }

    public String getName() {
        return this.innerProvider.getName();
    }

    public String getFullName() {
        return this.innerProvider.getFullName();
    }

    protected void doDispose() throws BaseException {
        super.doDispose();
        if (this.tileStructImage != null) {
            DisposeUtils.dispose((Disposable)((AbstractDisposable)this.tileStructImage));
            this.tileStructImage = null;
        }
        Set<Map.Entry<Integer, List<PageManager>>> entrySet = this.pageManagersPerZoomLevel.entrySet();
        Iterator<Map.Entry<Integer, List<PageManager>>> iterator = entrySet.iterator();
        while (iterator.hasNext()) {
            Map.Entry<Integer, List<PageManager>> entry = iterator.next();
            List<PageManager> pageManagers = entry.getValue();
            Iterator<PageManager> iterator2 = pageManagers.iterator();
            while (iterator2.hasNext()) {
                PageManager pageManager = iterator2.next();
                DisposeUtils.dispose((Disposable)pageManager);
                iterator2.remove();
            }
            iterator.remove();
        }
    }

    public void apply(RasterStoreProvider provider, IProjection crs, RasterQuery query) throws DataException {
        this.innerProvider = provider;
        this.pageManagersPerZoomLevel = new HashMap<Integer, List<PageManager>>();
    }

    public RasterStoreProvider getInnerProvider() {
        return this.innerProvider;
    }

    public BufferDimensions getDimensions() throws InitializeException {
        return this.innerProvider.getDimensions();
    }

    public boolean isTiled() {
        return true;
    }
}

