/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.tilecache.provider;

import java.util.HashMap;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.exception.ValidateDataParametersException;
import org.gvsig.fmap.dal.raster.RasterQuery;
import org.gvsig.fmap.dal.raster.spi.RasterStoreProvider;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.exception.CreateEnvelopeException;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.raster.lib.buffer.api.Band;
import org.gvsig.raster.lib.buffer.api.Buffer;
import org.gvsig.raster.lib.buffer.api.TileStruct;
import org.gvsig.raster.lib.buffer.api.exceptions.BufferException;
import org.gvsig.raster.tilecache.provider.AbstractTileCacheStructImage;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemoryTileStructImage
extends AbstractTileCacheStructImage {
    private static final Logger logger = LoggerFactory.getLogger(MemoryTileStructImage.class);
    private static final int MAX_RECENT_ACCEDED_TILES_NUMBER = 50;

    public MemoryTileStructImage(RasterStoreProvider innerProvider, RasterQuery query) {
        super(innerProvider, query);
        this.tileStruct = this.getTileStruct();
        this.recentAccededTiles = new HashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Band fetchTile(int bandNumber, int zoomLevel, int structRow, int structCol) {
        Band band;
        String keyTile = this.composeKeyForRecentTiles(zoomLevel, structRow, structCol);
        AbstractTileCacheStructImage.Tile tile = (AbstractTileCacheStructImage.Tile)((Object)this.recentAccededTiles.get(keyTile));
        if (tile != null) {
            return tile.getBuffer().getBand(bandNumber);
        }
        Buffer buffer = null;
        try {
            Band band2;
            buffer = this.requestTile(zoomLevel, structRow, structCol);
            ToolsLocator.getDisposableManager().bind((Disposable)buffer);
            if (this.recentAccededTiles.size() >= 50) {
                this.removeOlderTile();
            }
            this.recentAccededTiles.put(keyTile, new AbstractTileCacheStructImage.Tile(buffer, keyTile));
            band = band2 = buffer.getBand(bandNumber);
        }
        catch (CloneNotSupportedException | DataException | ValidateDataParametersException | CreateEnvelopeException | BufferException e) {
            Band band3;
            try {
                logger.warn("Can't fetch tile: zoomLevel = " + zoomLevel + ", tileRow = " + structRow + ", tileColumn = " + structCol + ", band = " + bandNumber + ".", e);
                band3 = null;
            }
            catch (Throwable throwable) {
                DisposeUtils.dispose(buffer);
                buffer = null;
                throw throwable;
            }
            DisposeUtils.dispose((Disposable)buffer);
            buffer = null;
            return band3;
        }
        DisposeUtils.dispose((Disposable)buffer);
        buffer = null;
        return band;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Buffer requestTile(int zoomLevel, int structRow, int structCol) throws CreateEnvelopeException, CloneNotSupportedException, BufferException, ValidateDataParametersException, DataException {
        Buffer buffer;
        RasterQuery rasterQuery = this.query.clone();
        Double pixelSize = (Double)this.tileStruct.getPixelSizePerZoomLevel().get(zoomLevel);
        rasterQuery.setPixelSize(pixelSize.doubleValue());
        GeometryManager geomManager = GeometryLocator.getGeometryManager();
        Envelope structExtent = this.tileStruct.getEnvelope();
        int rowsPerTile = this.tileStruct.getRowsPerTile();
        int columnsPerTile = this.tileStruct.getColumnsPerTile();
        double minX = structExtent.getMinimum(0) + (double)structCol * (pixelSize * (double)columnsPerTile);
        double minY = structExtent.getMaximum(1) - (double)(structRow + 1) * (pixelSize * (double)rowsPerTile);
        double maxX = minX + pixelSize * (double)columnsPerTile;
        double maxY = minY + pixelSize * (double)rowsPerTile;
        Envelope envelope = geomManager.createEnvelope(minX, minY, maxX, maxY, 0);
        Buffer buffer2 = null;
        Buffer clippedBuffer = null;
        Buffer interpolatedBuffer = null;
        try {
            buffer2 = this.innerProvider.createBuffer(rasterQuery);
            clippedBuffer = buffer2.clip(envelope);
            buffer = interpolatedBuffer = clippedBuffer.createInterpolated((int)Math.round(clippedBuffer.getDimensions().getPixelSizeY() * (double)clippedBuffer.getRows() / pixelSize), (int)Math.round(clippedBuffer.getDimensions().getPixelSizeX() * (double)clippedBuffer.getColumns() / pixelSize), 2, null);
        }
        catch (Throwable throwable) {
            DisposeUtils.dispose(buffer2);
            DisposeUtils.dispose(clippedBuffer);
            throw throwable;
        }
        DisposeUtils.dispose((Disposable)buffer2);
        DisposeUtils.dispose((Disposable)clippedBuffer);
        return buffer;
    }

    @Override
    public TileStruct getTileStruct() {
        if (this.tileStruct == null) {
            if (this.innerProvider != null) {
                this.tileStruct = this.innerProvider.getTileStruct();
            } else {
                throw new UnsupportedOperationException("Can't be applied the memory tile cache to the provider " + this.innerProvider.getFullName());
            }
        }
        return this.tileStruct;
    }
}

