/*
 * Decompiled with CFR 0.152.
 */
package org.jzkit.search.util.QueryModel.Internal;

import java.io.StringWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.jzkit.search.util.QueryModel.Internal.QueryNode;

public class AttrPlusTermNode
extends QueryNode
implements Cloneable {
    public static final String ACCESS_POINT_ATTR = "AccessPoint";
    public static final String RELATION_ATTR = "Relation";
    public static final String POSITION_ATTR = "Position";
    public static final String STRUCTURE_ATTR = "Structure";
    public static final String TRUNCATION_ATTR = "Truncation";
    public static final String COMPLETENESS_ATTR = "Completeness";
    private Object term;
    private Hashtable attrs = new Hashtable();
    public static final int AND_TERMS = 0;
    public static final int OR_TERMS = 1;
    private int default_multi_term_operator = 0;

    public AttrPlusTermNode() {
    }

    public AttrPlusTermNode(Hashtable attrs, Object term, String name, int default_multi_term_operator) {
        this.attrs = attrs;
        this.term = term;
        this.default_multi_term_operator = default_multi_term_operator;
        if (name != null) {
            this.setNodeName(name);
        }
    }

    public Object clone() {
        return new AttrPlusTermNode((Hashtable)this.attrs.clone(), this.term, this.getNodeName(), this.default_multi_term_operator);
    }

    public int countChildrenWithTerms() {
        if (this.term == null || this.term instanceof String && ((String)this.term).length() == 0 || this.term instanceof Object[] && ((Object[])this.term).length == 0 || this.term instanceof Vector && ((Vector)this.term).size() == 0) {
            return 0;
        }
        return 1;
    }

    public int countChildren() {
        return 0;
    }

    public void setTerm(Object term) {
        this.term = term;
    }

    public Object getTerm() {
        return this.term;
    }

    public int getDefaultMultiTermOperator() {
        String val = (String)this.attrs.get("MultiTermOp");
        int result = this.default_multi_term_operator;
        if (val != null) {
            if (val.equals("OR")) {
                result = 1;
            } else if (val.equals("AND")) {
                result = 0;
            }
        }
        return result;
    }

    public void clearAttrs() {
        this.attrs.clear();
    }

    public Enumeration getAttrEnum() {
        return this.attrs.keys();
    }

    public String toString() {
        String result = null;
        result = this.term != null ? (this.term instanceof String ? this.getNodeName() + " Single Term : " + this.term + " attrs : " + this.attrs + " annotations: " + this.annotations : (this.term instanceof Vector ? this.getNodeName() + " Term List : " + (Vector)this.term + " attrs : " + this.attrs + " annotations: " + this.annotations : (this.term instanceof Object[] ? this.getNodeName() + " Term List : " + (Object[])this.term + " attrs : " + this.attrs + " annotations: " + this.annotations : this.getNodeName() + " Unknown Term Type : " + this.term.toString() + " attrs : " + this.attrs + " annotations: " + this.annotations))) : this.getNodeName() + " No Term, attrs : " + this.attrs + " annotations: " + this.annotations;
        return result;
    }

    public String getTermAsString(boolean quote_phrases) {
        String retval = null;
        if (this.term != null) {
            if (this.term instanceof Vector) {
                retval = "";
                Vector term_list = (Vector)this.term;
                int i = term_list.size();
                for (int j = 0; j < i; ++j) {
                    if (j > 0) {
                        retval = retval + ", ";
                    }
                    String this_term = (String)term_list.elementAt(j);
                    retval = quote_phrases ? retval + "\"" + this_term + "\"" : retval + this_term;
                }
            } else if (this.term instanceof Object[]) {
                Object[] term_array = (Object[])this.term;
                StringWriter sw = new StringWriter();
                for (int j = 0; j < term_array.length; ++j) {
                    if (j > 0) {
                        sw.write(", ");
                    }
                    String this_term = term_array[j].toString();
                    if (quote_phrases) {
                        sw.write("\"");
                        sw.write(this_term);
                        sw.write("\"");
                        continue;
                    }
                    sw.write(this_term);
                }
                retval = sw.toString();
            } else {
                String term_string = this.term.toString();
                retval = quote_phrases ? "\"" + term_string + "\"" : term_string;
            }
        } else {
            retval = "";
        }
        return retval;
    }

    public void setAccessPoint(Object access_point) {
        this.attrs.put(ACCESS_POINT_ATTR, access_point);
    }

    public Object getAccessPoint() {
        return this.attrs.get(ACCESS_POINT_ATTR);
    }

    public void setRelation(Object relation) {
        this.attrs.put(RELATION_ATTR, relation);
    }

    public Object getRelation() {
        return this.attrs.get(RELATION_ATTR);
    }

    public void setPosition(Object position) {
        this.attrs.put(POSITION_ATTR, position);
    }

    public Object getPosition() {
        return this.attrs.get(POSITION_ATTR);
    }

    public void setStructure(Object structure) {
        this.attrs.put(STRUCTURE_ATTR, structure);
    }

    public Object getStructure() {
        return this.attrs.get(STRUCTURE_ATTR);
    }

    public void setTruncation(Object truncation) {
        this.attrs.put(TRUNCATION_ATTR, truncation);
    }

    public Object getTruncation() {
        return this.attrs.get(TRUNCATION_ATTR);
    }

    public void setCompleteness(Object completeness) {
        this.attrs.put(COMPLETENESS_ATTR, completeness);
    }

    public Object getCompleteness() {
        return this.attrs.get(COMPLETENESS_ATTR);
    }

    public Object getAttr(String attr_name) {
        return this.attrs.get(attr_name);
    }

    public void setAttr(String name, Object value) {
        this.attrs.put(name, value);
    }

    public Hashtable getAttrs() {
        return this.attrs;
    }

    public void clearAllTerms() {
    }

    public void dump(StringWriter sw) {
        sw.write(this.toString());
    }

    public AttrPlusTermNode cloneForAttrs() {
        return new AttrPlusTermNode((Hashtable)this.attrs.clone(), this.term, this.getNodeName(), this.default_multi_term_operator);
    }
}

