/*
 * Decompiled with CFR 0.152.
 */
package org.jzkit.search.util.QueryModel.Internal;

import java.io.StringWriter;
import org.jzkit.search.util.QueryModel.Internal.QueryNode;

public class ComplexNode
extends QueryNode {
    QueryNode lhs = null;
    QueryNode rhs = null;
    public static final int COMPLEX_AND = 1;
    public static final int COMPLEX_OR = 2;
    public static final int COMPLEX_ANDNOT = 3;
    public static final int COMPLEX_PROX = 4;
    int op = 0;

    public ComplexNode(QueryNode lhs, QueryNode rhs, int op, String nodename) {
        this.lhs = lhs;
        this.rhs = rhs;
        this.op = op;
        if (nodename != null) {
            this.setNodeName(nodename);
        }
    }

    public ComplexNode(QueryNode lhs, QueryNode rhs, int op) {
        this(lhs, rhs, op, null);
    }

    public QueryNode getLHS() {
        return this.lhs;
    }

    public QueryNode getRHS() {
        return this.rhs;
    }

    public int countChildrenWithTerms() {
        return this.lhs.countChildrenWithTerms() + this.rhs.countChildrenWithTerms();
    }

    public int countChildren() {
        return this.lhs.countChildren() + this.rhs.countChildren() + 2;
    }

    public void setOp(int opval) {
        this.op = opval;
    }

    public int getOp() {
        return this.op;
    }

    public String toString() {
        switch (this.op) {
            case 1: {
                return this.getNodeName() + " Boolean AND node. annotations: " + this.annotations;
            }
            case 2: {
                return this.getNodeName() + " Boolean OR node. annotations: " + this.annotations;
            }
            case 3: {
                return this.getNodeName() + " Boolean ANDNOT node. annotations: " + this.annotations;
            }
            case 4: {
                return this.getNodeName() + " PROX node. annotations: " + this.annotations;
            }
        }
        return this.getNodeName() + " Unknown complex op node. annotations: " + this.annotations;
    }

    public void clearAllTerms() {
        if (this.lhs != null) {
            this.lhs.clearAllTerms();
        }
        if (this.rhs != null) {
            this.rhs.clearAllTerms();
        }
    }

    public void dump(StringWriter sw) {
        switch (this.op) {
            case 1: {
                sw.write("AND " + this.annotations);
                break;
            }
            case 2: {
                sw.write("OR " + this.annotations);
                break;
            }
            case 3: {
                sw.write("ANDNOT " + this.annotations);
                break;
            }
            case 4: {
                sw.write("PROX " + this.annotations);
                break;
            }
            default: {
                sw.write("Unknown " + this.annotations);
            }
        }
        sw.write("(");
        this.lhs.dump(sw);
        sw.write(",");
        this.rhs.dump(sw);
        sw.write(")");
    }
}

