/*
 * Decompiled with CFR 0.152.
 */
package org.jzkit.search.util.RecordModel;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.jzkit.search.util.RecordModel.ExplicitRecordFormatSpecification;
import org.jzkit.search.util.RecordModel.InformationFragment;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class XMLRecord
implements InformationFragment,
Serializable {
    private static transient Logger log = Logger.getLogger((class$org$jzkit$search$util$RecordModel$XMLRecord == null ? (class$org$jzkit$search$util$RecordModel$XMLRecord = XMLRecord.class$("org.jzkit.search.util.RecordModel.XMLRecord")) : class$org$jzkit$search$util$RecordModel$XMLRecord).getName());
    private static transient DocumentBuilderFactory dfactory = null;
    private String source_repository = null;
    private String source_collection_name = null;
    private Object handle = null;
    private String orig = null;
    private ExplicitRecordFormatSpecification spec = null;
    private Document doc = null;
    static /* synthetic */ Class class$org$jzkit$search$util$RecordModel$XMLRecord;

    public XMLRecord(String source) {
        log.fine("New XMLRecord");
        this.orig = source;
        this.spec = new ExplicitRecordFormatSpecification("xml", this.deriveSchemaFromDoc(), null);
    }

    public XMLRecord(String source_repository, String source_collection_name, Object handle, String source, ExplicitRecordFormatSpecification spec) {
        this.source_repository = source_repository;
        this.source_collection_name = source_collection_name;
        this.handle = handle;
        this.orig = source;
        this.spec = spec;
        if (spec == null || spec.getSchema() == null || spec.getSchema().equals("")) {
            this.spec = new ExplicitRecordFormatSpecification("xml", this.deriveSchemaFromDoc(), null);
        }
    }

    private String deriveSchemaFromDoc() {
        String result = null;
        try {
            Document d = this.getDocument();
            Element root_element = d.getDocumentElement();
            String root_tag = root_element.getTagName();
            String tag_namespace_uri = root_element.getNamespaceURI();
            result = root_tag;
        }
        catch (Exception e) {
            log.fine("Problem: " + e);
        }
        return result;
    }

    public Object getOriginalObject() {
        return this.orig;
    }

    public String getOriginalObjectClassName() {
        return "Document";
    }

    public Document getDocument() {
        if (this.doc == null && this.orig != null) {
            try {
                DocumentBuilder docBuilder = dfactory.newDocumentBuilder();
                this.doc = docBuilder.parse(new ByteArrayInputStream(this.orig.getBytes()));
            }
            catch (ParserConfigurationException pce) {
                log.warning(pce.toString());
                pce.printStackTrace();
            }
            catch (SAXException saxe) {
                log.warning(saxe.toString());
                saxe.printStackTrace();
            }
            catch (IOException ioe) {
                log.warning(ioe.toString());
                ioe.printStackTrace();
            }
        }
        return this.doc;
    }

    public String getDocumentSchema() {
        DocumentType doctype = this.getDocument().getDoctype();
        if (doctype != null) {
            return doctype.getSystemId();
        }
        return this.getDocument().getDocumentElement().getNodeName();
    }

    public String toString() {
        return this.orig;
    }

    public String getSourceRepositoryID() {
        return this.source_repository;
    }

    public String getSourceCollectionName() {
        return this.source_collection_name;
    }

    public Object getSourceFragmentID() {
        if (this.handle != null) {
            return this.handle;
        }
        return null;
    }

    public ExplicitRecordFormatSpecification getFormatSpecification() {
        return this.spec;
    }

    public void setFormatSpecification(ExplicitRecordFormatSpecification spec) {
        this.spec = spec;
    }

    public void setSourceRepositoryID(String id) {
        this.source_repository = id;
    }

    public void setSourceCollectionName(String collection_name) {
        this.source_collection_name = collection_name;
    }

    public void setSourceFragmentID(Object id) {
        this.handle = id;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        dfactory = DocumentBuilderFactory.newInstance();
        dfactory.setNamespaceAware(true);
        dfactory.setValidating(false);
        dfactory.setAttribute("http://xml.org/sax/features/validation", Boolean.FALSE);
        dfactory.setAttribute("http://apache.org/xml/features/nonvalidating/load-external-dtd", Boolean.FALSE);
    }
}

