/*
 * Decompiled with CFR 0.152.
 */
package org.jzkit.search.util.RecordModel;

import java.io.Serializable;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.jzkit.search.util.RecordModel.ExplicitRecordFormatSpecification;
import org.jzkit.search.util.RecordModel.InformationFragment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class iso2709
implements InformationFragment,
Serializable {
    protected String source_repository = null;
    protected String source_collection_name = null;
    protected Object handle = null;
    protected byte[] source_record = null;
    protected Document xml_rep = null;
    protected String character_encoding = null;
    protected static transient String default_character_encoding = "US-ASCII";
    private ExplicitRecordFormatSpecification spec = null;
    public static final transient char ISO2709_RECORD_TERMINATOR = '\u001d';
    public static final transient char ISO2709_FIELD_TERMINATOR = '\u001e';
    public static final transient char ISO2709_DELIMITER = '\u001f';
    private static transient Logger log = Logger.getLogger((class$org$jzkit$search$util$RecordModel$iso2709 == null ? (class$org$jzkit$search$util$RecordModel$iso2709 = iso2709.class$("org.jzkit.search.util.RecordModel.iso2709")) : class$org$jzkit$search$util$RecordModel$iso2709).getName());
    String result = null;
    static /* synthetic */ Class class$org$jzkit$search$util$RecordModel$iso2709;

    public iso2709(Object source) {
        this.source_record = (byte[])source;
    }

    public iso2709(Object source, String character_encoding) {
        this.source_record = (byte[])source;
        this.character_encoding = character_encoding;
    }

    public iso2709(String source_repository, String source_collection_name, ExplicitRecordFormatSpecification spec, Object handle, Object source) {
        this(source_repository, source_collection_name, spec, handle, source, default_character_encoding);
    }

    public iso2709(String source_repository, String source_collection_name, ExplicitRecordFormatSpecification spec, Object handle, Object source, String character_encoding) {
        this.source_record = (byte[])source;
        this.handle = handle;
        this.source_collection_name = source_collection_name;
        this.source_repository = source_repository;
        this.character_encoding = character_encoding;
        this.spec = spec;
    }

    public Object getOriginalObject() {
        return this.source_record;
    }

    public String getOriginalObjectClassName() {
        return "byte[]";
    }

    public Document getDocument() {
        if (null == this.xml_rep) {
            this.xml_rep = this.convert();
        }
        return this.xml_rep;
    }

    public String getDocumentSchema() {
        return this.spec.getSchema().toString();
    }

    public String getSourceRepositoryID() {
        return this.source_repository;
    }

    public String getSourceCollectionName() {
        return this.source_collection_name;
    }

    public Object getSourceFragmentID() {
        if (this.handle != null) {
            return this.handle;
        }
        return null;
    }

    private Document convert() {
        String orig = null;
        orig = new String(this.source_record);
        Document retval = null;
        DocumentBuilderFactory dfactory = DocumentBuilderFactory.newInstance();
        dfactory.setNamespaceAware(true);
        try {
            DocumentBuilder docBuilder = dfactory.newDocumentBuilder();
            retval = docBuilder.newDocument();
        }
        catch (ParserConfigurationException pce) {
            log.log(Level.SEVERE, "Problem configuring parser", pce);
        }
        Element root = retval.createElement("iso2709");
        if (this.spec != null && this.spec.getSchema() != null) {
            root.setAttribute("Variant", "" + this.spec.getSchema().toString());
        }
        int record_length = Integer.parseInt(orig.substring(0, 5));
        char record_status = orig.charAt(5);
        root.setAttribute("RecordStatus", "" + record_status);
        char type_of_record = orig.charAt(6);
        root.setAttribute("TypeOfRecord", "" + type_of_record);
        char impl_defined_7 = orig.charAt(7);
        root.setAttribute("ImplDefined1", "" + impl_defined_7);
        char impl_defined_8 = orig.charAt(8);
        root.setAttribute("ImplDefined2", "" + impl_defined_8);
        char impl_defined_17 = orig.charAt(17);
        root.setAttribute("ImplDefined17", "" + impl_defined_17);
        char impl_defined_18 = orig.charAt(18);
        root.setAttribute("ImplDefined18", "" + impl_defined_18);
        char impl_defined_19 = orig.charAt(19);
        root.setAttribute("ImplDefined19", "" + impl_defined_19);
        int indicator_length = 2;
        int subfield_code_length = 2;
        char character_coding_scheme = orig.charAt(9);
        root.setAttribute("CodingScheme", "" + character_coding_scheme);
        int base_address = Integer.parseInt(orig.substring(12, 17));
        int length_field_length = Character.digit(orig.charAt(20), 10);
        int length_entry = Character.digit(orig.charAt(21), 10);
        if (Character.isDigit(orig.charAt(10))) {
            indicator_length = Character.digit(orig.charAt(10), 10);
        }
        if (Character.isDigit(orig.charAt(11))) {
            subfield_code_length = Character.digit(orig.charAt(11), 10);
        }
        int offset = 24;
        while (orig.charAt(offset) != '\u001e' && offset < base_address) {
            String tag = orig.substring(offset, offset + 3);
            int data_length = Integer.parseInt(orig.substring(offset += 3, offset + length_field_length));
            int data_offset = Integer.parseInt(orig.substring(offset += length_field_length, offset + length_entry));
            offset += length_entry;
            Element tag_element = retval.createElement("field");
            tag_element.setAttribute("tag", tag);
            root.appendChild(tag_element);
            String this_tag = null;
            if (tag.charAt(0) == '0' && tag.charAt(1) == '0') {
                this_tag = orig.substring(base_address + data_offset, base_address + data_offset + data_length - 1);
                tag_element.appendChild(retval.createTextNode(this_tag));
                continue;
            }
            tag_element.setAttribute("Indicator1", "" + orig.charAt(base_address + data_offset));
            tag_element.setAttribute("Indicator2", "" + orig.charAt(base_address + data_offset + 1));
            this_tag = orig.substring(base_address + data_offset + 2, base_address + data_offset + data_length);
            StringTokenizer st = new StringTokenizer(this_tag, "\u001d\u001e\u001f", true);
            String subfield = null;
            while (st.hasMoreTokens()) {
                subfield = st.nextToken();
                if (subfield.charAt(0) == '\u001d' || subfield.charAt(0) == '\u001e') continue;
                if (subfield.charAt(0) == '\u001f') {
                    subfield = st.nextToken();
                    Element subfield_element = retval.createElement("subfield");
                    subfield_element.setAttribute("code", "" + subfield.charAt(0));
                    tag_element.appendChild(subfield_element);
                    String sf_str = subfield.substring(1, subfield.length());
                    try {
                        String add_str = new String(sf_str.getBytes(), this.character_encoding);
                        subfield_element.appendChild(retval.createTextNode(add_str));
                    }
                    catch (UnsupportedEncodingException uee) {
                        log.log(Level.SEVERE, "Unable to use charset " + this.character_encoding + " to create tag US-ASCII", uee);
                        subfield_element.appendChild(retval.createTextNode(sf_str));
                    }
                    continue;
                }
                try {
                    String sf_str = new String(subfield.getBytes(), this.character_encoding);
                    tag_element.appendChild(retval.createTextNode(sf_str));
                }
                catch (UnsupportedEncodingException uee) {
                    log.log(Level.SEVERE, "Unable to use charset " + this.character_encoding + " to create tag US-ASCII", uee);
                    tag_element.appendChild(retval.createTextNode(subfield));
                }
            }
        }
        retval.appendChild(root);
        return retval;
    }

    private String hexDump(String s) {
        StringWriter sw = new StringWriter();
        byte[] sba = s.getBytes();
        for (int i = 0; i < sba.length; ++i) {
            sw.write(" " + s.charAt(i));
        }
        return sw.toString();
    }

    public ExplicitRecordFormatSpecification getFormatSpecification() {
        return this.spec;
    }

    public void setFormatSpecification(ExplicitRecordFormatSpecification spec) {
        this.spec = spec;
    }

    public void setSourceRepositoryID(String id) {
        this.source_repository = id;
    }

    public void setSourceCollectionName(String collection_name) {
        this.source_collection_name = collection_name;
    }

    public void setSourceFragmentID(Object id) {
        this.handle = id;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

