/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.symbology.app.importsymbols;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.ComboBoxModel;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.ListModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.JTextComponent;
import org.apache.commons.io.FilenameUtils;
import org.gvsig.app.ApplicationLocator;
import org.gvsig.app.ApplicationManager;
import org.gvsig.symbology.app.importsymbols.ImportPictureMarkerSymbolsPanelLayout;
import org.gvsig.symbology.app.importsymbols.ImportPictureMarkerSymbolsProcess;
import org.gvsig.tools.util.FolderSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImportPictureMarkerSymbolsPanel
extends ImportPictureMarkerSymbolsPanelLayout {
    private static final long serialVersionUID = 1919826881234125305L;
    private static Logger logger = LoggerFactory.getLogger(ImportPictureMarkerSymbolsPanel.class);
    private ImportPictureMarkerSymbolsProcess process = null;
    private ApplicationManager application;
    private List<File> selectedFiles = null;

    public ImportPictureMarkerSymbolsPanel(ImportPictureMarkerSymbolsProcess process) {
        this.process = process;
        this.application = ApplicationLocator.getManager();
        this.initComponents();
    }

    private void closeWindow() {
        this.setVisible(false);
    }

    private void translate(Container container) {
        for (int n = 0; n < container.getComponentCount(); ++n) {
            Component component = container.getComponent(n);
            try {
                if (component instanceof JLabel) {
                    JLabel label = (JLabel)component;
                    if (!label.getText().startsWith("_")) continue;
                    label.setText(this.application.translate(label.getText(), new String[0]));
                    continue;
                }
                if (component instanceof AbstractButton) {
                    AbstractButton button = (AbstractButton)component;
                    if (!button.getText().startsWith("_")) continue;
                    button.setText(this.application.translate(button.getText(), new String[0]));
                    continue;
                }
                if (component instanceof JTextComponent) {
                    JTextComponent text = (JTextComponent)component;
                    if (!text.getText().startsWith("_")) continue;
                    text.setText(this.application.translate(text.getText(), new String[0]));
                    continue;
                }
                if (!(component instanceof Container)) continue;
                this.translate((Container)component);
                continue;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private void initComponents() {
        this.translate(this);
        this.ctrlBrowseImagesToImport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ImportPictureMarkerSymbolsPanel.this.doBrowseImagesToImport();
            }
        });
        this.ctrlDefaultSize.setValue(this.process.getSymbolSize());
        if (this.process.getTargetFolderName() != null) {
            this.ctrltFolderName.setText(this.process.getTargetFolderName());
        }
        FolderSet repo = this.process.getSymbolsRepository();
        File[] folders = repo.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File arg0, String arg1) {
                return arg0.isDirectory();
            }
        });
        final ArrayList<FileItem> folderItems = new ArrayList<FileItem>();
        for (int i = 0; i < folders.length; ++i) {
            folderItems.add(new FileItem(folders[i]));
        }
        this.ctrlExistingFolders.setModel(new ListModel(){

            @Override
            public void removeListDataListener(ListDataListener arg0) {
            }

            @Override
            public int getSize() {
                return folderItems.size();
            }

            public Object getElementAt(int arg0) {
                return folderItems.get(arg0);
            }

            @Override
            public void addListDataListener(ListDataListener arg0) {
            }
        });
        this.ctrlExistingFolders.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent arg0) {
                if (!arg0.getValueIsAdjusting()) {
                    try {
                        File file = ((FileItem)ImportPictureMarkerSymbolsPanel.this.ctrlExistingFolders.getSelectedValue()).getValue();
                        ImportPictureMarkerSymbolsPanel.this.ctrltFolderName.setText(file.getName());
                    }
                    catch (Exception ex) {
                        logger.info("Error getting selected filename", (Throwable)ex);
                    }
                }
            }
        });
        final OverwriteItem[] overwriteItems = new OverwriteItem[]{new OverwriteItem(this.application.translate("_Ask_to_the_user", new String[0]), ImportPictureMarkerSymbolsProcess.YesNoAsk.ASK), new OverwriteItem(this.application.translate("_Dont_overwrite", new String[0]), ImportPictureMarkerSymbolsProcess.YesNoAsk.NO), new OverwriteItem(this.application.translate("_Overwrite_always", new String[0]), ImportPictureMarkerSymbolsProcess.YesNoAsk.YES)};
        this.ctrlOverwriteOptions.setModel(new ComboBoxModel(){
            OverwriteItem selected = null;

            @Override
            public void removeListDataListener(ListDataListener arg0) {
            }

            @Override
            public int getSize() {
                return overwriteItems.length;
            }

            @Override
            public Object getElementAt(int arg0) {
                return overwriteItems[arg0];
            }

            @Override
            public void addListDataListener(ListDataListener arg0) {
            }

            @Override
            public void setSelectedItem(Object arg0) {
                this.selected = (OverwriteItem)arg0;
            }

            @Override
            public Object getSelectedItem() {
                return this.selected;
            }
        });
        this.ctrlOverwriteOptions.setSelectedIndex(0);
        this.ctrlImport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ImportPictureMarkerSymbolsPanel.this.doImport();
            }
        });
        this.ctrlCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ImportPictureMarkerSymbolsPanel.this.doCancel();
            }
        });
    }

    private void doImport() {
        if (this.ctrltFolderName.getText().trim().length() == 0) {
            this.application.messageDialog(this.application.translate("_Should_select_a_folder_name", new String[0]), this.process.getName(), 2);
            return;
        }
        if (this.selectedFiles == null || this.selectedFiles.size() == 0) {
            this.application.messageDialog(this.application.translate("_Should_select_the_images_to_import", new String[0]), this.process.getName(), 2);
            return;
        }
        this.process.setTargetFolderName(this.ctrltFolderName.getText());
        this.process.setSymbolSize(((SpinnerNumberModel)this.ctrlDefaultSize.getModel()).getNumber().doubleValue());
        this.process.setOverwrite(((OverwriteItem)this.ctrlOverwriteOptions.getSelectedItem()).getValue());
        this.process.getSelectedImageFiles().clear();
        this.process.getSelectedImageFiles().addAll(this.selectedFiles);
        this.closeWindow();
    }

    private void doCancel() {
        this.process.cancelRequest();
        this.closeWindow();
    }

    private List<File> fileChooser(String title, boolean multiselect, FileFilter filter) {
        JFileChooser fc = new JFileChooser();
        fc.setFileFilter(filter);
        fc.setMultiSelectionEnabled(multiselect);
        int r = fc.showDialog(this.application.getRootComponent(), title);
        if (r == 0) {
            return Arrays.asList(fc.getSelectedFiles());
        }
        return null;
    }

    private void doBrowseImagesToImport() {
        List<File> files = this.fileChooser(this.application.translate("_Select_the_images", new String[0]), true, new FileFilter(){

            @Override
            public String getDescription() {
                StringBuffer buffer = new StringBuffer();
                ArrayList<String> extensions = new ArrayList<String>();
                extensions.addAll(ImportPictureMarkerSymbolsPanel.this.process.getAllowedFileExtensions());
                int l = extensions.size();
                if (l >= 2) {
                    for (int i = 0; i < l - 2; ++i) {
                        buffer.append((String)extensions.get(i));
                        buffer.append(", ");
                    }
                    buffer.append((String)extensions.get(l - 2));
                    buffer.append(" & ");
                    buffer.append((String)extensions.get(l - 1));
                } else {
                    buffer.append((String)extensions.get(0));
                }
                buffer.append(" ");
                buffer.append(ImportPictureMarkerSymbolsPanel.this.application.translate("_Images", new String[0]));
                return buffer.toString();
            }

            @Override
            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                String extension = FilenameUtils.getExtension((String)f.getName()).toLowerCase();
                return extension != null && ImportPictureMarkerSymbolsPanel.this.process.getAllowedFileExtensions().contains(extension);
            }
        });
        if (files != null) {
            this.selectedFiles = files;
            final ArrayList<FileItem> folderItems = new ArrayList<FileItem>();
            for (int i = 0; i < files.size(); ++i) {
                folderItems.add(new FileItem(files.get(i)));
            }
            this.ctrlImagesToImport.setModel(new ListModel(){

                @Override
                public void removeListDataListener(ListDataListener arg0) {
                }

                @Override
                public int getSize() {
                    return folderItems.size();
                }

                public Object getElementAt(int arg0) {
                    return folderItems.get(arg0);
                }

                @Override
                public void addListDataListener(ListDataListener arg0) {
                }
            });
        }
    }

    private class FileItem {
        private File value;

        FileItem(File value) {
            this.value = value;
        }

        public String toString() {
            return this.value.getName();
        }

        public File getValue() {
            return this.value;
        }
    }

    private class OverwriteItem {
        private String label;
        private ImportPictureMarkerSymbolsProcess.YesNoAsk value;

        OverwriteItem(String label, ImportPictureMarkerSymbolsProcess.YesNoAsk value) {
            this.label = label;
            this.value = value;
        }

        public String toString() {
            return this.label;
        }

        public ImportPictureMarkerSymbolsProcess.YesNoAsk getValue() {
            return this.value;
        }
    }
}

