/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.symbology.app.importsymbols;

import java.awt.Component;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.gvsig.app.ApplicationLocator;
import org.gvsig.app.ApplicationManager;
import org.gvsig.fmap.mapcontext.MapContextLocator;
import org.gvsig.fmap.mapcontext.rendering.symbols.SymbolManager;
import org.gvsig.symbology.SymbologyLocator;
import org.gvsig.symbology.SymbologyManager;
import org.gvsig.symbology.app.importsymbols.ImportPictureMarkerSymbolsPanel;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.marker.IPictureMarkerSymbol;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.persistence.PersistenceManager;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.task.AbstractMonitorableTask;
import org.gvsig.tools.task.SimpleTaskStatus;
import org.gvsig.tools.util.FolderSet;
import org.gvsig.tools.util.impl.DefaultFolderSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImportPictureMarkerSymbolsProcess
extends AbstractMonitorableTask {
    private static Logger logger = LoggerFactory.getLogger(ImportPictureMarkerSymbolsProcess.class);
    private static final String[] SELECTION_SUFFIX = new String[]{"_sel", "_bg"};
    private ApplicationManager application = null;
    private SymbolManager symbolManager = null;
    private SymbologyManager symbologyManager = null;
    private Set<String> allowedFileExtensions = null;
    private List<File> notCreatedSymbols = new ArrayList<File>();
    private boolean quietMode = false;
    private YesNoAsk overwrite = YesNoAsk.ASK;
    private List<File> selectedImageFiles = new ArrayList<File>();
    private String targetFolderName;
    private double symbolSize = 18.0;

    protected ImportPictureMarkerSymbolsProcess() {
        super(false);
        this.application = ApplicationLocator.getManager();
        this.setTaskName(this.application.translate("_Import_picture_marker_symbols", new String[0]));
    }

    public Set<String> getAllowedFileExtensions() {
        if (this.allowedFileExtensions == null) {
            this.allowedFileExtensions = new HashSet<String>();
            this.allowedFileExtensions.add("png");
            this.allowedFileExtensions.add("jpg");
            this.allowedFileExtensions.add("jpeg");
            this.allowedFileExtensions.add("gif");
            this.allowedFileExtensions.add("bmp");
            this.allowedFileExtensions.add("svg");
        }
        return this.allowedFileExtensions;
    }

    public YesNoAsk getOverwrite() {
        return this.overwrite;
    }

    public void setOverwrite(YesNoAsk overwrite) {
        this.overwrite = overwrite;
    }

    public double getSymbolSize() {
        return this.symbolSize;
    }

    public void setSymbolSize(double symbolSize) {
        this.symbolSize = symbolSize;
    }

    public String getTargetFolderName() {
        return this.targetFolderName;
    }

    public void setTargetFolderName(String targetFolderName) {
        this.targetFolderName = targetFolderName;
    }

    public List<File> getSelectedImageFiles() {
        return this.selectedImageFiles;
    }

    public boolean isQuietMode() {
        return this.quietMode;
    }

    public void setQuietMode(boolean quietMode) {
        this.quietMode = quietMode;
    }

    public FolderSet getSymbolsRepository() {
        File symbolsFolder = new File(this.getSymbolManager().getSymbolPreferences().getSymbolLibraryPath());
        DefaultFolderSet repo = new DefaultFolderSet();
        repo.add(symbolsFolder);
        return repo;
    }

    public List<File> getNotCreatedSymbols() {
        return this.notCreatedSymbols;
    }

    public void run() {
        SimpleTaskStatus status = null;
        try {
            status = (SimpleTaskStatus)this.getTaskStatus();
            this.preProcess();
            if (status.isCancellationRequested()) {
                status.cancel();
                return;
            }
            status.add();
            status.setRangeOfValues(1L, (long)this.getSelectedImageFiles().size());
            for (int i = 0; i < this.getSelectedImageFiles().size(); ++i) {
                if (status.isCancellationRequested()) {
                    status.cancel();
                    return;
                }
                status.setCurValue((long)(i + 1));
                this.processItem(this.getSelectedImageFiles().get(i));
            }
            this.postPrecess();
            if (status.isCancellationRequested()) {
                status.cancel();
                return;
            }
            if (!this.isQuietMode()) {
                this.application.messageDialog("_Import_of_symbols_completed", this.getName(), 1);
            }
        }
        catch (Exception e) {
            logger.info("Error in process", (Throwable)e);
            if (status != null) {
                status.abort();
            }
            if (!this.isQuietMode()) {
                this.application.message("_Import_of_symbols_aborted\n\n" + e.getMessage(), 2);
                this.application.messageDialog("_Error_in_the_process_of_import_point_symbols_Some_symbols_cant_be_imported\n\n" + e.getMessage(), this.getName(), 2);
            }
        }
        finally {
            if (status != null && status.isRunning()) {
                status.terminate();
            }
            this.application.refreshMenusAndToolBars();
        }
    }

    private void preProcess() {
        if (this.isQuietMode() && this.getOverwrite() == YesNoAsk.ASK) {
            this.setOverwrite(YesNoAsk.YES);
        } else {
            Component dlg = this.application.createComponent(ImportPictureMarkerSymbolsPanel.class, new Object[]{this});
            this.application.showDialog(dlg, this.getName());
        }
    }

    private void processItem(File item) throws InterruptedException {
        PersistenceManager persistenceManager = ToolsLocator.getPersistenceManager();
        if (this.isSelectedImage(item)) {
            return;
        }
        File source_image = this.getSourceImage(item);
        File source_image_sel = this.getSourceImageSelected(item);
        File target_image = this.getTargetImage(item);
        File target_image_sel = this.getTargetImageSelected(item);
        File target_symbol = this.getTargetSymbol(item);
        if (!source_image_sel.exists()) {
            source_image_sel = source_image;
        }
        if (target_symbol.exists()) {
            switch (this.getOverwrite()) {
                case ASK: {
                    int resp = this.application.confirmDialog(this.application.translate("_Symbol_{0}_already_exists_Overwrite", new String[]{target_symbol.getAbsolutePath()}), this.getName(), 0, 3);
                    if (resp != 1) break;
                    return;
                }
                case NO: {
                    return;
                }
            }
        }
        try {
            if (!target_image.getParentFile().exists()) {
                target_image.getParentFile().mkdirs();
            }
            this.copyFile(source_image, target_image);
            this.copyFile(source_image_sel, target_image_sel);
            IPictureMarkerSymbol symbol = this.getSymbologyManager().createPictureMarkerSymbol(target_image.toURI().toURL(), target_image_sel.toURI().toURL());
            symbol.setSize(this.getSymbolSize());
            symbol.setDescription(FilenameUtils.getBaseName((String)target_image.getName()));
            PersistentState state = persistenceManager.getState((Object)symbol);
            FileOutputStream out = new FileOutputStream(target_symbol);
            persistenceManager.saveState(state, (OutputStream)out);
        }
        catch (Exception e) {
            logger.info("Can't create symbol from '" + item.getAbsolutePath() + ".", (Throwable)e);
            this.notCreatedSymbols.add(item);
        }
    }

    private boolean isSelectedImage(File item) {
        String ext = FilenameUtils.getExtension((String)item.getName());
        String name = FilenameUtils.getBaseName((String)item.getName());
        File orig = null;
        String suf = null;
        for (int i = 0; i < SELECTION_SUFFIX.length; ++i) {
            suf = SELECTION_SUFFIX[i];
            if (!name.endsWith(suf) || !(orig = new File(item.getParentFile(), name.substring(0, name.length() - suf.length()) + "." + ext)).exists()) continue;
            return true;
        }
        return false;
    }

    private void postPrecess() {
        if (!this.isQuietMode() && this.notCreatedSymbols.size() > 0) {
            StringBuffer listOfFiles = new StringBuffer();
            listOfFiles.append("\n\n");
            for (File file : this.notCreatedSymbols) {
                listOfFiles.append(file.getAbsolutePath());
                listOfFiles.append("\n");
            }
            this.application.message(this.application.translate("_many_symbols_can_be_createds", new String[0]) + listOfFiles.toString(), 2);
        }
    }

    private void copyFile(File source, File target) throws IOException {
        if (target.exists()) {
            switch (this.getOverwrite()) {
                case ASK: {
                    int resp = this.application.confirmDialog(this.application.translate("_File_{0}_already_exists_Overwrite", new String[]{target.getAbsolutePath()}), this.getName(), 0, 3);
                    if (resp != 0) break;
                    FileUtils.copyFile((File)source, (File)target);
                    break;
                }
                case NO: {
                    break;
                }
                case YES: {
                    FileUtils.copyFile((File)source, (File)target);
                }
            }
        } else {
            FileUtils.copyFile((File)source, (File)target);
        }
    }

    private File getTargetSymbol(File item) {
        File target = FileUtils.getFile((File)this.getSymbolsRepository().asFile(), (String[])new String[]{this.getTargetFolderName(), FilenameUtils.getBaseName((String)item.getName()) + this.getSymbolManager().getSymbolPreferences().getSymbolFileExtension()});
        return target;
    }

    private File getSourceImage(File item) {
        return item;
    }

    private File getSourceImageSelected(File item) {
        String ext = FilenameUtils.getExtension((String)item.getName());
        String name = FilenameUtils.getBaseName((String)item.getName());
        File source = null;
        String suf = null;
        for (int i = 0; i < SELECTION_SUFFIX.length; ++i) {
            suf = SELECTION_SUFFIX[i];
            source = new File(item.getParentFile(), name + suf + "." + ext);
            if (!source.exists()) continue;
            return source;
        }
        source = new File(item.getParentFile(), name + SELECTION_SUFFIX[0] + "." + ext);
        return source;
    }

    private File getTargetImage(File item) {
        File target = FileUtils.getFile((File)this.getSymbolsRepository().asFile(), (String[])new String[]{this.getTargetFolderName(), item.getName()});
        return target;
    }

    private File getTargetImageSelected(File item) {
        String ext = FilenameUtils.getExtension((String)item.getName());
        String name = FilenameUtils.getBaseName((String)item.getName());
        File target = FileUtils.getFile((File)this.getSymbolsRepository().asFile(), (String[])new String[]{this.getTargetFolderName(), name + "_sel." + ext});
        return target;
    }

    private SymbolManager getSymbolManager() {
        if (this.symbolManager == null) {
            this.symbolManager = MapContextLocator.getSymbolManager();
        }
        return this.symbolManager;
    }

    private SymbologyManager getSymbologyManager() {
        if (this.symbologyManager == null) {
            this.symbologyManager = SymbologyLocator.getSymbologyManager();
        }
        return this.symbologyManager;
    }

    public static enum YesNoAsk {
        YES,
        NO,
        ASK;

    }
}

