/*
 * Decompiled with CFR 0.152.
 */
package org.mapdb.serializer;

import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import org.mapdb.DataInput2;
import org.mapdb.DataOutput2;
import org.mapdb.serializer.GroupSerializer;

public class SerializerBoolean
implements GroupSerializer<Boolean> {
    @Override
    public void serialize(DataOutput2 out, Boolean value) throws IOException {
        out.writeBoolean(value);
    }

    @Override
    public Boolean deserialize(DataInput2 in, int available) throws IOException {
        return in.readBoolean();
    }

    @Override
    public int fixedSize() {
        return 1;
    }

    @Override
    public boolean isTrusted() {
        return true;
    }

    @Override
    public int valueArraySearch(Object keys, Boolean key) {
        return Arrays.binarySearch(this.valueArrayToArray(keys), key);
    }

    @Override
    public int valueArraySearch(Object keys, Boolean key, Comparator comparator) {
        return Arrays.binarySearch(this.valueArrayToArray(keys), key, comparator);
    }

    @Override
    public void valueArraySerialize(DataOutput2 out, Object vals) throws IOException {
        for (boolean b : (boolean[])vals) {
            out.writeBoolean(b);
        }
    }

    @Override
    public Object valueArrayDeserialize(DataInput2 in, int size2) throws IOException {
        boolean[] ret2 = new boolean[size2];
        for (int i = 0; i < size2; ++i) {
            ret2[i] = in.readBoolean();
        }
        return ret2;
    }

    @Override
    public Boolean valueArrayGet(Object vals, int pos) {
        return ((boolean[])vals)[pos];
    }

    @Override
    public int valueArraySize(Object vals) {
        return ((boolean[])vals).length;
    }

    @Override
    public Object valueArrayEmpty() {
        return new boolean[0];
    }

    @Override
    public Object valueArrayPut(Object vals, int pos, Boolean newValue) {
        boolean[] array = (boolean[])vals;
        boolean[] ret2 = Arrays.copyOf(array, array.length + 1);
        if (pos < array.length) {
            System.arraycopy(array, pos, ret2, pos + 1, array.length - pos);
        }
        ret2[pos] = newValue;
        return ret2;
    }

    @Override
    public Object valueArrayUpdateVal(Object vals, int pos, Boolean newValue) {
        boolean[] vals2 = (boolean[])((boolean[])vals).clone();
        vals2[pos] = newValue;
        return vals2;
    }

    @Override
    public Object valueArrayFromArray(Object[] objects) {
        boolean[] ret2 = new boolean[objects.length];
        for (int i = 0; i < ret2.length; ++i) {
            ret2[i] = (Boolean)objects[i];
        }
        return ret2;
    }

    @Override
    public Object valueArrayCopyOfRange(Object vals, int from, int to) {
        return Arrays.copyOfRange((boolean[])vals, from, to);
    }

    @Override
    public Object valueArrayDeleteValue(Object vals, int pos) {
        boolean[] valsOrig = (boolean[])vals;
        boolean[] vals2 = new boolean[valsOrig.length - 1];
        System.arraycopy(vals, 0, vals2, 0, pos - 1);
        System.arraycopy(vals, pos, vals2, pos - 1, vals2.length - (pos - 1));
        return vals2;
    }
}

