/*
 * Decompiled with CFR 0.152.
 */
package org.mapdb.volume;

import java.nio.ByteBuffer;
import org.mapdb.DataInput2;
import org.mapdb.volume.Volume;

public abstract class ByteBufferVolSingle
extends Volume {
    protected final boolean cleanerHackEnabled;
    protected ByteBuffer buffer;
    protected final boolean readOnly;
    protected final long maxSize;

    protected ByteBufferVolSingle(boolean readOnly, long maxSize, boolean cleanerHackEnabled) {
        this.readOnly = readOnly;
        this.maxSize = maxSize;
        this.cleanerHackEnabled = cleanerHackEnabled;
    }

    @Override
    public void ensureAvailable(long offset) {
    }

    @Override
    public final void putLong(long offset, long value) {
        this.buffer.putLong((int)offset, value);
    }

    @Override
    public final void putInt(long offset, int value) {
        this.buffer.putInt((int)offset, value);
    }

    @Override
    public final void putByte(long offset, byte value) {
        this.buffer.put((int)offset, value);
    }

    @Override
    public void putData(long offset, byte[] src, int srcPos, int srcSize) {
        ByteBuffer b1 = this.buffer.duplicate();
        int bufPos = (int)offset;
        b1.position(bufPos);
        b1.put(src, srcPos, srcSize);
    }

    @Override
    public final void putData(long offset, ByteBuffer buf) {
        ByteBuffer b1 = this.buffer.duplicate();
        int bufPos = (int)offset;
        b1.position(bufPos);
        b1.put(buf);
    }

    @Override
    public void copyTo(long inputOffset, Volume target, long targetOffset, long size2) {
        ByteBuffer b1 = this.buffer.duplicate();
        int bufPos = (int)inputOffset;
        b1.position(bufPos);
        b1.limit((int)((long)bufPos + size2));
        target.putData(targetOffset, b1);
    }

    @Override
    public void getData(long offset, byte[] src, int srcPos, int srcSize) {
        ByteBuffer b1 = this.buffer.duplicate();
        int bufPos = (int)offset;
        b1.position(bufPos);
        b1.get(src, srcPos, srcSize);
    }

    @Override
    public final long getLong(long offset) {
        return this.buffer.getLong((int)offset);
    }

    @Override
    public final int getInt(long offset) {
        return this.buffer.getInt((int)offset);
    }

    @Override
    public final byte getByte(long offset) {
        return this.buffer.get((int)offset);
    }

    @Override
    public final DataInput2.ByteBuffer getDataInput(long offset, int size2) {
        return new DataInput2.ByteBuffer(this.buffer, (int)offset);
    }

    @Override
    public void putDataOverlap(long offset, byte[] data, int pos, int len) {
        this.putData(offset, data, pos, len);
    }

    @Override
    public DataInput2 getDataInputOverlap(long offset, int size2) {
        return this.getDataInput(offset, size2);
    }

    @Override
    public void clear(long startOffset, long endOffset) {
        int start = (int)startOffset;
        int end = (int)endOffset;
        ByteBuffer buf = this.buffer;
        for (int pos = start; pos < end; pos += CLEAR.length) {
            buf = buf.duplicate();
            buf.position(pos);
            buf.put(CLEAR, 0, Math.min(CLEAR.length, end - pos));
        }
    }

    @Override
    public int sliceSize() {
        return -1;
    }

    @Override
    public boolean isSliced() {
        return false;
    }
}

